/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.SiteBundle;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteIU;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.p2.updatesite.VersionSuffixGenerator;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteXMLAction
extends AbstractPublisherAction {
    private static final String QUALIFIER = "qualifier";
    private static final VersionSuffixGenerator versionSuffixGenerator = new VersionSuffixGenerator();
    protected UpdateSite updateSite;
    private SiteCategory defaultCategory;
    private HashSet<SiteCategory> defaultCategorySet;
    protected URI location;
    private String categoryQualifier = null;
    private Version categoryVersion = null;
    private static final IExpression qualifierMatchExpr = ExpressionUtil.parse((String)"id == $0 && version ~= $1");

    public SiteXMLAction(URI location, String categoryQualifier) {
        this.location = location;
        this.categoryQualifier = categoryQualifier;
    }

    public SiteXMLAction(UpdateSite updateSite, String categoryQualifier) {
        this.updateSite = updateSite;
        this.categoryQualifier = categoryQualifier;
    }

    public void setCategoryVersion(String version) {
        this.categoryVersion = Version.parseVersion((String)version);
    }

    private void initialize() {
        if (this.defaultCategory != null) {
            return;
        }
        this.defaultCategory = new SiteCategory();
        this.defaultCategory.setDescription("Default category for otherwise uncategorized features");
        this.defaultCategory.setLabel("Uncategorized");
        this.defaultCategory.setName("Default");
        this.defaultCategorySet = new HashSet(1);
        this.defaultCategorySet.add(this.defaultCategory);
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        if (this.updateSite == null) {
            try {
                this.updateSite = UpdateSite.load(this.location, (Transport)publisherInfo.getMetadataRepository().getProvisioningAgent().getService(Transport.SERVICE_NAME), monitor);
            }
            catch (ProvisionException e) {
                return new Status(4, Activator.ID, Messages.Error_generating_siteXML, (Throwable)e);
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
        }
        this.initialize();
        this.initializeRepoFromSite(publisherInfo);
        return this.generateCategories(publisherInfo, results, monitor);
    }

    private IStatus generateCategories(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        HashMap<SiteCategory, Set<IInstallableUnit>> categoriesToIUs = new HashMap<SiteCategory, Set<IInstallableUnit>>();
        Map<SiteFeature, Set<SiteCategory>> featuresToCategories = this.getFeatureToCategoryMappings(publisherInfo);
        for (SiteFeature feature : featuresToCategories.keySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Collection<IInstallableUnit> ius = this.getFeatureIU(feature, publisherInfo, results);
            if (ius == null) continue;
            Set<SiteCategory> categories = featuresToCategories.get(feature);
            if (categories == null || categories.isEmpty()) {
                categories = this.defaultCategorySet;
            }
            for (SiteCategory category : categories) {
                HashSet<IInstallableUnit> iusInCategory = (HashSet<IInstallableUnit>)categoriesToIUs.get(category);
                if (iusInCategory == null) {
                    iusInCategory = new HashSet<IInstallableUnit>();
                    categoriesToIUs.put(category, iusInCategory);
                }
                iusInCategory.addAll(ius);
            }
        }
        Map<SiteBundle, Set<SiteCategory>> bundlesToCategories = this.getBundleToCategoryMappings(publisherInfo);
        for (SiteBundle bundle : bundlesToCategories.keySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Collection<IInstallableUnit> ius = this.getBundleIU(bundle, publisherInfo, results);
            if (ius == null) continue;
            Set<SiteCategory> categories = bundlesToCategories.get(bundle);
            if (categories == null || categories.isEmpty()) {
                categories = this.defaultCategorySet;
            }
            for (SiteCategory category : categories) {
                HashSet<IInstallableUnit> iusInCategory = (HashSet<IInstallableUnit>)categoriesToIUs.get(category);
                if (iusInCategory == null) {
                    iusInCategory = new HashSet<IInstallableUnit>();
                    categoriesToIUs.put(category, iusInCategory);
                }
                iusInCategory.addAll(ius);
            }
        }
        this.addSiteIUsToCategories(categoriesToIUs, publisherInfo, results);
        this.generateCategoryIUs(categoriesToIUs, results);
        return Status.OK_STATUS;
    }

    private void addSiteIUsToCategories(Map<SiteCategory, Set<IInstallableUnit>> categoriesToIUs, IPublisherInfo publisherInfo, IPublisherResult results) {
        SiteIU[] siteIUs;
        if (this.updateSite == null) {
            return;
        }
        SiteModel site = this.updateSite.getSite();
        if (site == null) {
            return;
        }
        SiteIU[] siteIUArray = siteIUs = site.getIUs();
        int n = siteIUs.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<IInstallableUnit> ius;
            SiteIU siteIU = siteIUArray[n2];
            String[] categoryNames = siteIU.getCategoryNames();
            if (categoryNames.length != 0 && (ius = this.getIUs(siteIU, publisherInfo, results)).size() != 0) {
                String[] stringArray = categoryNames;
                int n3 = categoryNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String categoryName = stringArray[n4];
                    SiteCategory category = site.getCategory(categoryName);
                    if (category != null) {
                        Set<IInstallableUnit> categoryIUs = categoriesToIUs.get(category);
                        if (categoryIUs == null) {
                            categoryIUs = new HashSet<IInstallableUnit>();
                            categoriesToIUs.put(category, categoryIUs);
                        }
                        categoryIUs.addAll(ius);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private Collection<IInstallableUnit> getIUs(SiteIU siteIU, IPublisherInfo publisherInfo, IPublisherResult results) {
        String id = siteIU.getID();
        String range = siteIU.getRange();
        String type = siteIU.getQueryType();
        String expression = siteIU.getQueryExpression();
        Object[] params = siteIU.getQueryParams();
        if (id == null && (type == null || expression == null)) {
            return CollectionUtils.emptyList();
        }
        IQuery query = null;
        if (id != null) {
            VersionRange vRange = new VersionRange(range);
            query = QueryUtil.createIUQuery((String)id, (VersionRange)vRange);
        } else if (type.equals("context")) {
            query = QueryUtil.createQuery((String)expression, (Object[])params);
        } else if (type.equals("match")) {
            query = QueryUtil.createMatchQuery((String)expression, (Object[])params);
        }
        if (query == null) {
            return CollectionUtils.emptyList();
        }
        IQueryResult queryResult = results.query(query, null);
        if (queryResult.isEmpty()) {
            queryResult = publisherInfo.getMetadataRepository().query(query, null);
        }
        if (queryResult.isEmpty() && publisherInfo.getContextMetadataRepository() != null) {
            queryResult = publisherInfo.getContextMetadataRepository().query(query, null);
        }
        return queryResult.toUnmodifiableSet();
    }

    private Collection<IInstallableUnit> getFeatureIU(SiteFeature feature, IPublisherInfo publisherInfo, IPublisherResult results) {
        String id = String.valueOf(feature.getFeatureIdentifier()) + ".feature.group";
        String versionString = feature.getFeatureVersion();
        Version version = versionString != null && versionString.length() > 0 ? Version.create((String)versionString) : Version.emptyVersion;
        IQuery query = null;
        if (version.equals(Version.emptyVersion)) {
            query = QueryUtil.createIUQuery((String)id);
        } else {
            String qualifier;
            try {
                qualifier = PublisherHelper.toOSGiVersion((Version)version).getQualifier();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                qualifier = null;
            }
            if (qualifier != null && qualifier.endsWith(QUALIFIER)) {
                IQuery qualifierQuery;
                VersionRange range = this.createVersionRange(version.toString());
                query = qualifierQuery = QueryUtil.createMatchQuery((IExpression)qualifierMatchExpr, (Object[])new Object[]{id, range});
            } else {
                query = QueryUtil.createLimitQuery((IQuery)QueryUtil.createIUQuery((String)id, (Version)version), (int)1);
            }
        }
        IQueryResult queryResult = results.query(query, null);
        if (queryResult.isEmpty()) {
            queryResult = publisherInfo.getMetadataRepository().query(query, null);
        }
        if (queryResult.isEmpty() && publisherInfo.getContextMetadataRepository() != null) {
            queryResult = publisherInfo.getContextMetadataRepository().query(query, null);
        }
        if (!queryResult.isEmpty()) {
            return queryResult.toUnmodifiableSet();
        }
        return null;
    }

    private Collection<IInstallableUnit> getBundleIU(SiteBundle bundle, IPublisherInfo publisherInfo, IPublisherResult results) {
        String id = bundle.getBundleIdentifier();
        String versionString = bundle.getBundleVersion();
        Version version = versionString != null && versionString.length() > 0 ? Version.create((String)versionString) : Version.emptyVersion;
        IQuery query = null;
        if (version.equals(Version.emptyVersion)) {
            query = QueryUtil.createIUQuery((String)id);
        } else {
            String qualifier;
            try {
                qualifier = PublisherHelper.toOSGiVersion((Version)version).getQualifier();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                qualifier = null;
            }
            if (qualifier != null && qualifier.endsWith(QUALIFIER)) {
                IQuery qualifierQuery;
                VersionRange range = this.createVersionRange(version.toString());
                query = qualifierQuery = QueryUtil.createMatchQuery((IExpression)qualifierMatchExpr, (Object[])new Object[]{id, range});
            } else {
                query = QueryUtil.createLimitQuery((IQuery)QueryUtil.createIUQuery((String)id, (Version)version), (int)1);
            }
        }
        IQueryResult queryResult = results.query(query, null);
        if (queryResult.isEmpty()) {
            queryResult = publisherInfo.getMetadataRepository().query(query, null);
        }
        if (queryResult.isEmpty() && publisherInfo.getContextMetadataRepository() != null) {
            queryResult = publisherInfo.getContextMetadataRepository().query(query, null);
        }
        if (!queryResult.isEmpty()) {
            return queryResult.toUnmodifiableSet();
        }
        return null;
    }

    protected VersionRange createVersionRange(String versionId) {
        VersionRange range = null;
        if (versionId == null || "0.0.0".equals(versionId)) {
            range = VersionRange.emptyRange;
        } else {
            int qualifierIdx = versionId.indexOf(QUALIFIER);
            if (qualifierIdx != -1) {
                String newVersion = versionId.substring(0, qualifierIdx);
                if (newVersion.endsWith(".")) {
                    newVersion = newVersion.substring(0, newVersion.length() - 1);
                }
                Version lower = Version.parseVersion((String)newVersion);
                Version upper = null;
                String newQualifier = VersionSuffixGenerator.incrementQualifier(PublisherHelper.toOSGiVersion((Version)lower).getQualifier());
                org.osgi.framework.Version osgiVersion = PublisherHelper.toOSGiVersion((Version)lower);
                upper = newQualifier == null ? Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)(osgiVersion.getMicro() + 1)) : Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro(), (String)newQualifier);
                range = new VersionRange(lower, true, upper, false);
            } else {
                range = new VersionRange(Version.parseVersion((String)versionId), true, Version.parseVersion((String)versionId), true);
            }
        }
        return range;
    }

    protected Map<SiteFeature, Set<SiteCategory>> getFeatureToCategoryMappings(IPublisherInfo publisherInfo) {
        HashMap<SiteFeature, Set<SiteCategory>> mappings = new HashMap<SiteFeature, Set<SiteCategory>>();
        if (this.updateSite == null) {
            return mappings;
        }
        SiteModel site = this.updateSite.getSite();
        if (site == null) {
            return mappings;
        }
        SiteFeature[] features = site.getFeatures();
        int i = 0;
        while (i < features.length) {
            String[] categoryNames = features[i].getCategoryNames();
            Set<SiteCategory> categories = mappings.get(features[i]);
            if (categories == null) {
                categories = new HashSet<SiteCategory>();
                mappings.put(features[i], categories);
            }
            int j = 0;
            while (j < categoryNames.length) {
                SiteCategory category = site.getCategory(categoryNames[j]);
                if (category != null) {
                    categories.add(category);
                }
                ++j;
            }
            ++i;
        }
        return mappings;
    }

    protected Map<SiteBundle, Set<SiteCategory>> getBundleToCategoryMappings(IPublisherInfo publisherInfo) {
        HashMap<SiteBundle, Set<SiteCategory>> mappings = new HashMap<SiteBundle, Set<SiteCategory>>();
        if (this.updateSite == null) {
            return mappings;
        }
        SiteModel site = this.updateSite.getSite();
        if (site == null) {
            return mappings;
        }
        SiteBundle[] bundles = site.getBundles();
        int i = 0;
        while (i < bundles.length) {
            String[] categoryNames = bundles[i].getCategoryNames();
            HashSet<SiteCategory> categories = new HashSet<SiteCategory>();
            mappings.put(bundles[i], categories);
            int j = 0;
            while (j < categoryNames.length) {
                SiteCategory category = site.getCategory(categoryNames[j]);
                if (category != null) {
                    categories.add(category);
                }
                ++j;
            }
            ++i;
        }
        return mappings;
    }

    private void initializeRepoFromSite(IPublisherInfo publisherInfo) {
        File siteFile;
        URLEntry[] associatedSites;
        SiteModel site = this.updateSite.getSite();
        String mirrors = site.getMirrorsURI();
        if (mirrors != null) {
            int index = mirrors.indexOf("site.xml");
            if (index != -1) {
                mirrors = String.valueOf(mirrors.substring(0, index)) + mirrors.substring(index + "site.xml".length());
            }
            publisherInfo.getMetadataRepository().setProperty("p2.mirrorsURL", mirrors);
            if (publisherInfo.getArtifactRepository() != null) {
                publisherInfo.getArtifactRepository().setProperty("p2.mirrorsURL", mirrors);
            }
        }
        if ((associatedSites = site.getAssociatedSites()) != null) {
            ArrayList<RepositoryReference> refs = new ArrayList<RepositoryReference>(associatedSites.length * 2);
            int i = 0;
            while (i < associatedSites.length) {
                URLEntry associatedSite = associatedSites[i];
                String siteLocation = associatedSite.getURL();
                try {
                    URI associateLocation = new URI(siteLocation);
                    String label = associatedSite.getAnnotation();
                    refs.add(new RepositoryReference(associateLocation, label, 0, 1));
                    refs.add(new RepositoryReference(associateLocation, label, 1, 1));
                }
                catch (URISyntaxException uRISyntaxException) {
                    String message = "Invalid site reference: " + siteLocation;
                    LogHelper.log((IStatus)new Status(4, Activator.ID, message));
                }
                ++i;
            }
            publisherInfo.getMetadataRepository().addReferences(refs);
        }
        if ((siteFile = URIUtil.toFile((URI)this.updateSite.getLocation())) != null && siteFile.exists()) {
            String[] keyStrings;
            File siteParent = siteFile.getParentFile();
            List<String> messageKeys = site.getMessageKeys();
            if (siteParent.isDirectory()) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getDirPropertyLocalizations((File)siteParent, (String)"site", null, (String[])keyStrings));
            } else if (siteFile.getName().endsWith(".jar")) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getJarPropertyLocalizations((File)siteParent, (String)"site", null, (String[])keyStrings));
            }
        }
    }

    protected void generateCategoryIUs(Map<SiteCategory, Set<IInstallableUnit>> categoriesToFeatures, IPublisherResult result) {
        for (SiteCategory category : categoriesToFeatures.keySet()) {
            result.addIU(this.createCategoryIU(category, categoriesToFeatures.get(category), null), "non_root");
        }
    }

    public IInstallableUnit createCategoryIU(SiteCategory category, Set<IInstallableUnit> featureIUs, IInstallableUnit parentCategory) {
        MetadataFactory.InstallableUnitDescription cat = new MetadataFactory.InstallableUnitDescription();
        cat.setSingleton(true);
        String categoryId = this.buildCategoryId(category.getName());
        cat.setId(categoryId);
        if (this.categoryVersion == null) {
            cat.setVersion(Version.createOSGi((int)1, (int)0, (int)0, (String)versionSuffixGenerator.generateSuffix(featureIUs, CollectionUtils.emptyList())));
        } else {
            org.osgi.framework.Version osgiVersion;
            String qualifier;
            if (this.categoryVersion.isOSGiCompatible() && (qualifier = (osgiVersion = PublisherHelper.toOSGiVersion((Version)this.categoryVersion)).getQualifier()).endsWith(QUALIFIER)) {
                String suffix = versionSuffixGenerator.generateSuffix(featureIUs, CollectionUtils.emptyList());
                qualifier = String.valueOf(qualifier.substring(0, qualifier.length() - 9)) + suffix;
                this.categoryVersion = Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro(), (String)qualifier);
            }
            cat.setVersion(this.categoryVersion);
        }
        String label = category.getLabel();
        cat.setProperty("org.eclipse.equinox.p2.name", label != null ? label : category.getName());
        cat.setProperty("org.eclipse.equinox.p2.description", category.getDescription());
        ArrayList<IRequirement> reqsConfigurationUnits = new ArrayList<IRequirement>(featureIUs.size());
        for (IInstallableUnit iu : featureIUs) {
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            reqsConfigurationUnits.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (IMatchExpression)iu.getFilter(), (boolean)false, (boolean)false));
        }
        if (parentCategory != null) {
            reqsConfigurationUnits.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)parentCategory.getId(), (VersionRange)VersionRange.emptyRange, (IMatchExpression)parentCategory.getFilter(), (boolean)false, (boolean)false));
        }
        cat.setRequirements(reqsConfigurationUnits.toArray(new IRequirement[reqsConfigurationUnits.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(PublisherHelper.createSelfCapability((String)categoryId, (Version)cat.getVersion()));
        Map<Locale, Map<String, String>> localizations = category.getLocalizations();
        if (localizations != null) {
            for (Map.Entry<Locale, Map<String, String>> locEntry : localizations.entrySet()) {
                Locale locale = locEntry.getKey();
                Map<String, String> translatedStrings = locEntry.getValue();
                for (Map.Entry<String, String> e : translatedStrings.entrySet()) {
                    cat.setProperty(String.valueOf(locale.toString()) + '.' + e.getKey(), e.getValue());
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability((String)categoryId, (Locale)locale));
            }
        }
        cat.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        cat.setArtifacts(new IArtifactKey[0]);
        cat.setProperty("org.eclipse.equinox.p2.type.category", "true");
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cat);
    }

    private String buildCategoryId(String categoryName) {
        if (this.categoryQualifier != null) {
            if (this.categoryQualifier.length() > 0) {
                return String.valueOf(this.categoryQualifier) + "." + categoryName;
            }
            return categoryName;
        }
        if (this.updateSite != null) {
            return String.valueOf(URIUtil.toUnencodedString((URI)this.updateSite.getLocation())) + "." + categoryName;
        }
        return categoryName;
    }

    protected Transport getTransport(IPublisherInfo info) {
        IMetadataRepository repo = info.getMetadataRepository();
        if (repo == null) {
            repo = info.getArtifactRepository();
        }
        if (repo == null) {
            throw new IllegalStateException("The transport service can not be found.");
        }
        return (Transport)repo.getProvisioningAgent().getService(Transport.SERVICE_NAME);
    }
}

