/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.impl;

import java.util.Collection;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.Contact;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.DescriptionProvider;
import org.eclipse.b3.aggregator.IdentificationProvider;
import org.eclipse.b3.aggregator.InfosProvider;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MavenMapping;
import org.eclipse.b3.aggregator.Status;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.StatusProvider;
import org.eclipse.b3.aggregator.util.GeneralUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionImpl
extends MinimalEObjectImpl.Container
implements Contribution {
    protected int eFlags = 0;
    protected static final boolean BRANCH_ENABLED_EDEFAULT = false;
    protected static final boolean ENABLED_EDEFAULT = true;
    protected static final int ENABLED_EFLAG = 1;
    protected static final String DESCRIPTION_EDEFAULT = "";
    protected String description = "";
    protected EList<String> errors;
    protected EList<String> warnings;
    protected EList<String> infos;
    protected static final String LABEL_EDEFAULT = null;
    protected String label = LABEL_EDEFAULT;
    protected EList<MappedRepository> repositories;
    protected EList<Contact> contacts;
    protected EList<MavenMapping> mavenMappings;
    private Status status;

    protected ContributionImpl() {
        this.eFlags |= 1;
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == DescriptionProvider.class) {
            switch (derivedFeatureID) {
                case 2: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == StatusProvider.class) {
            switch (derivedFeatureID) {
                case 3: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == InfosProvider.class) {
            switch (derivedFeatureID) {
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 2;
                }
            }
            return -1;
        }
        if (baseClass == IdentificationProvider.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == DescriptionProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 2;
                }
            }
            return -1;
        }
        if (baseClass == StatusProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 3;
                }
            }
            return -1;
        }
        if (baseClass == InfosProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 4;
                }
                case 1: {
                    return 5;
                }
                case 2: {
                    return 6;
                }
            }
            return -1;
        }
        if (baseClass == IdentificationProvider.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isBranchEnabled();
            }
            case 1: {
                return this.isEnabled();
            }
            case 2: {
                return this.getDescription();
            }
            case 3: {
                return this.getStatus();
            }
            case 4: {
                return this.getErrors();
            }
            case 5: {
                return this.getWarnings();
            }
            case 6: {
                return this.getInfos();
            }
            case 7: {
                return this.getLabel();
            }
            case 8: {
                return this.getRepositories();
            }
            case 9: {
                return this.getContacts();
            }
            case 10: {
                return this.getMavenMappings();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getRepositories()).basicRemove((Object)otherEnd, msgs);
            }
            case 10: {
                return ((InternalEList)this.getMavenMappings()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetBranchEnabled();
            }
            case 1: {
                return (this.eFlags & 1) == 0;
            }
            case 2: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 3: {
                return this.getStatus() != null;
            }
            case 4: {
                return this.errors != null && !this.errors.isEmpty();
            }
            case 5: {
                return this.warnings != null && !this.warnings.isEmpty();
            }
            case 6: {
                return this.infos != null && !this.infos.isEmpty();
            }
            case 7: {
                return LABEL_EDEFAULT == null ? this.label != null : !LABEL_EDEFAULT.equals(this.label);
            }
            case 8: {
                return this.repositories != null && !this.repositories.isEmpty();
            }
            case 9: {
                return this.contacts != null && !this.contacts.isEmpty();
            }
            case 10: {
                return this.mavenMappings != null && !this.mavenMappings.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setEnabled((Boolean)newValue);
                return;
            }
            case 2: {
                this.setDescription((String)newValue);
                return;
            }
            case 4: {
                this.getErrors().clear();
                this.getErrors().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getWarnings().clear();
                this.getWarnings().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getInfos().clear();
                this.getInfos().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setLabel((String)newValue);
                return;
            }
            case 8: {
                this.getRepositories().clear();
                this.getRepositories().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getContacts().clear();
                this.getContacts().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.getMavenMappings().clear();
                this.getMavenMappings().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.CONTRIBUTION;
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setEnabled(true);
                return;
            }
            case 2: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 4: {
                this.getErrors().clear();
                return;
            }
            case 5: {
                this.getWarnings().clear();
                return;
            }
            case 6: {
                this.getInfos().clear();
                return;
            }
            case 7: {
                this.setLabel(LABEL_EDEFAULT);
                return;
            }
            case 8: {
                this.getRepositories().clear();
                return;
            }
            case 9: {
                this.getContacts().clear();
                return;
            }
            case 10: {
                this.getMavenMappings().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public EList<MavenMapping> getAllMavenMappings() {
        EList<MavenMapping> myMappings = this.getMavenMappings();
        EList<MavenMapping> parentMappings = GeneralUtils.getAggregation((EObject)this).getMavenMappings();
        BasicEList allMappings = new BasicEList(myMappings.size() + parentMappings.size());
        allMappings.addAll(myMappings);
        allMappings.addAll(parentMappings);
        return allMappings;
    }

    @Override
    public EList<Contact> getContacts() {
        if (this.contacts == null) {
            this.contacts = new EObjectResolvingEList(Contact.class, (InternalEObject)this, 9);
        }
        return this.contacts;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public EList<String> getErrors() {
        if (this.errors == null) {
            this.errors = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 4);
        }
        return this.errors;
    }

    @Override
    public String getIdentification() {
        return this.getLabel();
    }

    @Override
    public EList<String> getInfos() {
        if (this.infos == null) {
            this.infos = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 6);
        }
        return this.infos;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public EList<MavenMapping> getMavenMappings() {
        if (this.mavenMappings == null) {
            this.mavenMappings = new EObjectContainmentEList.Resolving(MavenMapping.class, (InternalEObject)this, 10);
        }
        return this.mavenMappings;
    }

    @Override
    public EList<MappedRepository> getRepositories() {
        if (this.repositories == null) {
            this.repositories = new EObjectContainmentEList.Resolving(MappedRepository.class, (InternalEObject)this, 8);
        }
        return this.repositories;
    }

    @Override
    public EList<MappedRepository> getRepositories(boolean enabledOnly) {
        EList<MappedRepository> repos = this.getRepositories();
        if (enabledOnly) {
            repos = GeneralUtils.getEnabled(repos);
        }
        return repos;
    }

    @Override
    public synchronized Status getStatus() {
        StatusCode statusCode;
        if (this.status != null && this.status.getCode() != StatusCode.OK) {
            return this.status;
        }
        for (MappedRepository repo : this.getRepositories()) {
            if (!repo.isEnabled() || (statusCode = repo.getStatus().getCode()) == StatusCode.OK || statusCode == StatusCode.WAITING) continue;
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
        for (MavenMapping mapping : this.getMavenMappings()) {
            statusCode = mapping.getStatus().getCode();
            if (statusCode == StatusCode.OK || statusCode == StatusCode.WAITING) continue;
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
        return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
    }

    @Override
    public EList<String> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 5);
        }
        return this.warnings;
    }

    @Override
    public boolean isBranchEnabled() {
        return GeneralUtils.isBranchEnabled(this);
    }

    @Override
    public boolean isEnabled() {
        return (this.eFlags & 1) != 0;
    }

    @Override
    public boolean isSetBranchEnabled() {
        return true;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        boolean oldEnabled;
        boolean bl = oldEnabled = (this.eFlags & 1) != 0;
        this.eFlags = newEnabled ? (this.eFlags |= 1) : (this.eFlags &= 0xFFFFFFFE);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldEnabled, newEnabled));
        }
    }

    @Override
    public void setLabel(String newLabel) {
        String oldLabel = this.label;
        this.label = newLabel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldLabel, (Object)this.label));
        }
    }

    public void setStatus(Status newStatus) {
        Status oldStatus = this.status;
        this.status = newStatus;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldStatus, (Object)newStatus));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (enabled: ");
        result.append((this.eFlags & 1) != 0);
        result.append(", description: ");
        result.append(this.description);
        result.append(", errors: ");
        result.append(this.errors);
        result.append(", warnings: ");
        result.append(this.warnings);
        result.append(", infos: ");
        result.append(this.infos);
        result.append(", label: ");
        result.append(this.label);
        result.append(')');
        return result.toString();
    }
}

