/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.p2.maven.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.b3.p2.maven.util.AccessibleByteArrayOutputStream;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.b3.util.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UriUtils {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final String linkPatternString = "([^?#][^\"]+/?)";
    private static final Pattern htmlPattern;
    private static final Pattern linkPattern;
    private static final Pattern ftpPattern;
    private static final Pattern indexPath;
    public static final URI[] EMPTY_URI_ARRAY;

    static {
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(false);
        htmlPattern = Pattern.compile("<A\\s+HREF=\"([^?#][^\"]+)\"\\s*>[^<]+</A>", 2);
        linkPattern = Pattern.compile(linkPatternString, 2);
        ftpPattern = Pattern.compile("[a-z]+\\s+[0-9]+\\s+(?:(?:[0-9]+:[0-9]+)|(?:[0-9]{4}))\\s+(.+?)(?:([\\r|\\n])|(\\s+->\\s+))", 2);
        indexPath = Pattern.compile("^(.*/)?index\\.[a-z][a-z0-9]+$");
        EMPTY_URI_ARRAY = new URI[0];
    }

    public static URI appendTrailingSlash(URI uri) {
        if (!uri.getPath().endsWith("/")) {
            try {
                uri = new URI(uri.getScheme(), uri.getAuthority(), String.valueOf(uri.getPath()) + '/', uri.getQuery(), uri.getFragment());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return uri;
    }

    /*
     * Unable to fully structure code
     */
    public static URI[] extractHTMLLinks(Transport transport, URI uriToHTML, IProgressMonitor monitor) throws CoreException {
        block9: {
            links = new ArrayList<URI>();
            try {
                buffer = new AccessibleByteArrayOutputStream(8192, 0x200000);
                transport.download(uriToHTML, (OutputStream)buffer, monitor);
                try {
                    builder = UriUtils.documentBuilderFactory.newDocumentBuilder();
                    builder.setErrorHandler(new ErrorHandler(){

                        @Override
                        public void error(SAXParseException ex) throws SAXException {
                            throw ex;
                        }

                        @Override
                        public void fatalError(SAXParseException ex) throws SAXException {
                            throw ex;
                        }

                        @Override
                        public void warning(SAXParseException ex) throws SAXException {
                        }
                    });
                    source = new InputSource(buffer.getInputStream());
                    source.setSystemId(uriToHTML.toString());
                    document = builder.parse(source);
                    UriUtils.collectLinks(document.getDocumentElement(), uriToHTML, links);
                    break block9;
                }
                catch (SAXException e) {
                    scanner = new Scanner(buffer.getInputStream());
                    parent = UriUtils.appendTrailingSlash(uriToHTML);
                    ** while (scanner.findWithinHorizon((Pattern)UriUtils.htmlPattern, (int)0) != null)
                }
lbl-1000:
                // 1 sources

                {
                    mr = scanner.match();
                    UriUtils.addLink(links, parent, mr.group(1));
                    continue;
                }
lbl21:
                // 1 sources

                scanner.close();
            }
            catch (IllegalStateException e) {
                LogUtils.warning((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                return UriUtils.EMPTY_URI_ARRAY;
            }
            catch (FileNotFoundException e) {
                return UriUtils.EMPTY_URI_ARRAY;
            }
            catch (IOException e) {
                LogUtils.warning((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                return UriUtils.EMPTY_URI_ARRAY;
            }
            catch (ParserConfigurationException e) {
                LogUtils.warning((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                return UriUtils.EMPTY_URI_ARRAY;
            }
            catch (URISyntaxException e) {
                LogUtils.warning((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                return UriUtils.EMPTY_URI_ARRAY;
            }
        }
        return links.toArray(new URI[links.size()]);
    }

    public static File getFile(URI uri) throws MalformedURLException {
        if (uri == null) {
            return null;
        }
        String proto = uri.toURL().getProtocol();
        if (proto == null) {
            return new File(uri);
        }
        if ("file".equalsIgnoreCase(proto)) {
            String path = uri.toString().replace("file:", "");
            return new File(path);
        }
        return null;
    }

    public static URI[] list(Transport transport, URI uri, IProgressMonitor monitor) throws CoreException {
        File dir = null;
        try {
            dir = UriUtils.getFile(uri);
        }
        catch (MalformedURLException e) {
            LogUtils.warning((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
            return EMPTY_URI_ARRAY;
        }
        if (dir != null) {
            File[] list = dir.listFiles();
            if (list == null) {
                return EMPTY_URI_ARRAY;
            }
            int top = list.length;
            if (top == 0) {
                return EMPTY_URI_ARRAY;
            }
            URI[] result = new URI[top];
            while (--top >= 0) {
                URI fileUri;
                File file = list[top];
                result[top] = fileUri = UriUtils.normalizeToURI(file.toString(), file.isDirectory());
            }
            MonitorUtils.complete((IProgressMonitor)monitor);
            return result;
        }
        String proto = null;
        try {
            proto = uri.toURL().getProtocol();
        }
        catch (MalformedURLException e) {
            LogUtils.warning((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
            return EMPTY_URI_ARRAY;
        }
        if (proto.equalsIgnoreCase("ftp") || proto.equalsIgnoreCase("sftp")) {
            ArrayList<URI> result = new ArrayList<URI>();
            Scanner scanner = null;
            try {
                scanner = new Scanner(transport.stream(uri, monitor));
                uri = UriUtils.appendTrailingSlash(uri);
                while (scanner.findWithinHorizon(ftpPattern, 0) != null) {
                    MatchResult mr = scanner.match();
                    result.add(new URI(uri.getScheme(), uri.getAuthority(), String.valueOf(uri.getPath()) + '/' + mr.group(1), uri.getQuery(), uri.getFragment()));
                }
                URI[] uRIArray = result.toArray(new URI[result.size()]);
                return uRIArray;
            }
            catch (CoreException e) {
                LogUtils.warning((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                URI[] uRIArray = EMPTY_URI_ARRAY;
                return uRIArray;
            }
            catch (FileNotFoundException e) {
                URI[] uRIArray = EMPTY_URI_ARRAY;
                return uRIArray;
            }
            catch (IOException e) {
                LogUtils.warning((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                URI[] uRIArray = EMPTY_URI_ARRAY;
                return uRIArray;
            }
            catch (URISyntaxException e) {
                LogUtils.warning((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                URI[] uRIArray = EMPTY_URI_ARRAY;
                return uRIArray;
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        return UriUtils.extractHTMLLinks(transport, uri, monitor);
    }

    public static URI normalizeToURI(String pathOrURI, boolean asFolder) throws CoreException {
        String scheme;
        URI uri;
        char c;
        if (pathOrURI == null || pathOrURI.length() == 0) {
            return null;
        }
        if ((pathOrURI = pathOrURI.replace('\\', '/')).length() > 1 && pathOrURI.charAt(1) == ':' && ((c = pathOrURI.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            pathOrURI = "file:/" + pathOrURI;
        }
        try {
            uri = new URI(pathOrURI);
        }
        catch (URISyntaxException e) {
            if (pathOrURI.indexOf(32) < 0) {
                throw ExceptionUtils.wrap((Throwable)e);
            }
            try {
                uri = new URI(pathOrURI.replaceAll("\\s", "%20"));
            }
            catch (URISyntaxException e2) {
                throw ExceptionUtils.wrap((Throwable)e2);
            }
        }
        boolean change = false;
        String path = uri.getPath();
        if (asFolder && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
            change = true;
        }
        if ((scheme = uri.getScheme()) == null) {
            scheme = "file";
            change = true;
        }
        try {
            if (change) {
                uri = new URI(scheme, uri.getAuthority(), path, uri.getQuery(), uri.getFragment());
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.wrap((Throwable)e);
        }
    }

    private static void addLink(List<URI> links, URI parent, String link) throws URISyntaxException {
        if (link.equals("../")) {
            return;
        }
        try {
            int slashIdx;
            URI child = URI.create(link);
            String query = child.getQuery();
            String fragment = child.getFragment();
            if (query != null || fragment != null) {
                return;
            }
            String scheme = parent.getScheme();
            String childScheme = child.getScheme();
            if (scheme == null ? childScheme != null : childScheme != null && !childScheme.equals(scheme)) {
                return;
            }
            String host = parent.getHost();
            String childHost = child.getHost();
            if (host == null ? childHost != null : childHost != null && !childHost.equals(host)) {
                return;
            }
            int port = parent.getPort();
            int childPort = child.getPort();
            if (port == -1 ? childPort != -1 : childPort != -1 && childPort != port) {
                return;
            }
            String path = parent.getPath();
            String childPath = child.getPath();
            if (path == null || childPath == null) {
                return;
            }
            if (childPath.startsWith(path)) {
                childPath = childPath.substring(path.length());
            }
            if ((slashIdx = childPath.indexOf(47)) >= 0 && slashIdx != childPath.length() - 1) {
                return;
            }
            if (childPath.length() == 0 || childPath.startsWith(".") || childPath.equals("/")) {
                return;
            }
            link = childPath;
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Matcher m = indexPath.matcher(link);
        if (m.matches() && (link = m.group(1)) == null) {
            return;
        }
        links.add(new URI(parent.getScheme(), parent.getAuthority(), String.valueOf(parent.getPath()) + link, parent.getQuery(), parent.getFragment()));
    }

    private static void collectLinks(Element element, URI parent, ArrayList<URI> links) throws URISyntaxException {
        if (element.getNodeName().equals("a")) {
            String link = element.getAttribute("href");
            if (linkPattern.matcher(link).matches()) {
                UriUtils.addLink(links, parent, link);
            }
        } else {
            Node child = element.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    UriUtils.collectLinks((Element)child, parent, links);
                }
                child = child.getNextSibling();
            }
        }
    }
}

