/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.BasicVersion;
import org.eclipse.equinox.p2.metadata.VersionedId;

public class VersionSuffixGenerator {
    public static final String VERSION_QUALIFIER = "qualifier";
    private Map<String, Integer> contextQualifierLengths;
    private static final int QUALIFIER_SUFFIX_VERSION = 1;
    private static final String BASE_64_ENCODING = "-0123456789_ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private final int maxVersionSuffixLength;
    private final int significantDigits;

    private static void appendEncodedCharacter(StringBuilder buffer, int c) {
        while (c > 62) {
            buffer.append('z');
            c -= 63;
        }
        buffer.append(VersionSuffixGenerator.base64Character(c));
    }

    private static char base64Character(int number) {
        return number < 0 || number > 63 ? (char)' ' : BASE_64_ENCODING.charAt(number);
    }

    private static int charValue(char c) {
        int index = BASE_64_ENCODING.indexOf(c);
        return index + 1;
    }

    private static String lengthPrefixBase64(long number) {
        int length = 7;
        int i = 0;
        while (i < 7) {
            if (number < 1L << i * 6 + 3) {
                length = i;
                break;
            }
            ++i;
        }
        StringBuilder result = new StringBuilder(length + 1);
        result.append(VersionSuffixGenerator.base64Character((length << 3) + (int)(number >> 6 * length & 7L)));
        while (--length >= 0) {
            result.append(VersionSuffixGenerator.base64Character((int)(number >> 6 * length & 0x3FL)));
        }
        return result.toString();
    }

    private static int computeNameSum(String name) {
        int sum = 0;
        int top = name.length();
        int lshift = 20;
        int idx = 0;
        while (idx < top) {
            int c = name.charAt(idx) & 0xFFFF;
            if (c == 46 && lshift > 0) {
                lshift -= 4;
            } else {
                sum += c << lshift;
            }
            ++idx;
        }
        return sum;
    }

    public VersionSuffixGenerator() {
        this(-1, -1);
    }

    public VersionSuffixGenerator(int maxVersionSuffixLenght, int significantDigits) {
        this.maxVersionSuffixLength = maxVersionSuffixLenght < 0 ? 28 : maxVersionSuffixLenght;
        this.significantDigits = significantDigits < 0 ? Integer.MAX_VALUE : significantDigits;
    }

    public void addContextQualifierLength(String context, int length) {
        if (this.contextQualifierLengths == null) {
            this.contextQualifierLengths = new HashMap<String, Integer>();
        }
        this.contextQualifierLengths.put(context, length);
    }

    public String generateSuffix(List<VersionedId> features, List<VersionedId> bundles) {
        String qualifier2;
        BasicVersion version;
        if (this.maxVersionSuffixLength <= 0) {
            return null;
        }
        long majorSum = 0L;
        long minorSum = 0L;
        long serviceSum = 0L;
        long nameCharsSum = 0L;
        ++majorSum;
        int numElements = features.size() + bundles.size();
        if (numElements == 0) {
            return null;
        }
        String[] qualifiers = new String[numElements];
        int idx = 0;
        for (VersionedId refFeature : features) {
            version = (BasicVersion)refFeature.getVersion();
            try {
                majorSum += (long)version.getMajor();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                minorSum += (long)version.getMinor();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                serviceSum += (long)version.getMicro();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            qualifier2 = null;
            try {
                qualifier2 = version.getQualifier();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            Integer ctxLen = this.contextQualifierLengths == null ? null : this.contextQualifierLengths.get(refFeature.getId());
            int contextLength = ctxLen == null ? -1 : ctxLen;
            if (qualifier2 != null && ++contextLength > 0 && qualifier2.length() > contextLength) {
                qualifier2 = qualifier2.substring(contextLength);
            }
            qualifiers[idx++] = qualifier2;
            nameCharsSum = VersionSuffixGenerator.computeNameSum(refFeature.getId());
        }
        for (VersionedId refBundle : bundles) {
            version = (BasicVersion)refBundle.getVersion();
            try {
                majorSum += (long)version.getMajor();
            }
            catch (UnsupportedOperationException qualifier2) {
                // empty catch block
            }
            try {
                minorSum += (long)version.getMinor();
            }
            catch (UnsupportedOperationException qualifier2) {
                // empty catch block
            }
            try {
                serviceSum += (long)version.getMicro();
            }
            catch (UnsupportedOperationException qualifier2) {
                // empty catch block
            }
            qualifier2 = null;
            try {
                qualifier2 = version.isOSGiCompatible() ? version.getQualifier() : null;
            }
            catch (UnsupportedOperationException ctxLen) {
                // empty catch block
            }
            if (qualifier2 != null && qualifier2.endsWith(VERSION_QUALIFIER)) {
                int resultingLength = qualifier2.length() - VERSION_QUALIFIER.length();
                if (resultingLength > 0) {
                    if (qualifier2.charAt(resultingLength - 1) == '.') {
                        --resultingLength;
                    }
                    qualifier2 = resultingLength > 0 ? qualifier2.substring(0, resultingLength) : null;
                } else {
                    qualifier2 = null;
                }
            }
            qualifiers[idx++] = qualifier2;
        }
        int longestQualifier = 0;
        while (--idx >= 0) {
            String qualifier3 = qualifiers[idx];
            if (qualifier3 == null) continue;
            if (qualifier3.length() > this.significantDigits) {
                qualifiers[idx] = qualifier3 = qualifier3.substring(0, this.significantDigits);
            }
            if (qualifier3.length() <= longestQualifier) continue;
            longestQualifier = qualifier3.length();
        }
        StringBuilder result = new StringBuilder();
        result.append(VersionSuffixGenerator.lengthPrefixBase64(majorSum));
        result.append(VersionSuffixGenerator.lengthPrefixBase64(minorSum));
        result.append(VersionSuffixGenerator.lengthPrefixBase64(serviceSum));
        result.append(VersionSuffixGenerator.lengthPrefixBase64(nameCharsSum));
        if (longestQualifier > 0) {
            int[] qualifierSums = new int[longestQualifier];
            idx = 0;
            while (idx < numElements) {
                qualifier2 = qualifiers[idx];
                if (qualifier2 != null) {
                    int top = qualifier2.length();
                    int j = 0;
                    while (j < top) {
                        int n = j;
                        qualifierSums[n] = qualifierSums[n] + VersionSuffixGenerator.charValue(qualifier2.charAt(j));
                        ++j;
                    }
                }
                ++idx;
            }
            int carry = 0;
            int k = longestQualifier - 1;
            while (k >= 1) {
                int n = k;
                qualifierSums[n] = qualifierSums[n] + carry;
                carry = qualifierSums[k] / 65;
                qualifierSums[k] = qualifierSums[k] % 65;
                --k;
            }
            qualifierSums[0] = qualifierSums[0] + carry;
            result.append(VersionSuffixGenerator.lengthPrefixBase64(qualifierSums[0]));
            int m = 1;
            while (m < longestQualifier) {
                VersionSuffixGenerator.appendEncodedCharacter(result, qualifierSums[m]);
                ++m;
            }
        }
        if (result.length() > this.maxVersionSuffixLength) {
            result.setLength(this.maxVersionSuffixLength);
        }
        int len = result.length();
        while (len > 0 && result.charAt(len - 1) == '-') {
            result.setLength(--len);
        }
        return result.toString();
    }
}

