/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.b3.aggregator.Category;
import org.eclipse.b3.aggregator.Configuration;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.ExclusionRule;
import org.eclipse.b3.aggregator.InstallableUnitType;
import org.eclipse.b3.aggregator.MapRule;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MappedUnit;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.ValidConfigurationsRule;
import org.eclipse.b3.aggregator.ValidationSet;
import org.eclipse.b3.aggregator.engine.Builder;
import org.eclipse.b3.aggregator.engine.internal.RequirementUtils;
import org.eclipse.b3.aggregator.util.InstallableUnitUtils;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.b3.util.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.internal.p2.metadata.expression.ExpressionFactory;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;

public class VerificationIUAction
extends AbstractPublisherAction {
    private final Builder builder;
    private final ValidationSet validationSet;

    private static IMatchExpression<IInstallableUnit> createFilter(List<Configuration> configs) {
        List<Configuration> enabledConfigs = VerificationIUAction.getEnabledConfigs(configs);
        if (enabledConfigs != null && !enabledConfigs.isEmpty()) {
            StringBuilder filterBld = new StringBuilder();
            if (enabledConfigs.size() > 1) {
                filterBld.append("(|");
            }
            for (Configuration config : enabledConfigs) {
                filterBld.append("(&(osgi.os=");
                filterBld.append(config.getOperatingSystem().getLiteral());
                filterBld.append(")(osgi.ws=");
                filterBld.append(config.getWindowSystem().getLiteral());
                filterBld.append(")(osgi.arch=");
                filterBld.append(config.getArchitecture().getLiteral());
                filterBld.append("))");
            }
            if (enabledConfigs.size() > 1) {
                filterBld.append(')');
            }
            return ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)"properties ~= $0"), new Object[]{ExpressionUtil.parseLDAP((String)filterBld.toString())});
        }
        return null;
    }

    private static List<Configuration> getEnabledConfigs(List<Configuration> configs) {
        ArrayList<Configuration> enabledConfigs = new ArrayList<Configuration>();
        for (Configuration config : configs) {
            if (!config.isEnabled()) continue;
            enabledConfigs.add(config);
        }
        return enabledConfigs;
    }

    public VerificationIUAction(Builder builder, ValidationSet validationSet) {
        this.builder = builder;
        this.validationSet = validationSet;
    }

    private void addCategoryContent(IInstallableUnit category, MappedRepository repository, List<IInstallableUnit> allIUs, Map<String, Set<RepositoryRequirement>> required, List<String> errors, Set<String> explicit) {
        block0: for (IRequirement rc : category.getRequirements()) {
            for (IInstallableUnit riu : allIUs) {
                if (!riu.satisfies(rc)) continue;
                if ("true".equalsIgnoreCase(riu.getProperty("org.eclipse.equinox.p2.type.category"))) {
                    this.addCategoryContent(riu, repository, allIUs, required, errors, explicit);
                    continue block0;
                }
                this.addRequirementFor(repository, riu, (IMatchExpression<IInstallableUnit>)rc.getFilter(), required, errors, explicit, false);
                continue block0;
            }
            String error = String.format("Category %s includes a requirement for %s that cannot be fulfilled", category.getId(), rc);
            errors.add(error);
            LogUtils.error((String)error, (Object[])new Object[0]);
        }
    }

    private void addRequirementFor(MappedRepository mr, IInstallableUnit iu, IMatchExpression<IInstallableUnit> filter, Map<String, Set<RepositoryRequirement>> requirements, List<String> errors, Set<String> explicit, boolean isExplicit) {
        IRequirement rc;
        String id = iu.getId();
        Version v = iu.getVersion();
        VersionRange range = null;
        if (!Version.emptyVersion.equals(v)) {
            range = new VersionRange(v, true, v, true);
        }
        IMatchExpression iuFilter = filter;
        IMatchExpression origFilter = iu.getFilter();
        if (origFilter != null && filter != null) {
            Object[] origFilterParams = origFilter.getParameters();
            Object[] filterParams = filter.getParameters();
            Object[] compoundParams = new Object[origFilterParams.length + filterParams.length];
            System.arraycopy(origFilterParams, 0, compoundParams, 0, origFilterParams.length);
            System.arraycopy(filterParams, 0, compoundParams, origFilterParams.length, filterParams.length);
            iuFilter = ExpressionFactory.INSTANCE.matchExpression(ExpressionFactory.INSTANCE.and(new IExpression[]{origFilter, filter}), compoundParams);
        }
        IRequirement req = rc = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, iuFilter, (boolean)false, (boolean)false);
        this.addRequirementFor(mr, req, requirements, errors, explicit, isExplicit);
    }

    private void addRequirementFor(MappedRepository mr, IRequirement rc, Map<String, Set<RepositoryRequirement>> requirements, List<String> errors, Set<String> explicit, boolean isExplicit) {
        String id = RequirementUtils.getName(rc);
        for (MapRule rule : mr.getMapRules(true)) {
            if (!(rule instanceof ExclusionRule) || !id.equals(rule.getName()) || !RequirementUtils.isIntersectingWith(rc, rule.getVersionRange())) continue;
            return;
        }
        RepositoryRequirement rq = new RepositoryRequirement(mr, rc, isExplicit);
        Set<RepositoryRequirement> repoReqs = requirements.get(id);
        if (repoReqs == null) {
            repoReqs = new HashSet<RepositoryRequirement>();
            requirements.put(id, repoReqs);
        }
        repoReqs.add(rq);
        if (repoReqs.size() == 1) {
            if (isExplicit) {
                explicit.add(id);
            }
            return;
        }
        for (RepositoryRequirement req : repoReqs) {
            this.builder.addMappingExclusion(req.repository);
        }
        if (explicit.contains(id)) {
            if (!isExplicit) {
                LogUtils.debug((String)"%s excluded since it is already explicitly mapped", (Object[])new Object[]{rc.toString()});
                repoReqs.remove(rq);
            } else {
                boolean filtersAllTheSame = true;
                for (RepositoryRequirement repositoryRequirement : repoReqs) {
                    if ((rc.getFilter() == null || rc.getFilter().equals(repositoryRequirement.requirement.getFilter())) && (rc.getFilter() != null || repositoryRequirement.requirement.getFilter() == null)) continue;
                    filtersAllTheSame = false;
                    break;
                }
                if (!filtersAllTheSame) {
                    String error = String.format("%s is explicitly mapped more than once but with different configurations", id);
                    errors.add(error);
                    LogUtils.error((String)error, (Object[])new Object[0]);
                }
            }
            return;
        }
        if (isExplicit) {
            Iterator<RepositoryRequirement> itor = repoReqs.iterator();
            while (itor.hasNext()) {
                RepositoryRequirement req = itor.next();
                if (req.equals(rq)) continue;
                LogUtils.debug((String)"%s excluded since it is explicitly mapped", (Object[])new Object[]{req.requirement.toString()});
                itor.remove();
            }
            explicit.add(id);
            return;
        }
        IRequirement orig = null;
        for (RepositoryRequirement req : repoReqs) {
            if (!req.equals(rq)) continue;
            orig = req.requirement;
            break;
        }
        IRequirement modifiedReq = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)VersionRange.emptyRange, (IMatchExpression)orig.getFilter(), (boolean)false, (boolean)false);
        for (RepositoryRequirement repositoryRequirement : repoReqs) {
            repositoryRequirement.requirement = modifiedReq;
        }
    }

    private IRequirement createRejection(ExclusionRule exclusionRule) {
        return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)exclusionRule.getName(), (VersionRange)exclusionRule.getVersionRange(), null, (int)0, (int)0, (boolean)false, (String)exclusionRule.getDescription());
    }

    public String getRelativeEObjectURI(EObject eObject) {
        return EcoreUtil.getURI((EObject)eObject).deresolve(((EObject)this.builder.getAggregation()).eResource().getURI()).toString();
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        HashMap<String, Set<RepositoryRequirement>> required = new HashMap<String, Set<RepositoryRequirement>>();
        boolean errorsFound = false;
        EList validationSetContribs = this.validationSet.getAllContributions();
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 + validationSetContribs.size()));
        try {
            HashSet<String> explicit = new HashSet<String>();
            for (Contribution contrib : validationSetContribs) {
                ArrayList errors = new ArrayList();
                for (MappedRepository mappedRepository : contrib.getRepositories(true)) {
                    EList allIUs;
                    try {
                        allIUs = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)mappedRepository).getInstallableUnits();
                    }
                    catch (CoreException e) {
                        LogUtils.error((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                        errors.add(e.getMessage());
                        continue;
                    }
                    if (mappedRepository.isMapExclusive()) {
                        for (MappedUnit mu : mappedRepository.getUnits(true)) {
                            if (mu instanceof Category) {
                                this.addCategoryContent(mu.resolveAsSingleton(true), mappedRepository, (List<IInstallableUnit>)allIUs, required, errors, explicit);
                                continue;
                            }
                            this.addRequirementFor(mappedRepository, mu.getRequirement(), required, errors, explicit, true);
                        }
                        continue;
                    }
                    EList mapRules = mappedRepository.getMapRules(true);
                    HashMap<IMatchExpression<IInstallableUnit>, ArrayList<IInstallableUnit>> preSelectedIUs = new HashMap<IMatchExpression<IInstallableUnit>, ArrayList<IInstallableUnit>>();
                    block9: for (IInstallableUnit iInstallableUnit : allIUs) {
                        InstallableUnitType riuType;
                        if (iInstallableUnit instanceof IInstallableUnitPatch || (riuType = InstallableUnitUtils.getType((IInstallableUnit)iInstallableUnit)) != InstallableUnitType.PRODUCT && riuType != InstallableUnitType.FEATURE) continue;
                        IMatchExpression<IInstallableUnit> filter = null;
                        for (MapRule rule : mapRules) {
                            if (!iInstallableUnit.getId().equals(rule.getName()) || !rule.getVersionRange().isIncluded(iInstallableUnit.getVersion())) continue;
                            if (rule instanceof ExclusionRule) {
                                this.builder.addMappingExclusion(mappedRepository);
                                continue block9;
                            }
                            if (!(rule instanceof ValidConfigurationsRule)) continue;
                            if (filter != null) {
                                throw new IllegalStateException("Only one configuration rule per IU name can be specified");
                            }
                            filter = VerificationIUAction.createFilter((List<Configuration>)((ValidConfigurationsRule)rule).getValidConfigurations());
                        }
                        ArrayList<IInstallableUnit> units = (ArrayList<IInstallableUnit>)preSelectedIUs.get(filter);
                        if (units == null) {
                            units = new ArrayList<IInstallableUnit>();
                            preSelectedIUs.put(filter, units);
                        }
                        units.add(iInstallableUnit);
                    }
                    for (Map.Entry entry : preSelectedIUs.entrySet()) {
                        IRequirement[] iRequirementArray = RequirementUtils.createAllAvailableVersionsRequirements((List)entry.getValue(), (IMatchExpression<IInstallableUnit>)((IMatchExpression)entry.getKey()));
                        int n = iRequirementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IRequirement req = iRequirementArray[n2];
                            this.addRequirementFor(mappedRepository, req, required, errors, explicit, false);
                            ++n2;
                        }
                    }
                }
                if (errors.size() > 0) {
                    errorsFound = true;
                    this.builder.sendEmail(contrib, errors);
                }
                MonitorUtils.worked((IProgressMonitor)subMon, (int)1);
            }
            if (errorsFound) {
                Status status = new Status(4, "org.eclipse.b3.aggregator.engine", "Features without repositories");
                return status;
            }
            HashMap<MappedRepository, ArrayList<IRequirement>> crMap = new HashMap<MappedRepository, ArrayList<IRequirement>>();
            for (Set rcSet : required.values()) {
                for (RepositoryRequirement repositoryRequirement : rcSet) {
                    MappedRepository mappedRepository = repositoryRequirement.repository;
                    ArrayList<IRequirement> rList = (ArrayList<IRequirement>)crMap.get(mappedRepository);
                    if (rList == null) {
                        rList = new ArrayList<IRequirement>();
                        crMap.put(mappedRepository, rList);
                    }
                    rList.add(repositoryRequirement.requirement);
                }
            }
            MetadataFactory.InstallableUnitDescription iuDescription = new MetadataFactory.InstallableUnitDescription();
            iuDescription.setId("Cannot be installed into the IDE");
            iuDescription.setVersion(Version.emptyVersion);
            iuDescription.setProperty("org.eclipse.b3.aggregator.generated.IU", Boolean.TRUE.toString());
            iuDescription.addProvidedCapabilities(Collections.singletonList(MetadataFactory.createProvidedCapability((String)"A.PDE.Target.Platform", (String)iuDescription.getId(), (Version)iuDescription.getVersion())));
            results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription), "non_root");
            ArrayList<IRequirement> rList = new ArrayList<IRequirement>(crMap.size());
            for (Map.Entry entry : crMap.entrySet()) {
                MappedRepository repository = (MappedRepository)entry.getKey();
                ArrayList crList = (ArrayList)entry.getValue();
                ArrayList<IRequirement> rejections = new ArrayList<IRequirement>();
                for (MapRule mapRule : repository.getMapRules(true)) {
                    if (!(mapRule instanceof ExclusionRule)) continue;
                    rejections.add(this.createRejection((ExclusionRule)mapRule));
                }
                if (!rejections.isEmpty()) {
                    MetadataFactory.InstallableUnitDescription installableUnitDescription = new MetadataFactory.InstallableUnitDescription();
                    installableUnitDescription.setId(String.valueOf(this.builder.getMappedRepositoryVerificationIUName(repository)) + "_rejections");
                    installableUnitDescription.setVersion(Builder.ALL_CONTRIBUTED_CONTENT_VERSION);
                    installableUnitDescription.setProperty("org.eclipse.b3.aggregator.generated.IU", Boolean.TRUE.toString());
                    installableUnitDescription.addProvidedCapabilities(Collections.singletonList(this.createSelfCapability(installableUnitDescription.getId(), installableUnitDescription.getVersion())));
                    installableUnitDescription.setRequirements(rejections.toArray(new IRequirement[rejections.size()]));
                    IInstallableUnit rejecterIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)installableUnitDescription);
                    results.addIU(rejecterIU, "non_root");
                    crList.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)rejecterIU.getId(), (VersionRange)new VersionRange(rejecterIU.getVersion(), true, rejecterIU.getVersion(), true), null, (int)1, (int)1, (boolean)true));
                }
                iuDescription.setId(this.builder.getMappedRepositoryVerificationIUName(repository));
                iuDescription.setVersion(Builder.ALL_CONTRIBUTED_CONTENT_VERSION);
                iuDescription.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
                iuDescription.setProperty("org.eclipse.b3.aggregator.model.element.URI", this.getRelativeEObjectURI((EObject)repository));
                iuDescription.setProperty("org.eclipse.b3.aggregator.generated.IU", Boolean.TRUE.toString());
                iuDescription.addProvidedCapabilities(Collections.singletonList(this.createSelfCapability(iuDescription.getId(), iuDescription.getVersion())));
                iuDescription.setRequirements(crList.toArray(new IRequirement[crList.size()]));
                rList.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)iuDescription.getId(), (VersionRange)new VersionRange(iuDescription.getVersion(), true, iuDescription.getVersion(), true), null, (boolean)false, (boolean)false));
                results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription), "non_root");
            }
            iuDescription.setId(this.builder.getVerificationIUName(this.validationSet));
            iuDescription.setVersion(Builder.ALL_CONTRIBUTED_CONTENT_VERSION);
            iuDescription.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
            iuDescription.setProperty("org.eclipse.b3.aggregator.generated.IU", Boolean.TRUE.toString());
            iuDescription.addProvidedCapabilities(Collections.singletonList(this.createSelfCapability(iuDescription.getId(), iuDescription.getVersion())));
            iuDescription.setRequirements(rList.toArray(new IRequirement[rList.size()]));
            results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription), "root");
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            MonitorUtils.done((IProgressMonitor)subMon);
        }
    }

    static class RepositoryRequirement {
        MappedRepository repository;
        IRequirement requirement;
        boolean explicit;

        public RepositoryRequirement(MappedRepository repository, IRequirement requirement, boolean explicit) {
            this.repository = repository;
            this.requirement = requirement;
            this.explicit = explicit;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RepositoryRequirement)) {
                return false;
            }
            RepositoryRequirement other = (RepositoryRequirement)o;
            return other.repository.equals(this.repository) && other.requirement.equals(this.requirement) && other.explicit == this.explicit;
        }
    }
}

