/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.b3.aggregator.Aggregation;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.ValidationSet;
import org.eclipse.b3.aggregator.p2.util.MetadataRepositoryResourceImpl;
import org.eclipse.b3.aggregator.util.AggregatorResourceImpl;
import org.eclipse.b3.cli.HeadlessActivator;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ResourceUtils {
    public static void cleanUpResources(Aggregation aggregator) {
        ResourceUtils.cleanUpResources(aggregator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpResources(Aggregation aggregator, boolean updateMarkers) {
        ResourceSet topSet;
        Resource topResource = ((EObject)aggregator).eResource();
        if (topResource == null) {
            return;
        }
        ResourceSet resourceSet = topSet = topResource.getResourceSet();
        synchronized (resourceSet) {
            HashSet<Resource> referencedResources = new HashSet<Resource>();
            referencedResources.add(topResource);
            for (ValidationSet vs : aggregator.getValidationSets()) {
                for (Contribution contribution : vs.getContributions()) {
                    for (MappedRepository mappedRepository : contribution.getRepositories()) {
                        if (mappedRepository.isBranchEnabled()) {
                            if (mappedRepository.getResolvedLocation() == null) continue;
                            URI repoURI = MetadataRepositoryResourceImpl.getResourceUriForNatureAndLocation(mappedRepository.getNature(), mappedRepository.getResolvedLocation());
                            referencedResources.add(topSet.getResource(repoURI, false));
                            continue;
                        }
                        if (mappedRepository.getMetadataRepository(false) == null) continue;
                        mappedRepository.setMetadataRepository(null);
                    }
                }
                for (MetadataRepositoryReference repoRef : vs.getValidationRepositories()) {
                    if (repoRef.isBranchEnabled()) {
                        if (repoRef.getResolvedLocation() == null) continue;
                        URI repoURI = MetadataRepositoryResourceImpl.getResourceUriForNatureAndLocation(repoRef.getNature(), repoRef.getResolvedLocation());
                        referencedResources.add(topSet.getResource(repoURI, false));
                        continue;
                    }
                    if (repoRef.getMetadataRepository(false) == null) continue;
                    repoRef.setMetadataRepository(null);
                }
            }
            Iterator allResources = topSet.getResources().iterator();
            while (allResources.hasNext()) {
                Resource res = (Resource)allResources.next();
                if (referencedResources.contains(res) || !(res instanceof MetadataRepositoryResourceImpl)) continue;
                ((MetadataRepositoryResourceImpl)res).cancelLoadingJob();
                allResources.remove();
            }
        }
        if (updateMarkers && !HeadlessActivator.getInstance().isHeadless()) {
            ((AggregatorResourceImpl)topResource).analyzeResource();
        }
    }

    public static Aggregation getAggregation(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        EList resources = resourceSet.getResources();
        Resource aggregatorResource = null;
        for (Resource resource : resources) {
            if (!(resource instanceof AggregatorResourceImpl)) continue;
            aggregatorResource = resource;
            break;
        }
        return aggregatorResource == null ? null : (Aggregation)aggregatorResource.getContents().get(0);
    }

    public static MetadataRepository getMetadataRepository(MetadataRepositoryReference repoRef) throws CoreException {
        MetadataRepository mdr = repoRef.getMetadataRepository();
        if (mdr == null) {
            Resource resource = ((EObject)repoRef).eResource();
            if (resource != null && resource instanceof MetadataRepositoryResourceImpl && ((MetadataRepositoryResourceImpl)resource).getLastException() != null) {
                throw ExceptionUtils.wrap((Throwable)((MetadataRepositoryResourceImpl)resource).getLastException());
            }
            throw ExceptionUtils.fromMessage((String)("Error loading repository " + repoRef.getResolvedLocation()), (Object[])new Object[0]);
        }
        return mdr;
    }

    public static String getResourceXMLNS(URI resourceURI, String resourceTopNodeName, String resourceNSAttributeName) {
        class XMLNSHandler
        extends DefaultHandler {
            private String xmlns;
            private final /* synthetic */ String val$resourceTopNodeName;
            private final /* synthetic */ String val$resourceNSAttributeName;

            XMLNSHandler(String string, String string2) {
                this.val$resourceTopNodeName = string;
                this.val$resourceNSAttributeName = string2;
            }

            public String getXMLNS() {
                return this.xmlns;
            }

            public void startElement(String nsURI, String strippedName, String tagName, Attributes attributes) throws SAXException {
                if (tagName.equalsIgnoreCase(this.val$resourceTopNodeName)) {
                    this.xmlns = attributes.getValue(this.val$resourceNSAttributeName);
                    throw new SAXException("XMLNS is read");
                }
            }
        }
        XMLNSHandler xmlnsHandler = null;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            xmlnsHandler = new XMLNSHandler(resourceTopNodeName, resourceNSAttributeName);
            parser.setContentHandler(xmlnsHandler);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parser.parse(new InputSource(new ExtensibleURIConverterImpl().createInputStream(resourceURI)));
        }
        catch (SAXException e) {
            if (xmlnsHandler != null) {
                return xmlnsHandler.getXMLNS();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isCurrentModel(URI resourceURI) {
        String topElement = "aggregator:" + AggregatorPackage.eINSTANCE.getAggregation().getName();
        String nsAttribute = "xmlns:aggregator";
        String xmlns = ResourceUtils.getResourceXMLNS(resourceURI, topElement, nsAttribute);
        return "http://www.eclipse.org/b3/2011/aggregator/1.1.0".equals(xmlns);
    }

    public static void loadResourceForMappedRepository(MetadataRepositoryReference repoRef) {
        repoRef.startRepositoryLoad(false);
    }
}

