/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    public static void close(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        IOUtils.copyStream(is, os, true, true);
    }

    public static void copyStream(InputStream is, OutputStream os, boolean closeInput, boolean closeOutput) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        finally {
            try {
                if (closeInput) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            if (closeOutput) {
                os.close();
            }
        }
    }

    public static String readString(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copyStream(is, os);
        return new String(os.toByteArray());
    }
}

