/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.engine.ModelAbstractCommand;
import org.eclipse.b3.aggregator.impl.MetadataRepositoryReferenceImpl;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.kohsuke.args4j.Option;

public class Modifier
extends ModelAbstractCommand {
    @Option(name="--action", usage="Specifies the type of the execution.")
    private ActionType action;
    @Option(name="--repoLocation", usage="Appoints a new repository for aggregation")
    private String repoLocation;

    public String getShortDescription() {
        return "Modifies the aggregates model from the command line";
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        try {
            EList metadataRepos;
            Aggregator aggregator = this.loadModelFromFile();
            if (this.action == ActionType.ADD) {
                MetadataRepositoryReferenceImpl newRepository = (MetadataRepositoryReferenceImpl)AggregatorFactory.eINSTANCE.createMetadataRepositoryReference();
                newRepository.setLocation(this.repoLocation);
                metadataRepos = aggregator.getValidationRepositories();
                metadataRepos.add((Object)newRepository);
            } else if (this.action == ActionType.REMOVE) {
                HashSet<MetadataRepositoryReference> removees = new HashSet<MetadataRepositoryReference>();
                metadataRepos = aggregator.getValidationRepositories();
                for (MetadataRepositoryReference metadataRepositoryReference : metadataRepos) {
                    if (!metadataRepositoryReference.getLocation().equals(this.repoLocation)) continue;
                    removees.add(metadataRepositoryReference);
                }
                if (removees.size() == 0) {
                    throw ExceptionUtils.fromMessage((String)("Unable to find validation repository " + this.repoLocation), (Object[])new Object[0]);
                }
                metadataRepos.removeAll(removees);
            }
            EObject eObj = (EObject)aggregator;
            Resource resource = eObj.eResource();
            HashMap<String, String> saveOptions = new HashMap<String, String>();
            saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
            resource.save(saveOptions);
        }
        catch (Exception e) {
            ExceptionUtils.wrap((Throwable)e);
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionType {
        ADD,
        REMOVE;

    }
}

