/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.transformer.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.presentation.AggregatorEditorPlugin;
import org.eclipse.b3.aggregator.transformer.TransformationManager;
import org.eclipse.b3.aggregator.transformer.TransformerContextContributor;
import org.eclipse.b3.aggregator.transformer.ui.TransformerContributorWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class TransformationWizard
extends Wizard
implements INewWizard {
    private static final String LEGACY_TRANSFORMATION_UI_ID = "org.eclipse.b3.aggregator.editor.legacy_transformation_ui";
    private static final String LEGACY_TRANSFORMATION_ATTR_NAME = "name";
    private static final String LEGACY_TRANSFORMATION_ATTR_CLASS = "class";
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(AggregatorEditorPlugin.INSTANCE.getString("_UI_AggregatorEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = AggregatorEditorPlugin.INSTANCE.getString("_UI_AggregatorEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected AggregatorPackage aggregatorPackage = AggregatorPackage.eINSTANCE;
    protected AggregatorFactory aggregatorFactory = this.aggregatorPackage.getAggregatorFactory();
    protected InfoPage infoPage;
    protected List<IWizardPage> contextContributorWizardPages = new ArrayList<IWizardPage>();
    protected NewFileCreationPage newFileCreationPage;
    protected URI srcResourceURI;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;
    private IFile modelFile;
    private Resource finalResource;
    private TransformationManager manager;
    private IFile originalFile;

    public TransformationWizard(URI srcResourceURI) {
        this.srcResourceURI = srcResourceURI;
        final IConfigurationElement[] transformationsUI = Platform.getExtensionRegistry().getConfigurationElementsFor(LEGACY_TRANSFORMATION_UI_ID);
        TransformationManager.ContributorListener listener = new TransformationManager.ContributorListener(){

            public void contributorFound(IConfigurationElement config, TransformerContextContributor contributor) throws CoreException {
                IConfigurationElement[] iConfigurationElementArray = transformationsUI;
                int n = transformationsUI.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement transformationUI = iConfigurationElementArray[n2];
                    if (transformationUI.getAttribute(TransformationWizard.LEGACY_TRANSFORMATION_ATTR_NAME).equals(config.getAttribute(TransformationWizard.LEGACY_TRANSFORMATION_ATTR_NAME))) {
                        TransformerContributorWizardPage wizPage = (TransformerContributorWizardPage)((Object)transformationUI.createExecutableExtension(TransformationWizard.LEGACY_TRANSFORMATION_ATTR_CLASS));
                        wizPage.setContextContributor(contributor);
                        TransformationWizard.this.contextContributorWizardPages.add((IWizardPage)wizPage);
                    }
                    ++n2;
                }
            }
        };
        this.manager = new TransformationManager(srcResourceURI, listener);
    }

    public void addPages() {
        this.infoPage = new InfoPage("InfoPage", this.manager.isSrcNamespaceFound(), this.manager.getTransformationSequence() != null && !this.manager.getTransformationSequence().isEmpty());
        this.infoPage.setTitle("Deprecated Resource");
        this.infoPage.setDescription("Selected resource needs to be transformed to the up-to-date structure");
        this.addPage((IWizardPage)this.infoPage);
        for (IWizardPage contextContributorWizardPage : this.contextContributorWizardPages) {
            this.addPage(contextContributorWizardPage);
        }
        this.newFileCreationPage = new NewFileCreationPage("FileCreationPage", this.selection);
        this.newFileCreationPage.setTitle("Target Location");
        this.newFileCreationPage.setDescription("Provide location for the transformed model");
        String fileName = String.valueOf(this.srcResourceURI.lastSegment().replaceAll("\\.[^.]*$", "")) + "." + FILE_EXTENSIONS.get(0);
        this.newFileCreationPage.setFileName(fileName);
        IPath containerPath = Path.fromOSString((String)(this.srcResourceURI.isPlatform() ? this.srcResourceURI.toPlatformString(true) : this.srcResourceURI.toFileString())).makeAbsolute().removeLastSegments(1);
        this.newFileCreationPage.setContainerFullPath(containerPath);
        this.addPage((IWizardPage)this.newFileCreationPage);
        this.originalFile = ResourcesPlugin.getWorkspace().getRoot().getFile(containerPath.append(fileName));
    }

    public IFile getModelFile() {
        return this.modelFile;
    }

    public Resource getTargetResource() {
        return this.finalResource;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("Aggregator Model Transformation");
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(AggregatorEditorPlugin.INSTANCE.getImage("full/wizban/NewAggregator.png")));
    }

    public boolean performFinish() {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask("Transformation is in progress", -1);
                        TransformationWizard.this.finalResource = TransformationWizard.this.manager.transformResource(!TransformationWizard.this.modelFile.equals((Object)TransformationWizard.this.originalFile));
                        TransformationWizard.this.finalResource.setURI(URI.createPlatformResourceURI((String)TransformationWizard.this.modelFile.getFullPath().toString(), (boolean)true));
                        TransformationWizard.this.finalResource.save(null);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.setNeedsProgressMonitor(true);
        this.modelFile = this.newFileCreationPage.getModelFile();
        try {
            this.getContainer().run(true, false, operation);
        }
        catch (InvocationTargetException e) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage("Transformation error: " + e.getCause().getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public class InfoPage
    extends WizardPage {
        private boolean srcNamespaceFound;
        private boolean transformationSequenceExists;

        public InfoPage(String pageId, boolean srcNamespaceFound, boolean transformationSequenceExists) {
            super(pageId);
            this.srcNamespaceFound = srcNamespaceFound;
            this.transformationSequenceExists = transformationSequenceExists;
            this.setPageComplete(srcNamespaceFound && transformationSequenceExists);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            if (!this.srcNamespaceFound || !this.transformationSequenceExists) {
                label.setText("Transformation from the selected resource model was not defined - transformation is not possible");
                label.setForeground(Display.getCurrent().getSystemColor(3));
            } else {
                label.setText("This wizard will take you through Aggregation Model Transformation");
            }
            this.setControl((Control)composite);
        }
    }

    public class NewFileCreationPage
    extends WizardNewFileCreationPage {
        public NewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
            this.setAllowExistingResources(true);
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(AggregatorEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

