/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.internal.function.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.script.functionservice.impl.FunctionProviderBaseImpl;
import org.osgi.framework.Bundle;

public class FunctionProviderImpl
extends FunctionProviderBaseImpl {
    public FunctionProviderImpl() {
        super(Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.birt.core.ScriptFunctionService"));
    }

    @Override
    protected void populateResources(List<URL> libs, String suffix, IConfigurationElement confElement) {
        String source = confElement.getAttribute("location");
        IExtension extension = confElement.getDeclaringExtension();
        String namespace = extension.getNamespace();
        Bundle bundle = org.eclipse.core.runtime.Platform.getBundle((String)namespace);
        if (bundle != null) {
            URL url;
            Enumeration files = bundle.getEntryPaths(source);
            if (files != null) {
                while (files.hasMoreElements()) {
                    URL url2;
                    String filePath = (String)files.nextElement();
                    if (!filePath.toLowerCase().endsWith(suffix) || (url2 = bundle.getEntry(filePath)) == null) continue;
                    libs.add(url2);
                }
            } else if (source.toLowerCase().endsWith(suffix) && (url = bundle.getEntry(source)) != null) {
                libs.add(url);
            }
        }
        if (bundle == null || libs.isEmpty()) {
            File file = new File(source);
            if (file.exists() && file.isDirectory()) {
                libs.addAll(FunctionProviderImpl.findFileList(file, suffix));
            } else if (source.toLowerCase().endsWith(suffix)) {
                try {
                    libs.add(new URL(source));
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
    }

    private static List<URL> findFileList(File file, String suffix) {
        ArrayList<URL> fileList = new ArrayList<URL>();
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith(suffix)) {
                try {
                    fileList.add(f.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (f.isDirectory()) {
                fileList.addAll(FunctionProviderImpl.findFileList(f, suffix));
            }
            ++n2;
        }
        return fileList;
    }
}

