/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.birt.core.framework.parser.AbstractParseState;
import org.eclipse.birt.core.framework.parser.ParseState;
import org.eclipse.birt.core.framework.parser.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLParserHandler
extends DefaultHandler {
    protected String currentElement = null;
    protected Stack stateStack = new Stack();
    protected Locator locator = null;
    protected ArrayList errors = new ArrayList();

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        assert (this.stateStack.isEmpty());
        this.pushState(this.createStartState());
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        assert (this.stateStack.size() == 1);
        this.topState().end();
        this.popState();
    }

    public void semanticError(Exception e) {
        this.semanticError(new XMLParserException(e));
    }

    public abstract void semanticError(XMLParserException var1);

    protected void pushState(AbstractParseState state) {
        assert (state != null);
        state.context = this.currentElement;
        this.stateStack.push(state);
    }

    private AbstractParseState popState() {
        assert (!this.stateStack.isEmpty());
        AbstractParseState state = (AbstractParseState)this.stateStack.pop();
        if (this.stateStack.size() > 0) {
            this.topState().endElement(state);
        }
        return state;
    }

    protected AbstractParseState topState() {
        assert (!this.stateStack.isEmpty());
        return (AbstractParseState)this.stateStack.lastElement();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.currentElement = qName;
        AbstractParseState newState = this.topState().startElement(qName);
        newState.elementName = this.currentElement;
        this.pushState(newState);
        newState.parseAttrs(atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        AbstractParseState state = this.topState();
        state.end();
        this.popState();
        if (!this.stateStack.isEmpty()) {
            this.topState().endElement(state);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.stateStack.isEmpty()) {
            this.topState().text.append(ch, start, length);
        }
    }

    public abstract AbstractParseState createStartState();

    @Override
    public void setDocumentLocator(Locator theLocator) {
        super.setDocumentLocator(this.locator);
        this.locator = theLocator;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.semanticError(new XMLParserException(e));
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.semanticError(new XMLParserException(e));
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.semanticError(new XMLParserException(e));
    }

    public List getErrors() {
        return this.errors;
    }

    public class InnerAnyTagState
    extends InnerParseState {
        @Override
        public AbstractParseState startElement(String tagName) {
            return new InnerAnyTagState();
        }
    }

    public class InnerParseState
    extends ParseState {
        public InnerParseState() {
            super(XMLParserHandler.this);
        }
    }
}

