/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.PlotWith2DAxes;
import org.eclipse.birt.chart.computation.withaxes.StackedSeriesLookup;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;

public final class SeriesRenderingHints
implements ISeriesRenderingHints {
    private int iDataSetStructure = 0;
    private final double dAxisLocation;
    private final double dZeroLocation;
    private final double dSeriesThickness;
    private final double dPlotBaseLocation;
    private final AxisTickCoordinates daTickCoordinates;
    private final DataPointHints[] dpa;
    private final AutoScale scBase;
    private final AutoScale scOrthogonal;
    private final StackedSeriesLookup ssl;
    private final PlotWith2DAxes pwa;
    private final DataSetIterator dsiBase;
    private final DataSetIterator dsiOrthogonal;
    private static final IGObjectFactory goFactory = GObjectFactory.instance();
    private Bounds clientArea;

    public SeriesRenderingHints(PlotWith2DAxes _pwa, double _dAxisLocation, double _dPlotBaseLocation, double _dZeroLocation, double _dSeriesThickness, AxisTickCoordinates _daTickCoordinates, DataPointHints[] _dpa, AutoScale _scBase, AutoScale _scOrthogonal, StackedSeriesLookup _ssl, DataSetIterator _dsiBase, DataSetIterator _dsiOrthogonal) {
        this.pwa = _pwa;
        this.dAxisLocation = _dAxisLocation;
        this.dZeroLocation = _dZeroLocation;
        this.dPlotBaseLocation = _dPlotBaseLocation;
        this.dSeriesThickness = _dSeriesThickness;
        this.daTickCoordinates = _daTickCoordinates;
        this.dpa = _dpa;
        this.scBase = _scBase;
        this.scOrthogonal = _scOrthogonal;
        this.ssl = _ssl;
        this.dsiBase = _dsiBase;
        this.dsiOrthogonal = _dsiOrthogonal;
        this.iDataSetStructure = this.dsiBase.size() != this.dsiOrthogonal.size() ? (this.iDataSetStructure |= 2) : 1;
        if (this.dsiBase.isEmpty()) {
            this.iDataSetStructure |= 4;
        }
        if (this.dsiOrthogonal.isEmpty()) {
            this.iDataSetStructure |= 8;
        }
    }

    public final double getAxisLocation() {
        return this.dAxisLocation;
    }

    public final double getZeroLocation() {
        return this.dZeroLocation;
    }

    public final double getLocationOnOrthogonal(Object oValue) throws ChartException, IllegalArgumentException {
        return Methods.getLocation(this.scOrthogonal, oValue);
    }

    public final double getPlotBaseLocation() {
        return this.dPlotBaseLocation;
    }

    public final double getSeriesThickness() {
        return this.dSeriesThickness;
    }

    public final AxisTickCoordinates getTickCoordinates() {
        return this.daTickCoordinates;
    }

    @Override
    public final DataPointHints[] getDataPoints() {
        return this.dpa;
    }

    public final boolean isCategoryScale() {
        return this.scBase.getType() == 16 || this.scBase.isCategoryScale();
    }

    public final StackedSeriesLookup getStackedSeriesLookup() {
        return this.ssl;
    }

    public final Position getLabelPosition(Series se) throws ChartException, IllegalArgumentException {
        int iTransposed = this.pwa.transposeLabelPosition(2, Methods.getLabelPosition(se.getLabelPosition()));
        Position p = null;
        switch (iTransposed) {
            case 1: {
                p = Position.LEFT_LITERAL;
                break;
            }
            case 2: {
                p = Position.RIGHT_LITERAL;
                break;
            }
            case 4: {
                p = Position.ABOVE_LITERAL;
                break;
            }
            case 8: {
                p = Position.BELOW_LITERAL;
                break;
            }
            case 16: {
                p = Position.OUTSIDE_LITERAL;
                break;
            }
            case 32: {
                p = Position.INSIDE_LITERAL;
            }
        }
        return p;
    }

    public final Label getLabelAttributes(Series se) throws IllegalArgumentException {
        return goFactory.copyOf(se.getLabel());
    }

    @Override
    public final Bounds getClientAreaBounds(boolean bReduceByInsets) {
        Bounds boClientArea = goFactory.copyOf(this.clientArea);
        if (bReduceByInsets) {
            boClientArea.adjust(this.pwa.getPlotInsets());
        }
        return boClientArea;
    }

    public final void setClientAreaBounds(Bounds bounds) {
        this.clientArea = bounds;
    }

    @Override
    public int getDataSetStructure() {
        return this.iDataSetStructure;
    }

    @Override
    public DataSetIterator getBaseDataSet() {
        return this.dsiBase;
    }

    @Override
    public DataSetIterator getOrthogonalDataSet() {
        return this.dsiOrthogonal;
    }

    public AutoScale getOrthogonalScale() {
        return this.scOrthogonal;
    }
}

