/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.AdditionalInfoController;
import org.eclipse.jface.text.contentassist.CompletionProposalPopup;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.Helper;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.JFaceTextMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

class AsyncCompletionProposalPopup
extends CompletionProposalPopup {
    private static final int MAX_WAIT_IN_MS = 50;
    private List<CompletableFuture<List<ICompletionProposal>>> fFutures;

    public AsyncCompletionProposalPopup(ContentAssistant contentAssistant, IContentAssistSubjectControl contentAssistSubjectControl, AdditionalInfoController infoController) {
        super(contentAssistant, contentAssistSubjectControl, infoController);
    }

    public AsyncCompletionProposalPopup(ContentAssistant contentAssistant, ITextViewer viewer, AdditionalInfoController infoController) {
        super(contentAssistant, viewer, infoController);
    }

    @Override
    public String showProposals(boolean autoActivated) {
        if (this.fKeyListener == null) {
            this.fKeyListener = new CompletionProposalPopup.ProposalSelectionListener(this);
        }
        Control control = this.fContentAssistSubjectControlAdapter.getControl();
        if (!Helper.okToUse((Widget)this.fProposalShell) && control != null && !control.isDisposed()) {
            this.fContentAssistSubjectControlAdapter.addKeyListener(this.fKeyListener);
            this.fLastCompletionOffset = this.fFilterOffset = (this.fInvocationOffset = this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
            List<ICompletionProposal> computedProposals = Collections.synchronizedList(new ArrayList());
            this.fFutures = this.buildCompletionFuturesOrJobs(this.fInvocationOffset);
            ArrayList<CompletionStage> populateFutures = new ArrayList<CompletionStage>(this.fFutures.size());
            for (CompletableFuture<List<ICompletionProposal>> future : this.fFutures) {
                populateFutures.add(future.thenAccept(proposals -> {
                    boolean bl = computedProposals.addAll((Collection<ICompletionProposal>)proposals);
                }));
            }
            long requestBeginningTimestamp = System.currentTimeMillis();
            long stillRemainingThreeshold = 50L;
            for (CompletableFuture completableFuture : populateFutures) {
                try {
                    completableFuture.get(stillRemainingThreeshold, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException exception) {}
                stillRemainingThreeshold = 50L - (System.currentTimeMillis() - requestBeginningTimestamp);
                if (stillRemainingThreeshold < 0L) break;
            }
            this.fComputedProposals = computedProposals;
            if (stillRemainingThreeshold > 0L) {
                int n = computedProposals.size();
                if (n == 0 && this.hideWhenNoProposals(autoActivated)) {
                    return null;
                }
                if (n == 1 && !autoActivated && this.canAutoInsert((ICompletionProposal)computedProposals.get(0))) {
                    this.insertProposal(computedProposals.get(0), '\u0000', 0, this.fInvocationOffset);
                    this.hide();
                } else {
                    this.createProposalSelector();
                    this.setProposals(computedProposals, false);
                    this.displayProposals();
                }
            } else {
                this.createProposalSelector();
                ComputingProposal computingProposal = new ComputingProposal(this.fInvocationOffset, this.fFutures.size());
                computedProposals.add(0, computingProposal);
                this.fComputedProposals = computedProposals;
                this.setProposals(this.fComputedProposals, false);
                Set remaining = Collections.synchronizedSet(new HashSet(populateFutures));
                for (CompletableFuture completableFuture : populateFutures) {
                    completableFuture.thenRun(() -> {
                        ArrayList newProposals;
                        remaining.removeIf(CompletableFuture::isDone);
                        computingProposal.setRemaining(remaining.size());
                        if (remaining.isEmpty()) {
                            computedProposals.remove(computingProposal);
                        }
                        this.fComputedProposals = newProposals = new ArrayList(computedProposals);
                        Display.getDefault().asyncExec(() -> {
                            if (!autoActivated && remaining.isEmpty() && newProposals.size() == 1 && this.canAutoInsert((ICompletionProposal)newProposals.get(0))) {
                                if (Helper.okToUse((Widget)this.fProposalShell)) {
                                    this.insertProposal((ICompletionProposal)newProposals.get(0), '\u0000', 0, this.fInvocationOffset);
                                    this.hide();
                                }
                                return;
                            }
                            this.setProposals(newProposals, false);
                            this.displayProposals();
                        });
                    });
                }
                this.displayProposals();
            }
        } else {
            this.fLastCompletionOffset = this.fFilterOffset;
            this.handleRepeatedInvocation();
        }
        return this.getErrorMessage();
    }

    @Override
    List<ICompletionProposal> computeProposals(int offset) {
        if (this.fProposalShell != null) {
            this.fProposalShell.dispose();
        }
        this.showProposals(true);
        return this.fComputedProposals;
    }

    @Override
    void createProposalSelector() {
        super.createProposalSelector();
        this.fProposalShell.addDisposeListener(e -> this.cancelFutures());
    }

    void cancelFutures() {
        if (this.fFutures != null) {
            for (Future future : this.fFutures) {
                future.cancel(true);
            }
            this.fFutures = null;
        }
    }

    @Override
    protected List<ICompletionProposal> computeFilteredProposals(int offset, DocumentEvent event) {
        if (this.fComputedProposals.size() > 0 && this.fComputedProposals.get(0) instanceof ComputingProposal) {
            Set<CompletableFuture<List<ICompletionProposal>>> remaining = Collections.synchronizedSet(new HashSet<CompletableFuture<List<ICompletionProposal>>>(this.fFutures));
            for (CompletableFuture<List<ICompletionProposal>> future : this.fFutures) {
                future.thenRun(() -> {
                    remaining.removeIf(CompletableFuture::isDone);
                    if (remaining.isEmpty()) {
                        this.filterProposals();
                    }
                });
            }
            return this.fComputedProposals;
        }
        return super.computeFilteredProposals(offset, event);
    }

    @Override
    public void hide() {
        super.hide();
        this.cancelFutures();
    }

    protected List<CompletableFuture<List<ICompletionProposal>>> buildCompletionFuturesOrJobs(int invocationOffset) {
        Set<IContentAssistProcessor> processors = null;
        try {
            processors = this.fContentAssistant.getContentAssistProcessors(this.getTokenContentType(invocationOffset));
        }
        catch (BadLocationException badLocationException) {}
        if (processors == null) {
            return Collections.emptyList();
        }
        ArrayList<CompletableFuture<List<ICompletionProposal>>> futures = new ArrayList<CompletableFuture<List<ICompletionProposal>>>(processors.size());
        for (IContentAssistProcessor processor : processors) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                ICompletionProposal[] proposals = processor.computeCompletionProposals(this.fViewer, invocationOffset);
                if (proposals == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(proposals);
            }));
        }
        return futures;
    }

    private String getTokenContentType(int invocationOffset) throws BadLocationException {
        if (this.fContentAssistSubjectControl != null) {
            IDocument document = this.fContentAssistSubjectControl.getDocument();
            if (document != null) {
                return TextUtilities.getContentType((IDocument)document, (String)this.fContentAssistant.getDocumentPartitioning(), (int)invocationOffset, (boolean)true);
            }
        } else {
            return TextUtilities.getContentType((IDocument)this.fViewer.getDocument(), (String)this.fContentAssistant.getDocumentPartitioning(), (int)invocationOffset, (boolean)true);
        }
        return "__dftl_partition_content_type";
    }

    private static final class ComputingProposal
    implements ICompletionProposal,
    ICompletionProposalExtension {
        private final int fOffset;
        private final int fSize;
        private int fRemaining;

        public ComputingProposal(int offset, int size) {
            this.fSize = size;
            this.fRemaining = size;
            this.fOffset = offset;
        }

        @Override
        public void apply(IDocument document) {
        }

        @Override
        public Point getSelection(IDocument document) {
            return new Point(this.fOffset, 0);
        }

        @Override
        public IContextInformation getContextInformation() {
            return null;
        }

        @Override
        public Image getImage() {
            return null;
        }

        @Override
        public String getDisplayString() {
            return NLS.bind((String)JFaceTextMessages.getString("AsyncCompletionProposalPopup.computing"), (Object)Math.round(100.0 * (double)(this.fSize - this.fRemaining) / (double)this.fSize));
        }

        @Override
        public String getAdditionalProposalInfo() {
            return NLS.bind((String)JFaceTextMessages.getString("AsyncCompletionProposalPopup.computingDetails"), (Object[])new Object[]{this.fSize, this.fSize - this.fRemaining, this.fRemaining});
        }

        @Override
        public void apply(IDocument document, char trigger, int offset) {
        }

        @Override
        public boolean isValidFor(IDocument document, int offset) {
            return false;
        }

        @Override
        public char[] getTriggerCharacters() {
            return null;
        }

        @Override
        public int getContextInformationPosition() {
            return -1;
        }

        public void setRemaining(int size) {
            this.fRemaining = size;
        }
    }
}

