/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseWizardDialog;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.ResourceAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.dialog.PublishResourceWizard;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.jface.wizard.IWizard;

public class AddResourceAction
extends ResourceAction {
    public AddResourceAction(LibraryExplorerTreeViewPage viewer) {
        super(Messages.getString((String)"AddResourceAction.Text"), viewer);
    }

    public boolean isEnabled() {
        try {
            return this.canInsertIntoSelectedContainer();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void run() {
        File container;
        try {
            container = this.getSelectedContainer();
        }
        catch (IOException e) {
            ExceptionUtil.handle((Throwable)e);
            return;
        }
        if (container == null) {
            return;
        }
        final PublishResourceWizard publishLibrary = new PublishResourceWizard(container.getAbsolutePath());
        BaseWizardDialog dialog = new BaseWizardDialog(UIUtil.getDefaultShell(), (IWizard)publishLibrary){

            protected void okPressed() {
                publishLibrary.setCopyFileRunnable(AddResourceAction.this.createCopyFileRunnable(publishLibrary.getSourceFile(), publishLibrary.getTargetFile()));
                super.okPressed();
            }
        };
        dialog.setPageSize(500, 250);
        if (dialog.open() == 0) {
            this.fireResourceChanged(publishLibrary.getTargetFile().getAbsolutePath());
        }
    }
}

