/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jetty.server.Server;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ViewerWebServer {
    public static final String VIEWER_WEB_SERVER_ID = "org.eclipse.birt.report.viewer.server";
    private ServiceRegistration<Server> serviceRegister;
    private String host;
    private int port;

    public ViewerWebServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void start() {
        Server server = new Server();
        Hashtable<String, Object> serverProps = new Hashtable<String, Object>();
        ((Dictionary)serverProps).put("managedServerName", VIEWER_WEB_SERVER_ID);
        ((Dictionary)serverProps).put("jetty.http.host", this.host);
        ((Dictionary)serverProps).put("jetty.http.port", this.port);
        ((Dictionary)serverProps).put("jetty.etc.config.urls", this.getJettyConfigURLs());
        BundleContext context = ViewerPlugin.getDefault().getBundleContext();
        this.serviceRegister = context.registerService(Server.class, (Object)server, serverProps);
    }

    public void stop() {
        if (this.serviceRegister != null) {
            this.serviceRegister.unregister();
            this.serviceRegister = null;
        }
    }

    private String getJettyConfigURLs() {
        String[] configFiles = new String[]{"/jettyhome/etc/jetty.xml", "/jettyhome/etc/jetty-selector.xml", "/jettyhome/etc/jetty-deployer.xml", "/jettyhome/etc/jetty-special.xml"};
        Bundle bundle = ViewerPlugin.getDefault().getBundle();
        StringBuilder sb = new StringBuilder();
        String[] stringArray = configFiles;
        int n = configFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String configFile = stringArray[n2];
            String strURL = null;
            try {
                URL url = bundle.getEntry(configFile);
                if (url != null) {
                    strURL = FileLocator.toFileURL((URL)url).toExternalForm();
                    strURL = strURL.replaceAll(" ", "%20");
                }
            }
            catch (IOException iOException) {}
            if (strURL != null) {
                sb.append(strURL);
                sb.append(",");
            }
            ++n2;
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

