/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import java.util.Vector;

public class StringMatcher {
    protected String fPattern;
    protected int fLength;
    protected boolean fIgnoreWildCards;
    protected boolean fIgnoreCase;
    protected boolean fHasLeadingStar;
    protected boolean fHasTrailingStar;
    protected String[] fSegments;
    protected int fBound = 0;
    protected String[] wordsSplitted;
    protected Word[] words;
    protected static final char fSingleWildCard = '\u0000';

    public StringMatcher(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        this.fIgnoreCase = ignoreCase;
        this.fIgnoreWildCards = ignoreWildCards;
        this.fPattern = pattern;
        this.fLength = pattern.length();
        this.parsePatternIntoWords();
        if (this.fIgnoreWildCards) {
            this.parseNoWildCards();
        } else {
            this.parseWildCardsForWords();
            this.parseWildCards();
        }
    }

    public Position find(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        int tlen = text.length();
        if (start < 0) {
            start = 0;
        }
        if (end > tlen) {
            end = tlen;
        }
        if (end < 0 || start >= end) {
            return null;
        }
        if (this.fLength == 0) {
            return new Position(start, start);
        }
        if (this.fIgnoreWildCards) {
            int x = this.posIn(text, start, end);
            if (x < 0) {
                return null;
            }
            return new Position(x, x + this.fLength);
        }
        int segCount = this.fSegments.length;
        if (segCount == 0) {
            return new Position(start, end);
        }
        int curPos = start;
        int matchStart = -1;
        int i = 0;
        while (i < segCount && curPos < end) {
            String current = this.fSegments[i];
            int nextMatch = this.regExpPosIn(text, curPos, end, current);
            if (nextMatch < 0) {
                return null;
            }
            if (i == 0) {
                matchStart = nextMatch;
            }
            curPos = nextMatch + current.length();
            ++i;
        }
        if (i < segCount) {
            return null;
        }
        return new Position(matchStart, curPos);
    }

    public boolean match(String text) {
        if (text == null) {
            return false;
        }
        return this.match(text, 0, text.length());
    }

    /*
     * Unable to fully structure code
     */
    public boolean match(String text, int start, int end) {
        found = true;
        segments = null;
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            return false;
        }
        j = 0;
        while (j < this.words.length) {
            block19: {
                block22: {
                    block21: {
                        block20: {
                            block18: {
                                if (!this.fIgnoreWildCards) break block18;
                                if (end - start == this.words[j].pattern.length() && this.words[j].pattern.regionMatches(this.fIgnoreCase, 0, text, start, this.words[j].pattern.length())) {
                                    return true;
                                }
                                break block19;
                            }
                            segments = this.words[j].fragments;
                            this.fHasLeadingStar = this.words[j].hasLeadingStar;
                            this.fHasTrailingStar = this.words[j].hasTrailingStar;
                            segCount = segments.length;
                            if (segCount == 0 && (this.fHasLeadingStar || this.fHasTrailingStar)) {
                                return true;
                            }
                            if (start != end) break block20;
                            if (this.words[j].pattern.length() == 0) {
                                return true;
                            }
                            break block19;
                        }
                        if (this.words[j].pattern.length() != 0) break block21;
                        if (start == end) {
                            return true;
                        }
                        break block19;
                    }
                    tlen = text.length();
                    if (start < 0) {
                        start = 0;
                    }
                    if (end > tlen) {
                        end = tlen;
                    }
                    tCurPos = start;
                    bound = end - this.words[j].bound;
                    if (bound < 0) break block19;
                    i = 0;
                    current = segments[i];
                    segLength = current.length();
                    if (this.fHasLeadingStar) break block22;
                    if (!this.regExpRegionMatches(text, start, current, 0, segLength)) break block19;
                    ++i;
                    tCurPos += segLength;
                }
                if (segments.length != 1 || this.fHasLeadingStar || this.fHasTrailingStar) ** GOTO lbl62
                if (tCurPos != end) break block19;
                return true;
lbl-1000:
                // 1 sources

                {
                    current = segments[i];
                    k = current.indexOf(0);
                    if (k < 0) {
                        currentMatch = this.textPosIn(text, tCurPos, end, current);
                        if (currentMatch < 0) {
                            found = false;
                        }
                    } else {
                        currentMatch = this.regExpPosIn(text, tCurPos, end, current);
                        if (currentMatch < 0) {
                            found = false;
                        }
                    }
                    if (!found) continue;
                    tCurPos = currentMatch + current.length();
                    ++i;
lbl62:
                    // 3 sources

                    ** while (i < segCount && found)
                }
lbl63:
                // 1 sources

                if (this.fHasTrailingStar == false && tCurPos != end ? this.regExpRegionMatches(text, end - (clen = current.length()), current, 0, clen) != false : i == segCount) {
                    return true;
                }
            }
            ++j;
        }
        return false;
    }

    private void parsePatternIntoWords() {
        String trimedPattern = this.fPattern.trim();
        this.wordsSplitted = trimedPattern.split("\\s+");
        int wordsIndex = 0;
        if (!trimedPattern.isEmpty()) {
            this.words = new Word[this.wordsSplitted.length + 1];
            this.words[wordsIndex] = new Word();
            this.words[wordsIndex].pattern = trimedPattern;
            wordsIndex = 1;
        } else {
            this.words = new Word[this.wordsSplitted.length];
        }
        int i = 0;
        while (i < this.wordsSplitted.length) {
            this.words[wordsIndex] = new Word();
            this.words[wordsIndex].pattern = this.wordsSplitted[i];
            ++wordsIndex;
            ++i;
        }
    }

    private void parseNoWildCards() {
        this.fSegments = new String[1];
        this.fSegments[0] = this.fPattern;
        this.fBound = this.fLength;
        this.words = new Word[1];
        this.words[0].pattern = this.fPattern;
        this.words[0].bound = this.fLength;
        this.words[0].fragments = this.wordsSplitted;
    }

    private void parseWildCards() {
        if (this.fPattern.startsWith("*")) {
            this.fHasLeadingStar = true;
        }
        if (this.fPattern.endsWith("*") && this.fLength > 1 && this.fPattern.charAt(this.fLength - 2) != '\\') {
            this.fHasTrailingStar = true;
        }
        Vector<String> temp = new Vector<String>();
        int pos = 0;
        StringBuilder buf = new StringBuilder();
        block5: while (pos < this.fLength) {
            char c = this.fPattern.charAt(pos++);
            switch (c) {
                case '\\': {
                    char next;
                    if (pos >= this.fLength) {
                        buf.append(c);
                        break;
                    }
                    if ((next = this.fPattern.charAt(pos++)) == '*' || next == '?' || next == '\\') {
                        buf.append(next);
                        break;
                    }
                    buf.append(c);
                    buf.append(next);
                    break;
                }
                case '*': {
                    if (buf.length() <= 0) continue block5;
                    temp.addElement(buf.toString());
                    this.fBound += buf.length();
                    buf.setLength(0);
                    break;
                }
                case '?': {
                    buf.append('\u0000');
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0) {
            temp.addElement(buf.toString());
            this.fBound += buf.length();
        }
        this.fSegments = new String[temp.size()];
        temp.copyInto(this.fSegments);
    }

    private void parseWildCardsForWords() {
        int i = 0;
        while (i < this.words.length) {
            if (this.words[i].pattern.startsWith("*")) {
                this.words[i].hasLeadingStar = true;
            }
            if (this.words[i].pattern.endsWith("*") && this.words[i].pattern.length() > 1 && this.words[i].pattern.charAt(this.words[i].pattern.length() - 2) != '\\') {
                this.words[i].hasTrailingStar = true;
            }
            Vector<String> temp = new Vector<String>();
            int pos = 0;
            StringBuilder buf = new StringBuilder();
            block6: while (pos < this.words[i].pattern.length()) {
                char c = this.words[i].pattern.charAt(pos++);
                switch (c) {
                    case '\\': {
                        char next;
                        if (pos >= this.words[i].pattern.length()) {
                            buf.append(c);
                            break;
                        }
                        if ((next = this.words[i].pattern.charAt(pos++)) == '*' || next == '?' || next == '\\') {
                            buf.append(next);
                            break;
                        }
                        buf.append(c);
                        buf.append(next);
                        break;
                    }
                    case '*': {
                        if (buf.length() <= 0) continue block6;
                        temp.addElement(buf.toString());
                        this.words[i].bound += buf.length();
                        buf.setLength(0);
                        break;
                    }
                    case '?': {
                        buf.append('\u0000');
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            if (buf.length() > 0) {
                temp.addElement(buf.toString());
                this.words[i].bound += buf.length();
            }
            this.words[i].fragments = new String[temp.size()];
            temp.copyInto(this.words[i].fragments);
            ++i;
        }
    }

    protected int posIn(String text, int start, int end) {
        int max = end - this.fLength;
        if (!this.fIgnoreCase) {
            int i = text.indexOf(this.fPattern, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, this.fPattern, 0, this.fLength)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int regExpPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        int i = start;
        while (i <= max) {
            if (this.regExpRegionMatches(text, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean regExpRegionMatches(String text, int tStart, String p, int pStart, int plen) {
        while (plen-- > 0) {
            char tchar = text.charAt(tStart++);
            char pchar = p.charAt(pStart++);
            if (!this.fIgnoreWildCards && pchar == '\u0000' || pchar == tchar || this.fIgnoreCase && (Character.toUpperCase(tchar) == Character.toUpperCase(pchar) || Character.toLowerCase(tchar) == Character.toLowerCase(pchar))) continue;
            return false;
        }
        return true;
    }

    protected int textPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        if (!this.fIgnoreCase) {
            int i = text.indexOf(p, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static class Position {
        int start;
        int end;

        public Position(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }

    public class Word {
        boolean hasTrailingStar = false;
        boolean hasLeadingStar = false;
        int bound = 0;
        String[] fragments = null;
        String pattern = null;
    }
}

