/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import com.eaio.uuid.UUID;
import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.AbstractSerializer;
import me.prettyprint.hector.api.ddl.ComparatorType;

public final class TimeUUIDSerializer
extends AbstractSerializer<UUID> {
    private static final TimeUUIDSerializer instance = new TimeUUIDSerializer();

    public static TimeUUIDSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(UUID uuid) {
        int i;
        if (uuid == null) {
            return null;
        }
        long msb = uuid.getTime();
        long lsb = uuid.getClockSeqAndNode();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return ByteBuffer.wrap(buffer);
    }

    @Override
    public UUID fromByteBuffer(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        return new UUID(bytes.getLong(), bytes.getLong());
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.TIMEUUIDTYPE;
    }
}

