/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFileV3;
import org.eclipse.birt.core.archive.compound.v3.Ext2File;

public class ArchiveEntryV3
extends ArchiveEntry {
    protected ArchiveFileV3 archive;
    protected Ext2File file;

    ArchiveEntryV3(ArchiveFileV3 archive, Ext2File file) {
        super(file.getName());
        this.archive = archive;
        this.file = file;
        this.archive.openEntry(this);
    }

    @Override
    public long getLength() throws IOException {
        return this.file.length();
    }

    @Override
    public void close() throws IOException {
        this.archive.closeEntry(this);
        this.file.close();
    }

    @Override
    public int read(long pos, byte[] b, int off, int len) throws IOException {
        this.file.seek(pos);
        return this.file.read(b, off, len);
    }

    @Override
    public void setLength(long length) throws IOException {
        this.file.setLength(length);
    }

    @Override
    public void write(long pos, byte[] b, int off, int len) throws IOException {
        this.file.seek(pos);
        this.file.write(b, off, len);
    }
}

