/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineTextArea;

public class InlineTextExtension {
    private ArrayList<InlineTextArea> lines = new ArrayList();
    private ArrayList<Integer> lineBreaks = new ArrayList();
    private int floatPos;
    private int offsetInContent;
    private int dimension = 0;
    private int widthRestrict;
    private boolean firstTimeEnter = true;

    public void updatePageHintInfo(InlineTextArea area) {
        if (this.lineBreaks == null || this.lineBreaks.size() == 0) {
            return;
        }
        if (!this.firstTimeEnter && area.isInRepeatedHeader()) {
            return;
        }
        if (this.firstTimeEnter) {
            this.firstTimeEnter = false;
        }
        this.offsetInContent = 0;
        this.floatPos = 0;
        this.dimension = 0;
        this.widthRestrict = 0;
        int lineNumber = this.lines.indexOf(area);
        if (lineNumber != 0 && !this.lineBreaks.contains(lineNumber - 1)) {
            return;
        }
        Collections.sort(this.lineBreaks);
        int startLineNumber = lineNumber;
        int i = 0;
        while (i < startLineNumber) {
            this.offsetInContent += this.lines.get(i).getAllocatedWidth();
            ++i;
        }
        for (int breakLineNumber : this.lineBreaks) {
            if (breakLineNumber < startLineNumber) continue;
            InlineTextArea startLine = this.lines.get(startLineNumber);
            this.floatPos = startLine.getAllocatedX();
            int i2 = startLineNumber;
            while (i2 <= breakLineNumber) {
                this.dimension += this.lines.get(i2).getAllocatedWidth();
                this.widthRestrict = startLine.parent.getWidth();
                ++i2;
            }
            break block1;
        }
    }

    public void addLine(InlineTextArea area) {
        this.lines.add(area);
    }

    public void replaceLine(InlineTextArea oldArea, InlineTextArea newArea) {
        int lineNumber = this.lines.indexOf(oldArea);
        this.lines.remove(lineNumber);
        this.lines.add(lineNumber, newArea);
    }

    public void addLineBreak(InlineTextArea area) {
        int lineNumber = this.lines.indexOf(area);
        this.lineBreaks.add(lineNumber);
    }

    public void addLineBreak() {
        int lineNumber = this.lines.size() - 1;
        this.lineBreaks.add(lineNumber);
    }

    public int getFloatPos() {
        return this.floatPos;
    }

    public int getOffsetInContent() {
        return this.offsetInContent;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getWidthRestrict() {
        return this.widthRestrict;
    }
}

