/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartReportItemHelper;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.dialogs.ColumnBindingDialog;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ChartColumnBindingDialog
extends ColumnBindingDialog {
    private ChartWizardContext context;
    private Button btnRefresh;
    private boolean fIsReadOnly;

    public ChartColumnBindingDialog(ReportItemHandle input, Shell parent, ChartWizardContext context) {
        super(input, parent, false, true);
        this.context = context;
    }

    protected void handleAddEvent() {
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(true, true);
        dialog.setInput(this.inputElement);
        dialog.setExpressionProvider(this.expressionProvider);
        if (dialog.open() == 0 && this.bindingTable != null) {
            this.refreshBindingTable();
            this.bindingTable.getTable().setSelection(this.bindingTable.getTable().getItemCount() - 1);
        }
    }

    protected void handleEditEvent() {
        ComputedColumnHandle bindingHandle = null;
        int pos = this.getColumnBindingIndexFromTableSelection();
        if (pos > -1) {
            bindingHandle = (ComputedColumnHandle)DEUtil.getBindingHolder((DesignElementHandle)this.inputElement).getColumnBindings().getAt(pos);
        }
        if (bindingHandle == null) {
            return;
        }
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(false);
        dialog.setInput(this.inputElement, bindingHandle, (Object)this.context);
        dialog.setExpressionProvider(this.expressionProvider);
        if (dialog.open() == 0 && this.bindingTable != null) {
            this.bindingTable.getTable().setSelection(pos);
        }
    }

    protected void handleDelEvent() {
        if (!this.btnDel.isEnabled()) {
            return;
        }
        int pos = this.getColumnBindingIndexFromTableSelection();
        if (pos > -1) {
            try {
                ComputedColumnHandle handle = (ComputedColumnHandle)DEUtil.getBindingHolder((DesignElementHandle)this.inputElement).getColumnBindings().getAt(pos);
                this.deleteRow(handle);
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }

    private void updateButtonStatusForReadOnly() {
        if (this.fIsReadOnly) {
            this.btnAdd.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnDel.setEnabled(false);
            this.getAggregationButton().setEnabled(false);
        }
    }

    protected int addButtons(Composite cmp, final Table table) {
        Listener[] listeners = this.getAggregationButton().getListeners(13);
        if (listeners.length > 0) {
            this.getAggregationButton().removeListener(13, listeners[0]);
        }
        this.getAggregationButton().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DataColumnBindingDialog dialog = new DataColumnBindingDialog(true);
                dialog.setInput(ChartColumnBindingDialog.this.inputElement, null, (Object)ChartColumnBindingDialog.this.context);
                dialog.setExpressionProvider(ChartColumnBindingDialog.this.expressionProvider);
                dialog.setAggreate(true);
                if (dialog.open() == 0 && ChartColumnBindingDialog.this.bindingTable != null) {
                    ChartColumnBindingDialog.this.refreshBindingTable();
                    ChartColumnBindingDialog.this.bindingTable.getTable().setSelection(ChartColumnBindingDialog.this.bindingTable.getTable().getItemCount() - 1);
                }
                ChartColumnBindingDialog.this.refreshBindingTable();
                if (table.getItemCount() > 0) {
                    ChartColumnBindingDialog.this.setSelectionInTable(table.getItemCount() - 1);
                }
                ChartColumnBindingDialog.this.updateButtons();
            }
        });
        this.btnRefresh = new Button(cmp, 8);
        this.btnRefresh.setText(Messages.getString("ChartColumnBindingDialog.Button.Refresh"));
        GridData data = new GridData(2);
        data.widthHint = Math.max(60, this.btnRefresh.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnRefresh.setLayoutData((Object)data);
        this.btnRefresh.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    List<Object> columnList = new ArrayList();
                    CubeHandle cubeHandle = ChartReportItemHelper.instance().getBindingCubeHandle(ChartColumnBindingDialog.this.inputElement);
                    if (cubeHandle != null) {
                        if (ChartColumnBindingDialog.this.inputElement.getCube() == null || ChartItemUtil.isInMultiViews((ReportItemHandle)ChartColumnBindingDialog.this.inputElement)) {
                            ChartColumnBindingDialog.this.refreshBindingTable();
                        } else {
                            ChartColumnBindingDialog.this.inputElement.getColumnBindings().clearValue();
                            columnList = ChartXTabUIUtil.generateComputedColumns((ExtendedItemHandle)ChartColumnBindingDialog.this.inputElement, cubeHandle);
                            if (columnList.size() > 0) {
                                Iterator<Object> iter = columnList.iterator();
                                while (iter.hasNext()) {
                                    DEUtil.addColumn((DesignElementHandle)ChartColumnBindingDialog.this.inputElement, (ComputedColumn)((ComputedColumn)iter.next()), (boolean)false);
                                }
                            }
                        }
                    } else {
                        DataSetHandle dataSetHandle = ChartColumnBindingDialog.this.inputElement.getDataSet();
                        if (dataSetHandle == null || ChartItemUtil.isInMultiViews((ReportItemHandle)ChartColumnBindingDialog.this.inputElement)) {
                            ChartColumnBindingDialog.this.refreshBindingTable();
                        } else {
                            List resultSetColumnList = DataUtil.getColumnList((DataSetHandle)dataSetHandle);
                            for (ResultSetColumnHandle resultSetColumn : resultSetColumnList) {
                                ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)ChartColumnBindingDialog.this.inputElement, (String)resultSetColumn.getColumnName());
                                column.setDataType(resultSetColumn.getDataType());
                                column.setExpression(DEUtil.getExpression((Object)resultSetColumn));
                                columnList.add(column);
                            }
                            if (columnList.size() > 0) {
                                Iterator<Object> iter = columnList.iterator();
                                while (iter.hasNext()) {
                                    DEUtil.addColumn((DesignElementHandle)ChartColumnBindingDialog.this.inputElement, (ComputedColumn)((ComputedColumn)iter.next()), (boolean)false);
                                }
                            }
                        }
                    }
                    ChartColumnBindingDialog.this.bindingTable.setInput((Object)ChartColumnBindingDialog.this.inputElement);
                }
                catch (SemanticException e) {
                    WizardBase.displayException((Throwable)e);
                }
            }
        });
        return 2;
    }

    protected void updateButtons() {
        super.updateButtons();
        this.getAggregationButton().setEnabled(this.btnAdd.isEnabled());
        if (!this.isOwnColumnBinding(this.bindingTable.getTable().getSelectionIndex())) {
            this.btnDel.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
        this.updateButtonStatusForReadOnly();
    }

    private boolean isOwnColumnBinding(int pos) {
        List<ComputedColumnHandle> bindings = this.getBindingList((DesignElementHandle)this.inputElement);
        return pos < 0 ? false : bindings.get(pos).getElementHandle() == this.inputElement;
    }

    private int getColumnBindingIndexFromTableSelection() {
        int selection = this.bindingTable.getTable().getSelectionIndex();
        int index = -1;
        int i = 0;
        while (i <= selection) {
            if (this.isOwnColumnBinding(i)) {
                ++index;
            }
            ++i;
        }
        return index;
    }

    protected void addBinding(ComputedColumn column) {
        try {
            DEUtil.addColumn((DesignElementHandle)this.inputElement, (ComputedColumn)column, (boolean)true);
            ChartWizard.removeException((String)"ChartColumnBindingDialog");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ChartColumnBindingDialog", (String)e.getLocalizedMessage());
        }
    }

    protected List<ComputedColumnHandle> getBindingList(DesignElementHandle inputElement) {
        Iterator iterator = ChartItemUtil.getColumnDataBindings((ReportItemHandle)((ReportItemHandle)inputElement));
        ArrayList<ComputedColumnHandle> list = new ArrayList<ComputedColumnHandle>();
        while (iterator.hasNext()) {
            list.add((ComputedColumnHandle)iterator.next());
        }
        return list;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x860 | 0x10 | 0x10000);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.fIsReadOnly = isReadOnly;
    }

    protected void setDialogInput(DataColumnBindingDialog dialog, ComputedColumnHandle bindingHandle) {
        if (dialog != null) {
            dialog.setInput(this.inputElement, bindingHandle, (Object)this.context);
        }
    }
}

