/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManagerFactory;
import org.eclipse.birt.report.engine.nLayout.area.impl.FixedLayoutPageHintGenerator;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class LayoutContext {
    protected int maxWidth;
    protected int maxHeight;
    protected int maxBP;
    protected String format;
    protected IReportContent report;
    protected IContent unresolvedContent;
    protected Locale locale;
    protected long totalPage = 0L;
    protected long pageCount = 0L;
    protected long pageNumber = 0L;
    protected boolean autoPageBreak = true;
    private boolean sizeOverflowPageBreak = false;
    protected String supportedImageFormats = "PNG;GIF;JPG;BMP;SVG";
    protected boolean finished = false;
    protected int engineTaskType = 2;
    protected boolean isFixedLayout = false;
    protected boolean isInHtmlRender = false;
    protected HTMLLayoutContext htmlLayoutContext = null;
    protected HashMap<String, Long> bookmarkMap = new HashMap();
    protected boolean displayNone = false;
    protected boolean fitToPage = false;
    protected boolean pageBreakPaginationOnly = false;
    protected int pageOverflow = 4;
    protected int preferenceWidth = 0;
    protected int pageLimit = -1;
    protected boolean textWrapping = true;
    protected boolean fontSubstitution = true;
    protected boolean bidiProcessing = true;
    protected boolean enableWordbreak = false;
    private FontMappingManager fontManager;
    private int dpi = 0;
    private Boolean reserveDocumentPageNumbers = null;
    private int totalPageTemplateWidth;
    private HashMap cachedTableHeaders = null;
    private HashMap cachedGroupHeaders = null;
    protected FixedLayoutPageHintGenerator pageHintGenerator = null;

    public boolean isDisplayNone() {
        return this.displayNone;
    }

    public void setDisplayNone(boolean displayNone) {
        this.displayNone = displayNone;
    }

    public HTMLLayoutContext getHtmlLayoutContext() {
        return this.htmlLayoutContext;
    }

    public void addBookmarkMap(long pageNumber, String bookmark) {
        if (!this.bookmarkMap.containsKey(bookmark)) {
            this.bookmarkMap.put(bookmark, pageNumber);
        }
    }

    public Map<String, Long> getBookmarkMap() {
        return this.bookmarkMap;
    }

    public void setHtmlLayoutContext(HTMLLayoutContext htmlLayoutContext) {
        this.htmlLayoutContext = htmlLayoutContext;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public int getMaxBP() {
        return this.maxBP;
    }

    public void setMaxBP(int maxBP) {
        this.maxBP = maxBP;
    }

    public void setAutoPageBreak(boolean autoPageBreak) {
        this.autoPageBreak = autoPageBreak;
    }

    public boolean isAutoPageBreak() {
        return this.autoPageBreak;
    }

    public void addUnresolvedContent(IContent content) {
        this.unresolvedContent = content;
    }

    public IContent getUnresolvedContent() {
        return this.unresolvedContent;
    }

    public long getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public IReportContent getReport() {
        return this.report;
    }

    public void setReport(IReportContent report) {
        this.report = report;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getEngineTaskType() {
        return this.engineTaskType;
    }

    public void setEngineTaskType(int engineTaskType) {
        this.engineTaskType = engineTaskType;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    public void setFitToPage(boolean fitToPage) {
        this.fitToPage = fitToPage;
    }

    public boolean fitToPage() {
        return this.fitToPage;
    }

    public void setPagebreakPaginationOnly(boolean pageBreakPaginationOnly) {
        this.pageBreakPaginationOnly = pageBreakPaginationOnly;
        this.setAutoPageBreak(!pageBreakPaginationOnly);
    }

    public boolean pagebreakPaginationOnly() {
        return this.pageBreakPaginationOnly;
    }

    public int getPageOverflow() {
        return this.pageOverflow;
    }

    public void setPageOverflow(int pageOverflow) {
        this.pageOverflow = pageOverflow;
        if (pageOverflow != 4) {
            this.autoPageBreak = false;
        }
    }

    public void setPreferenceWidth(int preferenceWidth) {
        this.preferenceWidth = preferenceWidth;
    }

    public int getPreferenceWidth() {
        return this.preferenceWidth;
    }

    public void setPageLimit(int pageLimit) {
        this.pageLimit = pageLimit;
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public boolean exceedPageLimit() {
        return (this.engineTaskType == 2 || this.engineTaskType == 3) && this.pageLimit > 0 && this.pageCount >= (long)this.pageLimit;
    }

    public void setTextWrapping(boolean textWrapping) {
        this.textWrapping = textWrapping;
    }

    public boolean getTextWrapping() {
        return this.textWrapping;
    }

    public void setFontSubstitution(boolean fontSubstitution) {
        this.fontSubstitution = fontSubstitution;
    }

    public boolean getFontSubstitution() {
        return this.fontSubstitution;
    }

    public void setBidiProcessing(boolean bidiProcessing) {
        this.bidiProcessing = bidiProcessing;
    }

    public boolean getBidiProcessing() {
        return this.bidiProcessing;
    }

    public boolean isEnableWordbreak() {
        return this.enableWordbreak;
    }

    public void setEnableWordbreak(boolean enableWordbreak) {
        this.enableWordbreak = enableWordbreak;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public FontMappingManager getFontManager() {
        if (this.fontManager == null) {
            this.fontManager = FontMappingManagerFactory.getInstance().getFontMappingManager(this.format, this.locale);
        }
        return this.fontManager;
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setDpi(int dpi) {
        this.dpi = dpi;
    }

    public boolean isReserveDocumentPageNumbers() {
        if (this.reserveDocumentPageNumbers == null) {
            return this.isFixedLayout;
        }
        return this.reserveDocumentPageNumbers;
    }

    public void setReserveDocumentPageNumbers(boolean reserveDocumentPageNumbers) {
        this.reserveDocumentPageNumbers = reserveDocumentPageNumbers;
    }

    public void setTotalPageTemplateWidth(int totalPageTemplateWidth) {
        this.totalPageTemplateWidth = totalPageTemplateWidth;
    }

    public int getTotalPageTemplateWidth() {
        return this.totalPageTemplateWidth;
    }

    public void setCachedHeaderMap(HashMap tableHeaders, HashMap groupHeaders) {
        this.cachedTableHeaders = tableHeaders;
        this.cachedGroupHeaders = groupHeaders;
    }

    protected ITableBandContent getWrappedTableHeader(InstanceID id) {
        Object cachedHeaders;
        if (this.cachedTableHeaders != null && (cachedHeaders = this.cachedTableHeaders.get(id)) != null) {
            return (ITableBandContent)cachedHeaders;
        }
        return null;
    }

    protected ITableBandContent getWrappedGroupHeader(InstanceID id) {
        Object cachedHeaders;
        if (this.cachedGroupHeaders != null && (cachedHeaders = this.cachedGroupHeaders.get(id)) != null) {
            return (ITableBandContent)cachedHeaders;
        }
        return null;
    }

    public String getSupportedImageFormats() {
        return this.supportedImageFormats;
    }

    public void setSupportedImageFormats(String supportedImageFormats) {
        this.supportedImageFormats = supportedImageFormats;
    }

    public boolean isFixedLayout() {
        return this.isFixedLayout;
    }

    public void setFixedLayout(boolean isFixedLayout) {
        this.isFixedLayout = isFixedLayout;
    }

    public void createPageHintGenerator() {
        if (this.isFixedLayout) {
            this.pageHintGenerator = new FixedLayoutPageHintGenerator(this);
        }
    }

    public FixedLayoutPageHintGenerator getPageHintGenerator() {
        return this.pageHintGenerator;
    }

    public boolean isInHtmlRender() {
        return this.isInHtmlRender;
    }

    public void setInHtmlRender(boolean isInHtmlRender) {
        this.isInHtmlRender = isInHtmlRender;
    }

    public String getMasterPage() {
        return this.htmlLayoutContext.getMasterPage();
    }

    public ArrayList getPageHint() {
        return this.pageHintGenerator.getPageHint();
    }

    public List getTableColumnHints() {
        return this.htmlLayoutContext.getPageHintManager().getTableColumnHints();
    }

    public List<UnresolvedRowHint> getUnresolvedRowHints() {
        return this.pageHintGenerator.getUnresolvedRowHints();
    }

    public void resetUnresolvedRowHints() {
        if (this.pageHintGenerator != null) {
            this.pageHintGenerator.resetRowHint();
        }
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public boolean isSizeOverflowPageBreak() {
        return this.sizeOverflowPageBreak;
    }

    public void setSizeOverflowPageBreak(boolean sizeOverflowPageBreak) {
        this.sizeOverflowPageBreak = sizeOverflowPageBreak;
    }
}

