/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.Point;
import org.eclipse.birt.report.model.api.util.Rectangle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.MasterPageContextContainmentValidator;
import org.eclipse.birt.report.model.api.validators.MasterPageSizeValidator;
import org.eclipse.birt.report.model.api.validators.MasterPageTypeValidator;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.interfaces.IMasterPageModel;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public abstract class MasterPage
extends StyledElement
implements IMasterPageModel {
    public MasterPage() {
    }

    public MasterPage(String theName) {
        super(theName);
    }

    public Point getSize(Module module) {
        Point size = new Point();
        String type = this.getStringProperty(module, "type");
        String height = null;
        String width = null;
        if (type.equalsIgnoreCase("custom")) {
            height = this.getStringProperty(module, "height");
            width = this.getStringProperty(module, "width");
        } else if (type.equalsIgnoreCase("us-letter")) {
            height = "11in";
            width = "8.5in";
        } else if (type.equalsIgnoreCase("us-legal")) {
            height = "14in";
            width = "8.5in";
        } else if (type.equalsIgnoreCase("a4")) {
            height = "297mm";
            width = "210mm";
        } else if (type.equalsIgnoreCase("a3")) {
            height = "420mm";
            width = "297mm";
        } else if (type.equalsIgnoreCase("a5")) {
            height = "210mm";
            width = "148mm";
        } else if (type.equalsIgnoreCase("us-ledger")) {
            height = "17in";
            width = "11in";
        } else if (type.equalsIgnoreCase("us-super-b")) {
            height = "19in";
            width = "13in";
        } else {
            assert (false);
            return size;
        }
        try {
            String sessionUnit = module.getSession().getUnits();
            if (height != null) {
                size.y = DimensionUtil.convertTo(height, sessionUnit, sessionUnit).getMeasure();
            }
            if (width != null) {
                size.x = DimensionUtil.convertTo(width, sessionUnit, sessionUnit).getMeasure();
            }
        }
        catch (PropertyValueException propertyValueException) {
            assert (false);
        }
        catch (IllegalArgumentException e) {
            if (!"custom".equalsIgnoreCase(type)) {
                throw e;
            }
            try {
                DimensionValue dimWidth = StringUtil.parseInput(width, module.getLocale());
                DimensionValue dimHeight = StringUtil.parseInput(height, module.getLocale());
                size.x = dimWidth.getMeasure();
                size.y = dimHeight.getMeasure();
            }
            catch (PropertyValueException propertyValueException) {
                return null;
            }
        }
        return size;
    }

    public boolean isLandscape(Module module) {
        return !this.getStringProperty(module, "type").equalsIgnoreCase("custom") && this.getStringProperty(module, "orientation").equalsIgnoreCase("landscape");
    }

    public boolean isCustomType(Module module) {
        return "custom".equalsIgnoreCase(this.getStringProperty(module, "type"));
    }

    public Rectangle getContentArea(Module module) {
        Point size = this.getSize(module);
        Rectangle margins = new Rectangle();
        margins.y = this.getFloatProperty(module, "topMargin");
        margins.x = this.getFloatProperty(module, "leftMargin");
        margins.height = size.y - margins.y - this.getFloatProperty(module, "bottomMargin");
        margins.width = size.x - margins.x - this.getFloatProperty(module, "rightMargin");
        return margins;
    }

    @Override
    public List<SemanticException> validate(Module module) {
        List<SemanticException> list = super.validate(module);
        List<SemanticException> pageSizeErrors = MasterPageTypeValidator.getInstance().validate(module, this);
        if (!pageSizeErrors.isEmpty()) {
            list.addAll(pageSizeErrors);
            return list;
        }
        list.addAll(MasterPageSizeValidator.getInstance().validate(module, this));
        return list;
    }

    @Override
    public List<SemanticException> checkContent(Module module, ContainerContext containerInfo, DesignElement content) {
        List<SemanticException> errors = super.checkContent(module, containerInfo, content);
        if (!errors.isEmpty()) {
            return errors;
        }
        errors.addAll(MasterPageContextContainmentValidator.getInstance().validateForAdding(module, containerInfo, content));
        return errors;
    }

    @Override
    public List<SemanticException> checkContent(Module module, ContainerContext containerInfo, IElementDefn defn) {
        List<SemanticException> errors = super.checkContent(module, containerInfo, defn);
        if (!errors.isEmpty()) {
            return errors;
        }
        errors.addAll(MasterPageContextContainmentValidator.getInstance().validateForAdding(module, containerInfo == null ? null : containerInfo.getElement(), defn));
        return errors;
    }

    private DimensionValue getPredefinedDimension(String propName, boolean isLandScape, String predefinedWidth, String predefinedHeight) throws PropertyValueException {
        if ("height".equals(propName)) {
            if (!isLandScape) {
                return DimensionValue.parse(predefinedHeight);
            }
            return DimensionValue.parse(predefinedWidth);
        }
        if ("width".equals(propName)) {
            if (!isLandScape) {
                return DimensionValue.parse(predefinedWidth);
            }
            return DimensionValue.parse(predefinedHeight);
        }
        assert (false);
        return null;
    }

    @Override
    public Object getProperty(Module module, ElementPropertyDefn prop) {
        block11: {
            String propName = prop.getName();
            if ("height".equals(propName) || "width".equals(propName)) {
                String pageType = (String)this.getProperty(module, "type");
                if ("custom".equalsIgnoreCase(pageType)) {
                    return super.getProperty(module, prop);
                }
                boolean isLandScape = this.isLandscape(module);
                try {
                    if ("a4".equalsIgnoreCase(pageType)) {
                        return this.getPredefinedDimension(propName, isLandScape, "210mm", "297mm");
                    }
                    if ("us-legal".equalsIgnoreCase(pageType)) {
                        return this.getPredefinedDimension(propName, isLandScape, "8.5in", "14in");
                    }
                    if ("us-letter".equalsIgnoreCase(pageType)) {
                        return this.getPredefinedDimension(propName, isLandScape, "8.5in", "11in");
                    }
                    if ("us-ledger".equalsIgnoreCase(pageType)) {
                        return this.getPredefinedDimension(propName, isLandScape, "11in", "17in");
                    }
                    if ("us-super-b".equalsIgnoreCase(pageType)) {
                        return this.getPredefinedDimension(propName, isLandScape, "13in", "19in");
                    }
                    if ("a3".equalsIgnoreCase(pageType)) {
                        return this.getPredefinedDimension(propName, isLandScape, "297mm", "420mm");
                    }
                    if ("a5".equalsIgnoreCase(pageType)) {
                        return this.getPredefinedDimension(propName, isLandScape, "148mm", "210mm");
                    }
                }
                catch (PropertyValueException propertyValueException) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError();
                }
            }
        }
        return super.getProperty(module, prop);
    }
}

