/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.AggregateSortObserver;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.GenericAggregateResultSet;
import org.apache.derby.impl.sql.execute.GenericAggregator;

class GroupedAggregateResultSet
extends GenericAggregateResultSet
implements CursorResultSet {
    public int rowsInput;
    public int rowsReturned;
    private ColumnOrdering[] order;
    public boolean hasDistinctAggregate;
    public boolean isInSortedOrder;
    private int numDistinctAggs = 0;
    private int maxRowSize;
    private ScanController scanController;
    private ExecIndexRow sourceExecIndexRow;
    private ExecIndexRow sortResultRow;
    private boolean resultsComplete;
    private List<ExecRow> finishedResults;
    private ExecIndexRow[] resultRows;
    private List<List<Set<DataValueDescriptor>>> distinctValues;
    private boolean rollup;
    private boolean usingAggregateObserver = false;
    private long genericSortId;
    private TransactionController tc;
    public Properties sortProperties = new Properties();

    GroupedAggregateResultSet(NoPutResultSet noPutResultSet, boolean bl, int n, int n2, Activation activation, int n3, int n4, int n5, double d, double d2, boolean bl2) throws StandardException {
        super(noPutResultSet, n, activation, n3, n5, d, d2);
        this.isInSortedOrder = bl;
        this.rollup = bl2;
        this.finishedResults = new ArrayList<ExecRow>();
        this.order = (ColumnOrdering[])((FormatableArrayHolder)activation.getPreparedStatement().getSavedObject(n2)).getArray(ColumnOrdering[].class);
        this.hasDistinctAggregate = this.aggInfoList.hasDistinct();
        this.usingAggregateObserver = !bl && !this.rollup && !this.hasDistinctAggregate;
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.sortResultRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.sourceExecIndexRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.source.openCore();
        try {
            ExecIndexRow execIndexRow;
            if (!this.isInSortedOrder) {
                this.scanController = this.loadSorter();
            }
            boolean bl = this.resultsComplete = (execIndexRow = this.getNextRowFromRS()) == null;
            if (this.usingAggregateObserver) {
                if (execIndexRow != null) {
                    this.finishedResults.add(this.finishAggregation(execIndexRow).getClone());
                }
            } else if (!this.resultsComplete) {
                this.resultRows = this.rollup ? new ExecIndexRow[this.numGCols() + 1] : new ExecIndexRow[1];
                if (this.aggInfoList.hasDistinct()) {
                    this.distinctValues = new ArrayList<List<Set<DataValueDescriptor>>>(this.resultRows.length);
                }
                for (int i = 0; i < this.resultRows.length; ++i) {
                    this.resultRows[i] = (ExecIndexRow)execIndexRow.getClone();
                    this.initializeVectorAggregation(this.resultRows[i]);
                    if (!this.aggInfoList.hasDistinct()) continue;
                    this.distinctValues.add(new ArrayList(this.aggregates.length));
                    this.initializeDistinctMaps(i, true);
                }
            }
        }
        catch (StandardException standardException) {
            this.isOpen = true;
            try {
                this.close();
            }
            catch (StandardException standardException2) {
                // empty catch block
            }
            throw standardException;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private ScanController loadSorter() throws StandardException {
        ExecIndexRow execIndexRow;
        int n = (int)this.optimizerEstimatedRowCount;
        ExecIndexRow execIndexRow2 = this.getRowTemplate();
        this.tc = this.getTransactionController();
        BasicSortObserver basicSortObserver = this.usingAggregateObserver ? new AggregateSortObserver(true, this.aggregates, this.aggregates, execIndexRow2) : new BasicSortObserver(true, false, execIndexRow2, true);
        this.genericSortId = this.tc.createSort(null, execIndexRow2.getRowArray(), this.order, basicSortObserver, false, n, this.maxRowSize);
        SortController sortController = this.tc.openSort(this.genericSortId);
        while ((execIndexRow = this.getNextRowFromRS()) != null) {
            sortController.insert(execIndexRow.getRowArray());
        }
        this.source.close();
        sortController.completedInserts();
        this.sortProperties = sortController.getSortInfo().getAllSortInfo(this.sortProperties);
        if (this.aggInfoList.hasDistinct()) {
            this.numDistinctAggs = 1;
        }
        return this.tc.openSortScan(this.genericSortId, this.activation.getResultSetHoldability());
    }

    private int numGCols() {
        return this.order.length - this.numDistinctAggs;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (!this.isOpen) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.finishedResults.size() > 0) {
            return this.makeCurrent(this.finishedResults.remove(0));
        }
        if (this.resultsComplete) {
            return null;
        }
        ExecIndexRow execIndexRow = this.getNextRowFromRS();
        if (execIndexRow == null) {
            return this.finalizeResults();
        }
        if (this.usingAggregateObserver) {
            return this.finishAggregation(execIndexRow);
        }
        while (execIndexRow != null) {
            ExecIndexRow execIndexRow2 = this.resultRows[this.resultRows.length - 1];
            ExecRow execRow = execIndexRow.getClone();
            this.initializeVectorAggregation(execIndexRow);
            int n = this.sameGroupingValues(execIndexRow2, execIndexRow);
            for (int i = 0; i < this.resultRows.length; ++i) {
                boolean bl;
                boolean bl2 = this.rollup ? i <= n : (bl = n == this.numGCols());
                if (bl) {
                    this.mergeVectorAggregates(execIndexRow, this.resultRows[i], i);
                    continue;
                }
                this.setRollupColumnsToNull(this.resultRows[i], i);
                this.finishedResults.add(this.finishAggregation(this.resultRows[i]));
                this.resultRows[i] = (ExecIndexRow)execRow.getClone();
                this.initializeVectorAggregation(this.resultRows[i]);
                this.initializeDistinctMaps(i, false);
            }
            if (this.finishedResults.size() > 0) {
                this.nextTime += this.getElapsedMillis(this.beginTime);
                ++this.rowsReturned;
                return this.makeCurrent(this.finishedResults.remove(0));
            }
            execIndexRow = this.getNextRowFromRS();
        }
        return this.finalizeResults();
    }

    private ExecRow makeCurrent(Object object) throws StandardException {
        ExecRow execRow = (ExecRow)object;
        this.setCurrentRow(execRow);
        return execRow;
    }

    private ExecRow finalizeResults() throws StandardException {
        this.resultsComplete = true;
        if (!this.usingAggregateObserver) {
            for (int i = 0; i < this.resultRows.length; ++i) {
                this.setRollupColumnsToNull(this.resultRows[i], i);
                this.finishedResults.add(this.finishAggregation(this.resultRows[i]));
            }
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        if (this.finishedResults.size() > 0) {
            return this.makeCurrent(this.finishedResults.remove(0));
        }
        return null;
    }

    private int sameGroupingValues(ExecRow execRow, ExecRow execRow2) throws StandardException {
        for (int i = 0; i < this.numGCols(); ++i) {
            DataValueDescriptor dataValueDescriptor;
            DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(this.order[i].getColumnId() + 1);
            if (dataValueDescriptor2.compare(2, dataValueDescriptor = execRow2.getColumn(this.order[i].getColumnId() + 1), true, true)) continue;
            return i;
        }
        return this.numGCols();
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.sortResultRow = null;
            this.sourceExecIndexRow = null;
            this.closeSource();
            if (!this.isInSortedOrder) {
                this.tc.dropSort(this.genericSortId);
            }
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
        this.isOpen = false;
    }

    @Override
    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.originalSource.getTimeSpent(1);
        }
        return l;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        RowLocation rowLocation = this.scanController.newRowLocationTemplate();
        this.scanController.fetchLocation(rowLocation);
        return rowLocation;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    private ExecIndexRow getNextRowFromRS() throws StandardException {
        return this.scanController == null ? this.getRowFromResultSet() : this.getRowFromSorter();
    }

    private ExecIndexRow getRowFromResultSet() throws StandardException {
        ExecIndexRow execIndexRow = null;
        ExecRow execRow = this.source.getNextRowCore();
        if (execRow != null) {
            ++this.rowsInput;
            this.sourceExecIndexRow.execRowToExecIndexRow(execRow);
            execIndexRow = this.sourceExecIndexRow;
        }
        return execIndexRow;
    }

    private void setRollupColumnsToNull(ExecRow execRow, int n) throws StandardException {
        int n2 = this.resultRows.length - n - 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.numGCols() - 1 - i;
            DataValueDescriptor dataValueDescriptor = execRow.getColumn(this.order[n3].getColumnId() + 1);
            dataValueDescriptor.setToNull();
        }
    }

    private ExecIndexRow getRowFromSorter() throws StandardException {
        ExecIndexRow execIndexRow = null;
        if (this.scanController.next()) {
            this.currentRow = this.sortResultRow;
            execIndexRow = this.getExecutionFactory().getIndexableRow(this.currentRow);
            this.scanController.fetch(execIndexRow.getRowArray());
        }
        return execIndexRow;
    }

    public void closeSource() throws StandardException {
        if (this.scanController == null) {
            this.source.close();
        } else {
            this.scanController.close();
            this.scanController = null;
        }
    }

    private void initializeVectorAggregation(ExecRow execRow) throws StandardException {
        for (GenericAggregator genericAggregator : this.aggregates) {
            genericAggregator.initialize(execRow);
            genericAggregator.accumulate(execRow, execRow);
        }
    }

    private void mergeVectorAggregates(ExecRow execRow, ExecRow execRow2, int n) throws StandardException {
        for (int i = 0; i < this.aggregates.length; ++i) {
            DataValueDescriptor dataValueDescriptor;
            GenericAggregator genericAggregator = this.aggregates[i];
            AggregatorInfo aggregatorInfo = (AggregatorInfo)this.aggInfoList.elementAt(i);
            if (aggregatorInfo.isDistinct() && !(dataValueDescriptor = genericAggregator.getInputColumnValue(execRow)).isNull() && !this.distinctValues.get(n).get(i).add(dataValueDescriptor)) continue;
            genericAggregator.merge(execRow, execRow2);
        }
    }

    private void initializeDistinctMaps(int n, boolean bl) throws StandardException {
        for (int i = 0; i < this.aggregates.length; ++i) {
            AggregatorInfo aggregatorInfo = (AggregatorInfo)this.aggInfoList.elementAt(i);
            if (bl) {
                this.distinctValues.get(n).add(aggregatorInfo.isDistinct() ? new HashSet() : null);
            }
            if (!aggregatorInfo.isDistinct()) continue;
            Set<DataValueDescriptor> set = this.distinctValues.get(n).get(i);
            set.clear();
            DataValueDescriptor dataValueDescriptor = this.aggregates[i].getInputColumnValue(this.resultRows[n]);
            set.add(dataValueDescriptor);
        }
    }
}

