/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.data.ui.util.SelectValueFetcher;
import org.eclipse.birt.report.designer.internal.ui.data.DataService;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ImportValueDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.SelectionChoiceDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.DefaultParameterDialogControlTypeHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.internal.ui.expressions.ExpressionContextFactoryImpl;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionContextFactory;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ITableAreaModifier;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.TableArea;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.FormatBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectParameterDefaultValueDialog;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.parameters.ParameterUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ParameterDialog
extends BaseTitleAreaDialog {
    private static final String NULL_VALUE = Messages.getString((String)"ParameterDialog.Value.Null");
    private static final String EMPTY_VALUE = Messages.getString((String)"ParameterDialog.Value.Empty");
    private static final String CHOICE_NO_DEFAULT = Messages.getString((String)"ParameterDialog.Choice.NoDefault");
    private static final String CHOICE_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Choice.DisplayText");
    private static final String CHOICE_VALUE_COLUMN = Messages.getString((String)"ParameterDialog.Choice.ValueColumn");
    private static final String CHOICE_ASCENDING = Messages.getString((String)"ParameterDialog.Choice.ASCENDING");
    private static final String CHOICE_DESCENDING = Messages.getString((String)"ParameterDialog.Choice.DESCENDING");
    private static final String CHOICE_SELECT_VALUE = Messages.getString((String)"ParameterDialog.Choice.SelectValue");
    private static final String GROUP_MORE_OPTION = Messages.getString((String)"ParameterDialog.Group.MoreOption");
    private static final String LABEL_NAME = Messages.getString((String)"ParameterDialog.Label.Name");
    private static final String LABEL_DATETIME_PROMPT = Messages.getFormattedString((String)"ParameterDialog.datetime.prompt", (Object[])new String[]{"yyyy-MM-dd HH:mm:ss.SSS"});
    private static final String LABEL_DATE_PROMPT = Messages.getFormattedString((String)"ParameterDialog.date.prompt", (Object[])new String[]{"yyyy-MM-dd"});
    private static final String LABEL_TIME_PROMPT = Messages.getFormattedString((String)"ParameterDialog.time.prompt", (Object[])new String[]{"hh:mm:ss"});
    private static final String LABEL_PROMPT_TEXT = Messages.getString((String)"ParameterDialog.Label.PromptText");
    private static final String LABEL_PARAM_DATA_TYPE = Messages.getString((String)"ParameterDialog.Label.DataType");
    private static final String LABEL_DISPALY_TYPE = Messages.getString((String)"ParameterDialog.Label.DisplayType");
    private static final String LABEL_DEFAULT_VALUE = Messages.getString((String)"ParameterDialog.Label.DefaultValue");
    private static final String LABEL_HELP_TEXT = Messages.getString((String)"ParameterDialog.Label.HelpText");
    private static final String LABEL_LIST_OF_VALUE = Messages.getString((String)"ParameterDialog.Label.ListOfValue");
    private static final String LABEL_SORT_GROUP = Messages.getString((String)"ParameterDialog.Label.SortGroup");
    private static final String LABEL_VALUES = Messages.getString((String)"ParameterDialog.Label.Value");
    private static final String LABEL_FORMAT = Messages.getString((String)"ParameterDialog.Label.Format");
    private static final String LABEL_LIST_LIMIT = Messages.getString((String)"ParameterDialog.Label.Listlimit");
    private static final String LABEL_NULL = ParameterUtil.LABEL_NULL;
    private static final String LABEL_SELECT_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Label.SelectDisplayText");
    private static final String LABEL_SELECT_VALUE_COLUMN = Messages.getString((String)"ParameterDialog.Label.SelectValueColumn");
    private static final String LABEL_SELECT_DATA_SET = Messages.getString((String)"ParameterDialog.Label.SelectDataSet");
    private static final String LABEL_PREVIEW = Messages.getString((String)"ParameterDialog.Label.Preview");
    private static final String LABEL_SORT_KEY = Messages.getString((String)"ParameterDialog.Label.SortKey");
    private static final String LABEL_SORT_DIRECTION = Messages.getString((String)"ParameterDialog.Label.SortDirection");
    private static final String CHECKBOX_ISREQUIRED = Messages.getString((String)"ParameterDialog.CheckBox.IsRequired");
    private static final String CHECKBOX_DO_NOT_ECHO = Messages.getString((String)"ParameterDialog.CheckBox.DoNotEchoInput");
    private static final String CHECKBOX_HIDDEN = Messages.getString((String)"ParameterDialog.CheckBox.Hidden");
    private static final String CHECKBOX_DISTINCT = Messages.getString((String)"ParameterDialog.CheckBox.Distinct");
    private static final String BUTTON_LABEL_CHANGE_FORMAT = Messages.getString((String)"ParameterDialog.Button.ChangeFormat");
    private static final String BUTTON_LABEL_IMPORT = Messages.getString((String)"ParameterDialog.Button.ImportValue");
    private static final String BUTTON_LABEL_SET_DEFAULT = Messages.getString((String)"ParameterDialog.Button.SetDefault");
    private static final String BUTTON_LABEL_REMOVE_DEFAULT = Messages.getString((String)"ParameterDialog.Button.RemoveDefault");
    private static final String BUTTON_CREATE_DATA_SET = Messages.getString((String)"ParameterDialog.Button.CreateDataSet");
    private static final String RADIO_DYNAMIC = Messages.getString((String)"ParameterDialog.Radio.Dynamic");
    private static final String CHECK_ALLOW_MULTI = Messages.getString((String)"ParameterDialog.Check.AllowMulti");
    private static final String RADIO_STATIC = Messages.getString((String)"ParameterDialog.Radio.Static");
    private static final String ERROR_TITLE_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorTitle.InvalidListLimit");
    private static final String ERROR_MSG_CANNOT_BE_BLANK = Messages.getString((String)"ParameterDialog.ErrorMessage.CanootBeBlank");
    private static final String ERROR_MSG_CANNOT_BE_NULL = Messages.getString((String)"ParameterDialog.ErrorMessage.CanootBeNull");
    private static final String ERROR_MSG_DUPLICATED_VALUE = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedValue");
    private static final String ERROR_MSG_DUPLICATED_LABEL = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedLabel");
    private static final String ERROR_MSG_DUPLICATED_LABELKEY = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedLabelKey");
    private static final String ERROR_MSG_MISMATCH_DATA_TYPE = Messages.getString((String)"ParameterDialog.ErrorMessage.MismatchDataType");
    private static final String ERROR_MSG_DUPLICATED_NAME = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedName");
    private static final String ERROR_MSG_NAME_IS_EMPTY = Messages.getString((String)"ParameterDialog.ErrorMessage.EmptyName");
    private static final String ERROR_MSG_NO_AVAILABLE_COLUMN = Messages.getString((String)"ParameterDialog.ErrorMessage.NoAvailableColumn");
    private static final String ERROR_MSG_VALUE_COLUMN_EMPTY = Messages.getString((String)"ParameterDialog.ErrorMessage.ValueColumnEmpty");
    private static final String ERROR_MSG_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorMessage.InvalidListLimit");
    private static final String FLAG_DEFAULT = Messages.getString((String)"ParameterDialog.Flag.Default");
    private static final String COLUMN_VALUE = Messages.getString((String)"ParameterDialog.Column.Value");
    private static final String COLUMN_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Column.DisplayText");
    private static final String COLUMN_DISPLAY_TEXT_KEY = Messages.getString((String)"ParameterDialog.Column.DisplayTextKey");
    private static final String COLUMN_IS_DEFAULT = Messages.getString((String)"ParameterDialog.Column.Default");
    private static final String BOOLEAN_TRUE = Messages.getString((String)"ParameterDialog.Boolean.True");
    private static final String BOOLEAN_FALSE = Messages.getString((String)"ParameterDialog.Boolean.False");
    public static final String PARAM_CONTROL_LIST = "list-box/List";
    public static final String PARAM_CONTROL_COMBO = "list-box/Combo";
    public static final String DISPLAY_NAME_CONTROL_LIST = Messages.getString((String)"ParameterDialog.DisplayLabel.List");
    public static final String DISPLAY_NAME_CONTROL_COMBO = Messages.getString((String)"ParameterDialog.DisplayLabel.Combo");
    private static final String NONE_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Label.None");
    private static final Image DEFAULT_ICON = ReportPlatformUIImages.getImage("Default");
    private static final Image NOT_DEFAULT_ICON = ReportPlatformUIImages.getImage("NotDefault");
    public static final String CONTROLTYPE_VALUE = "controltype";
    public static final String DATATYPE_VALUE = "datatype";
    public static final String STATIC_VALUE = "static";
    public static final String HELPER_KEY_CONTROLTYPE = "controlType";
    public static final String HELPER_KEY_STARTPOINT = "autoSuggestStartPoint";
    public static final String CONTROLTYPE_INPUTVALUE = "controltypeinput";
    public static final String STARTPOINT_INPUTVALUE = "startpointinput";
    public static final String STARTPOINT_VALUE = "startpoint";
    private boolean allowMultiValueVisible = true;
    private HashMap dirtyProperties = new HashMap(5);
    private ArrayList choiceList = new ArrayList();
    private Map<SelectionChoice, SelectionChoice> editChoiceMap = new HashMap<SelectionChoice, SelectionChoice>();
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getElement("ScalarParameter").getProperty("dataType").getAllowedChoices();
    private static final double DEFAULT_PREVIEW_NUMBER = 1234.56;
    private static final int DEFAULT_PREVIEW_INTEGER = 123456;
    private ScalarParameterHandle inputParameter;
    private boolean loading = true;
    private Text nameEditor;
    private Text promptTextEditor;
    private Text helpTextEditor;
    private Text formatField;
    private Label promptMessageLine;
    private Button isRequired;
    private Button doNotEcho;
    private Button isHidden;
    private Button distinct;
    private Button importValue;
    private Button changeDefault;
    private Button changeFormat;
    private Button createDataSet;
    private Button dynamicRadio;
    private Button staticRadio;
    private Button allowMultiChoice;
    private Combo dataTypeChooser;
    private CCombo defaultValueChooser;
    private Combo dataSetChooser;
    private Combo columnChooser;
    private Combo displayTextChooser;
    private Combo sortKeyChooser;
    private Combo sortDirectionChooser;
    private Label sortKeyLabel;
    private Label sortDirectionLabel;
    private CLabel previewLabel;
    private TableViewer valueTable;
    private String lastDataType;
    private String lastControlType;
    private String formatCategroy;
    private String formatPattern;
    private ULocale formatLocale;
    private List<Expression> defaultValueList;
    private Composite valueArea;
    private Composite sorttingArea;
    private List columnList;
    private TableArea staticTableArea;
    private IDialogHelper controlTypeHelper;
    private IDialogHelper startPointTypeHelper;
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = (ArrayList)inputElement;
            ArrayList elementsList = (ArrayList)list.clone();
            return elementsList.toArray();
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            if (ParameterDialog.this.valueTable.getColumnProperties().length == 5 && columnIndex == 1) {
                SelectionChoice choice = (SelectionChoice)element;
                if (ParameterDialog.this.isDefaultChoice(choice)) {
                    return DEFAULT_ICON;
                }
                return NOT_DEFAULT_ICON;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SelectionChoice choice = (SelectionChoice)element;
            int valueIndex = ParameterDialog.this.valueTable.getColumnProperties().length - 3;
            String text = null;
            if (ParameterDialog.this.valueTable.getColumnProperties().length == 5 && columnIndex == 1) {
                if (ParameterDialog.this.isDefaultChoice(choice)) {
                    text = FLAG_DEFAULT;
                }
            } else if (columnIndex == valueIndex) {
                text = choice.getValue();
                if (text == null) {
                    text = NULL_VALUE;
                } else if (text.equals("")) {
                    text = EMPTY_VALUE;
                }
            } else if (columnIndex == valueIndex + 1) {
                text = choice.getLabel();
                if (text == null) {
                    return "";
                }
            } else if (columnIndex == valueIndex + 2) {
                text = choice.getLabelResourceKey();
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private final ITableAreaModifier tableAreaModifier = new ITableAreaModifier(){

        @Override
        public boolean editItem(Object element) {
            final SelectionChoice oldChoice = (SelectionChoice)element;
            SelectionChoice tempChoice = this.cloneSelectionChoice(oldChoice);
            String oldVal = oldChoice.getValue();
            boolean isDefault = ParameterDialog.this.isDefaultChoice(oldChoice);
            SelectionChoiceDialog dialog = new SelectionChoiceDialog(Messages.getString((String)"ParameterDialog.SelectionDialog.Edit"), ParameterDialog.this.canBeNull(), ParameterDialog.this.canUseEmptyValue());
            dialog.setInput(tempChoice);
            dialog.setValidator(new SelectionChoiceDialog.ISelectionChoiceValidator(){

                @Override
                public String validate(String displayLableKey, String displayLabel, String value) {
                    return ParameterDialog.this.validateChoice(oldChoice, displayLableKey, displayLabel, value);
                }
            });
            if (dialog.open() == 0) {
                ParameterDialog.this.editChoiceMap.put(tempChoice, oldChoice);
                ParameterDialog.this.choiceList.set(ParameterDialog.this.choiceList.indexOf(oldChoice), tempChoice);
                if (isDefault) {
                    ParameterDialog.this.changeDefaultValue(oldVal, tempChoice.getValue());
                }
                return true;
            }
            return false;
        }

        private SelectionChoice cloneSelectionChoice(SelectionChoice choice) {
            SelectionChoice tempChoice = StructureFactory.createSelectionChoice();
            tempChoice.setValue(choice.getValue());
            tempChoice.setLabel(choice.getLabel());
            tempChoice.setLabelResourceKey(choice.getLabelResourceKey());
            return tempChoice;
        }

        @Override
        public boolean newItem() {
            SelectionChoice choice = StructureFactory.createSelectionChoice();
            SelectionChoiceDialog dialog = new SelectionChoiceDialog(Messages.getString((String)"ParameterDialog.SelectionDialog.New"), ParameterDialog.this.canBeNull(), ParameterDialog.this.canUseEmptyValue());
            dialog.setInput(choice);
            dialog.setValidator(new SelectionChoiceDialog.ISelectionChoiceValidator(){

                @Override
                public String validate(String displayLabelKey, String displayLabel, String value) {
                    return ParameterDialog.this.validateChoice(null, displayLabelKey, displayLabel, value);
                }
            });
            if (dialog.open() == 0) {
                ParameterDialog.this.choiceList.add(choice);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeItem(Object[] elements) {
            int i = 0;
            while (i < elements.length) {
                if (ParameterDialog.this.isDefaultChoice((SelectionChoice)elements[i])) {
                    ParameterDialog.this.removeDefaultValue(((SelectionChoice)elements[i]).getValue());
                }
                ParameterDialog.this.choiceList.remove(elements[i]);
                ++i;
            }
            return true;
        }

        @Override
        public boolean removeItemAll() {
            ParameterDialog.this.choiceList.clear();
            if (ParameterDialog.this.defaultValueList != null && ParameterDialog.this.defaultValueList.size() > 0) {
                ParameterDialog.this.defaultValueList.clear();
                ParameterDialog.this.valueTable.refresh();
            }
            return true;
        }
    };
    protected IStructuredContentProvider tableContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    protected ITableLabelProvider tableLableProvier = new ITableLabelProvider(){

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Expression) {
                    String value = ((Expression)element).getStringExpression();
                    if (value == null) {
                        return NULL_VALUE;
                    }
                    if (value.equals("")) {
                        return EMPTY_VALUE;
                    }
                }
                return element.toString();
            }
            return "";
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private Text listLimit;
    private Composite displayArea;
    private boolean isInitialized;
    private TableViewer defaultValueViewer;
    private Button delBtn;
    private Button editBtn;
    private Button delAllBtn;
    private Group valuesDefineSection;
    private Button addButton;
    private Composite rightPart;

    public ParameterDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    public ParameterDialog(Shell parentShell, String title) {
        super(parentShell);
        this.title = title;
    }

    public ParameterDialog(Shell parentShell, String title, boolean allowMultiValueVisible) {
        this(parentShell, title);
        this.allowMultiValueVisible = allowMultiValueVisible;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(Messages.getString((String)"ParameterDialog.message"));
        ScrolledComposite scrollContent = new ScrolledComposite((Composite)super.createDialogArea(parent), 768);
        scrollContent.setAlwaysShowScrollBars(false);
        scrollContent.setExpandHorizontal(true);
        scrollContent.setMinWidth(600);
        scrollContent.setLayout((Layout)new FillLayout());
        scrollContent.setLayoutData((Object)new GridData(1808));
        this.displayArea = new Composite((Composite)scrollContent, 0);
        Composite topComposite = new Composite(this.displayArea, 0);
        topComposite.setLayoutData((Object)new GridData(768));
        topComposite.setLayout((Layout)new GridLayout(2, false));
        this.createPropertiesSection(topComposite);
        this.createDisplayOptionsSection(topComposite);
        this.createValuesDefineSection(this.displayArea);
        this.displayArea.setLayout((Layout)new GridLayout());
        Point size = this.displayArea.computeSize(-1, -1);
        this.displayArea.setSize(size);
        scrollContent.setContent((Control)this.displayArea);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ParameterDialog_ID");
        return scrollContent;
    }

    private void createPropertiesSection(Composite composite) {
        Composite propertiesSection = new Composite(composite, 0);
        propertiesSection.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.minimumWidth = 200;
        propertiesSection.setLayoutData((Object)gd);
        this.createLabel(propertiesSection, LABEL_NAME);
        this.nameEditor = new Text(propertiesSection, 2048);
        this.nameEditor.setLayoutData((Object)new GridData(768));
        this.nameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDialog.this.updateMessageLine();
            }
        });
        this.createLabel(propertiesSection, LABEL_PROMPT_TEXT);
        this.promptTextEditor = new Text(propertiesSection, 2048);
        this.promptTextEditor.setLayoutData((Object)new GridData(768));
        this.createLabel(propertiesSection, LABEL_PARAM_DATA_TYPE);
        this.dataTypeChooser = new Combo(propertiesSection, 12);
        this.dataTypeChooser.setLayoutData((Object)new GridData(768));
        this.dataTypeChooser.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(DATA_TYPE_CHOICE_SET));
        this.dataTypeChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.changeDataType();
                ParameterDialog.this.updateCheckBoxArea();
                ParameterDialog.this.refreshColumns(true);
                ParameterDialog.this.handleControlTypeSelectionEvent();
            }
        });
        this.createLabel(propertiesSection, LABEL_DISPALY_TYPE);
        this.createControlTypeChooser(propertiesSection);
    }

    private void createControlTypeChooser(Composite propertiesSection) {
        IDialogHelperProvider helperProvider = (IDialogHelperProvider)ElementAdapterManager.getAdapter((Object)this, IDialogHelperProvider.class);
        if (helperProvider != null) {
            this.controlTypeHelper = helperProvider.createHelper((Object)this, HELPER_KEY_CONTROLTYPE);
        }
        if (this.controlTypeHelper == null) {
            this.controlTypeHelper = new DefaultParameterDialogControlTypeHelper();
        }
        this.controlTypeHelper.setContainer((Object)this);
        this.controlTypeHelper.createContent(propertiesSection);
        this.controlTypeHelper.getControl().setLayoutData((Object)new GridData(768));
        this.controlTypeHelper.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ParameterDialog.this.handleControlTypeSelectionEvent();
            }
        });
    }

    private void createDisplayOptionsSection(Composite composite) {
        Group displayOptionSection = new Group(composite, 0);
        displayOptionSection.setText(GROUP_MORE_OPTION);
        displayOptionSection.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.minimumWidth = 400;
        displayOptionSection.setLayoutData((Object)gd);
        this.createLabel((Composite)displayOptionSection, LABEL_HELP_TEXT);
        this.helpTextEditor = new Text((Composite)displayOptionSection, 2048);
        this.helpTextEditor.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)displayOptionSection, LABEL_FORMAT);
        Composite formatSection = new Composite((Composite)displayOptionSection, 0);
        formatSection.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        formatSection.setLayoutData((Object)new GridData(768));
        this.formatField = new Text(formatSection, 2060);
        GridData fFgd = new GridData(768);
        fFgd.minimumWidth = 180;
        this.formatField.setLayoutData((Object)fFgd);
        this.changeFormat = new Button(formatSection, 8);
        this.changeFormat.setText(BUTTON_LABEL_CHANGE_FORMAT);
        this.setButtonLayoutData(this.changeFormat);
        this.changeFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.popupFormatBuilder(true);
            }
        });
        this.createLabel((Composite)displayOptionSection, null);
        Group previewArea = new Group((Composite)displayOptionSection, 0);
        previewArea.setLayoutData((Object)new GridData(768));
        previewArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        previewArea.setText(LABEL_PREVIEW);
        this.previewLabel = new CLabel((Composite)previewArea, 0);
        this.previewLabel.setAlignment(0x1000000);
        this.previewLabel.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)displayOptionSection, LABEL_LIST_LIMIT);
        Composite limitArea = new Composite((Composite)displayOptionSection, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        limitArea.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.verticalSpan = 1;
        limitArea.setLayoutData((Object)data);
        this.listLimit = new Text(limitArea, 2048);
        data = new GridData();
        data.widthHint = 80;
        this.listLimit.setLayoutData((Object)data);
        this.listLimit.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = "0123456789\u0000\b\u007f".indexOf(e.character) != -1;
            }
        });
        Label values = new Label(limitArea, 0);
        values.setText(Messages.getString((String)"ParameterDialog.Label.values"));
        values.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)displayOptionSection, null);
        Composite checkBoxArea = new Composite((Composite)displayOptionSection, 0);
        checkBoxArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        checkBoxArea.setLayoutData((Object)new GridData(1808));
        this.isRequired = new Button(checkBoxArea, 32);
        this.isRequired.setText(CHECKBOX_ISREQUIRED);
        this.addCheckBoxListener(this.isRequired, CHECKBOX_ISREQUIRED);
        this.doNotEcho = new Button(checkBoxArea, 32);
        this.doNotEcho.setText(CHECKBOX_DO_NOT_ECHO);
        this.addCheckBoxListener(this.doNotEcho, CHECKBOX_DO_NOT_ECHO);
        this.isHidden = new Button(checkBoxArea, 32);
        this.isHidden.setText(CHECKBOX_HIDDEN);
        this.addCheckBoxListener(this.isHidden, CHECKBOX_HIDDEN);
        this.distinct = new Button(checkBoxArea, 32);
        this.distinct.setText(CHECKBOX_DISTINCT);
        this.distinct.setSelection(false);
        this.addCheckBoxListener(this.distinct, CHECKBOX_DISTINCT);
        this.createStartPointSection(displayOptionSection);
    }

    private void createStartPointSection(Group displayOptionSection) {
        IDialogHelperProvider helperProvider = (IDialogHelperProvider)ElementAdapterManager.getAdapter((Object)this, IDialogHelperProvider.class);
        if (helperProvider != null) {
            this.startPointTypeHelper = helperProvider.createHelper((Object)this, HELPER_KEY_STARTPOINT);
        }
        if (this.startPointTypeHelper != null) {
            this.startPointTypeHelper.createContent((Composite)displayOptionSection);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.startPointTypeHelper.getControl().setLayoutData((Object)data);
            this.startPointTypeHelper.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    ParameterDialog.this.startPointTypeHelper.update(false);
                }
            });
        }
    }

    private void hideStartPointSection(boolean hide) {
        if (this.startPointTypeHelper != null && this.startPointTypeHelper.getControl() != null) {
            GridData gd = (GridData)this.startPointTypeHelper.getControl().getLayoutData();
            gd.exclude = hide;
            this.startPointTypeHelper.getControl().setVisible(!hide);
            this.startPointTypeHelper.getControl().getParent().layout();
            if (!hide) {
                this.startPointTypeHelper.update(true);
            }
        }
    }

    private void createValuesDefineSection(Composite composite) {
        this.valuesDefineSection = new Group(composite, 0);
        this.valuesDefineSection.setText(LABEL_LIST_OF_VALUE);
        this.valuesDefineSection.setLayout((Layout)new GridLayout(2, false));
        this.valuesDefineSection.setLayoutData((Object)new GridData(768));
        Composite choiceArea = new Composite((Composite)this.valuesDefineSection, 0);
        choiceArea.setLayoutData((Object)new GridData(768));
        choiceArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(4, true));
        this.staticRadio = new Button(choiceArea, 16);
        this.staticRadio.setText(RADIO_STATIC);
        GridData gd = new GridData();
        gd.widthHint = Math.max(this.staticRadio.computeSize((int)-1, (int)-1).x, 100);
        gd.horizontalIndent = 40;
        this.staticRadio.setLayoutData((Object)gd);
        this.staticRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParameterDialog.this.staticRadio.getSelection()) {
                    ParameterDialog.this.switchParamterType();
                }
            }
        });
        this.dynamicRadio = new Button(choiceArea, 16);
        this.dynamicRadio.setText(RADIO_DYNAMIC);
        this.dynamicRadio.setLayoutData((Object)new GridData());
        this.dynamicRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParameterDialog.this.dynamicRadio.getSelection()) {
                    ParameterDialog.this.switchParamterType();
                }
            }
        });
        this.allowMultiChoice = new Button(choiceArea, 32);
        this.allowMultiChoice.setText(CHECK_ALLOW_MULTI);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 0x1000008;
        gd.grabExcessHorizontalSpace = true;
        this.allowMultiChoice.setLayoutData((Object)gd);
        this.allowMultiChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParameterDialog.this.isStatic() && !ParameterDialog.this.allowMultiChoice.getSelection()) {
                    Table table;
                    if (ParameterDialog.this.defaultValueList != null && ParameterDialog.this.defaultValueList.size() > 0) {
                        Expression expression = ParameterDialog.this.getFirstDefaultValue();
                        ParameterDialog.this.defaultValueList.clear();
                        ParameterDialog.this.defaultValueList.add(expression);
                        ParameterDialog.this.valueTable.refresh();
                    }
                    if ((table = ParameterDialog.this.staticTableArea.getTableViewer().getTable()).getSelectionCount() > 1) {
                        table.deselectAll();
                        ParameterDialog.this.updateStaticTableButtons();
                    }
                }
                ParameterDialog.this.initDefaultValueViewer();
            }
        });
        this.valueArea = new Composite((Composite)this.valuesDefineSection, 0);
        this.valueArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        gd = new GridData(1808);
        gd.minimumHeight = 320;
        gd.widthHint = 550;
        gd.horizontalSpan = 2;
        this.valueArea.setLayoutData((Object)gd);
        this.createLabel((Composite)this.valuesDefineSection, null);
    }

    public void setInput(Object input) {
        this.inputParameter = (ScalarParameterHandle)input;
    }

    @Override
    protected boolean initDialog() {
        this.nameEditor.setText(this.inputParameter.getName());
        if (!StringUtil.isBlank((String)this.inputParameter.getPromptText())) {
            this.promptTextEditor.setText(this.inputParameter.getPromptText());
        }
        this.helpTextEditor.setText(UIUtil.convertToGUIString(this.inputParameter.getHelpText()));
        for (SelectionChoiceHandle choiceHandle : this.inputParameter.getPropertyHandle("selectionList")) {
            this.choiceList.add(choiceHandle.getStructure());
        }
        if (this.inputParameter.getValueType().equals(STATIC_VALUE)) {
            this.staticRadio.setSelection(true);
        } else {
            this.dynamicRadio.setSelection(true);
        }
        this.defaultValueList = this.inputParameter.getDefaultValueList();
        if (this.enableAllowMultiValueVisible()) {
            this.allowMultiChoice.setVisible(true);
            if ("multi-value".endsWith(this.inputParameter.getParamType())) {
                this.allowMultiChoice.setSelection(true);
            } else {
                this.allowMultiChoice.setSelection(false);
            }
        } else {
            this.allowMultiChoice.setVisible(false);
        }
        if (this.inputParameter.getPropertyHandle("listLimit").isSet()) {
            this.listLimit.setText(String.valueOf(this.inputParameter.getListlimit()));
        }
        this.isHidden.setSelection(this.inputParameter.isHidden());
        this.isRequired.setSelection(this.inputParameter.isRequired());
        this.doNotEcho.setSelection(this.inputParameter.isConcealValue());
        this.distinct.setSelection(!this.inputParameter.distinct());
        if (this.startPointTypeHelper != null) {
            this.startPointTypeHelper.setProperty(STARTPOINT_INPUTVALUE, this.inputParameter.getAutoSuggestThreshold());
            this.startPointTypeHelper.update(true);
        }
        this.changeDataType();
        this.dataTypeChooser.setText(DATA_TYPE_CHOICE_SET.findChoice(this.inputParameter.getDataType()).getDisplayName());
        this.switchParamterType();
        this.loading = false;
        Point size = this.displayArea.computeSize(-1, -1);
        this.displayArea.setSize(size);
        this.isInitialized = true;
        return true;
    }

    private void initValueArea() {
        String expressionType;
        Expression expression;
        String controlType = this.getSelectedControlType();
        if ("auto-suggest".equals(controlType)) {
            this.listLimit.setEnabled(false);
        }
        String defaultValue = (expression = this.getFirstDefaultValue()) == null ? null : expression.getStringExpression();
        String string = expressionType = expression == null ? null : expression.getType();
        if (defaultValue != null) {
            defaultValue = defaultValue.trim();
        }
        if (this.isStatic()) {
            if ("check-box".equals(controlType)) {
                String type;
                if (expressionType != null) {
                    this.defaultValueChooser.setData("exprType", (Object)expressionType);
                    ExpressionButton button = (ExpressionButton)this.defaultValueChooser.getData("exprButton");
                    if (button != null) {
                        button.refresh();
                    }
                }
                if ("constant".equals(type = (String)this.defaultValueChooser.getData("exprType"))) {
                    this.defaultValueChooser.setEditable(false);
                    if (this.defaultValueChooser.getItemCount() == 0) {
                        this.defaultValueChooser.add(CHOICE_NO_DEFAULT);
                        this.defaultValueChooser.add(BOOLEAN_TRUE);
                        this.defaultValueChooser.add(BOOLEAN_FALSE);
                    }
                } else {
                    this.defaultValueChooser.setEditable(true);
                    if (this.defaultValueChooser.getItemCount() != 0) {
                        this.defaultValueChooser.removeAll();
                    }
                }
                if (this.isValidValue(defaultValue, expressionType) != null) {
                    defaultValue = null;
                    if ("constant".equals(type)) {
                        this.defaultValueChooser.select(this.defaultValueChooser.indexOf(CHOICE_NO_DEFAULT));
                    } else {
                        this.defaultValueChooser.setText("");
                    }
                } else if (defaultValue == null) {
                    if ("constant".equals(type)) {
                        this.defaultValueChooser.select(this.defaultValueChooser.indexOf(CHOICE_NO_DEFAULT));
                    } else {
                        this.defaultValueChooser.setText("");
                    }
                } else if ("constant".equals(expressionType)) {
                    if (Boolean.valueOf(defaultValue).booleanValue()) {
                        this.defaultValueChooser.select(this.defaultValueChooser.indexOf(BOOLEAN_TRUE));
                    } else {
                        this.defaultValueChooser.select(this.defaultValueChooser.indexOf(BOOLEAN_FALSE));
                    }
                } else {
                    this.defaultValueChooser.setText(defaultValue);
                }
                this.handleDefaultValueModifyEvent();
            } else if ("text-box".equals(controlType)) {
                if (this.getSelectedDataType().equals("string")) {
                    if (expressionType != null) {
                        this.defaultValueChooser.setData("exprType", (Object)expressionType);
                        ExpressionButton button = (ExpressionButton)this.defaultValueChooser.getData("exprButton");
                        if (button != null) {
                            button.refresh();
                        }
                    }
                    this.defaultValueChooser.setText(DEUtil.resolveNull((String)defaultValue));
                } else if (defaultValue != null) {
                    if (defaultValue.equals(Boolean.toString(true)) || defaultValue.equals(Boolean.toString(false))) {
                        defaultValue = null;
                    } else {
                        if (expressionType != null) {
                            this.defaultValueChooser.setData("exprType", (Object)expressionType);
                            ExpressionButton button = (ExpressionButton)this.defaultValueChooser.getData("exprButton");
                            if (button != null) {
                                button.refresh();
                            }
                        }
                        this.defaultValueChooser.setText(defaultValue);
                    }
                }
                this.handleDefaultValueModifyEvent();
            } else if (PARAM_CONTROL_COMBO.equals(controlType) || PARAM_CONTROL_LIST.equals(controlType) || "radio-button".endsWith(controlType)) {
                this.initSorttingArea();
                if (this.lastControlType != null && this.lastControlType.equals("text-box")) {
                    defaultValue = null;
                }
            }
            this.refreshStaticValueTable();
        } else {
            Object button;
            ExpressionHandle columnValue;
            Object button2;
            this.refreshDataSets();
            if (this.inputParameter.getDataSet() != null) {
                this.dataSetChooser.setText(this.inputParameter.getDataSet().getName());
            }
            this.refreshColumns(false);
            this.refreshSortByItems();
            ExpressionHandle columnValueValue = this.inputParameter.getExpressionProperty("valueExpr");
            this.columnChooser.setData("exprType", (Object)(columnValueValue == null || columnValueValue.getType() == null ? UIUtil.getDefaultScriptType() : columnValueValue.getType()));
            String columnName = this.getColumnName((Control)this.columnChooser, this.inputParameter.getValueExpr());
            if (columnName != null) {
                this.columnChooser.setText(columnName);
            }
            if ((button2 = this.columnChooser.getData("exprButton")) instanceof ExpressionButton) {
                ((ExpressionButton)button2).refresh();
            }
            this.displayTextChooser.setData("exprType", (Object)((columnValue = this.inputParameter.getExpressionProperty("labelExpr")) == null || columnValue.getType() == null ? UIUtil.getDefaultScriptType() : columnValue.getType()));
            String columnName2 = this.getColumnName((Control)this.displayTextChooser, this.inputParameter.getLabelExpr());
            if (columnName2 != null) {
                this.displayTextChooser.setText(columnName2);
            }
            if ((button = this.displayTextChooser.getData("exprButton")) instanceof ExpressionButton) {
                ((ExpressionButton)button).refresh();
            }
            if (expressionType != null) {
                this.defaultValueChooser.setData("exprType", (Object)expressionType);
                button2 = (ExpressionButton)this.defaultValueChooser.getData("exprButton");
                if (button2 != null) {
                    ((ExpressionButton)button2).refresh();
                }
            }
            if (this.canUseEmptyValue() && "".equals(defaultValue)) {
                defaultValue = EMPTY_VALUE;
            }
            if (this.getSelectedDataType().equals("string")) {
                this.defaultValueChooser.setText(DEUtil.resolveNull((String)defaultValue));
            } else if (defaultValue != null) {
                this.defaultValueChooser.setText(defaultValue);
            }
            this.handleDefaultValueModifyEvent();
            this.initSorttingArea();
        }
        this.updateMessageLine();
    }

    private Expression getFirstDefaultValue() {
        if (this.defaultValueList != null && this.defaultValueList.size() > 0) {
            return this.defaultValueList.get(0);
        }
        return null;
    }

    private void setFirstDefaultValue(String value, String type) {
        Expression expression;
        if (this.defaultValueList == null) {
            this.defaultValueList = new ArrayList<Expression>();
            this.initDefaultValueViewer();
        }
        if (!this.defaultValueList.contains(expression = new Expression((Object)value, type))) {
            this.defaultValueList.add(0, expression);
        }
        this.updateMessageLine();
        this.updateFormatField();
    }

    private void initSorttingArea() {
        this.refreshSortByItems();
        if (!this.inputParameter.isFixedOrder()) {
            this.sortKeyLabel.setEnabled(true);
            this.sortKeyChooser.setEnabled(true);
            this.sortDirectionLabel.setEnabled(true);
            this.sortDirectionChooser.setEnabled(true);
            this.distinct.setEnabled(true);
            this.distinct.setSelection(!this.inputParameter.distinct());
            boolean isStatic = STATIC_VALUE.equals(this.inputParameter.getValueType());
            boolean isDynamic = "dynamic".equals(this.inputParameter.getValueType());
            if (isStatic) {
                String sortKey = this.inputParameter.getSortBy();
                if (sortKey == null || sortKey.equals("label")) {
                    this.sortKeyChooser.setText(CHOICE_DISPLAY_TEXT);
                } else {
                    this.sortKeyChooser.setText(CHOICE_VALUE_COLUMN);
                }
            } else if (isDynamic) {
                String columnName = this.getColumnName(this.inputParameter.getSortByColumn());
                if (columnName != null && this.sortKeyChooser.indexOf(columnName) >= 0) {
                    this.sortKeyChooser.setText(columnName);
                }
            } else {
                this.sortKeyChooser.select(0);
            }
            String sortDirection = this.inputParameter.getSortDirection();
            if (sortDirection == null || sortDirection.equals("asc")) {
                this.sortDirectionChooser.setText(CHOICE_ASCENDING);
            } else {
                this.sortDirectionChooser.setText(CHOICE_DESCENDING);
            }
        } else {
            this.sortKeyLabel.setEnabled(true);
            this.sortKeyChooser.setEnabled(true);
            this.sortDirectionLabel.setEnabled(false);
            this.sortDirectionChooser.setEnabled(false);
            this.distinct.setEnabled(false);
        }
    }

    private void initFormatField() {
        String type = this.getSelectedDataType();
        if ("decimal".equals(this.lastControlType) && "float".equals(type) || "float".equals(this.lastControlType) && "decimal".equals(type)) {
            return;
        }
        IChoiceSet choiceSet = this.getFormatChoiceSet(type);
        if (choiceSet == null) {
            this.formatPattern = null;
            this.formatCategroy = null;
        } else if (!this.loading || this.inputParameter.getCategory() == null && this.inputParameter.getPattern() == null) {
            if ("string".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("dateTime".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("date".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("time".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("decimal".equals(type) || "float".equals(type) || "integer".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            }
            this.formatPattern = null;
        } else {
            this.formatCategroy = this.inputParameter.getCategory();
            if (this.formatCategroy == null) {
                this.formatCategroy = "Unformatted";
            }
            this.formatPattern = this.inputParameter.getPattern();
            Object formatValue = this.inputParameter.getProperty("format");
            if (formatValue instanceof FormatValue) {
                PropertyHandle propHandle = this.inputParameter.getPropertyHandle("format");
                FormatValue formatValueToSet = (FormatValue)formatValue;
                FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                this.formatLocale = formatHandle.getLocale();
            }
        }
        this.updateFormatField();
    }

    private List getColumnValueList() {
        try {
            if (this.columnChooser.getText() == null || this.columnChooser.getText().equals("")) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString((String)"ParameterDialog.emptyColumnValueExpression.title"), (String)Messages.getString((String)"ParameterDialog.emptyColumnValueExpression.message"));
                this.columnChooser.forceFocus();
                return Collections.EMPTY_LIST;
            }
            ArrayList valueList = new ArrayList();
            valueList.addAll(SelectValueFetcher.getSelectValueList(ExpressionButtonUtil.getExpression((Control)this.columnChooser), this.getDataSetHandle(), DataEngineContext.DataEngineFlowMode.PARAM_EVALUATION_FLOW));
            Collections.sort(valueList);
            return valueList;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return Collections.EMPTY_LIST;
        }
    }

    private void refreshDataSets() {
        String selectedDataSetName = this.dataSetChooser.getText();
        String[] oldList = this.dataSetChooser.getItems();
        ArrayList<String> dataSetList = new ArrayList<String>();
        for (DataSetHandle DataSetHandle2 : this.inputParameter.getModuleHandle().getVisibleDataSets()) {
            dataSetList.add(DataSetHandle2.getQualifiedName());
        }
        Iterator<String> itr = new LinkedDataSetAdapter().getVisibleLinkedDataSets().iterator();
        while (itr.hasNext()) {
            dataSetList.add(itr.next().toString());
        }
        if (this.inputParameter.getDataSet() != null && !dataSetList.contains(this.inputParameter.getDataSet().getName())) {
            dataSetList.add(0, this.inputParameter.getDataSet().getName());
        }
        if (oldList.length != dataSetList.size()) {
            String newName = this.findNewDataSet(Arrays.asList(oldList), dataSetList);
            if (newName != null) {
                selectedDataSetName = newName;
            }
            this.dataSetChooser.setItems(dataSetList.toArray(new String[0]));
            if (StringUtil.isBlank((String)selectedDataSetName)) {
                this.dataSetChooser.select(0);
                this.refreshColumns(false);
            } else if (selectedDataSetName != null && this.dataSetChooser.indexOf(selectedDataSetName) != -1) {
                this.dataSetChooser.select(this.dataSetChooser.indexOf(selectedDataSetName));
                this.refreshColumns(false);
            }
            this.refreshSortByItems();
        }
    }

    private String findNewDataSet(List existingDataSets, List newDataSets) {
        int i = 0;
        while (i < newDataSets.size()) {
            if (!existingDataSets.contains(newDataSets.get(i))) {
                return (String)newDataSets.get(i);
            }
            ++i;
        }
        return null;
    }

    private DataSetHandle getDataSetHandle() {
        return DataUtil.findDataSet(this.dataSetChooser.getText(), this.inputParameter.getModuleHandle());
    }

    private void refreshColumns(boolean onlyFilter) {
        Object button;
        if (this.columnChooser == null || this.columnChooser.isDisposed()) {
            return;
        }
        if (!onlyFilter) {
            DataSetHandle dataSetHandle = this.getDataSetHandle();
            try {
                this.columnList = DataUtil.getColumnList(dataSetHandle);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
            this.displayTextChooser.removeAll();
            this.displayTextChooser.add(NONE_DISPLAY_TEXT);
            Iterator iter = this.columnList.iterator();
            while (iter.hasNext()) {
                this.displayTextChooser.add(((ResultSetColumnHandle)iter.next()).getColumnName());
            }
            button = this.displayTextChooser.getData("exprButton");
            if (button instanceof ExpressionButton && !((ExpressionButton)button).isSupportType("javascript")) {
                this.displayTextChooser.removeAll();
            }
            this.displayTextChooser.setText(NONE_DISPLAY_TEXT);
        }
        String originalSelection = this.columnChooser.getText();
        this.columnChooser.removeAll();
        for (ResultSetColumnHandle cachedColumn : this.columnList) {
            if (!this.matchDataType(cachedColumn)) continue;
            this.columnChooser.add(cachedColumn.getColumnName());
        }
        if (this.columnChooser.indexOf(originalSelection) != -1) {
            this.columnChooser.setText(originalSelection);
        }
        if (this.columnChooser.getItemCount() == 0) {
            this.columnChooser.add("");
        }
        if ((button = this.columnChooser.getData("exprButton")) instanceof ExpressionButton && !((ExpressionButton)button).isSupportType("javascript")) {
            this.columnChooser.removeAll();
        }
        this.updateMessageLine();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchDataType(ResultSetColumnHandle column) {
        if (this.getSelectedDataType().equals("string")) return true;
        if ("any".equals(column.getDataType())) {
            return true;
        }
        int type = DataAdapterUtil.modelDataTypeToCoreDataType((String)this.getSelectedDataType());
        int columnType = DataAdapterUtil.adaptModelDataType((String)column.getDataType());
        try {
            int[] compatibleTypes;
            int[] nArray = compatibleTypes = DataAdapterUtil.getCompatibleDataTypes((int)type);
            int n = compatibleTypes.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                int at = nArray[n2];
                if (columnType == at) {
                    return true;
                }
                ++n2;
            }
        }
        catch (AdapterException adapterException) {}
        return false;
    }

    private String getInputControlType() {
        String type = null;
        type = this.inputParameter.getControlType() == null ? "text-box" : ("list-box".equals(this.inputParameter.getControlType()) ? (this.inputParameter.isMustMatch() ? PARAM_CONTROL_LIST : PARAM_CONTROL_COMBO) : this.inputParameter.getControlType());
        return type;
    }

    private String getSelectedDataType() {
        String type = null;
        if (StringUtil.isBlank((String)this.dataTypeChooser.getText())) {
            type = this.inputParameter.getDataType();
        } else {
            IChoice choice = DATA_TYPE_CHOICE_SET.findChoiceByDisplayName(this.dataTypeChooser.getText());
            type = choice.getName();
        }
        return type;
    }

    private String getSelectedControlType() {
        if (this.controlTypeHelper == null) {
            return this.getInputControlType();
        }
        this.controlTypeHelper.update(false);
        String type = (String)this.controlTypeHelper.getProperty(CONTROLTYPE_VALUE);
        if (type == null) {
            return this.getInputControlType();
        }
        return type;
    }

    private void changeDataType() {
        String type = this.getSelectedDataType();
        if (type.equals(this.lastDataType)) {
            return;
        }
        this.makeUniqueAndValid();
        this.buildControlTypeList(type);
        this.initFormatField();
        if (type.equals("string")) {
            this.clearDefaultValueChooser(this.isRequired.getSelection());
        } else if (!type.equals("boolean")) {
            this.clearDefaultValueText();
            this.clearDefaultValueChooserSelections();
        }
        if (this.isStatic()) {
            this.refreshStaticValueTable();
        } else {
            this.refreshColumns(true);
            this.refreshDynamicValueTable();
        }
        this.lastDataType = type;
        this.updateMessageLine();
    }

    private void buildControlTypeList(String type) {
        this.controlTypeHelper.setProperty(DATATYPE_VALUE, type);
        this.controlTypeHelper.setProperty(STATIC_VALUE, this.isStatic());
        this.controlTypeHelper.setProperty(CONTROLTYPE_INPUTVALUE, this.getInputControlType());
        this.controlTypeHelper.update(true);
    }

    private boolean makeUniqueAndValid() {
        boolean change = false;
        try {
            Iterator<Object> iter;
            HashSet<Object> set = new HashSet<Object>();
            if (this.isStatic() && !this.distinct.isEnabled() || this.distinct.isEnabled() && !this.distinct.getSelection()) {
                if (this.choiceList != null) {
                    iter = this.choiceList.iterator();
                    while (iter.hasNext()) {
                        SelectionChoice choice = (SelectionChoice)iter.next();
                        if (this.isValidValue(choice.getValue()) != null || set.contains(this.validateValue(choice.getValue()))) {
                            if (this.enableAllowMultiValueVisible()) {
                                iter.remove();
                            }
                            change = true;
                            continue;
                        }
                        set.add(this.validateValue(choice.getValue()));
                    }
                }
                set.clear();
            }
            if (this.defaultValueList != null) {
                iter = this.defaultValueList.iterator();
                while (iter.hasNext()) {
                    Expression expression = (Expression)iter.next();
                    if (expression == null) continue;
                    if (this.isValidValue(expression) != null || set.contains(this.validateValue(expression))) {
                        if (this.enableAllowMultiValueVisible()) {
                            iter.remove();
                        }
                        change = true;
                        continue;
                    }
                    set.add(this.validateValue(expression));
                }
            }
        }
        catch (BirtException e) {
            ExceptionHandler.handle(e);
        }
        return change;
    }

    private void changeControlType() {
        String type = this.getSelectedControlType();
        if (this.isStatic() && !type.equals(this.lastControlType)) {
            if ("check-box".equals(type)) {
                this.clearArea(this.valueArea);
                this.switchToCheckBox();
            } else if (PARAM_CONTROL_COMBO.equals(type) || PARAM_CONTROL_LIST.equals(type) || "radio-button".equals(type)) {
                if (!(PARAM_CONTROL_COMBO.equals(this.lastControlType) || PARAM_CONTROL_LIST.equals(this.lastControlType) || "radio-button".equals(this.lastControlType))) {
                    this.clearArea(this.valueArea);
                    this.switchToList();
                }
            } else if ("text-box".equals(type)) {
                this.clearArea(this.valueArea);
                this.switchToText();
            }
            this.valueArea.layout();
            this.initValueArea();
            this.lastControlType = type;
        }
        this.updateCheckBoxArea();
        boolean radioEnable = false;
        if (PARAM_CONTROL_COMBO.equals(this.getSelectedControlType()) || PARAM_CONTROL_LIST.equals(this.getSelectedControlType()) && !"boolean".equals(this.getSelectedDataType())) {
            radioEnable = true;
        }
        if (radioEnable != this.staticRadio.isEnabled()) {
            this.staticRadio.setEnabled(radioEnable);
            this.dynamicRadio.setEnabled(radioEnable);
        }
        if ("auto-suggest".equals(this.getSelectedControlType())) {
            if (!this.dynamicRadio.getSelection()) {
                this.staticRadio.setSelection(false);
                this.dynamicRadio.setSelection(true);
                this.switchParamterType();
            }
            this.hideStartPointSection(false);
            this.listLimit.setEnabled(false);
        } else {
            this.hideStartPointSection(true);
            if (this.isStatic()) {
                this.listLimit.setEnabled(false);
            } else {
                this.listLimit.setEnabled(true);
            }
        }
        if (PARAM_CONTROL_LIST.equals(this.getSelectedControlType()) && this.allowMultiValueVisible) {
            this.allowMultiChoice.setVisible(true);
        } else {
            this.allowMultiChoice.setVisible(false);
        }
        if (this.isInitialized && this.defaultValueList != null && this.defaultValueList.size() > 0) {
            Expression expression = this.getFirstDefaultValue();
            if (!this.enableAllowMultiValueVisible() || !this.allowMultiChoice.getSelection()) {
                this.defaultValueList.clear();
                if (this.isStatic() && (PARAM_CONTROL_COMBO.equals(type) || PARAM_CONTROL_LIST.equals(type) || "radio-button".equals(type))) {
                    this.defaultValueList.add(expression);
                    this.valueTable.refresh();
                } else if (expression != null) {
                    this.defaultValueList.add(expression);
                }
            }
        }
        this.updateMessageLine();
    }

    private void switchParamterType() {
        this.clearArea(this.valueArea);
        this.lastControlType = null;
        if (this.isStatic()) {
            this.switchToStatic();
        } else {
            this.switchToDynamic();
        }
        this.buildControlTypeList(this.getSelectedDataType());
        this.valueArea.layout();
        this.initValueArea();
        this.updateCheckBoxArea();
        Point size = this.displayArea.computeSize(-1, -1);
        this.displayArea.setSize(size);
        this.displayArea.getParent().layout();
    }

    private void switchToCheckBox() {
        this.createLabel(this.valueArea, LABEL_DEFAULT_VALUE);
        Composite composite = new Composite(this.valueArea, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.defaultValueChooser = new CCombo(composite, 2048);
        this.defaultValueChooser.add(CHOICE_NO_DEFAULT);
        this.defaultValueChooser.add(BOOLEAN_TRUE);
        this.defaultValueChooser.add(BOOLEAN_FALSE);
        this.defaultValueChooser.setLayoutData((Object)new GridData(768));
        this.defaultValueChooser.setVisibleItemCount(30);
        this.defaultValueChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String type = (String)ParameterDialog.this.defaultValueChooser.getData("exprType");
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(ParameterDialog.this.defaultValueChooser.getItems()));
                switch (list.indexOf(ParameterDialog.this.defaultValueChooser.getText())) {
                    case 0: {
                        ParameterDialog.this.defaultValueList = null;
                        break;
                    }
                    case 1: {
                        ParameterDialog.this.addDefaultValue("true", type);
                        break;
                    }
                    case 2: {
                        ParameterDialog.this.addDefaultValue("false", type);
                        break;
                    }
                    default: {
                        ParameterDialog.this.addDefaultValue(ParameterDialog.this.defaultValueChooser.getText(), type);
                    }
                }
                ParameterDialog.this.updateMessageLine();
            }
        });
        IExpressionHelper helper = new IExpressionHelper(){

            @Override
            public String getExpression() {
                if (ParameterDialog.this.defaultValueChooser != null) {
                    return ParameterDialog.this.getDefaultValueChooserValue();
                }
                return "";
            }

            @Override
            public void setExpression(String expression) {
                if (ParameterDialog.this.defaultValueChooser != null) {
                    ParameterDialog.this.defaultValueChooser.setText(expression);
                }
            }

            @Override
            public void notifyExpressionChangeEvent(String oldExpression, String newExpression) {
                if (ParameterDialog.this.defaultValueChooser != null) {
                    ParameterDialog.this.defaultValueChooser.setFocus();
                }
            }

            public IExpressionProvider getExpressionProvider() {
                ExpressionProvider provider = new ExpressionProvider((DesignElementHandle)ParameterDialog.this.inputParameter);
                provider.addFilter(new ParameterVariableFilter());
                return provider;
            }

            @Override
            public String getExpressionType() {
                return (String)ParameterDialog.this.defaultValueChooser.getData("exprType");
            }

            @Override
            public void setExpressionType(String exprType) {
                String value = ParameterDialog.this.getDefaultValueChooserValue();
                ParameterDialog.this.defaultValueChooser.setData("exprType", (Object)exprType);
                if ("constant".equals(exprType)) {
                    ParameterDialog.this.defaultValueChooser.setEditable(false);
                    if (ParameterDialog.this.defaultValueChooser.getItemCount() == 0) {
                        ParameterDialog.this.defaultValueChooser.add(CHOICE_NO_DEFAULT);
                        ParameterDialog.this.defaultValueChooser.add(BOOLEAN_TRUE);
                        ParameterDialog.this.defaultValueChooser.add(BOOLEAN_FALSE);
                    }
                } else {
                    if (ParameterDialog.this.defaultValueChooser.getItemCount() != 0) {
                        ParameterDialog.this.defaultValueChooser.remove(CHOICE_NO_DEFAULT);
                        ParameterDialog.this.defaultValueChooser.remove(BOOLEAN_TRUE);
                        ParameterDialog.this.defaultValueChooser.remove(BOOLEAN_FALSE);
                    }
                    ParameterDialog.this.defaultValueChooser.setEditable(true);
                }
                if (value == null || value.trim().length() == 0) {
                    if ("constant".equals(exprType)) {
                        ParameterDialog.this.defaultValueChooser.select(ParameterDialog.this.defaultValueChooser.indexOf(CHOICE_NO_DEFAULT));
                    } else {
                        ParameterDialog.this.defaultValueChooser.setText("");
                    }
                } else if ("constant".equals(exprType)) {
                    if (Boolean.valueOf(value).booleanValue()) {
                        ParameterDialog.this.defaultValueChooser.select(ParameterDialog.this.defaultValueChooser.indexOf(BOOLEAN_TRUE));
                    } else {
                        ParameterDialog.this.defaultValueChooser.select(ParameterDialog.this.defaultValueChooser.indexOf(BOOLEAN_FALSE));
                    }
                } else {
                    ParameterDialog.this.defaultValueChooser.setText(value);
                }
                ParameterDialog.this.defaultValueChooser.notifyListeners(24, new Event());
            }

            @Override
            public Object getContextObject() {
                return ParameterDialog.this.inputParameter;
            }

            @Override
            public IExpressionContextFactory getExpressionContextFactory() {
                return new ExpressionContextFactoryImpl(this.getContextObject(), this.getExpressionProvider());
            }
        };
        ExpressionButton expressionButton = UIUtil.createExpressionButton(composite, 8);
        expressionButton.setExpressionHelper(helper);
        this.defaultValueChooser.setData("exprButton", (Object)expressionButton);
        this.defaultValueChooser.setData("exprType", (Object)"constant");
        expressionButton.refresh();
    }

    private void switchToList() {
        this.createLabel(this.valueArea, LABEL_VALUES);
        Composite tableAreaComposite = new Composite(this.valueArea, 0);
        tableAreaComposite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        tableAreaComposite.setLayoutData((Object)new GridData(1808));
        this.staticTableArea = new TableArea(tableAreaComposite, 67586, this.tableAreaModifier);
        GridData data = new GridData(1808);
        data.heightHint = this.staticTableArea.computeSize((int)-1, (int)-1).y;
        this.staticTableArea.setLayoutData(data);
        Table table = this.staticTableArea.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] stringArray = new String[5];
        stringArray[1] = COLUMN_IS_DEFAULT;
        stringArray[2] = COLUMN_VALUE;
        stringArray[3] = COLUMN_DISPLAY_TEXT;
        stringArray[4] = COLUMN_DISPLAY_TEXT_KEY;
        String[] columns = stringArray;
        int[] columnWidth = new int[]{10, 70, 100, 100, 100};
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 16384);
            column.setResizable(columns[i] != null);
            if (columns[i] != null) {
                column.setText(columns[i]);
            }
            column.setWidth(columnWidth[i]);
            ++i;
        }
        this.valueTable = this.staticTableArea.getTableViewer();
        this.valueTable.setColumnProperties(columns);
        this.valueTable.setContentProvider((IContentProvider)this.contentProvider);
        this.valueTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.staticTableArea.setInput(this.choiceList);
        this.valueTable.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    if (!ParameterDialog.this.allowMultiChoice.getSelection() && ParameterDialog.this.valueTable.getTable().getSelectionCount() > 1) {
                        ParameterDialog.this.valueTable.getTable().deselectAll();
                        ParameterDialog.this.valueTable.getTable().setSelection((TableItem)e.item);
                    }
                    ParameterDialog.this.updateStaticTableButtons();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite buttonBar = new Composite(tableAreaComposite, 0);
        buttonBar.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(4, false));
        buttonBar.setLayoutData((Object)new GridData(768));
        this.importValue = new Button(buttonBar, 8);
        this.importValue.setText(BUTTON_LABEL_IMPORT);
        this.setButtonLayoutData(this.importValue);
        this.importValue.setEnabled(!this.inputParameter.getModuleHandle().getVisibleDataSets().isEmpty() || this.staticRadio.getSelection() && !new LinkedDataSetAdapter().getVisibleLinkedDataSets().isEmpty());
        this.importValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String type = ParameterDialog.this.getSelectedDataType();
                ArrayList<String> choices = new ArrayList<String>();
                HashMap<String, String> labelMap = new HashMap<String, String>();
                for (SelectionChoice choice : ParameterDialog.this.choiceList) {
                    choices.add(choice.getValue());
                    if (choice.getLabel() == null) continue;
                    labelMap.put(choice.getValue(), choice.getLabel());
                }
                ImportValueDialog dialog = new ImportValueDialog(type, choices);
                if (ParameterDialog.this.distinct.isEnabled() && ParameterDialog.this.distinct.getSelection()) {
                    dialog.setDistinct(false);
                } else {
                    dialog.setDistinct(true);
                }
                if (ParameterDialog.this.isRequired.isEnabled() && !ParameterDialog.this.isRequired.getSelection()) {
                    dialog.setRequired(false);
                } else {
                    dialog.setRequired(true);
                }
                dialog.setValidate(new ImportValueDialog.IAddChoiceValidator(){

                    @Override
                    public String validateString(String value) {
                        String errorMessage = ParameterDialog.this.isValidValue(value);
                        if (errorMessage != null) {
                            return errorMessage;
                        }
                        return null;
                    }
                });
                if (dialog.open() == 0) {
                    String[] importValues = (String[])dialog.getResult();
                    ParameterDialog.this.choiceList.clear();
                    int i = 0;
                    while (i < importValues.length) {
                        SelectionChoice choice = StructureFactory.createSelectionChoice();
                        choice.setValue(importValues[i]);
                        if (labelMap.get(importValues[i]) != null) {
                            choice.setLabel((String)labelMap.get(importValues[i]));
                        }
                        ParameterDialog.this.choiceList.add(choice);
                        ++i;
                    }
                    if (ParameterDialog.this.defaultValueList != null) {
                        List<String> importList = Arrays.asList(importValues);
                        Expression[] expressionArray = ParameterDialog.this.defaultValueList.toArray(new Expression[0]);
                        int n = expressionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Expression expression = expressionArray[n2];
                            if (!importList.contains(expression == null ? null : expression.getStringExpression())) {
                                ParameterDialog.this.defaultValueList.remove(expression);
                            }
                            ++n2;
                        }
                    }
                    ParameterDialog.this.refreshStaticValueTable();
                }
            }
        });
        this.changeDefault = new Button(buttonBar, 2);
        this.changeDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionChoice choice = (SelectionChoice)((IStructuredSelection)ParameterDialog.this.valueTable.getSelection()).getFirstElement();
                if (ParameterDialog.this.isDefaultChoice(choice)) {
                    for (Object obj : (IStructuredSelection)ParameterDialog.this.valueTable.getSelection()) {
                        if (!(obj instanceof SelectionChoice)) continue;
                        ParameterDialog.this.removeDefaultValue(((SelectionChoice)obj).getValue());
                    }
                } else {
                    for (Object obj : (IStructuredSelection)ParameterDialog.this.valueTable.getSelection()) {
                        if (!(obj instanceof SelectionChoice)) continue;
                        ParameterDialog.this.addDefaultValue(((SelectionChoice)obj).getValue());
                    }
                }
                ParameterDialog.this.refreshStaticValueTable();
                ParameterDialog.this.changeDefault.getParent().layout();
            }
        });
        int width1 = UIUtil.getStringWidth(BUTTON_LABEL_REMOVE_DEFAULT, (Control)this.changeDefault) + 10;
        int width2 = UIUtil.getStringWidth(BUTTON_LABEL_SET_DEFAULT, (Control)this.changeDefault) + 10;
        int width = width1 >= width2 ? width1 : width2;
        GridData gd = new GridData();
        gd.widthHint = width;
        this.changeDefault.setLayoutData((Object)gd);
        this.createPromptLine(tableAreaComposite);
        this.updateStaticTableButtons();
        this.createSortingArea(this.valueArea);
    }

    private void addDefaultValue(String value) {
        this.addDefaultValue(value, null);
    }

    private void addDefaultValue(String value, String exprType) {
        String type = "constant";
        if (exprType != null) {
            type = exprType;
        }
        if (this.defaultValueList == null) {
            this.defaultValueList = new ArrayList<Expression>();
        } else if (!PARAM_CONTROL_LIST.equals(this.getSelectedControlType()) || !this.allowMultiChoice.getSelection()) {
            this.defaultValueList.clear();
        }
        Expression expression = new Expression((Object)value, type);
        if (!this.defaultValueList.contains(expression)) {
            this.defaultValueList.add(expression);
        }
        this.updateMessageLine();
        this.updateFormatField();
    }

    private void removeDefaultValue(String value) {
        if (this.defaultValueList != null) {
            Expression expression = new Expression((Object)value, "constant");
            this.defaultValueList.remove(expression);
            this.updateMessageLine();
            this.updateFormatField();
        }
    }

    private void changeDefaultValue(String oldVal, String newVal) {
        if (this.defaultValueList != null) {
            Expression expression = new Expression((Object)oldVal, "constant");
            this.defaultValueList.remove(expression);
            expression = new Expression((Object)newVal, "constant");
            if (!this.defaultValueList.contains(expression)) {
                this.defaultValueList.add(expression);
            }
            this.updateMessageLine();
            this.updateFormatField();
        }
    }

    private void switchToText() {
        this.createDefaultEditor();
        this.createLabel(this.valueArea, null);
        this.createPromptLine(this.valueArea);
    }

    private void switchToStatic() {
        this.changeControlType();
        this.listLimit.setEnabled(false);
    }

    private void switchToDynamic() {
        this.changeControlType();
        this.createLabel(this.valueArea, LABEL_SELECT_DATA_SET);
        Composite dataSetArea = this.createExprArea();
        this.dataSetChooser = new Combo(dataSetArea, 2056);
        this.dataSetChooser.setLayoutData((Object)new GridData(768));
        this.dataSetChooser.setVisibleItemCount(30);
        this.dataSetChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ParameterDialog.this.refreshColumns(false);
                ParameterDialog.this.refreshSortByItems();
            }

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.refreshColumns(false);
                ParameterDialog.this.refreshSortByItems();
            }
        });
        this.createDataSet = new Button(dataSetArea, 8);
        this.createDataSet.setText(BUTTON_CREATE_DATA_SET);
        this.setButtonLayoutData(this.createDataSet);
        this.createDataSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataService.getInstance().createDataSet();
                ParameterDialog.this.refreshDataSets();
            }
        });
        this.createLabel(this.valueArea, LABEL_SELECT_VALUE_COLUMN);
        Composite columnArea = this.createExprArea();
        this.columnChooser = new Combo(columnArea, 2052);
        this.columnChooser.setLayoutData((Object)new GridData(768));
        this.columnChooser.setVisibleItemCount(30);
        this.columnChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDialog.this.updateMessageLine();
            }
        });
        ExpressionButtonUtil.ExpressionHelper columnHelper = new ExpressionButtonUtil.ExpressionHelper(){

            @Override
            public String getExpression() {
                return ParameterDialog.this.getExpression((Control)ParameterDialog.this.columnChooser, ParameterDialog.this.columnChooser.getText());
            }

            @Override
            public void setExpression(String expression) {
                ParameterDialog.this.setExpression(ParameterDialog.this.columnChooser, expression);
            }

            public IExpressionProvider getExpressionProvider() {
                ParameterDataSetExpressionProvider provider = new ParameterDataSetExpressionProvider((DesignElementHandle)ParameterDialog.this.inputParameter);
                provider.addFilter(new ParameterVariableFilter());
                return provider;
            }

            @Override
            public IExpressionContextFactory getExpressionContextFactory() {
                HashMap<String, Object> extras = new HashMap<String, Object>();
                DataSetHandle dataSetHandle = ParameterDialog.this.inputParameter.getModuleHandle().findDataSet(ParameterDialog.this.dataSetChooser.getText());
                extras.put(ExpressionProvider.DATASETS, dataSetHandle);
                return new ExpressionContextFactoryImpl(this.getContextObject(), this.getExpressionProvider(), extras);
            }
        };
        ExpressionButtonUtil.createExpressionButton(columnArea, (Control)this.columnChooser, null, this.inputParameter, null, false, 8, columnHelper);
        this.createLabel(this.valueArea, LABEL_SELECT_DISPLAY_TEXT);
        Composite displayArea = this.createExprArea();
        this.displayTextChooser = new Combo(displayArea, 2052);
        this.displayTextChooser.setLayoutData((Object)new GridData(768));
        this.displayTextChooser.setVisibleItemCount(30);
        ExpressionButtonUtil.ExpressionHelper displayTextHelper = new ExpressionButtonUtil.ExpressionHelper(){

            @Override
            public String getExpression() {
                return ParameterDialog.this.getExpression((Control)ParameterDialog.this.displayTextChooser, ParameterDialog.this.displayTextChooser.getText());
            }

            @Override
            public void setExpression(String expression) {
                ParameterDialog.this.setExpression(ParameterDialog.this.displayTextChooser, expression);
            }

            public IExpressionProvider getExpressionProvider() {
                ParameterExpressionProvider provider = new ParameterExpressionProvider((DesignElementHandle)ParameterDialog.this.inputParameter, ParameterDialog.this.dataSetChooser.getText());
                provider.addFilter(new ParameterVariableFilter());
                return provider;
            }

            @Override
            public IExpressionContextFactory getExpressionContextFactory() {
                HashMap<String, Object> extras = new HashMap<String, Object>();
                DataSetHandle dataSetHandle = ParameterDialog.this.inputParameter.getModuleHandle().findDataSet(ParameterDialog.this.dataSetChooser.getText());
                extras.put(ExpressionProvider.DATASETS, dataSetHandle);
                return new ExpressionContextFactoryImpl(this.getContextObject(), this.getExpressionProvider(), extras);
            }
        };
        ExpressionButtonUtil.createExpressionButton(displayArea, (Control)this.displayTextChooser, null, this.inputParameter, null, false, 8, displayTextHelper);
        this.createDefaultEditor();
        this.createSortingArea(this.valueArea);
        this.createLabel(this.valueArea, null);
        this.createPromptLine(this.valueArea);
        this.listLimit.setEnabled(true);
    }

    private Composite createExprArea() {
        Composite exprArea = new Composite(this.valueArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        exprArea.setLayout((Layout)layout);
        exprArea.setLayoutData((Object)new GridData(768));
        return exprArea;
    }

    private void refreshSortByItems() {
        if (this.sortKeyChooser == null || this.sortKeyChooser.isDisposed()) {
            return;
        }
        this.sortKeyChooser.removeAll();
        this.sortKeyChooser.add(NONE_DISPLAY_TEXT);
        if (this.staticRadio.getSelection()) {
            this.sortKeyChooser.add(CHOICE_DISPLAY_TEXT);
            this.sortKeyChooser.add(CHOICE_VALUE_COLUMN);
        } else if (this.dynamicRadio.getSelection()) {
            Iterator iter = this.columnList.iterator();
            while (iter.hasNext()) {
                this.sortKeyChooser.add(((ResultSetColumnHandle)iter.next()).getColumnName());
            }
        }
        this.sortKeyChooser.setText(NONE_DISPLAY_TEXT);
    }

    private void createSortingArea(Composite parent) {
        this.sorttingArea = new Composite(parent, 0);
        GridData sorttingAreaGridData = new GridData(776);
        sorttingAreaGridData.horizontalSpan = 2;
        this.sorttingArea.setLayoutData((Object)sorttingAreaGridData);
        this.sorttingArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(1, false));
        Group sortGroup = new Group(this.sorttingArea, 0);
        sortGroup.setText(LABEL_SORT_GROUP);
        sortGroup.setLayout((Layout)new GridLayout(2, false));
        sortGroup.setLayoutData((Object)new GridData(768));
        Composite sortKeyArea = new Composite((Composite)sortGroup, 0);
        sortKeyArea.setLayoutData((Object)new GridData(768));
        sortKeyArea.setLayout((Layout)new GridLayout(2, false));
        this.sortKeyLabel = new Label(sortKeyArea, 0);
        this.sortKeyLabel.setText(LABEL_SORT_KEY);
        this.sortKeyChooser = new Combo(sortKeyArea, 2056);
        this.sortKeyChooser.setLayoutData((Object)new GridData(768));
        this.sortKeyChooser.setVisibleItemCount(30);
        this.sortKeyChooser.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!((Combo)e.widget).getText().equals(NONE_DISPLAY_TEXT)) {
                    ParameterDialog.this.sortDirectionLabel.setEnabled(true);
                    ParameterDialog.this.sortDirectionChooser.setEnabled(true);
                } else {
                    ParameterDialog.this.sortDirectionLabel.setEnabled(false);
                    ParameterDialog.this.sortDirectionChooser.setEnabled(false);
                }
            }
        });
        Composite sortDirectionArea = new Composite((Composite)sortGroup, 0);
        sortDirectionArea.setLayoutData((Object)new GridData(768));
        sortDirectionArea.setLayout((Layout)new GridLayout(2, false));
        this.sortDirectionLabel = new Label(sortDirectionArea, 0);
        this.sortDirectionLabel.setText(LABEL_SORT_DIRECTION);
        this.sortDirectionChooser = new Combo(sortDirectionArea, 2056);
        this.sortDirectionChooser.setLayoutData((Object)new GridData(768));
        this.sortDirectionChooser.setVisibleItemCount(30);
        this.sortDirectionChooser.add(CHOICE_ASCENDING);
        this.sortDirectionChooser.add(CHOICE_DESCENDING);
        this.sortDirectionChooser.setText(CHOICE_ASCENDING);
    }

    private void createMulitipleValueListComposite(Composite parent) {
        int tableStyle = 68356;
        Table table = new Table(parent, tableStyle);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = 100;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        String[] columNames = new String[]{Messages.getString((String)"FilterConditionBuilder.list.item1")};
        int[] columLength = new int[]{288};
        int i = 0;
        while (i < columNames.length) {
            TableColumn column = new TableColumn(table, 0, i);
            column.setText(columNames[i]);
            column.setWidth(columLength[i]);
            ++i;
        }
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.updateDynamicTableButtons();
            }
        });
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    ParameterDialog.this.delTableValue();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ParameterDialog.this.editTableValue();
            }
        });
        this.defaultValueViewer = new TableViewer(table);
        this.defaultValueViewer.setUseHashlookup(true);
        this.defaultValueViewer.setColumnProperties(columNames);
        this.defaultValueViewer.setLabelProvider((IBaseLabelProvider)this.tableLableProvier);
        this.defaultValueViewer.setContentProvider((IContentProvider)this.tableContentProvider);
        this.rightPart = new Composite(parent, 0);
        data = new GridData(1040);
        this.rightPart.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.rightPart.setLayout((Layout)layout);
        this.editBtn = new Button(this.rightPart, 8);
        this.editBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.edit"));
        this.editBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.edit.tooltip"));
        this.setButtonLayoutData(this.editBtn);
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.editTableValue();
            }
        });
        this.delBtn = new Button(this.rightPart, 8);
        this.delBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.delete"));
        this.delBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.delete.tooltip"));
        this.setButtonLayoutData(this.delBtn);
        this.delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.delTableValue();
            }
        });
        this.delAllBtn = new Button(this.rightPart, 8);
        this.delAllBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.deleteall"));
        this.delAllBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.deleteall.tooltip"));
        this.setButtonLayoutData(this.delAllBtn);
        GridData gd = (GridData)this.delAllBtn.getLayoutData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 1;
        this.delAllBtn.setLayoutData((Object)gd);
        this.delAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int count = ParameterDialog.this.defaultValueList.size();
                if (count > 0) {
                    ParameterDialog.this.defaultValueList.clear();
                    ParameterDialog.this.defaultValueViewer.refresh();
                    ParameterDialog.this.updateDynamicTableButtons();
                } else {
                    ParameterDialog.this.delAllBtn.setEnabled(false);
                }
            }
        });
    }

    protected void delTableValue() {
        int index = this.defaultValueViewer.getTable().getSelectionIndex();
        if (index > -1 && this.defaultValueList != null) {
            this.defaultValueList.remove(index);
            this.defaultValueViewer.refresh();
            if (this.defaultValueList.size() > 0) {
                if (this.defaultValueList.size() <= index) {
                    --index;
                }
                this.defaultValueViewer.getTable().select(index);
            }
            this.updateDynamicTableButtons();
        } else {
            if (this.defaultValueList == null) {
                this.defaultValueViewer.getTable().removeAll();
                this.updateDynamicTableButtons();
            }
            this.delBtn.setEnabled(false);
        }
    }

    protected void editTableValue() {
        IStructuredSelection selection = (IStructuredSelection)this.defaultValueViewer.getSelection();
        if (selection.getFirstElement() != null && selection.getFirstElement() instanceof Expression) {
            Expression expression = (Expression)selection.getFirstElement();
            ExpressionProvider provider = new ExpressionProvider((DesignElementHandle)this.inputParameter);
            ExpressionEditor editor = new ExpressionEditor(Messages.getString((String)"ParameterDialog.ExpressionEditor.Title"));
            editor.setInput(this.inputParameter, provider, true);
            editor.setExpression(expression);
            if (editor.open() == 0) {
                Expression value = editor.getExpression();
                if (DEUtil.resolveNull((String)value.getStringExpression()).length() == 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"MapRuleBuilderDialog.MsgDlg.Title"), (String)Messages.getString((String)"MapRuleBuilderDialog.MsgDlg.Msg"));
                    return;
                }
                int index = this.defaultValueViewer.getTable().getSelectionIndex();
                this.defaultValueList.remove(index);
                this.defaultValueList.add(index, value);
                this.defaultValueViewer.refresh();
                this.defaultValueViewer.getTable().select(index);
            }
            this.updateDynamicTableButtons();
        } else {
            this.editBtn.setEnabled(false);
        }
    }

    private void clearDefaultValueText() {
        if (this.defaultValueChooser == null || this.defaultValueChooser.isDisposed()) {
            return;
        }
        String textValue = this.defaultValueChooser.getText();
        if (textValue != null && (textValue.trim().length() == 0 || textValue.trim().equals(EMPTY_VALUE))) {
            this.defaultValueChooser.setText("");
        }
    }

    private void clearDefaultValueChooserSelections() {
        if (this.defaultValueChooser == null || this.defaultValueChooser.isDisposed()) {
            return;
        }
        if (this.defaultValueChooser.getItemCount() > 1) {
            String text = this.defaultValueChooser.getText();
            this.defaultValueChooser.removeAll();
            if (!this.isStatic()) {
                this.defaultValueChooser.add(EMPTY_VALUE);
                this.defaultValueChooser.add(CHOICE_SELECT_VALUE);
            }
            if (this.canUseEmptyValue()) {
                this.defaultValueChooser.setText(text);
            } else if (!EMPTY_VALUE.equals(text) && !NULL_VALUE.equals(text)) {
                this.defaultValueChooser.setText(text);
            }
        }
    }

    private void createDefaultEditor() {
        Label label = this.createLabel(this.valueArea, LABEL_DEFAULT_VALUE);
        GridData gd = (GridData)label.getLayoutData();
        gd.verticalAlignment = 1;
        label.setLayoutData((Object)gd);
        Composite composite = new Composite(this.valueArea, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.defaultValueChooser = new CCombo(composite, 2048);
        this.defaultValueChooser.setLayoutData((Object)new GridData(768));
        this.defaultValueChooser.setVisibleItemCount(30);
        if (!this.isStatic()) {
            this.defaultValueChooser.add(EMPTY_VALUE);
            this.defaultValueChooser.add(CHOICE_SELECT_VALUE);
        }
        this.defaultValueChooser.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String selection = e.text;
                if (ParameterDialog.this.defaultValueChooser.indexOf(selection) == -1) {
                    e.doit = true;
                    return;
                }
                e.doit = !selection.equals(CHOICE_SELECT_VALUE);
            }
        });
        this.defaultValueChooser.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!ParameterDialog.this.isStatic()) {
                    if (ParameterDialog.this.canUseEmptyValue()) {
                        if (ParameterDialog.this.defaultValueChooser.indexOf(EMPTY_VALUE) != -1) {
                            ParameterDialog.this.defaultValueChooser.remove(EMPTY_VALUE);
                        }
                        ParameterDialog.this.defaultValueChooser.add(EMPTY_VALUE);
                    } else if (ParameterDialog.this.defaultValueChooser.indexOf(EMPTY_VALUE) != -1) {
                        ParameterDialog.this.defaultValueChooser.remove(EMPTY_VALUE);
                    }
                }
            }
        });
        this.defaultValueChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ParameterDialog.this.defaultValueChooser.getSelectionIndex() == -1) {
                    return;
                }
                String selection = ParameterDialog.this.defaultValueChooser.getItem(ParameterDialog.this.defaultValueChooser.getSelectionIndex());
                if (selection.equals(CHOICE_SELECT_VALUE)) {
                    String[] selectedValues;
                    List columnValueList = ParameterDialog.this.getColumnValueList();
                    if (columnValueList.isEmpty()) {
                        return;
                    }
                    SelectParameterDefaultValueDialog dialog = new SelectParameterDefaultValueDialog(Display.getCurrent().getActiveShell(), Messages.getString((String)"SelectParameterDefaultValueDialog.Title"));
                    dialog.setColumnValueList(columnValueList, ParameterDialog.this.getSelectedDataType());
                    int status = dialog.open();
                    if (status == 0 && (selectedValues = dialog.getSelectedValue()) != null) {
                        int i = 0;
                        while (i < selectedValues.length) {
                            String value;
                            String selectedValue = selectedValues[i];
                            IExpressionConverter exprConverter = ExpressionUtility.getExpressionConverter((String)ParameterDialog.this.defaultValueChooser.getData("exprType"));
                            if (exprConverter != null) {
                                selectedValue = exprConverter.getConstantExpression(selectedValue, ParameterDialog.this.getSelectedDataType());
                            }
                            if ((value = DEUtil.resolveNull((String)selectedValue)).equals("")) {
                                ParameterDialog.this.defaultValueChooser.setText(EMPTY_VALUE);
                            } else {
                                ParameterDialog.this.defaultValueChooser.setText(value);
                            }
                            ParameterDialog.this.addDynamicDefaultValue();
                            ++i;
                        }
                    }
                } else if (ParameterDialog.this.isStatic()) {
                    ParameterDialog.this.refreshStaticValueTable();
                } else {
                    ParameterDialog.this.addDynamicDefaultValue();
                }
            }
        });
        this.defaultValueChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDialog.this.handleDefaultValueModifyEvent();
            }
        });
        IExpressionHelper helper = new IExpressionHelper(){

            @Override
            public String getExpression() {
                if (ParameterDialog.this.defaultValueChooser != null) {
                    return ParameterDialog.this.defaultValueChooser.getText();
                }
                return "";
            }

            @Override
            public void setExpression(String expression) {
                if (ParameterDialog.this.defaultValueChooser != null) {
                    ParameterDialog.this.defaultValueChooser.setText(expression);
                }
            }

            @Override
            public void notifyExpressionChangeEvent(String oldExpression, String newExpression) {
                if (ParameterDialog.this.defaultValueChooser != null) {
                    ParameterDialog.this.defaultValueChooser.setFocus();
                }
                if (newExpression != null && newExpression.trim().length() > 0 && !newExpression.equals(oldExpression)) {
                    ParameterDialog.this.addDynamicDefaultValue();
                    ParameterDialog.this.updateDynamicTableButtons();
                }
            }

            public IExpressionProvider getExpressionProvider() {
                ExpressionProvider provider = new ExpressionProvider((DesignElementHandle)ParameterDialog.this.inputParameter);
                provider.addFilter(new ParameterVariableFilter());
                return provider;
            }

            @Override
            public String getExpressionType() {
                return (String)ParameterDialog.this.defaultValueChooser.getData("exprType");
            }

            @Override
            public void setExpressionType(String exprType) {
                ParameterDialog.this.defaultValueChooser.setData("exprType", (Object)exprType);
                ParameterDialog.this.defaultValueChooser.notifyListeners(24, new Event());
            }

            @Override
            public Object getContextObject() {
                return ParameterDialog.this.inputParameter;
            }

            @Override
            public IExpressionContextFactory getExpressionContextFactory() {
                return new ExpressionContextFactoryImpl(ParameterDialog.this.inputParameter, this.getExpressionProvider());
            }
        };
        ExpressionButton expressionButton = UIUtil.createExpressionButton(composite, 8);
        expressionButton.setExpressionHelper(helper);
        this.defaultValueChooser.setData("exprButton", (Object)expressionButton);
        this.defaultValueChooser.setData("exprType", (Object)"constant");
        expressionButton.refresh();
        this.addButton = new Button(composite, 8);
        this.addButton.setText(Messages.getString((String)"ParameterDialog.DefaultValue.Add"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.addDynamicDefaultValue();
                ParameterDialog.this.updateDynamicTableButtons();
            }
        });
        this.createMulitipleValueListComposite(composite);
        this.initDefaultValueViewer();
    }

    private void createPromptLine(Composite parent) {
        this.promptMessageLine = new Label(parent, 0);
        this.promptMessageLine.setLayoutData((Object)new GridData(768));
    }

    private Object validateValue(String value) throws BirtException {
        return this.validateValue(value, null);
    }

    private Object validateValue(Expression expression) throws BirtException {
        if (expression == null) {
            return this.validateValue(null, null);
        }
        return this.validateValue(expression.getStringExpression(), expression.getType());
    }

    private Object validateValue(String value, String type) throws BirtException {
        String tempdefaultValue = value;
        String exprType = "constant";
        if (type != null) {
            exprType = type;
        }
        if (!"string".endsWith(this.getSelectedDataType()) && !"boolean".endsWith(this.getSelectedDataType())) {
            if ("constant".equals(exprType)) {
                if ("dateTime".equals(this.getSelectedDataType())) {
                    tempdefaultValue = ParameterUtil.convertToStandardFormat(DataTypeUtil.toDate((Object)tempdefaultValue));
                } else if ("date".equals(this.getSelectedDataType())) {
                    tempdefaultValue = ParameterUtil.convertToStandardFormat(DataTypeUtil.toSqlDate((Object)tempdefaultValue));
                } else if ("time".equals(this.getSelectedDataType())) {
                    tempdefaultValue = ParameterUtil.convertToStandardFormat(DataTypeUtil.toSqlTime((Object)tempdefaultValue));
                }
                return ParameterValidationUtil.validate((String)this.getSelectedDataType(), (String)"MM/dd/yyyy hh:mm:ss a", (String)tempdefaultValue, (ULocale)ULocale.getDefault());
            }
            return tempdefaultValue;
        }
        if ("boolean".equals(this.getSelectedDataType())) {
            if (tempdefaultValue != null && tempdefaultValue.equals(CHOICE_NO_DEFAULT)) {
                return DataTypeUtil.toBoolean(null);
            }
            if ("constant".equals(exprType)) {
                return DataTypeUtil.toBoolean((Object)tempdefaultValue);
            }
            return tempdefaultValue;
        }
        return tempdefaultValue;
    }

    private void validateValueList(List<Expression> values) throws BirtException {
        if (values != null) {
            for (Expression value : values) {
                this.validateValue(value);
            }
        }
    }

    protected void okPressed() {
        try {
            this.validateValueList(this.defaultValueList);
        }
        catch (BirtException e1) {
            ExceptionHandler.handle(e1);
            return;
        }
        try {
            this.inputParameter.setName(this.nameEditor.getText());
            this.inputParameter.setPromptText(UIUtil.convertToModelString(this.promptTextEditor.getText(), true));
            this.inputParameter.setParamType("simple");
            String newControlType = this.getSelectedControlType();
            if (PARAM_CONTROL_COMBO.equals(newControlType)) {
                newControlType = "list-box";
                this.inputParameter.setMustMatch(false);
            } else if (PARAM_CONTROL_LIST.equals(newControlType)) {
                newControlType = "list-box";
                this.inputParameter.setMustMatch(true);
                if (this.allowMultiChoice.isVisible() && this.allowMultiChoice.getSelection()) {
                    this.inputParameter.setParamType("multi-value");
                }
            } else {
                this.inputParameter.setProperty("mustMatch", null);
            }
            this.inputParameter.setControlType(newControlType);
            if (!this.isStatic() || "text-box".equals(newControlType) || "check-box".equals(newControlType)) {
                this.inputParameter.setDefaultValueList(this.defaultValueList);
            } else if (this.isStatic()) {
                boolean flag = false;
                int i = 0;
                while (this.defaultValueList != null && i < this.defaultValueList.size()) {
                    Expression expr = this.defaultValueList.get(i);
                    String value = null;
                    if (expr != null) {
                        value = expr.getStringExpression();
                    }
                    if (this.choiceList != null) {
                        for (SelectionChoice choice : this.choiceList) {
                            if (!this.isEqual(choice.getValue(), value)) continue;
                            flag = true;
                        }
                    }
                    if (!flag) {
                        this.defaultValueList.remove(i);
                        --i;
                    }
                    ++i;
                }
                if (flag) {
                    this.inputParameter.setDefaultValueList(this.defaultValueList);
                } else {
                    this.inputParameter.setDefaultValueList(null);
                }
            } else {
                this.inputParameter.setDefaultValueList(null);
            }
            this.inputParameter.setDataType(DATA_TYPE_CHOICE_SET.findChoiceByDisplayName(this.dataTypeChooser.getText()).getName());
            PropertyHandle selectionChioceList = this.inputParameter.getPropertyHandle("selectionList");
            selectionChioceList.setValue(new ArrayList());
            if (this.isStatic()) {
                this.inputParameter.setValueType(STATIC_VALUE);
                if (!"text-box".equals(newControlType) && !"check-box".equals(newControlType) && this.choiceList != null) {
                    SelectionChoice originalChoice = null;
                    for (SelectionChoice choice : this.choiceList) {
                        originalChoice = this.editChoiceMap.get(choice);
                        if (originalChoice != null) {
                            originalChoice.setValue(choice.getValue());
                            originalChoice.setLabel(choice.getLabel());
                            originalChoice.setLabelResourceKey(choice.getLabelResourceKey());
                            choice = originalChoice;
                        }
                        if (this.isValidValue(choice.getValue()) != null) continue;
                        selectionChioceList.addItem((IStructure)choice);
                    }
                }
                this.inputParameter.setDataSet(null);
                this.inputParameter.setValueExpr(null);
                this.inputParameter.setLabelExpr(null);
            } else {
                this.inputParameter.setValueType("dynamic");
                this.inputParameter.setDataSet(DataUtil.findDataSet(this.dataSetChooser.getText()));
                Expression expression = new Expression((Object)this.getExpression((Control)this.columnChooser, this.columnChooser.getText()), (String)this.columnChooser.getData("exprType"));
                this.inputParameter.setExpressionProperty("valueExpr", expression);
                if (this.displayTextChooser.getText().equals(LABEL_NULL)) {
                    this.inputParameter.setLabelExpr("");
                } else {
                    expression = new Expression((Object)this.getExpression((Control)this.displayTextChooser, this.displayTextChooser.getText()), (String)this.displayTextChooser.getData("exprType"));
                    this.inputParameter.setExpressionProperty("labelExpr", expression);
                }
                if (this.startPointTypeHelper != null && this.startPointTypeHelper.getControl() != null && this.startPointTypeHelper.getControl().isVisible()) {
                    this.startPointTypeHelper.update(false);
                    this.inputParameter.setAutoSuggestThreshold(((Integer)this.startPointTypeHelper.getProperty(STARTPOINT_VALUE)).intValue());
                }
            }
            this.inputParameter.setHelpText(UIUtil.convertToModelString(this.helpTextEditor.getText(), false));
            this.inputParameter.setCategory(this.formatCategroy);
            this.inputParameter.setPattern(this.formatPattern);
            Object value = this.inputParameter.getProperty("format");
            if (value instanceof FormatValue) {
                PropertyHandle propHandle = this.inputParameter.getPropertyHandle("format");
                FormatValue formatValueToSet = (FormatValue)value;
                FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                formatHandle.setLocale(this.formatLocale);
            }
            if (this.dirtyProperties.containsKey(CHECKBOX_HIDDEN)) {
                this.inputParameter.setHidden(this.getProperty(CHECKBOX_HIDDEN));
            }
            if (this.dirtyProperties.containsKey(CHECKBOX_ISREQUIRED)) {
                this.inputParameter.setIsRequired(this.getProperty(CHECKBOX_ISREQUIRED));
            }
            if (this.doNotEcho.isEnabled()) {
                if (this.dirtyProperties.containsKey(CHECKBOX_DO_NOT_ECHO)) {
                    this.inputParameter.setConcealValue(this.getProperty(CHECKBOX_DO_NOT_ECHO));
                }
            } else {
                this.inputParameter.setProperty("concealValue", null);
            }
            if (this.distinct.isEnabled()) {
                this.inputParameter.setDistinct(!this.distinct.getSelection());
            } else {
                this.inputParameter.setDistinct(true);
            }
            if (this.sorttingArea != null && !this.sorttingArea.isDisposed() && this.sorttingArea.isVisible()) {
                if (this.sortKeyChooser.getText().equals(NONE_DISPLAY_TEXT)) {
                    this.inputParameter.setFixedOrder(true);
                    this.inputParameter.setSortBy(null);
                    this.inputParameter.setSortDirection(null);
                    this.inputParameter.setSortByColumn(null);
                } else {
                    if (this.isStatic()) {
                        this.inputParameter.setFixedOrder(false);
                        if (this.sortKeyChooser.getText().equals(CHOICE_DISPLAY_TEXT)) {
                            this.inputParameter.setSortBy("label");
                        } else if (this.sortKeyChooser.getText().equals(CHOICE_VALUE_COLUMN)) {
                            this.inputParameter.setSortBy("value");
                        }
                        this.inputParameter.setSortByColumn(null);
                    } else if (this.dynamicRadio.getSelection()) {
                        this.inputParameter.setSortBy(null);
                        this.inputParameter.setFixedOrder(false);
                        this.inputParameter.setSortByColumn(this.getExpression(this.sortKeyChooser.getText()));
                    }
                    if (this.sortDirectionChooser.getText().equals(CHOICE_ASCENDING)) {
                        this.inputParameter.setSortDirection("asc");
                    } else if (this.sortDirectionChooser.getText().equals(CHOICE_DESCENDING)) {
                        this.inputParameter.setSortDirection("desc");
                    }
                }
            } else {
                this.inputParameter.setProperty("fixedOrder", null);
            }
            if (!(this.isStatic() || StringUtil.isBlank((String)this.listLimit.getText()) || "auto-suggest".equals(this.getSelectedControlType()))) {
                try {
                    this.inputParameter.setListlimit(Integer.parseInt(this.listLimit.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    ExceptionHandler.openErrorMessageBox(ERROR_TITLE_INVALID_LIST_LIMIT, MessageFormat.format(ERROR_MSG_INVALID_LIST_LIMIT, Integer.toString(Integer.MAX_VALUE)));
                }
            } else {
                this.inputParameter.setProperty("listLimit", null);
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return;
        }
        this.setResult(this.inputParameter);
        super.okPressed();
    }

    private Label createLabel(Composite parent, String content) {
        Label label = new Label(parent, 0);
        if (content != null) {
            label.setText(content);
        }
        this.setLabelLayoutData(label);
        return label;
    }

    private void setLabelLayoutData(Label label) {
        GridData gd = new GridData();
        if (label.getText().equals(LABEL_VALUES)) {
            gd.verticalAlignment = 1;
        }
        label.setLayoutData((Object)gd);
    }

    private void addCheckBoxListener(final Button checkBox, final String key) {
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.checkBoxChange(checkBox, key);
            }
        });
    }

    protected void checkBoxChange(Button checkBox, String key) {
        this.dirtyProperties.put(key, checkBox.getSelection());
        if (CHECKBOX_ISREQUIRED.equals(key) || CHECKBOX_DISTINCT.equals(key)) {
            boolean change;
            if ((this.isStatic() && !this.distinct.isEnabled() || this.distinct.isEnabled() && !this.distinct.getSelection()) && (change = this.makeUniqueAndValid())) {
                if (this.isStatic()) {
                    this.refreshStaticValueTable();
                } else {
                    this.refreshDynamicValueTable();
                }
            }
            if (this.getSelectedDataType().equals("string")) {
                this.clearDefaultValueChooser(checkBox.getSelection());
            }
            this.handleDefaultValueModifyEvent();
            this.updateMessageLine();
        }
    }

    private void clearDefaultValueChooser(boolean isChecked) {
        if (isChecked) {
            this.clearDefaultValueText();
            this.clearDefaultValueChooserSelections();
        } else if (this.defaultValueChooser == null || this.defaultValueChooser.isDisposed() || this.defaultValueChooser.getItemCount() > 1) {
            return;
        }
    }

    private void clearArea(Composite area) {
        Control[] children = area.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }

    private void updateDynamicTableButtons() {
        StructuredSelection selection = (StructuredSelection)this.defaultValueViewer.getSelection();
        boolean enable = selection.size() == 1;
        this.editBtn.setEnabled(enable);
        this.delBtn.setEnabled(!selection.isEmpty());
        this.delAllBtn.setEnabled(this.defaultValueViewer.getTable().getItemCount() > 0);
        String type = (String)this.defaultValueChooser.getData("exprType");
        String value = UIUtil.convertToModelString(this.defaultValueChooser.getText(), false);
        if (value != null) {
            if (value.equals(EMPTY_VALUE)) {
                value = "";
            } else if (value.equals(NULL_VALUE)) {
                value = null;
            }
        }
        Expression expression = null;
        if (value != null) {
            expression = new Expression((Object)value, type);
        }
        if (this.defaultValueChooser.getText().trim().length() == 0) {
            this.addButton.setEnabled(false);
        } else if (this.defaultValueList != null && this.defaultValueList.contains(expression)) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
        this.updateMessageLine();
    }

    private void updateStaticTableButtons() {
        boolean isDefault;
        this.staticTableArea.updateButtons();
        boolean isEnable = true;
        SelectionChoice selectedChoice = null;
        if (this.valueTable.getSelection().isEmpty()) {
            isEnable = false;
        } else if (((IStructuredSelection)this.valueTable.getSelection()).size() > 1) {
            selectedChoice = (SelectionChoice)((IStructuredSelection)this.valueTable.getSelection()).getFirstElement();
            boolean firstIsDefault = this.isDefaultChoice(selectedChoice);
            for (Object obj : (IStructuredSelection)this.valueTable.getSelection()) {
                if (!(obj instanceof SelectionChoice) || !(firstIsDefault ^ this.isDefaultChoice((SelectionChoice)obj))) continue;
                isEnable = false;
                break;
            }
        } else {
            selectedChoice = (SelectionChoice)((IStructuredSelection)this.valueTable.getSelection()).getFirstElement();
            String value = selectedChoice.getValue();
            try {
                this.validateValue(value);
            }
            catch (BirtException birtException) {
                isEnable = false;
            }
            if (value == null) {
                isEnable = false;
            }
        }
        boolean bl = isDefault = isEnable && this.isDefaultChoice(selectedChoice);
        if (isDefault) {
            this.changeDefault.setText(BUTTON_LABEL_REMOVE_DEFAULT);
        } else {
            this.changeDefault.setText(BUTTON_LABEL_SET_DEFAULT);
        }
        this.changeDefault.setSelection(isDefault);
        this.changeDefault.setEnabled(isEnable);
        this.updateMessageLine();
    }

    @Override
    protected void updateButtons() {
        boolean canFinish;
        boolean bl = canFinish = !StringUtil.isBlank((String)this.nameEditor.getText());
        if (canFinish && this.columnChooser != null && !this.columnChooser.isDisposed() && !this.isStatic()) {
            String expression = this.getExpression((Control)this.columnChooser, this.columnChooser.getText());
            canFinish = canFinish && expression != null && expression.length() > 0;
        }
        this.getOkButton().setEnabled(canFinish);
        super.updateButtons();
    }

    private void updateCheckBoxArea() {
        if ("text-box".equals(this.getSelectedControlType()) || "auto-suggest".equals(this.getSelectedControlType())) {
            if (!"auto-suggest".equals(this.getSelectedControlType())) {
                this.doNotEcho.setEnabled(true);
            } else {
                this.doNotEcho.setEnabled(false);
            }
            this.distinct.setEnabled(false);
        } else {
            this.doNotEcho.setEnabled(false);
            this.distinct.setEnabled(true);
        }
    }

    private void updateMessageLine() {
        String errorMessage = this.validateName();
        if (errorMessage == null && !this.isStatic() && this.columnChooser != null && !this.columnChooser.isDisposed()) {
            if (this.columnChooser.getItemCount() == 0) {
                errorMessage = ERROR_MSG_NO_AVAILABLE_COLUMN;
            } else if (this.columnChooser.getText().trim().length() == 0) {
                errorMessage = ERROR_MSG_VALUE_COLUMN_EMPTY;
            }
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        } else {
            this.setErrorMessage(null);
        }
        if (this.promptMessageLine != null && !this.promptMessageLine.isDisposed()) {
            if ("dateTime".equals(this.getSelectedDataType())) {
                this.promptMessageLine.setText(LABEL_DATETIME_PROMPT);
            } else if ("date".equals(this.getSelectedDataType())) {
                this.promptMessageLine.setText(LABEL_DATE_PROMPT);
            } else if ("time".equals(this.getSelectedDataType())) {
                this.promptMessageLine.setText(LABEL_TIME_PROMPT);
            } else {
                this.promptMessageLine.setText("");
            }
        }
        this.updateButtons();
    }

    private String validateName() {
        String name = this.nameEditor.getText().trim();
        if (name.length() == 0) {
            return ERROR_MSG_NAME_IS_EMPTY;
        }
        if (!name.equals(this.inputParameter.getName()) && this.inputParameter.getModuleHandle().findParameter(name) != null) {
            return ERROR_MSG_DUPLICATED_NAME;
        }
        try {
            this.validateValueList(this.defaultValueList);
        }
        catch (BirtException birtException) {
            return ERROR_MSG_MISMATCH_DATA_TYPE;
        }
        return null;
    }

    private String getDefaultValueChooserValue() {
        String defaultValue;
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(this.defaultValueChooser.getItems()));
        switch (list.indexOf(this.defaultValueChooser.getText())) {
            case 0: {
                defaultValue = null;
                break;
            }
            case 1: {
                defaultValue = "true";
                break;
            }
            case 2: {
                defaultValue = "false";
                break;
            }
            default: {
                defaultValue = this.defaultValueChooser.getText();
            }
        }
        return defaultValue;
    }

    private void refreshStaticValueTable() {
        if (this.valueTable != null && !this.valueTable.getTable().isDisposed()) {
            this.valueTable.refresh();
            this.updateStaticTableButtons();
        }
    }

    private void refreshDynamicValueTable() {
        if (this.defaultValueViewer != null && !this.defaultValueViewer.getTable().isDisposed()) {
            this.defaultValueViewer.refresh();
            this.updateDynamicTableButtons();
        }
    }

    private boolean getProperty(String key) {
        return (Boolean)this.dirtyProperties.get(key);
    }

    private String isValidValue(String value) {
        return this.isValidValue(value, null);
    }

    private String isValidValue(Expression expression) {
        if (expression == null) {
            return this.isValidValue(null, null);
        }
        return this.isValidValue(expression.getStringExpression(), expression.getType());
    }

    private String isValidValue(String value, String exprType) {
        if (this.canBeNull()) {
            if (value == null || value.length() == 0) {
                return null;
            }
        } else if (value == null || value.length() == 0) {
            return ERROR_MSG_CANNOT_BE_NULL;
        }
        if (this.canBeBlank()) {
            if (StringUtil.isBlank((String)value)) {
                return null;
            }
        } else if (StringUtil.isBlank((String)value)) {
            return ERROR_MSG_CANNOT_BE_BLANK;
        }
        try {
            this.validateValue(value, exprType);
        }
        catch (BirtException birtException) {
            return ERROR_MSG_MISMATCH_DATA_TYPE;
        }
        return null;
    }

    private boolean isEqual(String value1, String value2) {
        Object v1 = null;
        Object v2 = null;
        if (value1 == null && value2 != null || value1 != null && value2 == null) {
            return false;
        }
        try {
            v1 = this.validateValue(value1);
            v2 = this.validateValue(value2);
        }
        catch (BirtException birtException) {
            return false;
        }
        if (v1 == null) {
            return v2 == null;
        }
        if (v1 instanceof Double && v2 instanceof Double) {
            return ((Double)v1).compareTo((Double)v2) == 0;
        }
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo((BigDecimal)v2) == 0;
        }
        if (v1 instanceof Integer && v2 instanceof Integer) {
            return ((Integer)v1).compareTo((Integer)v2) == 0;
        }
        return v1.equals(v2);
    }

    private IChoiceSet getFormatChoiceSet(String type) {
        IChoiceSet choiceSet = null;
        if ("string".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("stringFormat");
        } else if ("dateTime".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("dateTimeFormat");
        } else if ("date".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("dateFormat");
        } else if ("time".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("timeFormat");
        } else if ("decimal".equals(type) || "float".equals(type) || "integer".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("numberFormat");
        }
        return choiceSet;
    }

    private void updateFormatField() {
        String previewString;
        String displayFormat;
        String exprType;
        ULocale locale = this.formatLocale;
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        String type = this.getSelectedDataType();
        IChoiceSet choiceSet = this.getFormatChoiceSet(type);
        Expression expression = this.getFirstDefaultValue();
        String defaultValue = expression == null ? null : expression.getStringExpression();
        String string = exprType = expression == null ? "constant" : expression.getType();
        if (defaultValue != null) {
            defaultValue = defaultValue.trim();
        }
        if ("javascript".equals(exprType)) {
            defaultValue = null;
        }
        if (choiceSet == null) {
            displayFormat = DEUtil.getMetaDataDictionary().getChoiceSet("stringFormat").findChoice("Unformatted").getDisplayName();
            previewString = "True";
        } else {
            if (this.formatCategroy == null || choiceSet.findChoice(this.formatCategroy) == null) {
                return;
            }
            if (choiceSet.findChoice(this.formatCategroy) == null) {
                return;
            }
            displayFormat = choiceSet.findChoice(this.formatCategroy).getDisplayName();
            if (ParameterUtil.isCustomCategory(this.formatCategroy)) {
                displayFormat = String.valueOf(displayFormat) + ": " + this.formatPattern;
            }
            if (type.equals("dateTime")) {
                previewString = new DateFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) ? this.formatPattern : (this.formatCategroy.equals("Unformatted") ? "DateTimeUnformatted" : this.formatCategroy), locale).format(new Date());
            } else if (type.equals("date")) {
                previewString = new DateFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) ? this.formatPattern : (this.formatCategroy.equals("Unformatted") ? "DateUnformatted" : this.formatCategroy), locale).format(new Date());
            } else if (type.equals("time")) {
                previewString = new DateFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) ? this.formatPattern : (this.formatCategroy.equals("Unformatted") ? "TimeUnformatted" : this.formatCategroy), locale).format(new Date());
            } else if (type.equals("string")) {
                previewString = new StringFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) ? this.formatPattern : this.formatCategroy, locale).format(defaultValue == null ? Messages.getString((String)"FormatStringPage.default.preview.text") : defaultValue);
            } else if (type.equals("integer")) {
                int intValue = 123456;
                if (defaultValue != null) {
                    try {
                        intValue = Integer.parseInt(defaultValue);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                previewString = new NumberFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) || this.isNumberFormat(this.formatCategroy) ? this.formatPattern : this.formatCategroy, locale).format((long)intValue);
            } else if (type.equals("decimal") || type.equals("float")) {
                double doulbeValue = 1234.56;
                if (defaultValue != null) {
                    try {
                        doulbeValue = Double.parseDouble(defaultValue);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                String realformatPattern = ParameterUtil.isCustomCategory(this.formatCategroy) || this.isNumberFormat(this.formatCategroy) ? this.formatPattern : this.formatCategroy;
                NumberFormatter tempFormater = new NumberFormatter(realformatPattern, locale);
                previewString = tempFormater.format(doulbeValue);
                if (Double.isInfinite(doulbeValue)) {
                    BigDecimal tempDecimal = new BigDecimal(defaultValue);
                    previewString = realformatPattern == null ? tempDecimal.toString() : tempFormater.format(tempDecimal);
                }
            } else {
                previewString = new NumberFormatter(ParameterUtil.isCustomCategory(this.formatCategroy) ? this.formatPattern : this.formatCategroy, locale).format(1234.56);
            }
        }
        this.formatField.setText(displayFormat);
        this.previewLabel.setText(this.convertNullString(previewString));
        this.changeFormat.setEnabled(choiceSet != null);
    }

    private boolean isNumberFormat(String formatCatogory) {
        return formatCatogory.equals("Unformatted") || formatCatogory.equals("General Number") || formatCatogory.equals("Currency") || formatCatogory.equals("Fixed") || formatCatogory.equals("Percent") || formatCatogory.equals("Scientific");
    }

    private String convertNullString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    private boolean containValue(SelectionChoice selectedChoice, String newValue, String property) {
        for (SelectionChoice choice : this.choiceList) {
            if (choice == selectedChoice) continue;
            String value = null;
            if (COLUMN_VALUE.equals(property) && this.isEqual(value = choice.getValue(), newValue)) {
                return true;
            }
            if (COLUMN_DISPLAY_TEXT_KEY.equals(property)) {
                value = choice.getLabelResourceKey();
                if (value == null) {
                    value = choice.getValue();
                }
                if (value == null) {
                    value = LABEL_NULL;
                }
                if (value.equals(newValue)) {
                    return true;
                }
            }
            if (!COLUMN_DISPLAY_TEXT.equals(property)) continue;
            value = choice.getLabel();
            if (value == null) {
                value = choice.getValue();
            }
            if (value == null) {
                value = LABEL_NULL;
            }
            if (!value.equals(newValue)) continue;
            return true;
        }
        return false;
    }

    private void popupFormatBuilder(boolean refresh) {
        String dataType = this.getSelectedDataType();
        if ("boolean".equals(dataType)) {
            return;
        }
        int formatType = "string".equals(dataType) ? 1 : ("dateTime".equals(dataType) ? 3 : ("date".equals(dataType) ? 4 : ("time".equals(dataType) ? 5 : 2)));
        FormatBuilder formatBuilder = new FormatBuilder(formatType);
        formatBuilder.setInputFormat(this.formatCategroy, this.formatPattern, this.formatLocale);
        String previewText = null;
        if (this.getFirstDefaultValue() != null) {
            previewText = this.getFirstDefaultValue().getStringExpression();
        }
        if (previewText != null) {
            formatBuilder.setPreviewText(previewText);
        }
        if (formatBuilder.open() == 0) {
            this.formatCategroy = (String)((Object[])formatBuilder.getResult())[0];
            this.formatPattern = (String)((Object[])formatBuilder.getResult())[1];
            this.formatLocale = (ULocale)((Object[])formatBuilder.getResult())[2];
            this.updateFormatField();
            if (refresh) {
                this.refreshStaticValueTable();
            }
        }
    }

    private boolean canBeBlank() {
        boolean canBeBlank = false;
        canBeBlank = this.dirtyProperties.containsKey(CHECKBOX_ISREQUIRED) ? (Boolean)this.dirtyProperties.get(CHECKBOX_ISREQUIRED) == false : !this.inputParameter.isRequired();
        return canBeBlank;
    }

    private boolean canBeNull() {
        boolean canBeNull = true;
        canBeNull = this.dirtyProperties.containsKey(CHECKBOX_ISREQUIRED) ? (Boolean)this.dirtyProperties.get(CHECKBOX_ISREQUIRED) == false : !this.inputParameter.isRequired();
        return canBeNull;
    }

    private boolean isDefaultChoice(SelectionChoice choice) {
        String choiceValue = choice.getValue();
        if (this.canBeNull() && choiceValue == null && this.defaultValueList != null) {
            if (this.defaultValueList.contains(null)) {
                return true;
            }
            if (this.defaultValueList.contains(new Expression(null, "constant"))) {
                return true;
            }
        }
        return choiceValue != null && this.defaultValueList != null && this.defaultValueList.contains(new Expression((Object)choiceValue, "constant"));
    }

    private boolean isStatic() {
        return this.staticRadio.getSelection();
    }

    private String getExpression(String columnName) {
        if (columnName.equals(NONE_DISPLAY_TEXT)) {
            return null;
        }
        for (ResultSetColumnHandle cachedColumn : this.columnList) {
            if (!cachedColumn.getColumnName().equals(columnName)) continue;
            return DEUtil.getExpression((Object)cachedColumn);
        }
        return columnName;
    }

    private String getExpression(Control control, String columnName) {
        if (columnName.equals(NONE_DISPLAY_TEXT)) {
            return null;
        }
        if (this.columnList == null) {
            return null;
        }
        for (ResultSetColumnHandle cachedColumn : this.columnList) {
            if (!cachedColumn.getColumnName().equals(columnName)) continue;
            IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter(control);
            return ExpressionUtility.getExpression(cachedColumn, converter);
        }
        return columnName;
    }

    private String getColumnName(String expression) {
        for (ResultSetColumnHandle cachedColumn : this.columnList) {
            if (!DEUtil.getExpression((Object)cachedColumn).equals(expression)) continue;
            return cachedColumn.getColumnName();
        }
        return expression;
    }

    private String getColumnName(Control control, String expression) {
        IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter(control);
        for (ResultSetColumnHandle cachedColumn : this.columnList) {
            if (!ExpressionUtility.getExpression(cachedColumn, converter).equals(expression)) continue;
            return cachedColumn.getColumnName();
        }
        return expression;
    }

    private String validateChoice(SelectionChoice choice, String displayLabelKey, String displayLabel, String value) {
        String errorMessage = this.isValidValue(value);
        if (errorMessage != null) {
            return errorMessage;
        }
        if (this.distinct.isEnabled() && this.distinct.getSelection()) {
            if (this.containValue(choice, displayLabelKey, COLUMN_DISPLAY_TEXT_KEY)) {
                return ERROR_MSG_DUPLICATED_LABELKEY;
            }
            return null;
        }
        if (this.containValue(choice, value, COLUMN_VALUE)) {
            return ERROR_MSG_DUPLICATED_VALUE;
        }
        if (displayLabel == null && this.containValue(choice, value, COLUMN_DISPLAY_TEXT) || this.containValue(choice, displayLabel, COLUMN_DISPLAY_TEXT)) {
            return ERROR_MSG_DUPLICATED_LABEL;
        }
        if (this.containValue(choice, displayLabelKey, COLUMN_DISPLAY_TEXT_KEY)) {
            return ERROR_MSG_DUPLICATED_LABELKEY;
        }
        return null;
    }

    private void setExpression(Combo chooser, String key) {
        chooser.deselectAll();
        key = StringUtil.trimString((String)key);
        if (StringUtil.isBlank((String)key)) {
            chooser.setText("");
            return;
        }
        IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)chooser);
        int i = 0;
        while (i < this.columnList.size()) {
            if (key.equals(ExpressionUtility.getExpression(this.columnList.get(i), converter))) {
                chooser.setText(((ResultSetColumnHandle)this.columnList.get(i)).getColumnName());
                return;
            }
            ++i;
        }
        chooser.setText(key);
    }

    private void handleControlTypeSelectionEvent() {
        this.controlTypeHelper.update(false);
        String type = this.getSelectedControlType();
        if ("check-box".equals(type) || "text-box".equals(type) || "radio-button".equals(type)) {
            this.staticRadio.setSelection(true);
            this.dynamicRadio.setSelection(false);
            this.staticRadio.setEnabled(false);
            this.dynamicRadio.setEnabled(false);
            this.switchParamterType();
        } else if (PARAM_CONTROL_LIST.equals(type) && "boolean".equals(this.getSelectedDataType())) {
            this.staticRadio.setSelection(false);
            this.dynamicRadio.setSelection(true);
            this.staticRadio.setEnabled(false);
            this.dynamicRadio.setEnabled(false);
            this.switchParamterType();
        }
        this.changeControlType();
        Point size = this.displayArea.computeSize(-1, -1);
        this.displayArea.setSize(size);
        this.displayArea.getParent().layout();
    }

    private void initDefaultValueViewer() {
        if (this.defaultValueViewer != null && !this.defaultValueViewer.getTable().isDisposed()) {
            if (!this.isStatic() && this.enableAllowMultiValueVisible()) {
                WidgetUtil.setExcludeGridData((Control)this.defaultValueViewer.getTable(), !this.allowMultiChoice.getSelection());
                WidgetUtil.setExcludeGridData((Control)this.rightPart, !this.allowMultiChoice.getSelection());
                WidgetUtil.setExcludeGridData((Control)this.addButton, !this.allowMultiChoice.getSelection());
                if (this.allowMultiChoice.getSelection()) {
                    this.defaultValueViewer.setInput(this.defaultValueList);
                    this.updateDynamicTableButtons();
                }
            } else {
                WidgetUtil.setExcludeGridData((Control)this.defaultValueViewer.getTable(), true);
                WidgetUtil.setExcludeGridData((Control)this.rightPart, true);
                WidgetUtil.setExcludeGridData((Control)this.addButton, true);
            }
            this.addButton.getParent().layout();
            this.defaultValueViewer.getTable().getParent().layout();
            this.valueArea.layout();
            Point size = this.displayArea.computeSize(-1, -1);
            this.displayArea.setSize(size);
            this.displayArea.getParent().layout();
        }
    }

    private boolean enableAllowMultiValueVisible() {
        return PARAM_CONTROL_LIST.endsWith(this.getSelectedControlType()) && this.allowMultiValueVisible;
    }

    private void addDynamicDefaultValue() {
        if (!this.isStatic() && this.enableAllowMultiValueVisible() && this.allowMultiChoice.getSelection()) {
            String type = (String)this.defaultValueChooser.getData("exprType");
            String value = UIUtil.convertToModelString(this.defaultValueChooser.getText(), false);
            if (value.equals(EMPTY_VALUE)) {
                value = "";
            } else if (value.equals(NULL_VALUE)) {
                value = null;
            }
            this.setFirstDefaultValue(value, type);
            this.refreshDynamicValueTable();
            this.defaultValueChooser.setFocus();
            this.defaultValueChooser.setText("");
        }
    }

    private boolean canUseEmptyValue() {
        return this.canBeNull() && "string".equals(this.getSelectedDataType());
    }

    private void handleDefaultValueModifyEvent() {
        if (this.defaultValueChooser == null || this.defaultValueChooser.isDisposed()) {
            return;
        }
        if (!this.isStatic() && this.enableAllowMultiValueVisible() && this.allowMultiChoice.getSelection()) {
            this.updateDynamicTableButtons();
            return;
        }
        String value = this.defaultValueChooser.getText();
        String type = (String)this.defaultValueChooser.getData("exprType");
        if (!this.isStatic()) {
            if (value.equals(EMPTY_VALUE)) {
                value = "";
            } else if (value.equals(NULL_VALUE) || value.equals("")) {
                value = null;
            }
        }
        if (this.defaultValueList != null) {
            this.defaultValueList.clear();
        }
        if ("".equals(value) && this.canUseEmptyValue()) {
            this.setFirstDefaultValue(value, type);
        } else {
            String modelValue = UIUtil.convertToModelString(value, false);
            if (modelValue != null) {
                this.setFirstDefaultValue(modelValue, type);
            } else {
                this.updateMessageLine();
                this.updateFormatField();
            }
        }
        if (this.isStatic()) {
            this.refreshStaticValueTable();
        }
    }

    private class ParameterDataSetExpressionProvider
    extends ExpressionProvider {
        public ParameterDataSetExpressionProvider(DesignElementHandle handle) {
            super(handle);
        }

        protected List getCategoryList() {
            ArrayList categoryList = (ArrayList)super.getCategoryList();
            if (categoryList != null && !categoryList.contains(DATASETS) && this.elementHandle.getModuleHandle() instanceof ReportDesignHandle && ((ReportDesignHandle)this.elementHandle.getModuleHandle()).getDataSets() != null) {
                if (categoryList.contains(OPERATORS)) {
                    categoryList.add(categoryList.indexOf(OPERATORS) + 1, DATASETS);
                } else {
                    categoryList.add(DATASETS);
                }
            }
            return categoryList;
        }
    }

    private static class ParameterVariableFilter
    extends ExpressionFilter {
        private ParameterVariableFilter() {
        }

        @Override
        public boolean select(Object parentElement, Object element) {
            return parentElement == null || element == null || !(parentElement instanceof String) || !(element instanceof String) || !"Category".equals(parentElement) || !ExpressionProvider.VARIABLES.equals(element);
        }
    }
}

