/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Vector;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.IntegerSpinControl;
import org.eclipse.birt.chart.ui.swt.composites.LineStyleChooserComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class GanttLineAttributesComposite
extends Composite
implements SelectionListener,
Listener {
    private transient Composite cmpContent = null;
    private transient Label lblStyle = null;
    private transient Label lblWidth = null;
    private transient Label lblColor = null;
    private transient LineStyleChooserComposite cmbStyle = null;
    private transient IntegerSpinControl iscWidth = null;
    private transient FillChooserComposite cmbColor = null;
    private transient Button cbVisible = null;
    private transient LineAttributes laCurrent = null;
    private transient boolean bEnableWidths = true;
    private transient boolean bEnableStyles = true;
    private transient boolean bEnableVisibility = true;
    private transient Vector vListeners = null;
    public static final int STYLE_CHANGED_EVENT = 1;
    public static final int WIDTH_CHANGED_EVENT = 2;
    public static final int COLOR_CHANGED_EVENT = 3;
    public static final int VISIBILITY_CHANGED_EVENT = 4;
    private transient boolean bEnabled = true;
    private transient boolean bEnableColor = true;
    private transient ChartWizardContext context;

    public GanttLineAttributesComposite(Composite parent, ChartWizardContext context, int style, LineAttributes laCurrent, boolean bEnableWidths, boolean bEnableStyles, boolean bEnableVisibility) {
        super(parent, style);
        this.context = context;
        this.laCurrent = laCurrent;
        if (laCurrent == null) {
            this.laCurrent = AttributeFactory.eINSTANCE.createLineAttributes();
        }
        this.bEnableStyles = bEnableStyles;
        this.bEnableWidths = bEnableWidths;
        this.bEnableVisibility = bEnableVisibility;
        this.init();
        this.placeComponents();
    }

    public GanttLineAttributesComposite(Composite parent, int style, LineAttributes laCurrent, boolean bEnableWidths, boolean bEnableStyles, boolean bEnableVisibility, boolean bEnableColor) {
        super(parent, style);
        this.laCurrent = laCurrent;
        if (laCurrent == null) {
            this.laCurrent = AttributeFactory.eINSTANCE.createLineAttributes();
        }
        this.bEnableStyles = bEnableStyles;
        this.bEnableWidths = bEnableWidths;
        this.bEnableVisibility = bEnableVisibility;
        this.bEnableColor = bEnableColor;
        this.init();
        this.placeComponents();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.vListeners = new Vector();
    }

    private void placeComponents() {
        FillLayout flMain = new FillLayout();
        flMain.marginHeight = 0;
        flMain.marginWidth = 0;
        GridLayout glContent = new GridLayout();
        glContent.verticalSpacing = 5;
        glContent.horizontalSpacing = 5;
        glContent.marginHeight = 4;
        glContent.marginWidth = 4;
        glContent.numColumns = 6;
        this.setLayout((Layout)flMain);
        this.cmpContent = new Composite((Composite)this, 0);
        this.cmpContent.setLayout((Layout)glContent);
        boolean bEnableUI = this.bEnabled = this.laCurrent.isVisible();
        if (this.bEnableVisibility) {
            this.cbVisible = new Button(this.cmpContent, 32);
            GridData gdCBVisible = new GridData(768);
            gdCBVisible.horizontalSpan = 6;
            this.cbVisible.setLayoutData((Object)gdCBVisible);
            this.cbVisible.setText(Messages.getString("LineAttributesComposite.Lbl.IsVisible"));
            this.cbVisible.setSelection(this.laCurrent.isVisible());
            this.cbVisible.addSelectionListener((SelectionListener)this);
            if (this.bEnabled) {
                bEnableUI = this.cbVisible.getSelection();
            }
        }
        if (this.bEnableStyles) {
            this.lblStyle = new Label(this.cmpContent, 0);
            GridData gdLStyle = new GridData(32);
            this.lblStyle.setLayoutData((Object)gdLStyle);
            this.lblStyle.setText(Messages.getString("LineAttributesComposite.Lbl.Style"));
            this.lblStyle.setEnabled(bEnableUI);
            this.cmbStyle = new LineStyleChooserComposite(this.cmpContent, 12, this.getSWTLineStyle(this.laCurrent.getStyle()));
            GridData gdCBStyle = new GridData(768);
            gdCBStyle.horizontalSpan = 5;
            this.cmbStyle.setLayoutData(gdCBStyle);
            this.cmbStyle.addListener(1, this);
            this.cmbStyle.setEnabled(bEnableUI);
        }
        if (this.bEnableWidths) {
            this.lblWidth = new Label(this.cmpContent, 0);
            GridData gdLWidth = new GridData(32);
            this.lblWidth.setLayoutData((Object)gdLWidth);
            this.lblWidth.setText(Messages.getString("LineAttributesComposite.Lbl.Width"));
            this.lblWidth.setEnabled(bEnableUI);
            this.iscWidth = new IntegerSpinControl(this.cmpContent, 0, this.laCurrent.getThickness());
            GridData gdISCWidth = new GridData(768);
            gdISCWidth.horizontalSpan = 5;
            this.iscWidth.setLayoutData(gdISCWidth);
            this.iscWidth.setMinimum(1);
            this.iscWidth.setMaximum(100);
            this.iscWidth.addListener(this);
            this.iscWidth.setEnabled(bEnableUI);
        }
        if (this.bEnableColor) {
            this.lblColor = new Label(this.cmpContent, 0);
            GridData gdLColor = new GridData(32);
            this.lblColor.setLayoutData((Object)gdLColor);
            this.lblColor.setText(Messages.getString("LineAttributesComposite.Lbl.Color"));
            this.lblColor.setEnabled(bEnableUI);
            this.cmbColor = new FillChooserComposite(this.cmpContent, 12, this.context, (Fill)this.laCurrent.getColor(), false, false);
            GridData gdCBColor = new GridData(768);
            gdCBColor.horizontalSpan = 5;
            this.cmbColor.setLayoutData(gdCBColor);
            this.cmbColor.addListener(this);
            this.cmbColor.setEnabled(bEnableUI);
        }
    }

    public Point getPreferredSize() {
        Point ptSize = new Point(250, 40);
        if (this.bEnableVisibility) {
            ptSize.y += 30;
        }
        if (this.bEnableStyles) {
            ptSize.y += 30;
        }
        if (this.bEnableWidths) {
            ptSize.y += 30;
        }
        return ptSize;
    }

    public void setEnabled(boolean bState) {
        boolean bEnableUI = true;
        if (this.bEnableVisibility) {
            this.cbVisible.setEnabled(bState);
            bEnableUI = this.cbVisible.getSelection();
        }
        if (this.bEnableStyles) {
            this.lblStyle.setEnabled(bState & bEnableUI);
            this.cmbStyle.setEnabled(bState & bEnableUI);
        }
        if (this.bEnableWidths) {
            this.lblWidth.setEnabled(bState & bEnableUI);
            this.iscWidth.setEnabled(bState & bEnableUI);
        }
        if (this.bEnableColor) {
            this.lblColor.setEnabled(bState & bEnableUI);
            this.cmbColor.setEnabled(bState & bEnableUI);
        }
        this.bEnabled = bState;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    public void setLineAttributes(LineAttributes attributes) {
        this.laCurrent = attributes;
        if (this.bEnableVisibility) {
            if (this.laCurrent == null) {
                this.cbVisible.setSelection(false);
            } else {
                this.cbVisible.setSelection(attributes.isVisible());
            }
            boolean bUIEnabled = this.cbVisible.getSelection();
            if (this.bEnableStyles) {
                this.cmbStyle.setEnabled(bUIEnabled);
                this.lblStyle.setEnabled(bUIEnabled);
            }
            if (this.bEnableWidths) {
                this.iscWidth.setEnabled(bUIEnabled);
                this.lblWidth.setEnabled(bUIEnabled);
            }
            if (this.bEnableColor) {
                this.cmbColor.setEnabled(bUIEnabled);
                this.lblColor.setEnabled(bUIEnabled);
            }
        }
        if (this.bEnableStyles) {
            if (this.laCurrent == null) {
                this.cmbStyle.setLineStyle(this.getSWTLineStyle(LineStyle.SOLID_LITERAL));
            } else {
                this.cmbStyle.setLineStyle(this.getSWTLineStyle(attributes.getStyle()));
            }
        }
        if (this.bEnableWidths) {
            if (this.laCurrent == null) {
                this.iscWidth.setValue(1);
            } else {
                this.iscWidth.setValue(attributes.getThickness());
            }
        }
        if (this.bEnableColor) {
            if (this.laCurrent == null) {
                this.cmbColor.setFill(null);
            } else {
                this.cmbColor.setFill((Fill)attributes.getColor());
            }
            this.cmbColor.redraw();
        }
        this.redraw();
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (oSource.equals(this.cbVisible)) {
            this.fireValueChangedEvent(4, new Boolean(this.cbVisible.getSelection()));
            if (this.isDisposed()) {
                return;
            }
            boolean bEnableUI = this.cbVisible.getSelection();
            if (this.bEnableStyles) {
                this.lblStyle.setEnabled(bEnableUI);
                this.cmbStyle.setEnabled(bEnableUI);
            }
            if (this.bEnableWidths) {
                this.lblWidth.setEnabled(bEnableUI);
                this.iscWidth.setEnabled(bEnableUI);
            }
            if (this.bEnableColor) {
                this.lblColor.setEnabled(bEnableUI);
                this.cmbColor.setEnabled(bEnableUI);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void fireValueChangedEvent(int iEventType, Object data) {
        int iL = 0;
        while (iL < this.vListeners.size()) {
            Event se = new Event();
            se.widget = this;
            se.data = data;
            se.type = iEventType;
            ((Listener)this.vListeners.get(iL)).handleEvent(se);
            ++iL;
        }
    }

    private LineStyle getModelLineStyle(int iStyle) {
        switch (iStyle) {
            case 1: {
                return LineStyle.SOLID_LITERAL;
            }
            case 2: {
                return LineStyle.DASHED_LITERAL;
            }
            case 4: {
                return LineStyle.DASH_DOTTED_LITERAL;
            }
            case 3: {
                return LineStyle.DOTTED_LITERAL;
            }
        }
        return null;
    }

    private int getSWTLineStyle(LineStyle style) {
        if (style.equals(LineStyle.DASHED_LITERAL)) {
            return 2;
        }
        if (style.equals(LineStyle.DASH_DOTTED_LITERAL)) {
            return 4;
        }
        if (style.equals(LineStyle.DOTTED_LITERAL)) {
            return 3;
        }
        return 1;
    }

    public void handleEvent(Event event) {
        if (this.cmbColor != null && ((Object)((Object)this.cmbColor)).equals(event.widget)) {
            this.fireValueChangedEvent(3, this.cmbColor.getFill());
        } else if (this.cmbStyle != null && ((Object)((Object)this.cmbStyle)).equals(event.widget)) {
            this.fireValueChangedEvent(1, this.getModelLineStyle(this.cmbStyle.getLineStyle()));
        } else if (this.iscWidth != null && ((Object)((Object)this.iscWidth)).equals(event.widget)) {
            this.fireValueChangedEvent(2, new Integer(this.iscWidth.getValue()));
        }
    }
}

