/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import java.util.ArrayList;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.DefaultSeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.series.GanttDataDefinitionComponent;
import org.eclipse.birt.chart.ui.swt.series.GanttSeriesAttributeComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.YOptionalDataDefinitionComponent;
import org.eclipse.swt.widgets.Composite;

public class GanttSeriesUIProvider
extends DefaultSeriesUIProvider {
    private static final String SERIES_CLASS = "org.eclipse.birt.chart.model.type.impl.GanttSeriesImpl";

    public Composite getSeriesAttributeSheet(Composite parent, Series series, ChartWizardContext context) {
        return new GanttSeriesAttributeComposite(parent, 0, context, series);
    }

    public String getSeriesClass() {
        return SERIES_CLASS;
    }

    public ISelectDataComponent getSeriesDataComponent(int seriesType, SeriesDefinition seriesDefn, ChartWizardContext context, String sTitle) {
        if (seriesType == 1) {
            return new GanttDataDefinitionComponent(seriesDefn, context, sTitle);
        }
        if (seriesType == 2) {
            YOptionalDataDefinitionComponent ddc = new YOptionalDataDefinitionComponent(1, "optional", seriesDefn, seriesDefn.getQuery(), context, sTitle);
            return ddc;
        }
        return new DefaultSelectDataComponent();
    }

    public AxisType[] getCompatibleAxisType(Series series) {
        return new AxisType[]{AxisType.DATE_TIME_LITERAL};
    }

    public void validateSeriesBindingType(Series series, IDataServiceProvider idsp) throws ChartException {
        ArrayList al = new ArrayList();
        al.addAll(series.getDataDefinition());
        int i = 0;
        while (i < al.size()) {
            Query query = (Query)al.get(i);
            DataType dataType = idsp.getDataType(query.getDefinition());
            if (i != 2 && (dataType == DataType.TEXT_LITERAL || dataType == DataType.NUMERIC_LITERAL)) {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 19, query.getDefinition());
            }
            ++i;
        }
    }

    public int[] validationIndex(Series series) {
        int[] nArray = new int[2];
        nArray[1] = 1;
        return nArray;
    }
}

