/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis;

import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.GridAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

public class AxisGridLinesSheet
extends AbstractPopupSheet
implements SelectionListener,
Listener {
    private Composite cmpContent;
    private Composite cmpGeneral = null;
    private FillChooserComposite fccLine = null;
    private Label cmbOrientation = null;
    private Button cbHidden = null;
    private Button cbTickBetweenCategory = null;
    private Group grpMajor = null;
    private Group grpMinor = null;
    private GridAttributesComposite gacMajor = null;
    private GridAttributesComposite gacMinor = null;
    private Label lblGridCount = null;
    private Spinner iscGridCount = null;
    private Axis axis;
    private int angleType;

    public AxisGridLinesSheet(String title, ChartWizardContext context, Axis axis, int angleType) {
        super(title, context, true);
        this.axis = axis;
        this.angleType = angleType;
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.Gridlines_ID");
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        GridLayout glGeneral = new GridLayout();
        glGeneral.numColumns = 10;
        glGeneral.horizontalSpacing = 5;
        glGeneral.verticalSpacing = 5;
        glGeneral.marginHeight = 4;
        glGeneral.marginWidth = 4;
        GridLayout glGapWidth = new GridLayout();
        glGapWidth.numColumns = 8;
        glGapWidth.horizontalSpacing = 5;
        glGapWidth.marginHeight = 2;
        glGapWidth.marginWidth = 2;
        FillLayout flMajor = new FillLayout();
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        Composite choiceComposite = new Composite(this.cmpContent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        choiceComposite.setLayoutData((Object)gd);
        choiceComposite.setLayout((Layout)new GridLayout(2, true));
        this.cbHidden = new Button(choiceComposite, 32);
        this.cbHidden.setLayoutData((Object)new GridData(1808));
        this.cbHidden.setText(Messages.getString("BaseAxisAttributeSheetImpl.Lbl.HideAxisLine"));
        this.cbHidden.setSelection(!this.axis.getLineAttributes().isVisible());
        this.cbHidden.addSelectionListener((SelectionListener)this);
        this.cbTickBetweenCategory = new Button(choiceComposite, 32);
        this.cbTickBetweenCategory.setLayoutData((Object)new GridData(32));
        this.cbTickBetweenCategory.setText(Messages.getString("BaseAxisAttributeSheetImpl.Lbl.IsTickBetweenCategories"));
        this.cbTickBetweenCategory.setSelection(this.axis.getScale().isTickBetweenCategories());
        this.cbTickBetweenCategory.addSelectionListener((SelectionListener)this);
        this.cbTickBetweenCategory.setEnabled(this.axis.isCategoryAxis());
        this.cbTickBetweenCategory.setVisible(this.angleType == 1 && this.axis.isCategoryAxis());
        this.cmpGeneral = new Composite(this.cmpContent, 0);
        GridData gdCMPGeneral = new GridData(1808);
        gdCMPGeneral.horizontalSpan = 2;
        gdCMPGeneral.grabExcessVerticalSpace = false;
        this.cmpGeneral.setLayoutData((Object)gdCMPGeneral);
        this.cmpGeneral.setLayout((Layout)glGeneral);
        Label lblColor = new Label(this.cmpGeneral, 0);
        GridData gdLBLColor = new GridData(4);
        lblColor.setLayoutData((Object)gdLBLColor);
        lblColor.setText(Messages.getString("BaseAxisAttributeSheetImpl.Lbl.AxisLineColor"));
        ColorDefinition clrCurrent = null;
        if (this.axis.eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getAxis_LineAttributes())) {
            clrCurrent = this.axis.getLineAttributes().getColor();
        }
        this.fccLine = new FillChooserComposite(this.cmpGeneral, 0, this.getContext(), (Fill)clrCurrent, false, false);
        GridData gdFCCLine = new GridData(1808);
        gdFCCLine.horizontalSpan = 9;
        gdFCCLine.widthHint = 260;
        gdFCCLine.heightHint = this.fccLine.getPreferredSize().y;
        gdFCCLine.grabExcessVerticalSpace = false;
        this.fccLine.setLayoutData(gdFCCLine);
        this.fccLine.addListener(this);
        Label lblOrientation = new Label(this.cmpGeneral, 0);
        GridData gdLBLOrientation = new GridData(4);
        gdLBLOrientation.grabExcessVerticalSpace = false;
        lblOrientation.setLayoutData((Object)gdLBLOrientation);
        lblOrientation.setText(Messages.getString("BaseAxisAttributeSheetImpl.Lbl.Orientation"));
        this.cmbOrientation = new Label(this.cmpGeneral, 4);
        GridData gdCMBOrientation = new GridData(768);
        gdCMBOrientation.horizontalSpan = 4;
        gdCMBOrientation.widthHint = 120;
        this.cmbOrientation.setLayoutData((Object)gdCMBOrientation);
        this.cmbOrientation.setText(LiteralHelper.orientationSet.getDisplayNameByName(this.getAxisForProcessing().getOrientation().getName()));
        this.lblGridCount = new Label(this.cmpGeneral, 0);
        GridData gdLBLGridCount = new GridData();
        this.lblGridCount.setLayoutData((Object)gdLBLGridCount);
        this.lblGridCount.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.MinorGridCount"));
        this.iscGridCount = new Spinner(this.cmpGeneral, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.iscGridCount.setLayoutData((Object)gd);
        this.iscGridCount.setMinimum(1);
        this.iscGridCount.setSelection(this.getAxisForProcessing().getScale().getMinorGridsPerUnit());
        this.iscGridCount.addSelectionListener((SelectionListener)this);
        this.grpMajor = new Group(this.cmpContent, 0);
        GridData gdGRPMajor = new GridData(768);
        this.grpMajor.setLayoutData((Object)gdGRPMajor);
        this.grpMajor.setText(Messages.getString("BaseAxisAttributeSheetImpl.Lbl.MajorGrid"));
        this.grpMajor.setLayout((Layout)flMajor);
        this.gacMajor = new GridAttributesComposite((Composite)this.grpMajor, 0, this.getContext(), this.axis.getMajorGrid(), this.axis.getOrientation().getValue());
        this.gacMajor.addListener(this);
        this.grpMinor = new Group(this.cmpContent, 0);
        this.grpMinor.setLayout((Layout)new FillLayout());
        GridData gdGRPMinor = new GridData(768);
        this.grpMinor.setLayoutData((Object)gdGRPMinor);
        this.grpMinor.setText(Messages.getString("BaseAxisAttributeSheetImpl.Lbl.MinorGrid"));
        this.gacMinor = new GridAttributesComposite((Composite)this.grpMinor, 0, this.getContext(), this.axis.getMinorGrid(), this.axis.getOrientation().getValue());
        this.gacMinor.addListener(this);
        this.setStateOfMinorGrid();
        return this.cmpContent;
    }

    public void handleEvent(Event event) {
        if (((Object)((Object)this.fccLine)).equals(event.widget)) {
            if (event.type == 1) {
                this.getAxisForProcessing().getLineAttributes().setColor((ColorDefinition)event.data);
            }
        } else if (((Object)((Object)this.gacMajor)).equals(event.widget)) {
            switch (event.type) {
                case 1: {
                    this.getAxisForProcessing().getMajorGrid().getLineAttributes().setStyle((LineStyle)event.data);
                    break;
                }
                case 2: {
                    this.getAxisForProcessing().getMajorGrid().getLineAttributes().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 3: {
                    this.getAxisForProcessing().getMajorGrid().getLineAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    this.getAxisForProcessing().getMajorGrid().getLineAttributes().setVisible(((Boolean)event.data).booleanValue());
                    break;
                }
                case 6: {
                    this.getAxisForProcessing().getMajorGrid().getTickAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 5: {
                    this.getAxisForProcessing().getMajorGrid().setTickStyle((TickStyle)event.data);
                    break;
                }
                case 7: {
                    this.getAxisForProcessing().getMajorGrid().getTickAttributes().setVisible(((Boolean)event.data).booleanValue());
                }
            }
        } else if (((Object)((Object)this.gacMinor)).equals(event.widget)) {
            switch (event.type) {
                case 1: {
                    this.getAxisForProcessing().getMinorGrid().getLineAttributes().setStyle((LineStyle)event.data);
                    break;
                }
                case 2: {
                    this.getAxisForProcessing().getMinorGrid().getLineAttributes().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 3: {
                    this.getAxisForProcessing().getMinorGrid().getLineAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    this.getAxisForProcessing().getMinorGrid().getLineAttributes().setVisible(((Boolean)event.data).booleanValue());
                    this.setStateOfMinorGrid();
                    break;
                }
                case 6: {
                    this.getAxisForProcessing().getMinorGrid().getTickAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 5: {
                    this.getAxisForProcessing().getMinorGrid().setTickStyle((TickStyle)event.data);
                    break;
                }
                case 7: {
                    this.getAxisForProcessing().getMinorGrid().getTickAttributes().setVisible(((Boolean)event.data).booleanValue());
                    this.setStateOfMinorGrid();
                }
            }
        }
    }

    private void setStateOfMinorGrid() {
        boolean enabled = this.getAxisForProcessing().getMinorGrid().getLineAttributes().isVisible() || this.getAxisForProcessing().getMinorGrid().getTickAttributes().isVisible();
        this.lblGridCount.setEnabled(enabled);
        this.iscGridCount.setEnabled(enabled);
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (oSource.equals(this.cbHidden)) {
            this.getAxisForProcessing().getLineAttributes().setVisible(!this.cbHidden.getSelection());
        } else if (oSource.equals(this.cbTickBetweenCategory)) {
            this.getAxisForProcessing().getScale().setTickBetweenCategories(this.cbTickBetweenCategory.getSelection());
        }
        if (oSource.equals(this.iscGridCount)) {
            this.getAxisForProcessing().getScale().setMinorGridsPerUnit(this.iscGridCount.getSelection());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private Axis getAxisForProcessing() {
        return this.axis;
    }
}

