/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart;

import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.UnitsOfMeasurement;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class GeneralPropertiesChartSheet
extends AbstractPopupSheet
implements Listener,
ModifyListener,
SelectionListener {
    private transient Composite cmpContent;
    private transient ExternalizedTextEditorComposite txtDescription;
    private transient Group grpGeneral;
    private transient Text txtType;
    private transient Text txtSubType;
    private transient Spinner txtUnitSpacing;
    private transient Combo cmbUnits;
    private transient Label lblSeriesThickness;
    private transient LocalizedNumberEditorComposite txtSeriesThickness;
    private transient Spinner iscColumnCount;
    private transient FillChooserComposite fccBackground;
    private transient String sOldUnits = "";

    public GeneralPropertiesChartSheet(String title, ChartWizardContext context) {
        super(title, context, false);
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.ChartGeneralProperties_ID");
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.cmpContent.setLayout((Layout)glContent);
        GridLayout glGeneral = new GridLayout();
        glGeneral.numColumns = 2;
        glGeneral.horizontalSpacing = 5;
        glGeneral.verticalSpacing = 5;
        glGeneral.marginHeight = 7;
        glGeneral.marginWidth = 7;
        this.createDescriptionArea(this.cmpContent);
        this.grpGeneral = new Group(this.cmpContent, 0);
        GridData gdGRPGeneral = new GridData(770);
        this.grpGeneral.setLayoutData((Object)gdGRPGeneral);
        this.grpGeneral.setLayout((Layout)glGeneral);
        this.grpGeneral.setText(Messages.getString("AttributeSheetImpl.Lbl.ChartProperties"));
        Label lblType = new Label((Composite)this.grpGeneral, 0);
        GridData gdLBLType = new GridData();
        gdLBLType.horizontalIndent = 1;
        lblType.setLayoutData((Object)gdLBLType);
        lblType.setText(Messages.getString("AttributeSheetImpl.Lbl.Type"));
        this.txtType = new Text((Composite)this.grpGeneral, 2056);
        GridData gdTXTType = new GridData(768);
        this.txtType.setLayoutData((Object)gdTXTType);
        this.txtType.setText(this.getContext().getChartType().getDisplayName());
        Label lblSubType = new Label((Composite)this.grpGeneral, 0);
        GridData gdLBLSubType = new GridData();
        gdLBLSubType.horizontalIndent = 1;
        lblSubType.setLayoutData((Object)gdLBLSubType);
        lblSubType.setText(Messages.getString("AttributeSheetImpl.Lbl.Subtype"));
        this.txtSubType = new Text((Composite)this.grpGeneral, 2056);
        GridData gdTXTSubType = new GridData(768);
        this.txtSubType.setLayoutData((Object)gdTXTSubType);
        this.txtSubType.setText("");
        Orientation orientation = Orientation.VERTICAL_LITERAL;
        if (this.getChart() instanceof ChartWithAxes) {
            orientation = ((ChartWithAxes)this.getChart()).getOrientation();
        }
        Vector vSubType = (Vector)this.getContext().getChartType().getChartSubtypes(this.getChart().getDimension().getName(), orientation);
        for (IChartSubType cSubType : vSubType) {
            if (!cSubType.getName().equals(this.getChart().getSubType())) continue;
            this.txtSubType.setText(cSubType.getDisplayName());
            break;
        }
        if (this.getChart().getDimension().getValue() == 1) {
            Label lblUnit = new Label((Composite)this.grpGeneral, 0);
            GridData gdLBLUnit = new GridData();
            gdLBLUnit.horizontalIndent = 1;
            lblUnit.setLayoutData((Object)gdLBLUnit);
            lblUnit.setText(Messages.getString("AttributeSheetImpl.Lbl.Units"));
            this.cmbUnits = new Combo((Composite)this.grpGeneral, 12);
            GridData gdCMBUnits = new GridData(768);
            this.cmbUnits.setLayoutData((Object)gdCMBUnits);
            this.cmbUnits.addSelectionListener((SelectionListener)this);
            this.lblSeriesThickness = new Label((Composite)this.grpGeneral, 0);
            GridData gdLBLSeriesThickness = new GridData();
            gdLBLSeriesThickness.horizontalIndent = 1;
            this.lblSeriesThickness.setLayoutData((Object)gdLBLSeriesThickness);
            this.txtSeriesThickness = new LocalizedNumberEditorComposite((Composite)this.grpGeneral, 2052);
            GridData gdTXTSeriesThickness = new GridData(768);
            this.txtSeriesThickness.setLayoutData(gdTXTSeriesThickness);
            double dblPoints = this.getChart().getSeriesThickness();
            double dblCurrent = this.getContext().getUIServiceProvider().getConvertedValue(dblPoints, "Points", this.getChart().getUnits());
            this.txtSeriesThickness.setValue(dblCurrent);
            this.txtSeriesThickness.addModifyListener(this);
            this.populateLists();
        }
        if (this.getChart() instanceof ChartWithoutAxes) {
            Label lblColumnCount = new Label((Composite)this.grpGeneral, 0);
            GridData gdLBLColumnCount = new GridData();
            gdLBLColumnCount.horizontalIndent = 1;
            lblColumnCount.setLayoutData((Object)gdLBLColumnCount);
            lblColumnCount.setText(Messages.getString("AttributeSheetImpl.Lbl.ColumnCount"));
            this.iscColumnCount = new Spinner((Composite)this.grpGeneral, 2048);
            GridData gdISCColumnCount = new GridData(768);
            this.iscColumnCount.setLayoutData((Object)gdISCColumnCount);
            this.iscColumnCount.setMinimum(0);
            this.iscColumnCount.setMaximum(5);
            this.iscColumnCount.setSelection(this.getChart().getGridColumnCount());
            this.iscColumnCount.addSelectionListener((SelectionListener)this);
        } else if (this.getChart() instanceof ChartWithAxes) {
            Label lblUnitSpacing = new Label((Composite)this.grpGeneral, 0);
            GridData gdUnitSpacing = new GridData();
            gdUnitSpacing.horizontalIndent = 1;
            lblUnitSpacing.setLayoutData((Object)gdUnitSpacing);
            lblUnitSpacing.setText(Messages.getString("AttributeSheetImpl.Lbl.UnitSpacing"));
            this.txtUnitSpacing = new Spinner((Composite)this.grpGeneral, 2048);
            GridData gdTXTUnitSpacing = new GridData(768);
            this.txtUnitSpacing.setLayoutData((Object)gdTXTUnitSpacing);
            this.txtUnitSpacing.setMinimum(0);
            this.txtUnitSpacing.setMaximum(100);
            this.txtUnitSpacing.setIncrement(1);
            double unitSpacing = ((ChartWithAxes)this.getChart()).getUnitSpacing();
            this.txtUnitSpacing.setSelection((int)unitSpacing);
            this.txtUnitSpacing.addSelectionListener((SelectionListener)this);
        }
        return this.cmpContent;
    }

    private void createDescriptionArea(Composite parent) {
        Composite cmpDesp = new Composite(parent, 0);
        cmpDesp.setLayout((Layout)new GridLayout(2, false));
        GridData griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.widthHint = 300;
        cmpDesp.setLayoutData((Object)griddata);
        List keys = null;
        if (this.getContext().getUIServiceProvider() != null) {
            keys = this.getContext().getUIServiceProvider().getRegisteredKeys();
        }
        Label lblDescription = new Label(cmpDesp, 0);
        GridData gdLBLDescription = new GridData(2);
        gdLBLDescription.horizontalIndent = 2;
        gdLBLDescription.grabExcessHorizontalSpace = false;
        lblDescription.setLayoutData((Object)gdLBLDescription);
        lblDescription.setText(Messages.getString("GeneralSheetImpl.Lbl.Description"));
        String sDescription = "";
        if (this.getChart().getDescription() != null) {
            sDescription = this.getChart().getDescription().getValue();
        }
        this.txtDescription = new ExternalizedTextEditorComposite(cmpDesp, 2114, 65, -1, keys, this.getContext().getUIServiceProvider(), sDescription);
        GridData gdTXTDescription = new GridData(768);
        gdTXTDescription.heightHint = 65;
        this.txtDescription.setLayoutData(gdTXTDescription);
        this.txtDescription.addListener(this);
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.unitsOfMeasurementSet;
        this.cmbUnits.setItems(ns.getDisplayNames());
        String str = this.getChart().getUnits();
        if (str != null && str.trim().length() != 0) {
            this.cmbUnits.setText(ns.getDisplayNameByName(str));
        } else {
            this.cmbUnits.setText(ns.getDisplayNameByName(UnitsOfMeasurement.POINTS_LITERAL.getName()));
            this.getChart().setUnits(UnitsOfMeasurement.POINTS_LITERAL.getName());
        }
        this.sOldUnits = ns.getNameByDisplayName(this.cmbUnits.getText());
        this.lblSeriesThickness.setText(new MessageFormat(Messages.getString("GeneralSheetImpl.Lbl.SeriesWidth")).format(new Object[]{LiteralHelper.unitsOfMeasurementSet.getDisplayNameByName(this.getChart().getUnits())}));
    }

    private double recalculateUnitDependentValues(double value) {
        return this.getContext().getUIServiceProvider().getConvertedValue(value, this.sOldUnits, LiteralHelper.unitsOfMeasurementSet.getNameByDisplayName(this.cmbUnits.getText()));
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget.equals((Object)this.txtSeriesThickness)) {
            double dblCurrent = this.txtSeriesThickness.getValue();
            double dblPoints = this.getContext().getUIServiceProvider().getConvertedValue(dblCurrent, LiteralHelper.unitsOfMeasurementSet.getNameByDisplayName(this.cmbUnits.getText()), UnitsOfMeasurement.POINTS_LITERAL.getName());
            this.getChart().setSeriesThickness(dblPoints);
        }
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.txtDescription)) {
            if (this.getChart().getDescription() != null) {
                this.getChart().getDescription().setValue(this.txtDescription.getText());
            } else {
                org.eclipse.birt.chart.model.attribute.Text description = TextImpl.create((String)this.txtDescription.getText());
                this.getChart().setDescription(description);
            }
        } else if (event.widget.equals((Object)this.fccBackground)) {
            this.getChart().getBlock().setBackground((Fill)event.data);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbUnits)) {
            this.txtSeriesThickness.setValue(this.recalculateUnitDependentValues(this.txtSeriesThickness.getValue()));
            this.getChart().setUnits(LiteralHelper.unitsOfMeasurementSet.getNameByDisplayName(this.cmbUnits.getText()));
            this.lblSeriesThickness.setText(new MessageFormat(Messages.getString("GeneralSheetImpl.Lbl.SeriesWidth")).format(new Object[]{LiteralHelper.unitsOfMeasurementSet.getDisplayNameByName(this.getChart().getUnits())}));
            this.sOldUnits = this.getChart().getUnits();
        } else if (e.getSource().equals(this.iscColumnCount)) {
            this.getChart().setGridColumnCount(this.iscColumnCount.getSelection());
        } else if (e.getSource().equals(this.txtUnitSpacing)) {
            ((ChartWithAxes)this.getChart()).setUnitSpacing((double)this.txtUnitSpacing.getSelection());
        }
    }
}

