/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.series;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.PaletteEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class SeriesPaletteSheet
extends AbstractPopupSheet {
    private SeriesDefinition cSeriesDefn = null;
    private SeriesDefinition[] vSeriesDefns = null;
    private ChartWizardContext context = null;
    private boolean isGroupedSeries = false;
    private StackLayout slPalette = null;
    private Group grpPalette = null;
    private PaletteEditorComposite cmpPE = null;
    private Composite cmpMPE = null;
    private TabFolder tf = null;
    private final int iFillChooserStyle;

    public SeriesPaletteSheet(String title, ChartWizardContext context, SeriesDefinition cSeriesDefn, SeriesDefinition[] vSeriesDefns, boolean isGroupedSeries, int iFillChooserStyle) {
        super(title, context, true);
        this.context = context;
        this.cSeriesDefn = cSeriesDefn;
        this.vSeriesDefns = vSeriesDefns;
        this.isGroupedSeries = isGroupedSeries;
        this.iFillChooserStyle = iFillChooserStyle;
    }

    public Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.SeriesPalette_ID");
        Composite cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        cmpContent.setLayout((Layout)glContent);
        this.slPalette = new StackLayout();
        this.grpPalette = new Group(cmpContent, 0);
        GridData gdGRPPalette = new GridData(1808);
        gdGRPPalette.heightHint = 300;
        this.grpPalette.setLayoutData((Object)gdGRPPalette);
        this.grpPalette.setLayout((Layout)this.slPalette);
        this.grpPalette.setText(Messages.getString("BaseSeriesAttributeSheetImpl.Lbl.Palette"));
        this.cmpPE = new PaletteEditorComposite((Composite)this.grpPalette, this.getContext(), this.cSeriesDefn.getSeriesPalette(), this.vSeriesDefns, this.iFillChooserStyle);
        this.cmpMPE = new Composite((Composite)this.grpPalette, 0);
        GridLayout gl = new GridLayout();
        gl.marginLeft = 0;
        gl.marginRight = 0;
        this.cmpMPE.setLayoutData((Object)new GridData(1808));
        this.cmpMPE.setLayout((Layout)gl);
        this.tf = new TabFolder(this.cmpMPE, 0);
        this.tf.setLayoutData((Object)new GridData(1808));
        if (this.isGroupedSeries && this.isColoredByValue()) {
            int i = 0;
            while (i < this.vSeriesDefns.length) {
                TabItem ti = new TabItem(this.tf, 0);
                ti.setText("Series" + (i + 1));
                ti.setControl((Control)new PaletteEditorComposite((Composite)this.tf, this.getContext(), this.vSeriesDefns[i].getSeriesPalette(), null, this.iFillChooserStyle));
                ++i;
            }
            this.tf.setSelection(0);
            this.slPalette.topControl = this.cmpMPE;
        } else if (this.isMultiAxes()) {
            int i = 0;
            while (i < ChartUIUtil.getOrthogonalAxisNumber((Chart)this.context.getModel())) {
                SeriesDefinition[] seriesDefns = (SeriesDefinition[])ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)this.context.getModel(), (int)i).toArray();
                TabItem ti = new TabItem(this.tf, 0);
                ti.setText("Axis" + (i + 1));
                ti.setControl((Control)new PaletteEditorComposite((Composite)this.tf, this.getContext(), seriesDefns[0].getSeriesPalette(), seriesDefns, this.iFillChooserStyle));
                ++i;
            }
            this.tf.setSelection(0);
            this.slPalette.topControl = this.cmpMPE;
        } else {
            this.slPalette.topControl = this.cmpPE;
        }
        return cmpContent;
    }

    public void setGroupedPalette(boolean isGroupedSeries) {
        this.isGroupedSeries = isGroupedSeries;
    }

    public void setCategorySeries(SeriesDefinition sd) {
        this.cSeriesDefn = sd;
    }

    private boolean isColoredByValue() {
        return this.context.getModel().getLegend().getItemType().getValue() == 0;
    }

    private boolean isMultiAxes() {
        return ChartUIUtil.getOrthogonalAxisNumber((Chart)this.context.getModel()) > 1;
    }
}

