/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.functionservice.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.script.functionservice.IScriptFunction;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionArgument;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionCategory;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionFactory;
import org.eclipse.birt.core.script.functionservice.impl.Argument;
import org.eclipse.birt.core.script.functionservice.impl.Category;
import org.eclipse.birt.core.script.functionservice.impl.CategoryWrapper;
import org.eclipse.birt.core.script.functionservice.impl.ScriptFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionProvider {
    private static final String EXTENSION_POINT = "org.eclipse.birt.core.ScriptFunctionService";
    private static final String ELEMENT_CATEGORY = "Category";
    private static final String ELEMENT_FUNCTION = "Function";
    private static final String ELEMENT_ARGUMENT = "Argument";
    private static final String ELEMENT_JSLIB = "JSLib";
    private static final String ELEMENT_DATATYPE = "DataType";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESC = "desc";
    private static final String ATTRIBUTE_FACTORYCLASS = "factoryclass";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_ISOPTIONAL = "isOptional";
    private static final String ATTRIBUTE_ALLOWVARARGUMENT = "variableArguments";
    private static final String ATTRIBUTE_ISSTATIC = "isStatic";
    private static final String ATTRIBUTE_ISCONSTRUCTOR = "isConstructor";
    private static final String ATTRIBUTE_LOCATION = "location";
    private static final String DEFAULT_CATEGORYNAME = null;
    private static Map<String, Category> categories;
    private static List<URL> jsLibs;

    static {
        jsLibs = new ArrayList<URL>();
    }

    public static IScriptFunctionCategory[] getCategories() throws BirtException {
        return FunctionProvider.getCategoryMap().values().toArray(new IScriptFunctionCategory[0]);
    }

    public static IScriptFunction[] getFunctions(String categoryName) throws BirtException {
        if (FunctionProvider.getCategoryMap().containsKey(categoryName)) {
            Category category = FunctionProvider.getCategoryMap().get(categoryName);
            return category.getFunctions();
        }
        return new IScriptFunction[0];
    }

    public static void registerScriptFunction(Context cx, Scriptable scope) throws BirtException {
        List<CategoryWrapper> wrapperedCategories = FunctionProvider.getWrapperedCategories();
        for (CategoryWrapper category : wrapperedCategories) {
            ScriptableObject.putProperty((Scriptable)scope, (String)category.getClassName(), (Object)((Object)category));
        }
        for (URL url : jsLibs) {
            try {
                Script script = cx.compileReader((Reader)new BufferedReader(new InputStreamReader(url.openStream())), null, 0, null);
                script.exec(cx, scope);
            }
            catch (IOException iOException) {}
        }
    }

    private static Map<String, Category> getCategoryMap() {
        if (categories != null) {
            return categories;
        }
        categories = new HashMap<String, Category>();
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint(EXTENSION_POINT);
        if (extPoint == null) {
            return categories;
        }
        IExtension[] exts = extPoint.getExtensions();
        if (exts == null) {
            return categories;
        }
        int e = 0;
        while (e < exts.length) {
            IConfigurationElement[] configElems = exts[e].getConfigurationElements();
            if (configElems != null) {
                int i = 0;
                while (i < configElems.length) {
                    if (configElems[i].getName().equals(ELEMENT_CATEGORY)) {
                        Category category = new Category(configElems[i].getAttribute(ATTRIBUTE_NAME), configElems[i].getAttribute(ATTRIBUTE_DESC));
                        categories.put(category.getName(), category);
                        IScriptFunctionFactory factory = null;
                        try {
                            if (configElems[i].getAttribute(ATTRIBUTE_FACTORYCLASS) != null) {
                                factory = (IScriptFunctionFactory)configElems[i].createExecutableExtension(ATTRIBUTE_FACTORYCLASS);
                            }
                            IConfigurationElement[] functions = configElems[i].getChildren(ELEMENT_FUNCTION);
                            int j = 0;
                            while (j < functions.length) {
                                IScriptFunction function = FunctionProvider.getScriptFunction(category, factory, functions[j]);
                                if (function != null) {
                                    category.addFunction(function);
                                }
                                ++j;
                            }
                        }
                        catch (FrameworkException frameworkException) {}
                    } else if (configElems[i].getName().equals(ELEMENT_FUNCTION)) {
                        IScriptFunction function;
                        if (categories.get(DEFAULT_CATEGORYNAME) == null) {
                            categories.put(DEFAULT_CATEGORYNAME, new Category(DEFAULT_CATEGORYNAME, null));
                        }
                        if ((function = FunctionProvider.getScriptFunction(categories.get(DEFAULT_CATEGORYNAME), null, configElems[i])) != null) {
                            categories.get(DEFAULT_CATEGORYNAME).addFunction(function);
                        }
                    } else if (configElems[i].getName().equals(ELEMENT_JSLIB)) {
                        FunctionProvider.populateResources(jsLibs, ".js", configElems[i]);
                    }
                    ++i;
                }
            }
            ++e;
        }
        return categories;
    }

    private static void populateResources(List<URL> libs, String suffix, IConfigurationElement confElement) {
        String source = confElement.getAttribute(ATTRIBUTE_LOCATION);
        IBundle bundle = Platform.getBundle(confElement.getDeclaringExtension().getNamespace());
        if (bundle != null) {
            URL url = bundle.getEntry(source);
            Enumeration files = bundle.getEntryPaths(source);
            if (files != null) {
                while (files.hasMoreElements()) {
                    String element = files.nextElement().toString();
                    if (!element.toLowerCase().endsWith(suffix)) continue;
                    try {
                        libs.add(new URL(url, element));
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else if (url.getFile().toLowerCase().endsWith(suffix)) {
                libs.add(bundle.getEntry(source));
            }
        }
    }

    private static IScriptFunction getScriptFunction(Category category, IScriptFunctionFactory factory, IConfigurationElement function) {
        try {
            String name = function.getAttribute(ATTRIBUTE_NAME);
            String desc = function.getAttribute(ATTRIBUTE_DESC);
            String varArgs = function.getAttribute(ATTRIBUTE_ALLOWVARARGUMENT);
            boolean allowVarArgs = FunctionProvider.extractBoolean(varArgs, false);
            boolean isConstructor = FunctionProvider.extractBoolean(function.getAttribute(ATTRIBUTE_ISCONSTRUCTOR), false);
            boolean isStatic = FunctionProvider.extractBoolean(function.getAttribute(ATTRIBUTE_ISSTATIC), true);
            String dataType = null;
            ArrayList<IScriptFunctionArgument> arguments = new ArrayList<IScriptFunctionArgument>();
            if (FunctionProvider.hasChildren(ELEMENT_DATATYPE, function)) {
                dataType = function.getChildren(ELEMENT_DATATYPE)[0].getAttribute(ATTRIBUTE_VALUE);
            }
            if (FunctionProvider.hasChildren(ELEMENT_ARGUMENT, function)) {
                int i = 0;
                while (i < function.getChildren(ELEMENT_ARGUMENT).length) {
                    arguments.add(FunctionProvider.getScriptFunctionArgument(function.getChildren(ELEMENT_ARGUMENT)[i]));
                    ++i;
                }
            }
            return new ScriptFunction(name, category, arguments.toArray(new IScriptFunctionArgument[0]), dataType, desc, factory == null ? null : factory.getFunctionExecutor(name), allowVarArgs, isStatic, isConstructor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean extractBoolean(String varArgs, boolean ifNull) throws BirtException {
        boolean allowVarArgs = varArgs == null ? ifNull : DataTypeUtil.toBoolean(varArgs);
        return allowVarArgs;
    }

    private static IScriptFunctionArgument getScriptFunctionArgument(IConfigurationElement argument) throws BirtException {
        String name = argument.getAttribute(ATTRIBUTE_NAME);
        String desc = argument.getAttribute(ATTRIBUTE_DESC);
        String optional = argument.getAttribute(ATTRIBUTE_ISOPTIONAL);
        boolean isOptional = FunctionProvider.extractBoolean(optional, false);
        String dataType = null;
        if (FunctionProvider.hasChildren(ELEMENT_DATATYPE, argument)) {
            dataType = argument.getChildren(ELEMENT_DATATYPE)[0].getAttribute(ATTRIBUTE_VALUE);
        }
        return new Argument(name, dataType, desc, isOptional);
    }

    private static boolean hasChildren(String name, IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren(name);
        return children != null && children.length > 0;
    }

    private static List<CategoryWrapper> getWrapperedCategories() throws BirtException {
        ArrayList<CategoryWrapper> result = new ArrayList<CategoryWrapper>();
        for (Category category : FunctionProvider.getCategoryMap().values()) {
            if (category.getName() == DEFAULT_CATEGORYNAME) continue;
            result.add(new CategoryWrapper(category));
        }
        return result;
    }
}

