/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IMessageLookup;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.ui.swt.ChartBuilderMessageLookup;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainterBase;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ChartPreviewPainter
extends ChartPreviewPainterBase
implements PaintListener,
IUpdateNotifier {
    private boolean bIsPainting = false;
    private Image buffer;
    private String errorMessage = null;
    private ChartWizardContext wizardContext;
    private GeneratedChartState gcs = null;
    private static int X_OFFSET = 3;
    private static int Y_OFFSET = 3;

    public ChartPreviewPainter(ChartWizardContext wizardContext) {
        this.wizardContext = wizardContext;
    }

    protected void paintChart() {
        if (!this.isDisposedPreviewCanvas()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ChartPreviewPainter.this.updateBuffer();
                    if (!ChartPreviewPainter.this.isDisposedPreviewCanvas()) {
                        ChartPreviewPainter.this.preview.redraw();
                    }
                }
            });
        }
    }

    private void updateBuffer() {
        Image oldBuffer;
        Exception paintError;
        block20: {
            if (this.bIsPainting) {
                return;
            }
            paintError = null;
            if (this.chart == null) {
                return;
            }
            if (this.isDisposedPreviewCanvas()) {
                return;
            }
            Rectangle re = this.preview.getClientArea();
            Rectangle adjustedRe = new Rectangle(0, 0, re.width, re.height);
            if (adjustedRe.width - 2 * X_OFFSET <= 0 || adjustedRe.height - 2 * Y_OFFSET <= 0) {
                if (this.buffer != null && !this.buffer.isDisposed()) {
                    this.buffer.dispose();
                    this.buffer = null;
                }
                return;
            }
            this.bIsPainting = true;
            oldBuffer = null;
            if (this.buffer == null) {
                this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
            } else {
                Rectangle ore = this.buffer.getBounds();
                oldBuffer = this.buffer;
                if (!adjustedRe.equals((Object)ore)) {
                    this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
                }
            }
            GC gc = new GC((Drawable)this.buffer);
            gc.setBackground(Display.getDefault().getSystemColor(25));
            gc.fillRectangle(this.buffer.getBounds());
            Bounds bo = BoundsImpl.create((double)X_OFFSET, (double)Y_OFFSET, (double)(adjustedRe.width - 2 * X_OFFSET), (double)(adjustedRe.height - 2 * Y_OFFSET));
            IDeviceRenderer deviceRenderer = null;
            try {
                try {
                    deviceRenderer = ChartEngine.instance().getRenderer("dv.SWT");
                    deviceRenderer.setProperty("device.output.context", (Object)gc);
                    bo.scale(72.0 / (double)deviceRenderer.getDisplayServer().getDpiResolution());
                    Generator gr = Generator.instance();
                    RunTimeContext rtc = new RunTimeContext();
                    rtc.setScriptingEnabled(false);
                    rtc.setMessageLookup((IMessageLookup)new ChartBuilderMessageLookup(this.wizardContext.getUIServiceProvider()));
                    rtc.setRightToLeft(this.wizardContext.isRtL());
                    rtc.setRightToLeftText(this.wizardContext.isTextRtL());
                    rtc.setResourceFinder(this.wizardContext.getResourceFinder());
                    rtc.setExternalizer(this.wizardContext.getExternalizer());
                    this.gcs = gr.build(deviceRenderer.getDisplayServer(), this.chart, bo, null, rtc, ChartPreviewPainter.isProcessorEnabled() ? this.wizardContext.getProcessor() : null);
                    gr.render(deviceRenderer, this.gcs);
                }
                catch (Exception ex) {
                    paintError = ex;
                    gc.dispose();
                    if (deviceRenderer != null) {
                        deviceRenderer.dispose();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                gc.dispose();
                if (deviceRenderer != null) {
                    deviceRenderer.dispose();
                }
                throw throwable;
            }
            gc.dispose();
            if (deviceRenderer != null) {
                deviceRenderer.dispose();
            }
        }
        boolean bException = false;
        if (paintError != null) {
            this.buffer = oldBuffer;
            bException = true;
            if (WizardBase.getErrors() == null) {
                this.errorMessage = paintError.getLocalizedMessage();
                WizardBase.showException((String)this.errorMessage);
            }
        }
        if (!bException && (WizardBase.getErrors() == null || WizardBase.getErrors().equals(this.errorMessage))) {
            WizardBase.removeException();
        }
        if (oldBuffer != null && oldBuffer != this.buffer) {
            oldBuffer.dispose();
        }
        this.bIsPainting = false;
    }

    public void paintControl(PaintEvent pev) {
        GC gc = pev.gc;
        if (this.buffer != null) {
            gc.drawImage(this.buffer, 0, 0);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.buffer != null) {
            this.buffer.dispose();
            this.buffer = null;
        }
    }

    public Chart getDesignTimeModel() {
        return this.wizardContext.getModel();
    }

    public Chart getRunTimeModel() {
        if (this.gcs != null) {
            return this.gcs.getChartModel();
        }
        return null;
    }

    public Object peerInstance() {
        return this.preview;
    }

    public void regenerateChart() {
        this.paintChart();
    }

    public void repaintChart() {
        this.repaintChartInTimer();
    }

    protected void clearPreviewCanvas() {
        if (this.isDisposedPreviewCanvas()) {
            return;
        }
        Rectangle re = this.preview.getClientArea();
        Rectangle adjustedRe = new Rectangle(0, 0, re.width, re.height);
        Image oldBuffer = null;
        if (this.buffer == null) {
            if (adjustedRe.width <= 0 || adjustedRe.height <= 0) {
                return;
            }
            this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
        } else {
            Rectangle ore = this.buffer.getBounds();
            oldBuffer = this.buffer;
            if (!adjustedRe.equals((Object)ore)) {
                if (adjustedRe.width <= 0 || adjustedRe.height <= 0) {
                    return;
                }
                this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
            }
        }
        GC gc = new GC((Drawable)this.buffer);
        gc.setBackground(Display.getDefault().getSystemColor(25));
        gc.fillRectangle(this.buffer.getBounds());
        gc.dispose();
        if (oldBuffer != null && oldBuffer != this.buffer) {
            oldBuffer.dispose();
        }
        if (this.isDisposedPreviewCanvas()) {
            return;
        }
        this.preview.redraw();
    }

    protected boolean isLivePreviewEnabled() {
        return this.wizardContext.getDataServiceProvider().isLivePreviewEnabled();
    }
}

