/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.Canvas;

public abstract class ChartPreviewPainterBase
implements IChartPreviewPainter {
    private static final int PAINT_DELAY = 200;
    private Timer fPaintTimer = null;
    protected Canvas preview = null;
    protected Chart chart = null;
    private static boolean enableProcessor = true;
    private static boolean isLivePreview = false;

    public void dispose() {
        ChartPreviewPainterBase.activateLivePreview(false);
        if (this.fPaintTimer != null) {
            this.fPaintTimer.cancel();
            this.fPaintTimer = null;
        }
    }

    public void renderModel(Chart chart) {
        if (chart == null) {
            return;
        }
        this.chart = chart;
        this.ignoreNotifications(true);
        if (!ChartPreviewPainterBase.isLivePreviewActive() || !this.isLivePreviewEnabled()) {
            chart.createSampleRuntimeSeries();
        }
        if (!this.isDisposedPreviewCanvas()) {
            this.clearPreviewCanvas();
            this.repaintChartInTimer();
        }
        this.ignoreNotifications(false);
    }

    public void setPreview(Canvas previewCanvas) {
        this.preview = previewCanvas;
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.repaintChartInTimer();
    }

    protected void repaintChartInTimer() {
        if (this.fPaintTimer != null) {
            this.fPaintTimer.cancel();
        }
        this.fPaintTimer = new Timer();
        TimerTask task = new TimerTask(){

            public void run() {
                ChartPreviewPainterBase.this.paintChart();
            }
        };
        this.fPaintTimer.schedule(task, 200L);
    }

    protected abstract void paintChart();

    protected void clearPreviewCanvas() {
    }

    protected boolean isDisposedPreviewCanvas() {
        return this.preview == null || this.preview.isDisposed();
    }

    protected boolean isLivePreviewEnabled() {
        return true;
    }

    protected void ignoreNotifications(boolean bIgnoreNotifications) {
        ChartAdapter.ignoreNotifications(bIgnoreNotifications);
    }

    public static boolean isLivePreviewActive() {
        return isLivePreview;
    }

    public static void activateLivePreview(boolean canLive) {
        isLivePreview = canLive;
    }

    public static void enableProcessor(boolean isEnabled) {
        enableProcessor = isEnabled;
    }

    public static boolean isProcessorEnabled() {
        return enableProcessor;
    }
}

