/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withoutaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.DialRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Dial
extends BaseRenderer {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    private DialRenderer dr = null;

    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 3, (Throwable)vex);
        }
        ChartWithoutAxes dct = (ChartWithoutAxes)this.getModel();
        SeriesDefinition sd = this.getSeriesDefinition();
        try {
            this.dr = new DialRenderer(dct, this, srh, sd.getSeriesPalette());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 3, (Throwable)ex);
        }
    }

    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        Bounds boCB;
        ChartWithoutAxes cwoa = (ChartWithoutAxes)this.getModel();
        if (cwoa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.dial.dimension", new Object[]{cwoa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        DialSeries ds = (DialSeries)this.getSeries();
        if (!ds.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.series.visibility", new Object[]{ds}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!ds.isVisible()) {
            return;
        }
        Bounds bounds = boCB = this.isDialSuperimposed() ? this.getPlotBounds() : this.getCellBounds();
        if (this.isDialSuperimposed()) {
            Series se;
            BaseRenderer br;
            double radius = 0.0;
            double startAngle = 0.0;
            double stopAngle = 0.0;
            Scale sc = null;
            AutoScale asc = null;
            double extraSpacing = 0.0;
            boolean inverseScale = false;
            boolean first = true;
            int i = 1;
            while (i < this.iSeriesCount) {
                br = this.getRenderer(i);
                se = br.getSeries();
                if (br instanceof Dial && se.isSetVisible() && se.isVisible()) {
                    if (first) {
                        radius = ((Dial)br).getActualRenderer().getDialRadius();
                        startAngle = ((Dial)br).getActualRenderer().getDialStartAngle();
                        stopAngle = ((Dial)br).getActualRenderer().getDialStopAngle();
                        sc = ((Dial)br).getActualRenderer().getDialScale();
                        inverseScale = ((Dial)br).getActualRenderer().isInverseScale();
                        first = false;
                    } else {
                        radius = Math.max(radius, ((Dial)br).getActualRenderer().getDialRadius());
                    }
                }
                ++i;
            }
            i = 1;
            while (i < this.iSeriesCount) {
                br = this.getRenderer(i);
                se = br.getSeries();
                if (br instanceof Dial && se.isSetVisible() && se.isVisible()) {
                    ((Dial)br).getActualRenderer().updateRadius(radius);
                    asc = ((Dial)br).getActualRenderer().getAutoScale(startAngle, stopAngle, sc, boCB);
                    if (sc.getMin() == null || sc.getMax() == null) {
                        double min = Double.MAX_VALUE;
                        double max = -1.7976931348623157E308;
                        int j = 1;
                        while (j < this.iSeriesCount) {
                            BaseRenderer innerbr = this.getRenderer(j);
                            Series innerse = innerbr.getSeries();
                            if (innerbr instanceof Dial && innerse.isSetVisible() && innerse.isVisible()) {
                                min = Math.min(min, ((Dial)innerbr).getActualRenderer().getValue());
                                max = Math.max(max, ((Dial)innerbr).getActualRenderer().getValue());
                            }
                            ++j;
                        }
                        Scale nsc = null;
                        boolean needChange = false;
                        if (sc.getMin() == null && AutoScale.getLocation((AutoScale)asc, (double)min) < asc.getStart()) {
                            nsc = (Scale)EcoreUtil.copy((EObject)sc);
                            nsc.setMin((DataElement)NumberDataElementImpl.create((double)min));
                            needChange = true;
                        }
                        if (sc.getMax() == null && AutoScale.getLocation((AutoScale)asc, (double)max) > asc.getEnd()) {
                            if (nsc == null) {
                                nsc = (Scale)EcoreUtil.copy((EObject)sc);
                            }
                            nsc.setMax((DataElement)NumberDataElementImpl.create((double)max));
                            needChange = true;
                        }
                        if (needChange) {
                            sc = nsc;
                            asc = ((Dial)br).getActualRenderer().getAutoScale(startAngle, stopAngle, nsc, boCB);
                        }
                    }
                    extraSpacing = ((Dial)br).getActualRenderer().getDialExtraSpacing(asc);
                    break;
                }
                ++i;
            }
            i = 1;
            while (i < this.iSeriesCount) {
                br = this.getRenderer(i);
                se = br.getSeries();
                if (br instanceof Dial && se.isSetVisible() && se.isVisible()) {
                    ((Dial)br).getActualRenderer().updateRadius(radius);
                    ((Dial)br).getActualRenderer().updateStartAngle(startAngle);
                    ((Dial)br).getActualRenderer().updateStopAngle(stopAngle);
                    ((Dial)br).getActualRenderer().updateScale(sc);
                    ((Dial)br).getActualRenderer().updateAutoScale(asc);
                    ((Dial)br).getActualRenderer().updateExtraSpacing(extraSpacing);
                    ((Dial)br).getActualRenderer().updateInverseScale(inverseScale);
                }
                ++i;
            }
        }
        logger.log(1, String.valueOf(Messages.getString("info.render.series", this.getRunTimeContext().getULocale())) + ((Object)((Object)this)).getClass().getName() + (this.iSeriesIndex + 1) + this.iSeriesCount);
        this.dr.render(this.getDevice(), boCB);
    }

    protected final Bounds getFirstDialBounds() {
        int i = 1;
        while (i < this.iSeriesCount) {
            if (this.getRenderer(i) instanceof Dial) {
                return this.getCellBounds(i);
            }
            ++i;
        }
        return this.getCellBounds();
    }

    protected final boolean isFirstDial() {
        int i = 1;
        while (i < this.iSeriesCount) {
            Series se;
            BaseRenderer br = this.getRenderer(i);
            if (br instanceof Dial && (se = br.getSeries()).isSetVisible() && se.isVisible()) {
                return br == this;
            }
            ++i;
        }
        return false;
    }

    protected final boolean isDialSuperimposed() {
        if (this.getModel() instanceof DialChart) {
            DialChart dct = (DialChart)this.getModel();
            return dct.isSetDialSuperimposition() && dct.isDialSuperimposition();
        }
        return false;
    }

    private final DialRenderer getActualRenderer() {
        return this.dr;
    }

    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        DialSeries ds = (DialSeries)this.getSeries();
        ColorDefinition cd = ds.getDial().getLineAttributes().getColor();
        LineAttributes lia = LineAttributesImpl.create((ColorDefinition)(cd == null ? null : ColorDefinitionImpl.copyInstance((ColorDefinition)cd)), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
        OvalRenderEvent ore = (OvalRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), OvalRenderEvent.class);
        ore.setBackground(fPaletteEntry);
        ore.setOutline(lia);
        ore.setBounds(BoundsImpl.copyInstance((Bounds)bo));
        ipr.fillOval(ore);
        ipr.drawOval(ore);
    }
}

