/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.swt.RegionAction;
import org.eclipse.birt.chart.device.swt.i18n.Messages;
import org.eclipse.birt.chart.device.swt.util.SwtUtil;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.render.InteractiveRenderer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

class SwtEventHandler
implements MouseListener,
MouseMoveListener,
MouseTrackListener,
KeyListener,
FocusListener {
    private static final ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swt");
    private final Cursor hand_cursor;
    private final LinkedHashMap lhmAllTriggers;
    private final IUpdateNotifier iun;
    private RegionAction raTooltip = null;
    private final ULocale lcl;
    private final GC _gc;
    private InteractiveRenderer iv = null;
    private StructureSource srcHighlight;
    private StructureSource srcToggleDataPoint;
    private StructureSource srcToggleVisibility;

    SwtEventHandler(InteractiveRenderer iv, LinkedHashMap _lhmAllTriggers, IUpdateNotifier _jc, ULocale _lcl) {
        this.lhmAllTriggers = _lhmAllTriggers;
        this.iun = _jc;
        this.lcl = _lcl;
        this.hand_cursor = new Cursor((Device)Display.getDefault(), 21);
        this._gc = new GC((Drawable)Display.getDefault());
        this.iv = iv;
    }

    private final List getActionsForConditions(TriggerCondition[] tca) {
        if (tca == null || tca.length == 0) {
            return null;
        }
        ArrayList al = new ArrayList();
        int i = 0;
        while (i < tca.length) {
            ArrayList tal = (ArrayList)this.lhmAllTriggers.get(tca[i]);
            if (tal != null) {
                al.addAll(tal);
            }
            ++i;
        }
        if (al.size() > 0) {
            return al;
        }
        return null;
    }

    private final boolean isLeftButton(MouseEvent e) {
        return e.button == 1;
    }

    private void handleAction(TriggerCondition[] tgArray, Object event) {
        this.handleAction(tgArray, event, true);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void handleAction(TriggerCondition[] tgArray, Object event, boolean cleanState) {
        al = this.getActionsForConditions(tgArray);
        if (al == null || event == null) {
            return;
        }
        ra = null;
        ac = null;
        p = null;
        if (event instanceof MouseEvent) {
            p = new Point(((MouseEvent)event).x, ((MouseEvent)event).y);
        }
        event instanceof KeyEvent;
        bFound = false;
        i = 0;
        block8: while (i < al.size()) {
            ra = (RegionAction)al.get(i);
            if (p != null && !ra.contains(p, this._gc)) ** GOTO lbl-1000
            ac = ra.getAction();
            src = ra.getSource();
            switch (ac.getType().getValue()) {
                case 0: {
                    uv = (URLValue)ac.getValue();
                    SwtEventHandler.logger.log(1, String.valueOf(Messages.getString("SwtEventHandler.info.redirect.url", this.lcl)) + uv.getBaseUrl());
                    SwtUtil.openURL(uv.getBaseUrl());
                    break block8;
                }
                case 1: {
                    if (ra != this.raTooltip) {
                        this.hideTooltip();
                    }
                    this.raTooltip = ra;
                    bFound = true;
                    this.showTooltip(this.raTooltip);
                    break block8;
                }
                case 2: {
                    bFound = true;
                    this.srcToggleVisibility = this.handleGraphicAction(src, this.srcToggleVisibility, ActionType.TOGGLE_VISIBILITY_LITERAL, cleanState);
                    break block8;
                }
                case 6: {
                    bFound = true;
                    this.srcToggleDataPoint = this.handleGraphicAction(src, this.srcToggleDataPoint, ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL, cleanState);
                    break block8;
                }
                case 4: {
                    bFound = true;
                    this.srcHighlight = this.handleGraphicAction(src, this.srcHighlight, ActionType.HIGHLIGHT_LITERAL, cleanState);
                    break block8;
                }
                case 5: {
                    if (this.iun instanceof ICallBackNotifier) {
                        cv = (CallBackValue)ac.getValue();
                        ((ICallBackNotifier)this.iun).callback(event, (Object)ra.getSource(), cv);
                        break block8;
                    }
                    SwtEventHandler.logger.log(2, Messages.getString("SwtEventHandler.info.improper.callback.notifier", new Object[]{this.iun}, this.lcl));
                    break block8;
                }
                default: lbl-1000:
                // 2 sources

                {
                    ++i;
                }
            }
        }
        if (!bFound) {
            this.disableActions(this.getActionTypesForConditions(tgArray));
        }
    }

    protected Set getActionTypesForConditions(TriggerCondition[] tca) {
        if (tca == null || tca.length == 0) {
            return null;
        }
        HashSet<ActionType> set = new HashSet<ActionType>();
        int i = 0;
        while (i < tca.length) {
            List tal = (List)this.lhmAllTriggers.get(tca[i]);
            if (tal != null) {
                for (RegionAction rg : tal) {
                    ActionType actionType = rg.getAction().getType();
                    set.add(actionType);
                }
            }
            ++i;
        }
        return set;
    }

    private void disableActions(Set actions) {
        if (actions == null) {
            return;
        }
        for (ActionType action : actions) {
            if (action == null) continue;
            switch (action.getValue()) {
                case 1: {
                    if (this.raTooltip == null) break;
                    this.hideTooltip();
                    this.raTooltip = null;
                    break;
                }
                case 4: {
                    if (this.srcHighlight == null) break;
                    this.iv.unregisterAction(this.srcHighlight, ActionType.HIGHLIGHT_LITERAL);
                    this.srcHighlight = null;
                    this.iun.repaintChart();
                    break;
                }
                case 6: {
                    if (this.srcToggleDataPoint == null) break;
                    this.iv.unregisterAction(this.srcToggleDataPoint, ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL);
                    this.srcToggleDataPoint = null;
                    this.iun.repaintChart();
                    break;
                }
                case 2: {
                    if (this.srcToggleVisibility == null) break;
                    this.iv.unregisterAction(this.srcToggleVisibility, ActionType.TOGGLE_VISIBILITY_LITERAL);
                    this.srcToggleVisibility = null;
                    this.iun.repaintChart();
                }
            }
        }
    }

    private StructureSource handleGraphicAction(StructureSource src, StructureSource previousSrc, ActionType actionType, boolean cleanState) {
        if (previousSrc == null) {
            previousSrc = src;
            this.iv.registerAction(src, actionType);
            this.iun.repaintChart();
        } else if (!this.iv.getSource(src).equals(this.iv.getSource(previousSrc))) {
            if (actionType == ActionType.HIGHLIGHT_LITERAL) {
                this.iv.unregisterAction(previousSrc, actionType);
                previousSrc = src;
                this.iv.registerAction(src, actionType);
            } else {
                previousSrc = src;
                if (this.iv.isRegisteredAction(src, actionType)) {
                    this.iv.unregisterAction(src, actionType);
                } else {
                    this.iv.registerAction(src, actionType);
                }
            }
            this.iun.repaintChart();
        } else if (cleanState) {
            this.iv.unregisterAction(previousSrc, actionType);
            previousSrc = null;
            this.iun.repaintChart();
        }
        return previousSrc;
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        TriggerCondition[] tgArray = new TriggerCondition[]{TriggerCondition.ONDBLCLICK_LITERAL};
        this.handleAction(tgArray, e);
    }

    public void mouseDown(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        TriggerCondition[] tgArray = new TriggerCondition[]{TriggerCondition.ONMOUSEDOWN_LITERAL};
        this.handleAction(tgArray, e);
    }

    public void mouseUp(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        TriggerCondition[] tgArray = new TriggerCondition[]{TriggerCondition.ONMOUSEUP_LITERAL, TriggerCondition.ONCLICK_LITERAL, TriggerCondition.MOUSE_CLICK_LITERAL};
        this.handleAction(tgArray, e);
    }

    public void mouseMove(MouseEvent e) {
        TriggerCondition[] tgArray;
        List al = this.getActionsForConditions(new TriggerCondition[]{TriggerCondition.ONCLICK_LITERAL, TriggerCondition.ONMOUSEDOWN_LITERAL, TriggerCondition.MOUSE_CLICK_LITERAL});
        if (al != null) {
            boolean bFound = false;
            int i = 0;
            while (i < al.size()) {
                RegionAction ra = (RegionAction)al.get(i);
                if (ra.contains(e.x, e.y, this._gc)) {
                    ((Composite)this.iun.peerInstance()).setCursor(this.hand_cursor);
                    bFound = true;
                    break;
                }
                ++i;
            }
            if (!bFound) {
                ((Composite)this.iun.peerInstance()).setCursor(null);
            }
        }
        if ((tgArray = new TriggerCondition[]{TriggerCondition.ONMOUSEMOVE_LITERAL, TriggerCondition.ONMOUSEOVER_LITERAL}) != null) {
            this.handleAction(tgArray, e, false);
        }
    }

    public void keyPressed(KeyEvent e) {
        TriggerCondition[] tg = new TriggerCondition[]{TriggerCondition.ONKEYDOWN_LITERAL};
        this.handleAction(tg, e);
    }

    public void keyReleased(KeyEvent e) {
        TriggerCondition[] tg = new TriggerCondition[]{TriggerCondition.ONKEYUP_LITERAL, TriggerCondition.ONKEYPRESS_LITERAL};
        this.handleAction(tg, e);
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        TriggerCondition[] tg = new TriggerCondition[]{TriggerCondition.ONMOUSEOUT_LITERAL};
        this.handleAction(tg, e);
    }

    public void mouseHover(MouseEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONFOCUS_LITERAL}, e);
    }

    public void focusLost(FocusEvent e) {
        this.handleAction(new TriggerCondition[]{TriggerCondition.ONBLUR_LITERAL}, e);
    }

    private final void hideTooltip() {
        ((Composite)this.iun.peerInstance()).setToolTipText(null);
    }

    private final void showTooltip(RegionAction ra) {
        Action ac = ra.getAction();
        TooltipValue tv = (TooltipValue)ac.getValue();
        String s = tv.getText();
        ((Composite)this.iun.peerInstance()).setToolTipText(s);
    }

    public final void dispose() {
        this.hand_cursor.dispose();
        this._gc.dispose();
    }
}

