/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CharTrie;
import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.IntTrie;
import com.ibm.icu.impl.NormalizerDataReader;
import com.ibm.icu.impl.Trie;
import com.ibm.icu.impl.TrieIterator;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.impl.USerializedSet;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.RangeValueIterator;
import com.ibm.icu.util.VersionInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;

public final class NormalizerImpl {
    static final NormalizerImpl IMPL;
    static final int UNSIGNED_BYTE_MASK = 255;
    static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    private static final String DATA_FILE_NAME = "data/icudt38b/unorm.icu";
    public static final int QC_NFC = 17;
    public static final int QC_NFKC = 34;
    public static final int QC_NFD = 4;
    public static final int QC_NFKD = 8;
    public static final int QC_ANY_NO = 15;
    public static final int QC_MAYBE = 16;
    public static final int QC_ANY_MAYBE = 48;
    public static final int QC_MASK = 63;
    private static final int COMBINES_FWD = 64;
    private static final int COMBINES_BACK = 128;
    public static final int COMBINES_ANY = 192;
    private static final int CC_SHIFT = 8;
    public static final int CC_MASK = 65280;
    private static final int EXTRA_SHIFT = 16;
    private static final long MIN_SPECIAL = 0xFC000000L;
    private static final long SURROGATES_TOP = 0xFFF00000L;
    private static final long MIN_HANGUL = 0xFFF00000L;
    private static final long JAMO_V_TOP = 0xFFF30000L;
    static final int INDEX_TRIE_SIZE = 0;
    static final int INDEX_CHAR_COUNT = 1;
    static final int INDEX_COMBINE_DATA_COUNT = 2;
    static final int INDEX_COMBINE_FWD_COUNT = 3;
    static final int INDEX_COMBINE_BOTH_COUNT = 4;
    static final int INDEX_COMBINE_BACK_COUNT = 5;
    public static final int INDEX_MIN_NFC_NO_MAYBE = 6;
    public static final int INDEX_MIN_NFKC_NO_MAYBE = 7;
    public static final int INDEX_MIN_NFD_NO_MAYBE = 8;
    public static final int INDEX_MIN_NFKD_NO_MAYBE = 9;
    static final int INDEX_FCD_TRIE_SIZE = 10;
    static final int INDEX_AUX_TRIE_SIZE = 11;
    static final int INDEX_CANON_SET_COUNT = 12;
    static final int INDEX_TOP = 32;
    private static final int AUX_UNSAFE_SHIFT = 11;
    private static final int AUX_COMP_EX_SHIFT = 10;
    private static final int AUX_NFC_SKIPPABLE_F_SHIFT = 12;
    private static final int AUX_MAX_FNC = 1024;
    private static final int AUX_UNSAFE_MASK = 2048;
    private static final int AUX_FNC_MASK = 1023;
    private static final int AUX_COMP_EX_MASK = 1024;
    private static final long AUX_NFC_SKIP_F_MASK = 4096L;
    static final int SET_INDEX_CANON_SETS_LENGTH = 0;
    static final int SET_INDEX_CANON_BMP_TABLE_LENGTH = 1;
    static final int SET_INDEX_CANON_SUPP_TABLE_LENGTH = 2;
    static final int SET_INDEX_TOP = 32;
    static final int CANON_SET_INDICIES_INDEX = 0;
    static final int CANON_SET_START_SETS_INDEX = 1;
    static final int CANON_SET_BMP_TABLE_INDEX = 2;
    static final int CANON_SET_SUPP_TABLE_INDEX = 3;
    static final int CANON_SET_MAX_CANON_SETS = 16384;
    static final int CANON_SET_BMP_MASK = 49152;
    static final int CANON_SET_BMP_IS_INDEX = 16384;
    private static final int MAX_BUFFER_SIZE = 20;
    public static final int COMPARE_EQUIV = 524288;
    private static FCDTrieImpl fcdTrieImpl;
    private static NormTrieImpl normTrieImpl;
    private static AuxTrieImpl auxTrieImpl;
    private static int[] indexes;
    private static char[] combiningTable;
    private static char[] extraData;
    private static Object[] canonStartSets;
    private static boolean isDataLoaded;
    private static boolean isFormatVersion_2_1;
    private static boolean isFormatVersion_2_2;
    private static byte[] unicodeVersion;
    private static final int DATA_BUFFER_SIZE = 25000;
    public static final int MIN_WITH_LEAD_CC = 768;
    private static final int DECOMP_FLAG_LENGTH_HAS_CC = 128;
    private static final int DECOMP_LENGTH_MASK = 127;
    private static final int BMP_INDEX_LENGTH = 2048;
    private static final int SURROGATE_BLOCK_BITS = 5;
    public static final int JAMO_L_BASE = 4352;
    public static final int JAMO_V_BASE = 4449;
    public static final int JAMO_T_BASE = 4519;
    public static final int HANGUL_BASE = 44032;
    public static final int JAMO_L_COUNT = 19;
    public static final int JAMO_V_COUNT = 21;
    public static final int JAMO_T_COUNT = 28;
    public static final int HANGUL_COUNT = 11172;
    private static final int OPTIONS_NX_MASK = 31;
    private static final int OPTIONS_UNICODE_MASK = 224;
    public static final int OPTIONS_SETS_MASK = 255;
    private static final UnicodeSet[] nxCache;
    private static final int NX_HANGUL = 1;
    private static final int NX_CJK_COMPAT = 2;
    public static final int BEFORE_PRI_29 = 256;
    public static final int OPTIONS_COMPAT = 4096;
    public static final int OPTIONS_COMPOSE_CONTIGUOUS = 8192;

    static {
        try {
            IMPL = new NormalizerImpl();
        }
        catch (Exception e) {
            throw new MissingResourceException(e.getMessage(), "", "");
        }
        nxCache = new UnicodeSet[256];
    }

    public static int getFromIndexesArr(int index) {
        return indexes[index];
    }

    private NormalizerImpl() throws IOException {
        if (!isDataLoaded) {
            InputStream i = ICUData.getRequiredStream(DATA_FILE_NAME);
            BufferedInputStream b = new BufferedInputStream(i, 25000);
            NormalizerDataReader reader = new NormalizerDataReader(b);
            indexes = reader.readIndexes(32);
            byte[] normBytes = new byte[indexes[0]];
            int combiningTableTop = indexes[2];
            combiningTable = new char[combiningTableTop];
            int extraDataTop = indexes[1];
            extraData = new char[extraDataTop];
            byte[] fcdBytes = new byte[indexes[10]];
            byte[] auxBytes = new byte[indexes[11]];
            canonStartSets = new Object[16384];
            fcdTrieImpl = new FCDTrieImpl();
            normTrieImpl = new NormTrieImpl();
            auxTrieImpl = new AuxTrieImpl();
            reader.read(normBytes, fcdBytes, auxBytes, extraData, combiningTable, canonStartSets);
            NormTrieImpl.normTrie = new IntTrie(new ByteArrayInputStream(normBytes), normTrieImpl);
            FCDTrieImpl.fcdTrie = new CharTrie(new ByteArrayInputStream(fcdBytes), fcdTrieImpl);
            AuxTrieImpl.auxTrie = new CharTrie(new ByteArrayInputStream(auxBytes), auxTrieImpl);
            isDataLoaded = true;
            byte[] formatVersion = reader.getDataFormatVersion();
            isFormatVersion_2_1 = formatVersion[0] > 2 || formatVersion[0] == 2 && formatVersion[1] >= 1;
            isFormatVersion_2_2 = formatVersion[0] > 2 || formatVersion[0] == 2 && formatVersion[1] >= 2;
            unicodeVersion = reader.getUnicodeVersion();
            b.close();
        }
    }

    private static boolean isHangulWithoutJamoT(char c) {
        return (c = (char)(c - 44032)) < '\u2ba4' && c % 28 == 0;
    }

    private static boolean isNorm32Regular(long norm32) {
        return norm32 < 0xFC000000L;
    }

    private static boolean isNorm32LeadSurrogate(long norm32) {
        return 0xFC000000L <= norm32 && norm32 < 0xFFF00000L;
    }

    private static boolean isNorm32HangulOrJamo(long norm32) {
        return norm32 >= 0xFFF00000L;
    }

    private static boolean isJamoVTNorm32JamoV(long norm32) {
        return norm32 < 0xFFF30000L;
    }

    public static long getNorm32(char c) {
        return 0xFFFFFFFFL & (long)NormTrieImpl.normTrie.getLeadValue(c);
    }

    public static long getNorm32FromSurrogatePair(long norm32, char c2) {
        return 0xFFFFFFFFL & (long)NormTrieImpl.normTrie.getTrailValue((int)norm32, c2);
    }

    private static long getNorm32(int c) {
        return 0xFFFFFFFFL & (long)NormTrieImpl.normTrie.getCodePointValue(c);
    }

    private static long getNorm32(char[] p, int start, int mask) {
        long norm32 = NormalizerImpl.getNorm32(p[start]);
        if ((norm32 & (long)mask) > 0L && NormalizerImpl.isNorm32LeadSurrogate(norm32)) {
            norm32 = NormalizerImpl.getNorm32FromSurrogatePair(norm32, p[start + 1]);
        }
        return norm32;
    }

    public static VersionInfo getUnicodeVersion() {
        return VersionInfo.getInstance(unicodeVersion[0], unicodeVersion[1], unicodeVersion[2], unicodeVersion[3]);
    }

    public static char getFCD16(char c) {
        return FCDTrieImpl.fcdTrie.getLeadValue(c);
    }

    public static char getFCD16FromSurrogatePair(char fcd16, char c2) {
        return FCDTrieImpl.fcdTrie.getTrailValue(fcd16, c2);
    }

    public static int getFCD16(int c) {
        return FCDTrieImpl.fcdTrie.getCodePointValue(c);
    }

    private static int getExtraDataIndex(long norm32) {
        return (int)(norm32 >> 16);
    }

    private static int decompose(long norm32, int qcMask, DecomposeArgs args) {
        int p = NormalizerImpl.getExtraDataIndex(norm32);
        args.length = extraData[p++];
        if ((norm32 & (long)qcMask & 8L) != 0L && args.length >= 256) {
            p += (args.length >> 7 & 1) + (args.length & 0x7F);
            args.length >>= 8;
        }
        if ((args.length & 0x80) > 0) {
            char bothCCs = extraData[p++];
            args.cc = 0xFF & bothCCs >> 8;
            args.trailCC = 0xFF & bothCCs;
        } else {
            args.trailCC = 0;
            args.cc = 0;
        }
        args.length &= 0x7F;
        return p;
    }

    private static int decompose(long norm32, DecomposeArgs args) {
        int p = NormalizerImpl.getExtraDataIndex(norm32);
        args.length = extraData[p++];
        if ((args.length & 0x80) > 0) {
            char bothCCs = extraData[p++];
            args.cc = 0xFF & bothCCs >> 8;
            args.trailCC = 0xFF & bothCCs;
        } else {
            args.trailCC = 0;
            args.cc = 0;
        }
        args.length &= 0x7F;
        return p;
    }

    private static int getNextCC(NextCCArgs args) {
        args.c = args.source[args.next++];
        long norm32 = NormalizerImpl.getNorm32(args.c);
        if ((norm32 & 0xFF00L) == 0L) {
            args.c2 = '\u0000';
            return 0;
        }
        if (!NormalizerImpl.isNorm32LeadSurrogate(norm32)) {
            args.c2 = '\u0000';
        } else if (args.next != args.limit && UTF16.isTrailSurrogate(args.c2 = args.source[args.next])) {
            ++args.next;
            norm32 = NormalizerImpl.getNorm32FromSurrogatePair(norm32, args.c2);
        } else {
            args.c2 = '\u0000';
            return 0;
        }
        return (int)(0xFFL & norm32 >> 8);
    }

    private static long getPrevNorm32(PrevArgs args, int minC, int mask) {
        args.c = args.src[--args.current];
        args.c2 = '\u0000';
        if (args.c < minC) {
            return 0L;
        }
        if (!UTF16.isSurrogate(args.c)) {
            return NormalizerImpl.getNorm32(args.c);
        }
        if (UTF16.isLeadSurrogate(args.c)) {
            return 0L;
        }
        if (args.current != args.start && UTF16.isLeadSurrogate(args.c2 = args.src[args.current - 1])) {
            --args.current;
            long norm32 = NormalizerImpl.getNorm32(args.c2);
            if ((norm32 & (long)mask) == 0L) {
                return 0L;
            }
            return NormalizerImpl.getNorm32FromSurrogatePair(norm32, args.c);
        }
        args.c2 = '\u0000';
        return 0L;
    }

    private static int getPrevCC(PrevArgs args) {
        return (int)(0xFFL & NormalizerImpl.getPrevNorm32(args, 768, 65280) >> 8);
    }

    public static boolean isNFDSafe(long norm32, int ccOrQCMask, int decompQCMask) {
        if ((norm32 & (long)ccOrQCMask) == 0L) {
            return true;
        }
        if (NormalizerImpl.isNorm32Regular(norm32) && (norm32 & (long)decompQCMask) != 0L) {
            DecomposeArgs args = new DecomposeArgs();
            NormalizerImpl.decompose(norm32, decompQCMask, args);
            return args.cc == 0;
        }
        return (norm32 & 0xFF00L) == 0L;
    }

    public static boolean isTrueStarter(long norm32, int ccOrQCMask, int decompQCMask) {
        if ((norm32 & (long)ccOrQCMask) == 0L) {
            return true;
        }
        if ((norm32 & (long)decompQCMask) != 0L) {
            int qcMask;
            DecomposeArgs args = new DecomposeArgs();
            int p = NormalizerImpl.decompose(norm32, decompQCMask, args);
            if (args.cc == 0 && (NormalizerImpl.getNorm32(extraData, p, qcMask = ccOrQCMask & 0x3F) & (long)qcMask) == 0L) {
                return true;
            }
        }
        return false;
    }

    private static int insertOrdered(char[] source, int start, int current, int p, char c, char c2, int cc) {
        int trailCC = cc;
        if (start < current && cc != 0) {
            int back;
            int preBack = back = current;
            PrevArgs prevArgs = new PrevArgs();
            prevArgs.current = current;
            prevArgs.start = start;
            prevArgs.src = source;
            int prevCC = NormalizerImpl.getPrevCC(prevArgs);
            preBack = prevArgs.current;
            if (cc < prevCC) {
                trailCC = prevCC;
                back = preBack;
                while (start < preBack) {
                    prevCC = NormalizerImpl.getPrevCC(prevArgs);
                    preBack = prevArgs.current;
                    if (cc >= prevCC) break;
                    back = preBack;
                }
                int r = p;
                do {
                    source[--r] = source[--current];
                } while (back != current);
            }
        }
        source[current] = c;
        if (c2 != '\u0000') {
            source[current + 1] = c2;
        }
        return trailCC;
    }

    private static int mergeOrdered(char[] source, int start, int current, char[] data, int next, int limit, boolean isOrdered) {
        int trailCC = 0;
        boolean adjacent = current == next;
        NextCCArgs ncArgs = new NextCCArgs();
        ncArgs.source = data;
        ncArgs.next = next;
        ncArgs.limit = limit;
        if (start != current || !isOrdered) {
            while (ncArgs.next < ncArgs.limit) {
                int cc = NormalizerImpl.getNextCC(ncArgs);
                if (cc == 0) {
                    trailCC = 0;
                    if (adjacent) {
                        current = ncArgs.next;
                    } else {
                        data[current++] = ncArgs.c;
                        if (ncArgs.c2 != '\u0000') {
                            data[current++] = ncArgs.c2;
                        }
                    }
                    if (isOrdered) break;
                    start = current;
                    continue;
                }
                int r = current + (ncArgs.c2 == '\u0000' ? 1 : 2);
                trailCC = NormalizerImpl.insertOrdered(source, start, current, r, ncArgs.c, ncArgs.c2, cc);
                current = r;
            }
        }
        if (ncArgs.next == ncArgs.limit) {
            return trailCC;
        }
        if (!adjacent) {
            do {
                source[current++] = data[ncArgs.next++];
            } while (ncArgs.next != ncArgs.limit);
            ncArgs.limit = current;
        }
        PrevArgs prevArgs = new PrevArgs();
        prevArgs.src = data;
        prevArgs.start = start;
        prevArgs.current = ncArgs.limit;
        return NormalizerImpl.getPrevCC(prevArgs);
    }

    private static int mergeOrdered(char[] source, int start, int current, char[] data, int next, int limit) {
        return NormalizerImpl.mergeOrdered(source, start, current, data, next, limit, true);
    }

    public static boolean checkFCD(char[] src, int srcStart, int srcLimit, UnicodeSet nx) {
        int prevCC = 0;
        int i = srcStart;
        int length = srcLimit;
        while (i != length) {
            char c2;
            int c;
            if ((c = src[i++]) < 768) {
                prevCC = -c;
                continue;
            }
            char fcd16 = NormalizerImpl.getFCD16((char)c);
            if (fcd16 == '\u0000') {
                prevCC = 0;
                continue;
            }
            if (UTF16.isLeadSurrogate((char)c)) {
                if (i != length && UTF16.isTrailSurrogate(c2 = src[i])) {
                    ++i;
                    fcd16 = NormalizerImpl.getFCD16FromSurrogatePair(fcd16, c2);
                } else {
                    c2 = '\u0000';
                    fcd16 = '\u0000';
                }
            } else {
                c2 = '\u0000';
            }
            if (NormalizerImpl.nx_contains(nx, (char)c, c2)) {
                prevCC = 0;
                continue;
            }
            int cc = fcd16 >> 8;
            if (cc != 0) {
                if (prevCC < 0) {
                    prevCC = !NormalizerImpl.nx_contains(nx, -prevCC) ? FCDTrieImpl.fcdTrie.getBMPValue((char)(-prevCC)) & 0xFF : 0;
                }
                if (cc < prevCC) {
                    return false;
                }
            }
            prevCC = fcd16 & 0xFF;
        }
        return true;
    }

    public static Normalizer.QuickCheckResult quickCheck(char[] src, int srcStart, int srcLimit, int minNoMaybe, int qcMask, int options, boolean allowMaybe, UnicodeSet nx) {
        Normalizer.QuickCheckResult result;
        block13: {
            ComposePartArgs args = new ComposePartArgs();
            int start = srcStart;
            if (!isDataLoaded) {
                return Normalizer.MAYBE;
            }
            int ccOrQCMask = 0xFF00 | qcMask;
            result = Normalizer.YES;
            char prevCC = '\u0000';
            while (true) {
                char cc;
                char c2;
                long norm32;
                char c;
                if (srcStart == srcLimit) {
                    return result;
                }
                if ((c = src[srcStart++]) < minNoMaybe || ((norm32 = NormalizerImpl.getNorm32(c)) & (long)ccOrQCMask) == 0L) {
                    prevCC = '\u0000';
                    continue;
                }
                if (NormalizerImpl.isNorm32LeadSurrogate(norm32)) {
                    if (srcStart != srcLimit && UTF16.isTrailSurrogate(c2 = src[srcStart])) {
                        ++srcStart;
                        norm32 = NormalizerImpl.getNorm32FromSurrogatePair(norm32, c2);
                    } else {
                        norm32 = 0L;
                        c2 = '\u0000';
                    }
                } else {
                    c2 = '\u0000';
                }
                if (NormalizerImpl.nx_contains(nx, c, c2)) {
                    norm32 = 0L;
                }
                if ((cc = (char)(norm32 >> 8 & 0xFFL)) != '\u0000' && cc < prevCC) {
                    return Normalizer.NO;
                }
                prevCC = cc;
                long qcNorm32 = norm32 & (long)qcMask;
                if ((qcNorm32 & 0xFL) >= 1L) {
                    result = Normalizer.NO;
                    break block13;
                }
                if (qcNorm32 == 0L) continue;
                if (allowMaybe) {
                    result = Normalizer.MAYBE;
                    continue;
                }
                int decompQCMask = qcMask << 2 & 0xF;
                int prevStarter = srcStart - 1;
                if (UTF16.isTrailSurrogate(src[prevStarter])) {
                    --prevStarter;
                }
                prevStarter = NormalizerImpl.findPreviousStarter(src, start, prevStarter, ccOrQCMask, decompQCMask, (char)minNoMaybe);
                srcStart = NormalizerImpl.findNextStarter(src, srcStart, srcLimit, qcMask, decompQCMask, (char)minNoMaybe);
                args.prevCC = prevCC;
                char[] buffer = NormalizerImpl.composePart(args, prevStarter, src, srcStart, srcLimit, options, nx);
                if (NormalizerImpl.strCompare(buffer, 0, args.length, src, prevStarter, srcStart, false) != 0) break;
            }
            result = Normalizer.NO;
        }
        return result;
    }

    public static int getDecomposition(int c, boolean compat, char[] dest, int destStart, int destCapacity) {
        if ((0xFFFFFFFFL & (long)c) <= 0x10FFFFL) {
            int qcMask;
            int minNoMaybe;
            if (!compat) {
                minNoMaybe = indexes[8];
                qcMask = 4;
            } else {
                minNoMaybe = indexes[9];
                qcMask = 8;
            }
            if (c < minNoMaybe) {
                if (destCapacity > 0) {
                    dest[0] = (char)c;
                }
                return -1;
            }
            long norm32 = NormalizerImpl.getNorm32(c);
            if ((norm32 & (long)qcMask) == 0L) {
                if (c <= 65535) {
                    if (destCapacity > 0) {
                        dest[0] = (char)c;
                    }
                    return -1;
                }
                if (destCapacity >= 2) {
                    dest[0] = UTF16.getLeadSurrogate(c);
                    dest[1] = UTF16.getTrailSurrogate(c);
                }
                return -2;
            }
            if (NormalizerImpl.isNorm32HangulOrJamo(norm32)) {
                int length;
                char c2 = (char)((c -= 44032) % 28);
                c /= 28;
                if (c2 > '\u0000') {
                    if (destCapacity >= 3) {
                        dest[2] = (char)(4519 + c2);
                    }
                    length = 3;
                } else {
                    length = 2;
                }
                if (destCapacity >= 2) {
                    dest[1] = (char)(4449 + c % 21);
                    dest[0] = (char)(4352 + c / 21);
                }
                return length;
            }
            DecomposeArgs args = new DecomposeArgs();
            int p = NormalizerImpl.decompose(norm32, qcMask, args);
            if (args.length <= destCapacity) {
                int limit = p + args.length;
                do {
                    dest[destStart++] = extraData[p++];
                } while (p < limit);
            }
            return args.length;
        }
        return 0;
    }

    public static int decompose(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, boolean compat, int[] outTrailCC, UnicodeSet nx) {
        int qcMask;
        char minNoMaybe;
        char[] buffer = new char[3];
        int destIndex = destStart;
        int srcIndex = srcStart;
        if (!compat) {
            minNoMaybe = (char)indexes[8];
            qcMask = 4;
        } else {
            minNoMaybe = (char)indexes[9];
            qcMask = 8;
        }
        int ccOrQCMask = 0xFF00 | qcMask;
        int reorderStartIndex = 0;
        int prevCC = 0;
        long norm32 = 0L;
        char c = '\u0000';
        int pStart = 0;
        int trailCC = -1;
        int cc = -1;
        while (true) {
            char[] p;
            char c2;
            int length;
            int prevSrc = srcIndex;
            while (srcIndex != srcLimit && ((c = src[srcIndex]) < minNoMaybe || ((norm32 = NormalizerImpl.getNorm32(c)) & (long)ccOrQCMask) == 0L)) {
                prevCC = 0;
                ++srcIndex;
            }
            if (srcIndex != prevSrc) {
                length = srcIndex - prevSrc;
                if (destIndex + length <= destLimit) {
                    System.arraycopy(src, prevSrc, dest, destIndex, length);
                }
                reorderStartIndex = destIndex += length;
            }
            if (srcIndex == srcLimit) break;
            ++srcIndex;
            if (NormalizerImpl.isNorm32HangulOrJamo(norm32)) {
                if (NormalizerImpl.nx_contains(nx, c)) {
                    c2 = '\u0000';
                    p = null;
                    length = 1;
                } else {
                    p = buffer;
                    pStart = 0;
                    trailCC = 0;
                    cc = 0;
                    c = (char)(c - 44032);
                    c2 = (char)(c % 28);
                    c = (char)(c / 28);
                    if (c2 > '\u0000') {
                        buffer[2] = (char)(4519 + c2);
                        length = 3;
                    } else {
                        length = 2;
                    }
                    buffer[1] = (char)(4449 + c % 21);
                    buffer[0] = (char)(4352 + c / 21);
                }
            } else {
                if (NormalizerImpl.isNorm32Regular(norm32)) {
                    c2 = '\u0000';
                    length = 1;
                } else if (srcIndex != srcLimit && UTF16.isTrailSurrogate(c2 = src[srcIndex])) {
                    ++srcIndex;
                    length = 2;
                    norm32 = NormalizerImpl.getNorm32FromSurrogatePair(norm32, c2);
                } else {
                    c2 = '\u0000';
                    length = 1;
                    norm32 = 0L;
                }
                if (NormalizerImpl.nx_contains(nx, c, c2)) {
                    trailCC = 0;
                    cc = 0;
                    p = null;
                } else if ((norm32 & (long)qcMask) == 0L) {
                    cc = trailCC = (int)(0xFFL & norm32 >> 8);
                    p = null;
                    pStart = -1;
                } else {
                    DecomposeArgs arg = new DecomposeArgs();
                    pStart = NormalizerImpl.decompose(norm32, qcMask, arg);
                    p = extraData;
                    length = arg.length;
                    cc = arg.cc;
                    trailCC = arg.trailCC;
                    if (length == 1) {
                        c = p[pStart];
                        c2 = '\u0000';
                        p = null;
                        pStart = -1;
                    }
                }
            }
            if (destIndex + length <= destLimit) {
                int reorderSplit = destIndex;
                if (p == null) {
                    if (cc != 0 && cc < prevCC) {
                        trailCC = NormalizerImpl.insertOrdered(dest, reorderStartIndex, reorderSplit, destIndex += length, c, c2, cc);
                    } else {
                        dest[destIndex++] = c;
                        if (c2 != '\u0000') {
                            dest[destIndex++] = c2;
                        }
                    }
                } else if (cc != 0 && cc < prevCC) {
                    destIndex += length;
                    trailCC = NormalizerImpl.mergeOrdered(dest, reorderStartIndex, reorderSplit, p, pStart, pStart + length);
                } else {
                    do {
                        dest[destIndex++] = p[pStart++];
                    } while (--length > 0);
                }
            } else {
                destIndex += length;
            }
            if ((prevCC = trailCC) != 0) continue;
            reorderStartIndex = destIndex;
        }
        outTrailCC[0] = prevCC;
        return destIndex - destStart;
    }

    private static int getNextCombining(NextCombiningArgs args, int limit, UnicodeSet nx) {
        args.c = args.source[args.start++];
        long norm32 = NormalizerImpl.getNorm32(args.c);
        args.c2 = '\u0000';
        args.combiningIndex = 0;
        args.cc = '\u0000';
        if ((norm32 & 0xFFC0L) == 0L) {
            return 0;
        }
        if (!NormalizerImpl.isNorm32Regular(norm32)) {
            if (NormalizerImpl.isNorm32HangulOrJamo(norm32)) {
                args.combiningIndex = (int)(0xFFFFFFFFL & (0xFFF0L | norm32 >> 16));
                return (int)(norm32 & 0xC0L);
            }
            if (args.start != limit && UTF16.isTrailSurrogate(args.c2 = args.source[args.start])) {
                ++args.start;
                norm32 = NormalizerImpl.getNorm32FromSurrogatePair(norm32, args.c2);
            } else {
                args.c2 = '\u0000';
                return 0;
            }
        }
        if (NormalizerImpl.nx_contains(nx, args.c, args.c2)) {
            return 0;
        }
        args.cc = (char)(norm32 >> 8 & 0xFFL);
        int combineFlags = (int)(norm32 & 0xC0L);
        if (combineFlags != 0) {
            int index = NormalizerImpl.getExtraDataIndex(norm32);
            args.combiningIndex = index > 0 ? extraData[index - 1] : 0;
        }
        return combineFlags;
    }

    private static int getCombiningIndexFromStarter(char c, char c2) {
        long norm32 = NormalizerImpl.getNorm32(c);
        if (c2 != '\u0000') {
            norm32 = NormalizerImpl.getNorm32FromSurrogatePair(norm32, c2);
        }
        return extraData[NormalizerImpl.getExtraDataIndex(norm32) - 1];
    }

    private static int combine(char[] table, int tableStart, int combineBackIndex, int[] outValues) {
        int key;
        if (outValues.length < 2) {
            throw new IllegalArgumentException();
        }
        while ((key = table[tableStart++]) < combineBackIndex) {
            tableStart += (table[tableStart] & 0x8000) != 0 ? 2 : 1;
        }
        if ((key & Short.MAX_VALUE) == combineBackIndex) {
            int value2;
            int value = table[tableStart];
            key = (int)(0xFFFFFFFFL & (long)((value & 0x2000) + 1));
            if ((value & 0x8000) != 0) {
                if ((value & 0x4000) != 0) {
                    value = (int)(0xFFFFFFFFL & (long)(value & 0x3FF | 0xD800));
                    value2 = table[tableStart + 1];
                } else {
                    value = table[tableStart + 1];
                    value2 = 0;
                }
            } else {
                value &= 0x1FFF;
                value2 = 0;
            }
            outValues[0] = value;
            outValues[1] = value2;
            return key;
        }
        return 0;
    }

    private static char recompose(RecomposeArgs args, int options, UnicodeSet nx) {
        int value = 0;
        int value2 = 0;
        int[] outValues = new int[2];
        int starter = -1;
        int combineFwdIndex = 0;
        boolean starterIsSupplementary = false;
        char prevCC = '\u0000';
        NextCombiningArgs ncArg = new NextCombiningArgs();
        ncArg.source = args.source;
        ncArg.cc = '\u0000';
        ncArg.c2 = '\u0000';
        while (true) {
            ncArg.start = args.start;
            int combineFlags = NormalizerImpl.getNextCombining(ncArg, args.limit, nx);
            int combineBackIndex = ncArg.combiningIndex;
            args.start = ncArg.start;
            if ((combineFlags & 0x80) != 0 && starter != -1) {
                int result;
                int r;
                int q;
                int remove;
                if ((combineBackIndex & 0x8000) != 0) {
                    if ((options & 0x100) != 0 || prevCC == '\u0000') {
                        remove = -1;
                        combineFlags = 0;
                        ncArg.c2 = args.source[starter];
                        if (combineBackIndex == 65522) {
                            ncArg.c2 = (char)(ncArg.c2 - 4352);
                            if (ncArg.c2 < '\u0013') {
                                remove = args.start - 1;
                                ncArg.c = (char)(44032 + (ncArg.c2 * 21 + (ncArg.c - 4449)) * 28);
                                if (args.start != args.limit && (ncArg.c2 = (char)(args.source[args.start] - 4519)) < '\u001c') {
                                    ++args.start;
                                    ncArg.c = (char)(ncArg.c + ncArg.c2);
                                } else {
                                    combineFlags = 64;
                                }
                                if (!NormalizerImpl.nx_contains(nx, ncArg.c)) {
                                    args.source[starter] = ncArg.c;
                                } else {
                                    if (!NormalizerImpl.isHangulWithoutJamoT(ncArg.c)) {
                                        --args.start;
                                    }
                                    remove = args.start;
                                }
                            }
                        } else if (NormalizerImpl.isHangulWithoutJamoT(ncArg.c2)) {
                            ncArg.c2 = (char)(ncArg.c2 + (ncArg.c - 4519));
                            if (!NormalizerImpl.nx_contains(nx, ncArg.c2)) {
                                remove = args.start - 1;
                                args.source[starter] = ncArg.c2;
                            }
                        }
                        if (remove != -1) {
                            q = remove;
                            r = args.start;
                            while (r < args.limit) {
                                args.source[q++] = args.source[r++];
                            }
                            args.start = remove;
                            args.limit = q;
                        }
                        ncArg.c2 = '\u0000';
                        if (combineFlags != 0) {
                            if (args.start == args.limit) {
                                return prevCC;
                            }
                            combineFwdIndex = 65520;
                            continue;
                        }
                    }
                } else if ((combineFwdIndex & 0x8000) == 0 && ((options & 0x100) != 0 ? prevCC != ncArg.cc || prevCC == '\u0000' : prevCC < ncArg.cc || prevCC == '\u0000') && (result = NormalizerImpl.combine(combiningTable, combineFwdIndex, combineBackIndex, outValues)) != 0 && !NormalizerImpl.nx_contains(nx, (char)value, (char)value2)) {
                    value = outValues[0];
                    value2 = outValues[1];
                    remove = ncArg.c2 == '\u0000' ? args.start - 1 : args.start - 2;
                    args.source[starter] = (char)value;
                    if (starterIsSupplementary) {
                        if (value2 != 0) {
                            args.source[starter + 1] = (char)value2;
                        } else {
                            starterIsSupplementary = false;
                            q = starter + 1;
                            r = q + 1;
                            while (r < remove) {
                                args.source[q++] = args.source[r++];
                            }
                            --remove;
                        }
                    } else if (value2 != 0) {
                        starterIsSupplementary = true;
                        ++starter;
                        q = remove++;
                        r = remove;
                        while (starter < q) {
                            args.source[--r] = args.source[--q];
                        }
                        args.source[starter] = (char)value2;
                        --starter;
                    }
                    if (remove < args.start) {
                        q = remove;
                        r = args.start;
                        while (r < args.limit) {
                            args.source[q++] = args.source[r++];
                        }
                        args.start = remove;
                        args.limit = q;
                    }
                    if (args.start == args.limit) {
                        return prevCC;
                    }
                    if (result > 1) {
                        combineFwdIndex = NormalizerImpl.getCombiningIndexFromStarter((char)value, (char)value2);
                        continue;
                    }
                    starter = -1;
                    continue;
                }
            }
            prevCC = ncArg.cc;
            if (args.start == args.limit) {
                return prevCC;
            }
            if (ncArg.cc == '\u0000') {
                if ((combineFlags & 0x40) != 0) {
                    if (ncArg.c2 == '\u0000') {
                        starterIsSupplementary = false;
                        starter = args.start - 1;
                    } else {
                        starterIsSupplementary = false;
                        starter = args.start - 2;
                    }
                    combineFwdIndex = combineBackIndex;
                    continue;
                }
                starter = -1;
                continue;
            }
            if ((options & 0x2000) == 0) continue;
            starter = -1;
        }
    }

    private static int findPreviousStarter(char[] src, int srcStart, int current, int ccOrQCMask, int decompQCMask, char minNoMaybe) {
        PrevArgs args = new PrevArgs();
        args.src = src;
        args.start = srcStart;
        args.current = current;
        while (args.start < args.current) {
            long norm32 = NormalizerImpl.getPrevNorm32(args, minNoMaybe, ccOrQCMask | decompQCMask);
            if (NormalizerImpl.isTrueStarter(norm32, ccOrQCMask, decompQCMask)) break;
        }
        return args.current;
    }

    private static int findNextStarter(char[] src, int start, int limit, int qcMask, int decompQCMask, char minNoMaybe) {
        long norm32;
        char c;
        int ccOrQCMask = 0xFF00 | qcMask;
        DecomposeArgs decompArgs = new DecomposeArgs();
        while (start != limit && (c = src[start]) >= minNoMaybe && ((norm32 = NormalizerImpl.getNorm32(c)) & (long)ccOrQCMask) != 0L) {
            char c2;
            if (NormalizerImpl.isNorm32LeadSurrogate(norm32)) {
                if (start + 1 == limit || !UTF16.isTrailSurrogate(c2 = src[start + 1]) || ((norm32 = NormalizerImpl.getNorm32FromSurrogatePair(norm32, c2)) & (long)ccOrQCMask) == 0L) {
                    break;
                }
            } else {
                c2 = '\u0000';
            }
            if ((norm32 & (long)decompQCMask) != 0L) {
                int p = NormalizerImpl.decompose(norm32, decompQCMask, decompArgs);
                if (decompArgs.cc == 0 && (NormalizerImpl.getNorm32(extraData, p, qcMask) & (long)qcMask) == 0L) break;
            }
            start += c2 == '\u0000' ? 1 : 2;
        }
        return start;
    }

    private static char[] composePart(ComposePartArgs args, int prevStarter, char[] src, int start, int limit, int options, UnicodeSet nx) {
        boolean compat = (options & 0x1000) != 0;
        int[] outTrailCC = new int[1];
        char[] buffer = new char[(limit - prevStarter) * 20];
        while (true) {
            args.length = NormalizerImpl.decompose(src, prevStarter, start, buffer, 0, buffer.length, compat, outTrailCC, nx);
            if (args.length <= buffer.length) break;
            buffer = new char[args.length];
        }
        int recomposeLimit = args.length;
        if (args.length >= 2) {
            RecomposeArgs rcArgs = new RecomposeArgs();
            rcArgs.source = buffer;
            rcArgs.start = 0;
            rcArgs.limit = recomposeLimit;
            args.prevCC = NormalizerImpl.recompose(rcArgs, options, nx);
            recomposeLimit = rcArgs.limit;
        }
        args.length = recomposeLimit;
        return buffer;
    }

    private static boolean composeHangul(char prev, char c, long norm32, char[] src, int[] srcIndex, int limit, boolean compat, char[] dest, int destIndex, UnicodeSet nx) {
        int start = srcIndex[0];
        if (NormalizerImpl.isJamoVTNorm32JamoV(norm32)) {
            if ((prev = (char)(prev - 4352)) < '\u0013') {
                c = (char)(44032 + (prev * 21 + (c - 4449)) * 28);
                if (start != limit) {
                    char next = src[start];
                    char t = (char)(next - 4519);
                    if (t < '\u001c') {
                        ++start;
                        c = (char)(c + t);
                    } else if (compat && NormalizerImpl.isNorm32Regular(norm32 = NormalizerImpl.getNorm32(next)) && (norm32 & 8L) != 0L) {
                        DecomposeArgs dcArgs = new DecomposeArgs();
                        int p = NormalizerImpl.decompose(norm32, 8, dcArgs);
                        if (dcArgs.length == 1 && (t = (char)(extraData[p] - 4519)) < '\u001c') {
                            ++start;
                            c = (char)(c + t);
                        }
                    }
                }
                if (NormalizerImpl.nx_contains(nx, c)) {
                    if (!NormalizerImpl.isHangulWithoutJamoT(c)) {
                        --start;
                    }
                    return false;
                }
                dest[destIndex] = c;
                srcIndex[0] = start;
                return true;
            }
        } else if (NormalizerImpl.isHangulWithoutJamoT(prev)) {
            if (NormalizerImpl.nx_contains(nx, c = (char)(prev + (c - 4519)))) {
                return false;
            }
            dest[destIndex] = c;
            srcIndex[0] = start;
            return true;
        }
        return false;
    }

    public static int compose(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, int options, UnicodeSet nx) {
        int qcMask;
        char minNoMaybe;
        int[] ioIndex = new int[1];
        int destIndex = destStart;
        int srcIndex = srcStart;
        if ((options & 0x1000) != 0) {
            minNoMaybe = (char)indexes[7];
            qcMask = 34;
        } else {
            minNoMaybe = (char)indexes[6];
            qcMask = 17;
        }
        int prevStarter = srcIndex;
        int ccOrQCMask = 0xFF00 | qcMask;
        int reorderStartIndex = 0;
        int prevCC = 0;
        long norm32 = 0L;
        char c = '\u0000';
        while (true) {
            char c2;
            int cc;
            int length;
            int prevSrc = srcIndex;
            while (srcIndex != srcLimit && ((c = src[srcIndex]) < minNoMaybe || ((norm32 = NormalizerImpl.getNorm32(c)) & (long)ccOrQCMask) == 0L)) {
                prevCC = 0;
                ++srcIndex;
            }
            if (srcIndex != prevSrc) {
                length = srcIndex - prevSrc;
                if (destIndex + length <= destLimit) {
                    System.arraycopy(src, prevSrc, dest, destIndex, length);
                }
                reorderStartIndex = destIndex += length;
                prevStarter = srcIndex - 1;
                if (UTF16.isTrailSurrogate(src[prevStarter]) && prevSrc < prevStarter && UTF16.isLeadSurrogate(src[prevStarter - 1])) {
                    --prevStarter;
                }
                prevSrc = srcIndex;
            }
            if (srcIndex == srcLimit) break;
            ++srcIndex;
            if (NormalizerImpl.isNorm32HangulOrJamo(norm32)) {
                cc = 0;
                prevCC = 0;
                reorderStartIndex = destIndex;
                ioIndex[0] = srcIndex;
                if (destIndex > 0 && NormalizerImpl.composeHangul(src[prevSrc - 1], c, norm32, src, ioIndex, srcLimit, (options & 0x1000) != 0, dest, destIndex <= destLimit ? destIndex - 1 : 0, nx)) {
                    prevStarter = srcIndex = ioIndex[0];
                    continue;
                }
                srcIndex = ioIndex[0];
                c2 = '\u0000';
                length = 1;
                prevStarter = prevSrc;
            } else {
                if (NormalizerImpl.isNorm32Regular(norm32)) {
                    c2 = '\u0000';
                    length = 1;
                } else if (srcIndex != srcLimit && UTF16.isTrailSurrogate(c2 = src[srcIndex])) {
                    ++srcIndex;
                    length = 2;
                    norm32 = NormalizerImpl.getNorm32FromSurrogatePair(norm32, c2);
                } else {
                    c2 = '\u0000';
                    length = 1;
                    norm32 = 0L;
                }
                ComposePartArgs args = new ComposePartArgs();
                if (NormalizerImpl.nx_contains(nx, c, c2)) {
                    cc = 0;
                } else if ((norm32 & (long)qcMask) == 0L) {
                    cc = (int)(0xFFL & norm32 >> 8);
                } else {
                    int decompQCMask = qcMask << 2 & 0xF;
                    if (NormalizerImpl.isTrueStarter(norm32, 0xFF00 | qcMask, decompQCMask)) {
                        prevStarter = prevSrc;
                    } else {
                        destIndex -= prevSrc - prevStarter;
                    }
                    srcIndex = NormalizerImpl.findNextStarter(src, srcIndex, srcLimit, qcMask, decompQCMask, minNoMaybe);
                    args.prevCC = prevCC;
                    args.length = length;
                    char[] p = NormalizerImpl.composePart(args, prevStarter, src, srcIndex, srcLimit, options, nx);
                    if (p == null) break;
                    prevCC = args.prevCC;
                    length = args.length;
                    if (destIndex + args.length <= destLimit) {
                        int i = 0;
                        while (i < args.length) {
                            dest[destIndex++] = p[i++];
                            --length;
                        }
                    } else {
                        destIndex += length;
                    }
                    prevStarter = srcIndex;
                    continue;
                }
            }
            if (destIndex + length <= destLimit) {
                if (cc != 0 && cc < prevCC) {
                    int reorderSplit = destIndex;
                    prevCC = NormalizerImpl.insertOrdered(dest, reorderStartIndex, reorderSplit, destIndex += length, c, c2, cc);
                    continue;
                }
                dest[destIndex++] = c;
                if (c2 != '\u0000') {
                    dest[destIndex++] = c2;
                }
                prevCC = cc;
                continue;
            }
            destIndex += length;
            prevCC = cc;
        }
        return destIndex - destStart;
    }

    private static int findSafeFCD(char[] src, int start, int limit, char fcd16) {
        char c;
        while ((fcd16 & 0xFF) != 0 && start != limit && (c = src[start]) >= '\u0300' && (fcd16 = NormalizerImpl.getFCD16(c)) != '\u0000') {
            char c2;
            if (!UTF16.isLeadSurrogate(c)) {
                if (fcd16 <= '\u00ff') break;
                ++start;
                continue;
            }
            if (start + 1 == limit || !UTF16.isTrailSurrogate(c2 = src[start + 1]) || (fcd16 = NormalizerImpl.getFCD16FromSurrogatePair(fcd16, c2)) <= '\u00ff') break;
            start += 2;
        }
        return start;
    }

    private static int decomposeFCD(char[] src, int start, int decompLimit, char[] dest, int[] destIndexArr, UnicodeSet nx) {
        int destIndex;
        char[] p = null;
        int pStart = -1;
        DecomposeArgs args = new DecomposeArgs();
        int reorderStartIndex = destIndex = destIndexArr[0];
        int prevCC = 0;
        while (start < decompLimit) {
            char c2;
            char c;
            long norm32;
            if (NormalizerImpl.isNorm32Regular(norm32 = NormalizerImpl.getNorm32(c = src[start++]))) {
                c2 = '\u0000';
                args.length = 1;
            } else if (start != decompLimit && UTF16.isTrailSurrogate(c2 = src[start])) {
                ++start;
                args.length = 2;
                norm32 = NormalizerImpl.getNorm32FromSurrogatePair(norm32, c2);
            } else {
                c2 = '\u0000';
                args.length = 1;
                norm32 = 0L;
            }
            if (NormalizerImpl.nx_contains(nx, c, c2)) {
                args.trailCC = 0;
                args.cc = 0;
                p = null;
            } else if ((norm32 & 4L) == 0L) {
                args.cc = args.trailCC = (int)(0xFFL & norm32 >> 8);
                p = null;
            } else {
                pStart = NormalizerImpl.decompose(norm32, args);
                p = extraData;
                if (args.length == 1) {
                    c = p[pStart];
                    c2 = '\u0000';
                    p = null;
                }
            }
            if (destIndex + args.length <= dest.length) {
                int reorderSplit = destIndex;
                if (p == null) {
                    if (args.cc != 0 && args.cc < prevCC) {
                        args.trailCC = NormalizerImpl.insertOrdered(dest, reorderStartIndex, reorderSplit, destIndex += args.length, c, c2, args.cc);
                    } else {
                        dest[destIndex++] = c;
                        if (c2 != '\u0000') {
                            dest[destIndex++] = c2;
                        }
                    }
                } else if (args.cc != 0 && args.cc < prevCC) {
                    destIndex += args.length;
                    args.trailCC = NormalizerImpl.mergeOrdered(dest, reorderStartIndex, reorderSplit, p, pStart, pStart + args.length);
                } else {
                    do {
                        dest[destIndex++] = p[pStart++];
                    } while (--args.length > 0);
                }
            } else {
                destIndex += args.length;
            }
            prevCC = args.trailCC;
            if (prevCC != 0) continue;
            reorderStartIndex = destIndex;
        }
        destIndexArr[0] = destIndex;
        return prevCC;
    }

    public static int makeFCD(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
        int decompStart = srcStart;
        int destIndex = destStart;
        int prevCC = 0;
        int c = 0;
        char fcd16 = '\u0000';
        int[] destIndexArr = new int[]{destIndex};
        while (true) {
            int cc;
            char c2;
            int length;
            int prevSrc = srcStart;
            while (srcStart != srcLimit) {
                c = src[srcStart];
                if (c < 768) {
                    prevCC = -c;
                } else {
                    fcd16 = NormalizerImpl.getFCD16((char)c);
                    if (fcd16 != '\u0000') break;
                    prevCC = 0;
                }
                ++srcStart;
            }
            if (srcStart != prevSrc) {
                length = srcStart - prevSrc;
                if (destIndex + length <= destLimit) {
                    System.arraycopy(src, prevSrc, dest, destIndex, length);
                }
                destIndex += length;
                prevSrc = srcStart;
                if (prevCC < 0) {
                    prevCC = !NormalizerImpl.nx_contains(nx, -prevCC) ? NormalizerImpl.getFCD16(-prevCC) & 0xFF : 0;
                    decompStart = prevSrc - 1;
                }
            }
            if (srcStart == srcLimit) break;
            if (prevCC == 0) {
                decompStart = prevSrc;
            }
            ++srcStart;
            if (UTF16.isLeadSurrogate((char)c)) {
                if (srcStart != srcLimit && UTF16.isTrailSurrogate(c2 = src[srcStart])) {
                    ++srcStart;
                    fcd16 = NormalizerImpl.getFCD16FromSurrogatePair(fcd16, c2);
                } else {
                    c2 = '\u0000';
                    fcd16 = '\u0000';
                }
            } else {
                c2 = '\u0000';
            }
            if (NormalizerImpl.nx_contains(nx, (char)c, c2)) {
                fcd16 = '\u0000';
            }
            if ((cc = fcd16 >> 8) == 0 || cc >= prevCC) {
                if (cc == 0) {
                    decompStart = prevSrc;
                }
                prevCC = fcd16 & 0xFF;
                int n = length = c2 == '\u0000' ? 1 : 2;
                if (destIndex + length <= destLimit) {
                    dest[destIndex++] = c;
                    if (c2 == '\u0000') continue;
                    dest[destIndex++] = c2;
                    continue;
                }
                destIndex += length;
                continue;
            }
            srcStart = NormalizerImpl.findSafeFCD(src, srcStart, srcLimit, fcd16);
            destIndexArr[0] = destIndex -= prevSrc - decompStart;
            prevCC = NormalizerImpl.decomposeFCD(src, decompStart, srcStart, dest, destIndexArr, nx);
            decompStart = srcStart;
            destIndex = destIndexArr[0];
        }
        return destIndex - destStart;
    }

    public static int getCombiningClass(int c) {
        long norm32 = NormalizerImpl.getNorm32(c);
        return (char)(norm32 >> 8 & 0xFFL);
    }

    public static boolean isFullCompositionExclusion(int c) {
        if (isFormatVersion_2_1) {
            char aux = AuxTrieImpl.auxTrie.getCodePointValue(c);
            return (aux & 0x400) != 0;
        }
        return false;
    }

    public static boolean isCanonSafeStart(int c) {
        if (isFormatVersion_2_1) {
            char aux = AuxTrieImpl.auxTrie.getCodePointValue(c);
            return (aux & 0x800) == 0;
        }
        return false;
    }

    public static boolean getCanonStartSet(int c, USerializedSet fillSet) {
        if (fillSet != null && canonStartSets != null) {
            char i = '\u0000';
            int[] indexes = (int[])canonStartSets[0];
            char[] startSets = (char[])canonStartSets[1];
            if (c <= 65535) {
                char[] table = (char[])canonStartSets[2];
                int start = 0;
                int limit = table.length;
                while (start < limit - 2) {
                    i = (char)((start + limit) / 4 * 2);
                    if (c < table[i]) {
                        limit = i;
                        continue;
                    }
                    start = i;
                }
                if (c == table[start]) {
                    i = table[start + 1];
                    if ((i & 0xC000) == 16384) {
                        i = (char)(i & 0x3FFF);
                        return fillSet.getSet(startSets, i - indexes.length);
                    }
                    fillSet.setToOne(i);
                    return true;
                }
            } else {
                char lowInt;
                char j = '\u0000';
                char[] table = (char[])canonStartSets[3];
                int start = 0;
                int limit = table.length;
                char high = (char)(c >> 16);
                char low = (char)c;
                while (start < limit - 3) {
                    i = (char)((start + limit) / 6 * 3);
                    j = (char)(table[i] & 0x1F);
                    char tableVal = table[i + '\u0001'];
                    lowInt = low;
                    if (high < j || tableVal > lowInt && high == j) {
                        limit = i;
                    } else {
                        start = i;
                    }
                    if (!ICUDebug.enabled()) continue;
                    System.err.println("\t\t j = " + Utility.hex((int)j, 4) + "\t i = " + Utility.hex((int)i, 4) + "\t high = " + Utility.hex(high) + "\t low = " + Utility.hex((int)lowInt, 4) + "\t table[i+1]: " + Utility.hex((int)tableVal, 4));
                }
                char h = table[start];
                char tableVal1 = table[start + 1];
                lowInt = low;
                if (high == (h & 0x1F) && lowInt == tableVal1) {
                    char tableVal2;
                    i = tableVal2 = table[start + 2];
                    if ((h & 0x8000) == 0) {
                        return fillSet.getSet(startSets, i - indexes.length);
                    }
                    int temp = (h & 0x1F00) << 8;
                    i = (char)(i | temp);
                    fillSet.setToOne(i);
                    return true;
                }
            }
        }
        return false;
    }

    public static int getFC_NFKC_Closure(int c, char[] dest) {
        int destCapacity = dest == null ? 0 : dest.length;
        int aux = AuxTrieImpl.auxTrie.getCodePointValue(c);
        if ((aux &= 0x3FF) != 0) {
            int length;
            int index = aux;
            char s = extraData[index];
            if (s < '\uff00') {
                length = 1;
            } else {
                length = s & 0xFF;
                ++index;
            }
            if (length > 0 && length <= destCapacity) {
                System.arraycopy(extraData, index, dest, 0, length);
            }
            return length;
        }
        return 0;
    }

    public static boolean isNFSkippable(int c, Normalizer.Mode mode, long mask) {
        long norm32 = NormalizerImpl.getNorm32(c);
        if ((norm32 & (mask &= 0xFFFFFFFFL)) != 0L) {
            return false;
        }
        if (mode == Normalizer.NFD || mode == Normalizer.NFKD || mode == Normalizer.NONE) {
            return true;
        }
        if ((norm32 & 4L) == 0L) {
            return true;
        }
        if (NormalizerImpl.isNorm32HangulOrJamo(norm32)) {
            return !NormalizerImpl.isHangulWithoutJamoT((char)c);
        }
        if (!isFormatVersion_2_2) {
            return false;
        }
        char aux = AuxTrieImpl.auxTrie.getCodePointValue(c);
        return ((long)aux & 0x1000L) == 0L;
    }

    public static UnicodeSet addPropertyStarts(UnicodeSet set) {
        TrieIterator normIter = new TrieIterator(NormTrieImpl.normTrie);
        RangeValueIterator.Element normResult = new RangeValueIterator.Element();
        while (normIter.next(normResult)) {
            set.add(normResult.start);
        }
        TrieIterator fcdIter = new TrieIterator(FCDTrieImpl.fcdTrie);
        RangeValueIterator.Element fcdResult = new RangeValueIterator.Element();
        while (fcdIter.next(fcdResult)) {
            set.add(fcdResult.start);
        }
        if (isFormatVersion_2_1) {
            TrieIterator auxIter = new TrieIterator(AuxTrieImpl.auxTrie);
            RangeValueIterator.Element auxResult = new RangeValueIterator.Element();
            while (auxIter.next(auxResult)) {
                set.add(auxResult.start);
            }
        }
        int c = 44032;
        while (c < 55204) {
            set.add(c);
            set.add(c + 1);
            c += 28;
        }
        set.add(55204);
        return set;
    }

    public static final int quickCheck(int c, int modeValue) {
        int[] nArray = new int[6];
        nArray[2] = 4;
        nArray[3] = 8;
        nArray[4] = 17;
        nArray[5] = 34;
        int[] qcMask = nArray;
        int norm32 = (int)NormalizerImpl.getNorm32(c) & qcMask[modeValue];
        if (norm32 == 0) {
            return 1;
        }
        if ((norm32 & 0xF) != 0) {
            return 0;
        }
        return 2;
    }

    public CharTrie getFCDTrie() {
        return FCDTrieImpl.fcdTrie;
    }

    private static int decompose(int c, char[] buffer) {
        int length = 0;
        long norm32 = 0xFFFFFFFFL & (long)NormTrieImpl.normTrie.getCodePointValue(c);
        if ((norm32 & 4L) != 0L) {
            if (NormalizerImpl.isNorm32HangulOrJamo(norm32)) {
                char c2 = (char)((c -= 44032) % 28);
                c /= 28;
                if (c2 > '\u0000') {
                    buffer[2] = (char)(4519 + c2);
                    length = 3;
                } else {
                    length = 2;
                }
                buffer[1] = (char)(4449 + c % 21);
                buffer[0] = (char)(4352 + c / 21);
                return length;
            }
            DecomposeArgs args = new DecomposeArgs();
            int index = NormalizerImpl.decompose(norm32, args);
            System.arraycopy(extraData, index, buffer, 0, args.length);
            return args.length;
        }
        return 0;
    }

    private static int foldCase(int c, char[] dest, int destStart, int destLimit, int options) {
        String src = UTF16.valueOf(c);
        String foldedStr = UCharacter.foldCase(src, options);
        char[] foldedC = foldedStr.toCharArray();
        int i = 0;
        while (i < foldedC.length) {
            if (destStart < destLimit) {
                dest[destStart] = foldedC[i];
            }
            ++destStart;
            ++i;
        }
        return c == UTF16.charAt(foldedStr, 0) ? -destStart : destStart;
    }

    public static int cmpEquivFold(String s1, String s2, int options) {
        return NormalizerImpl.cmpEquivFold(s1.toCharArray(), 0, s1.length(), s2.toCharArray(), 0, s2.length(), options);
    }

    public static int cmpEquivFold(char[] s1, int s1Start, int s1Limit, char[] s2, int s2Start, int s2Limit, int options) {
        char[] cSource1 = s1;
        char[] cSource2 = s2;
        CmpEquivLevel[] stack1 = new CmpEquivLevel[]{new CmpEquivLevel(), new CmpEquivLevel()};
        CmpEquivLevel[] stack2 = new CmpEquivLevel[]{new CmpEquivLevel(), new CmpEquivLevel()};
        char[] decomp1 = new char[8];
        char[] decomp2 = new char[8];
        char[] fold1 = new char[32];
        char[] fold2 = new char[32];
        int start1 = s1Start;
        int limit1 = s1Limit;
        int start2 = s2Start;
        int limit2 = s2Limit;
        int level2 = 0;
        int level1 = 0;
        int c2 = -1;
        int c1 = -1;
        int cp2 = -1;
        int cp1 = -1;
        while (true) {
            int length;
            char c;
            if (c1 < 0) {
                while (true) {
                    if (s1Start >= limit1) {
                        if (level1 == 0) {
                            c1 = -1;
                            break;
                        }
                    } else {
                        c1 = cSource1[s1Start];
                        ++s1Start;
                        break;
                    }
                    while ((start1 = stack1[--level1].start) == -1) {
                    }
                    s1Start = stack1[level1].s;
                    limit1 = stack1[level1].limit;
                    cSource1 = stack1[level1].source;
                }
            }
            if (c2 < 0) {
                while (true) {
                    if (s2Start >= limit2) {
                        if (level2 == 0) {
                            c2 = -1;
                            break;
                        }
                    } else {
                        c2 = cSource2[s2Start];
                        ++s2Start;
                        break;
                    }
                    while ((start2 = stack2[--level2].start) == -1) {
                    }
                    s2Start = stack2[level2].s;
                    limit2 = stack2[level2].limit;
                    cSource2 = stack2[level2].source;
                }
            }
            if (c1 == c2) {
                if (c1 < 0) {
                    return 0;
                }
                c2 = -1;
                c1 = -1;
                continue;
            }
            if (c1 < 0) {
                return -1;
            }
            if (c2 < 0) {
                return 1;
            }
            cp1 = c1;
            if (UTF16.isSurrogate((char)c1)) {
                if (UTF16.isLeadSurrogate((char)c1)) {
                    if (s1Start != limit1 && UTF16.isTrailSurrogate(c = cSource1[s1Start])) {
                        cp1 = UCharacterProperty.getRawSupplementary((char)c1, c);
                    }
                } else if (start1 <= s1Start - 2 && UTF16.isLeadSurrogate(c = cSource1[s1Start - 2])) {
                    cp1 = UCharacterProperty.getRawSupplementary(c, (char)c1);
                }
            }
            cp2 = c2;
            if (UTF16.isSurrogate((char)c2)) {
                if (UTF16.isLeadSurrogate((char)c2)) {
                    if (s2Start != limit2 && UTF16.isTrailSurrogate(c = cSource2[s2Start])) {
                        cp2 = UCharacterProperty.getRawSupplementary((char)c2, c);
                    }
                } else if (start2 <= s2Start - 2 && UTF16.isLeadSurrogate(c = cSource2[s2Start - 2])) {
                    cp2 = UCharacterProperty.getRawSupplementary(c, (char)c2);
                }
            }
            if (level1 < 2 && (options & 0x10000) != 0 && (length = NormalizerImpl.foldCase(cp1, fold1, 0, 32, options)) >= 0) {
                if (UTF16.isSurrogate((char)c1) && !UTF16.isLeadSurrogate((char)c1)) {
                    c2 = cSource2[--s2Start - 1];
                }
                stack1[0].start = start1;
                stack1[0].s = ++s1Start;
                stack1[0].limit = limit1;
                stack1[0].source = cSource1;
                ++level1;
                cSource1 = fold1;
                s1Start = 0;
                start1 = 0;
                limit1 = length;
                c1 = -1;
                continue;
            }
            if (level2 < 2 && (options & 0x10000) != 0 && (length = NormalizerImpl.foldCase(cp2, fold2, 0, 32, options)) >= 0) {
                if (UTF16.isSurrogate((char)c2) && !UTF16.isLeadSurrogate((char)c2)) {
                    c1 = cSource1[--s1Start - 1];
                }
                stack2[0].start = start2;
                stack2[0].s = ++s2Start;
                stack2[0].limit = limit2;
                stack2[0].source = cSource2;
                ++level2;
                cSource2 = fold2;
                s2Start = 0;
                start2 = 0;
                limit2 = length;
                c2 = -1;
                continue;
            }
            if (level1 < 2 && (options & 0x80000) != 0 && (length = NormalizerImpl.decompose(cp1, decomp1)) != 0) {
                if (UTF16.isSurrogate((char)c1) && !UTF16.isLeadSurrogate((char)c1)) {
                    c2 = cSource2[--s2Start - 1];
                }
                stack1[level1].start = start1;
                stack1[level1].s = ++s1Start;
                stack1[level1].limit = limit1;
                stack1[level1].source = cSource1;
                cSource1 = decomp1;
                s1Start = 0;
                start1 = 0;
                limit1 = length;
                if (++level1 < 2) {
                    stack1[level1++].start = -1;
                }
                c1 = -1;
                continue;
            }
            if (level2 >= 2 || (options & 0x80000) == 0 || (length = NormalizerImpl.decompose(cp2, decomp2)) == 0) break;
            if (UTF16.isSurrogate((char)c2) && !UTF16.isLeadSurrogate((char)c2)) {
                c1 = cSource1[--s1Start - 1];
            }
            stack2[level2].start = start2;
            stack2[level2].s = ++s2Start;
            stack2[level2].limit = limit2;
            stack2[level2].source = cSource2;
            cSource2 = decomp2;
            s2Start = 0;
            start2 = 0;
            limit2 = length;
            if (++level2 < 2) {
                stack2[level2++].start = -1;
            }
            c2 = -1;
        }
        if (c1 >= 55296 && c2 >= 55296 && (options & 0x8000) != 0) {
            if (!(c1 <= 56319 && s1Start != limit1 && UTF16.isTrailSurrogate(cSource1[s1Start]) || UTF16.isTrailSurrogate((char)c1) && start1 != s1Start - 1 && UTF16.isLeadSurrogate(cSource1[s1Start - 2]))) {
                c1 -= 10240;
            }
            if (!(c2 <= 56319 && s2Start != limit2 && UTF16.isTrailSurrogate(cSource2[s2Start]) || UTF16.isTrailSurrogate((char)c2) && start2 != s2Start - 1 && UTF16.isLeadSurrogate(cSource2[s2Start - 2]))) {
                c2 -= 10240;
            }
        }
        return c1 - c2;
    }

    private static int strCompare(char[] s1, int s1Start, int s1Limit, char[] s2, int s2Start, int s2Limit, boolean codePointOrder) {
        char c2;
        char c1;
        int limit1;
        int lengthResult;
        int start1 = s1Start;
        int start2 = s2Start;
        int length1 = s1Limit - s1Start;
        int length2 = s2Limit - s2Start;
        if (length1 < length2) {
            lengthResult = -1;
            limit1 = start1 + length1;
        } else if (length1 == length2) {
            lengthResult = 0;
            limit1 = start1 + length1;
        } else {
            lengthResult = 1;
            limit1 = start1 + length2;
        }
        if (s1 == s2) {
            return lengthResult;
        }
        while (true) {
            if (s1Start == limit1) {
                return lengthResult;
            }
            c1 = s1[s1Start];
            c2 = s2[s2Start];
            if (c1 != c2) break;
            ++s1Start;
            ++s2Start;
        }
        limit1 = start1 + length1;
        int limit2 = start2 + length2;
        if (c1 >= '\ud800' && c2 >= '\ud800' && codePointOrder) {
            if (!(c1 <= '\udbff' && s1Start + 1 != limit1 && UTF16.isTrailSurrogate(s1[s1Start + 1]) || UTF16.isTrailSurrogate(c1) && start1 != s1Start && UTF16.isLeadSurrogate(s1[s1Start - 1]))) {
                c1 = (char)(c1 - 10240);
            }
            if (!(c2 <= '\udbff' && s2Start + 1 != limit2 && UTF16.isTrailSurrogate(s2[s2Start + 1]) || UTF16.isTrailSurrogate(c2) && start2 != s2Start && UTF16.isLeadSurrogate(s2[s2Start - 1]))) {
                c2 = (char)(c2 - 10240);
            }
        }
        return c1 - c2;
    }

    private static final synchronized UnicodeSet internalGetNXHangul() {
        if (nxCache[1] == null) {
            NormalizerImpl.nxCache[1] = new UnicodeSet(44032, 55203);
        }
        return nxCache[1];
    }

    private static final synchronized UnicodeSet internalGetNXCJKCompat() {
        if (nxCache[2] == null) {
            UnicodeSet set = new UnicodeSet("[:Ideographic:]");
            UnicodeSet hasDecomp = new UnicodeSet();
            UnicodeSetIterator it = new UnicodeSetIterator(set);
            while (it.nextRange() && it.codepoint != UnicodeSetIterator.IS_STRING) {
                int start = it.codepoint;
                int end = it.codepointEnd;
                while (start <= end) {
                    long norm32 = NormalizerImpl.getNorm32(start);
                    if ((norm32 & 4L) > 0L) {
                        hasDecomp.add(start);
                    }
                    ++start;
                }
            }
            NormalizerImpl.nxCache[2] = hasDecomp;
        }
        return nxCache[2];
    }

    private static final synchronized UnicodeSet internalGetNXUnicode(int options) {
        if ((options &= 0xE0) == 0) {
            return null;
        }
        if (nxCache[options] == null) {
            UnicodeSet set = new UnicodeSet();
            switch (options) {
                case 32: {
                    set.applyPattern("[:^Age=3.2:]");
                    break;
                }
                default: {
                    return null;
                }
            }
            NormalizerImpl.nxCache[options] = set;
        }
        return nxCache[options];
    }

    private static final synchronized UnicodeSet internalGetNX(int options) {
        if (nxCache[options &= 0xFF] == null) {
            UnicodeSet other;
            if (options == 1) {
                return NormalizerImpl.internalGetNXHangul();
            }
            if (options == 2) {
                return NormalizerImpl.internalGetNXCJKCompat();
            }
            if ((options & 0xE0) != 0 && (options & 0x1F) == 0) {
                return NormalizerImpl.internalGetNXUnicode(options);
            }
            UnicodeSet set = new UnicodeSet();
            if ((options & 1) != 0 && (other = NormalizerImpl.internalGetNXHangul()) != null) {
                set.addAll(other);
            }
            if ((options & 2) != 0 && (other = NormalizerImpl.internalGetNXCJKCompat()) != null) {
                set.addAll(other);
            }
            if ((options & 0xE0) != 0 && (other = NormalizerImpl.internalGetNXUnicode(options)) != null) {
                set.addAll(other);
            }
            NormalizerImpl.nxCache[options] = set;
        }
        return nxCache[options];
    }

    public static final UnicodeSet getNX(int options) {
        if ((options &= 0xFF) == 0) {
            return null;
        }
        return NormalizerImpl.internalGetNX(options);
    }

    private static final boolean nx_contains(UnicodeSet nx, int c) {
        return nx != null && nx.contains(c);
    }

    private static final boolean nx_contains(UnicodeSet nx, char c, char c2) {
        return nx != null && nx.contains(c2 == '\u0000' ? c : UCharacterProperty.getRawSupplementary((char)c, c2));
    }

    static final class AuxTrieImpl
    implements Trie.DataManipulate {
        static CharTrie auxTrie = null;

        AuxTrieImpl() {
        }

        public int getFoldingOffset(int value) {
            return (value & 0x3FF) << 5;
        }
    }

    private static class CmpEquivLevel {
        char[] source;
        int start;
        int s;
        int limit;

        private CmpEquivLevel() {
        }
    }

    private static final class ComposePartArgs {
        int prevCC;
        int length;

        private ComposePartArgs() {
        }
    }

    private static final class DecomposeArgs {
        int cc;
        int trailCC;
        int length;

        private DecomposeArgs() {
        }
    }

    static final class FCDTrieImpl
    implements Trie.DataManipulate {
        static CharTrie fcdTrie = null;

        FCDTrieImpl() {
        }

        public int getFoldingOffset(int value) {
            return value;
        }
    }

    private static final class NextCCArgs {
        char[] source;
        int next;
        int limit;
        char c;
        char c2;

        private NextCCArgs() {
        }
    }

    private static final class NextCombiningArgs {
        char[] source;
        int start;
        char c;
        char c2;
        int combiningIndex;
        char cc;

        private NextCombiningArgs() {
        }
    }

    static final class NormTrieImpl
    implements Trie.DataManipulate {
        static IntTrie normTrie = null;

        NormTrieImpl() {
        }

        public int getFoldingOffset(int value) {
            return 2048 + (value >> 11 & 0x7FE0);
        }
    }

    private static final class PrevArgs {
        char[] src;
        int start;
        int current;
        char c;
        char c2;

        private PrevArgs() {
        }
    }

    private static final class RecomposeArgs {
        char[] source;
        int start;
        int limit;

        private RecomposeArgs() {
        }
    }
}

