/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.chart;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.model.attribute.LegendBehaviorType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.LegendLayoutSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.LegendTextSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart.LegendTitleSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ChartLegendSheetImpl
extends SubtaskSheetImpl
implements Listener,
SelectionListener {
    private Button btnVisible;
    private ExternalizedTextEditorComposite txtTitle;
    private Button btnTitleVisible;
    private Button btnShowValue;
    private org.eclipse.swt.widgets.Label lblTitle;
    private org.eclipse.swt.widgets.Label lblShowValue;
    private org.eclipse.swt.widgets.Label lblLegendBehavior;
    private Combo cmbLegendBehavior;

    public void createControl(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartLegend_ID");
        this.init();
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(2, false);
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Group cmpBasic = new Group(this.cmpContent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        cmpBasic.setLayout((Layout)layout);
        GridData gd2 = new GridData(768);
        cmpBasic.setLayoutData((Object)gd2);
        cmpBasic.setText(Messages.getString("ChartLegendSheetImpl.Label.Legend"));
        this.btnVisible = new Button((Composite)cmpBasic, 32);
        GridData gdBTNVisible = new GridData();
        gdBTNVisible.horizontalSpan = 3;
        this.btnVisible.setLayoutData((Object)gdBTNVisible);
        this.btnVisible.setText(Messages.getString("Shared.mne.Visibile_v"));
        this.btnVisible.setSelection(this.getChart().getLegend().isVisible());
        this.btnVisible.addSelectionListener((SelectionListener)this);
        this.lblTitle = new org.eclipse.swt.widgets.Label((Composite)cmpBasic, 0);
        this.lblTitle.setText(Messages.getString("ChartLegendSheetImpl.Label.Title"));
        List keys = null;
        if (this.getContext().getUIServiceProvider() != null) {
            keys = this.getContext().getUIServiceProvider().getRegisteredKeys();
        }
        this.txtTitle = new ExternalizedTextEditorComposite((Composite)cmpBasic, 2048, -1, -1, keys, this.getContext().getUIServiceProvider(), this.getChart().getLegend().getTitle().getCaption().getValue());
        gd2 = new GridData();
        gd2.widthHint = 180;
        this.txtTitle.setLayoutData(gd2);
        this.txtTitle.addListener(this);
        this.btnTitleVisible = new Button((Composite)cmpBasic, 32);
        this.btnTitleVisible.setText(Messages.getString("Shared.mne.Visibile_s"));
        this.btnTitleVisible.addSelectionListener((SelectionListener)this);
        this.btnTitleVisible.setSelection(this.getChart().getLegend().getTitle().isVisible());
        this.lblLegendBehavior = new org.eclipse.swt.widgets.Label((Composite)cmpBasic, 0);
        this.lblLegendBehavior.setText(Messages.getString("ChartLegendSheetImpl.Label.LegendBehaviorType"));
        this.cmbLegendBehavior = new Combo((Composite)cmpBasic, 12);
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        this.cmbLegendBehavior.setLayoutData((Object)gridData);
        this.cmbLegendBehavior.addSelectionListener((SelectionListener)this);
        this.cmbLegendBehavior.setEnabled(this.getChart().getInteractivity().isEnable());
        new org.eclipse.swt.widgets.Label((Composite)cmpBasic, 0);
        if (this.isShowValueEnabled()) {
            this.lblShowValue = new org.eclipse.swt.widgets.Label((Composite)cmpBasic, 0);
            this.lblShowValue.setText(Messages.getString("ChartLegendSheetImpl.Label.Value"));
            this.btnShowValue = new Button((Composite)cmpBasic, 32);
            GridData gdShowValue = new GridData();
            gdShowValue.horizontalSpan = 2;
            this.btnShowValue.setLayoutData((Object)gdShowValue);
            this.btnShowValue.setText(Messages.getString("ChartLegendSheetImpl.Label.ShowValue"));
            this.btnShowValue.setToolTipText(Messages.getString("ChartLegendSheetImpl.Tooltip.ShowDataPointValue"));
            this.btnShowValue.addSelectionListener((SelectionListener)this);
            this.btnShowValue.setSelection(this.getChart().getLegend().isShowValue());
        }
        this.populateLists();
        this.createButtonGroup(this.cmpContent);
        this.setState(this.getChart().getLegend().isVisible());
    }

    private void populateLists() {
        NameSet nameSet = LiteralHelper.legendBehaviorTypeSet;
        this.cmbLegendBehavior.setItems(nameSet.getDisplayNames());
        this.cmbLegendBehavior.select(nameSet.getSafeNameIndex(this.getChart().getInteractivity().getLegendBehavior().getName()));
    }

    private void setState(boolean enabled) {
        this.lblTitle.setEnabled(enabled);
        this.txtTitle.setEnabled(enabled && this.btnTitleVisible.getSelection());
        this.btnTitleVisible.setEnabled(enabled);
        if (this.isShowValueEnabled()) {
            this.lblShowValue.setEnabled(enabled);
            this.btnShowValue.setEnabled(enabled);
        }
        for (Button toggle : this.getToggleButtons()) {
            toggle.setEnabled(enabled && this.getContext().isEnabled("Chart.Legend" + toggle.getData()));
        }
        this.setToggleButtonEnabled(".Title", this.btnTitleVisible.getSelection() && enabled);
        this.setToggleButtonEnabled(".Interactivity", this.getChart().getInteractivity().isEnable() && enabled);
    }

    private boolean isShowValueEnabled() {
        return this.getChart().getLegend().getItemType() == LegendItemType.SERIES_LITERAL;
    }

    private void init() {
        if (this.getChart().getLegend().getTitle() == null) {
            Label label = LabelImpl.create();
            label.eAdapters().addAll((Collection)this.getChart().getLegend().eAdapters());
            this.getChart().getLegend().setTitle(label);
        }
    }

    private void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(5, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        AbstractPopupSheet popup = new LegendTitleSheet(Messages.getString("ChartLegendSheetImpl.Title.LegendTitle"), this.getContext());
        Button btnLegendTitle = this.createToggleButton(cmp, ".Title", Messages.getString("ChartLegendSheetImpl.Label.LegendTitle&"), popup, this.btnTitleVisible.getSelection());
        btnLegendTitle.addSelectionListener((SelectionListener)this);
        popup = new LegendLayoutSheet(Messages.getString("ChartLegendSheetImpl.Title.LegendLayout"), this.getContext());
        Button btnAreaProp = this.createToggleButton(cmp, ".Layout", Messages.getString("ChartLegendSheetImpl.Label.Layout"), popup);
        btnAreaProp.addSelectionListener((SelectionListener)this);
        popup = new LegendTextSheet(Messages.getString("ChartLegendSheetImpl.Title.LegendEntries"), this.getContext());
        Button btnLegendText = this.createToggleButton(cmp, ".Entries", Messages.getString("ChartLegendSheetImpl.Label.Entries"), popup);
        btnLegendText.addSelectionListener((SelectionListener)this);
        popup = new InteractivitySheet(Messages.getString("ChartLegendSheetImpl.Label.Interactivity"), this.getContext(), this.getChart().getLegend().getTriggers(), 16, false, true);
        Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup, this.getChart().getInteractivity().isEnable());
        btnInteractivity.addSelectionListener((SelectionListener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.txtTitle)) {
            this.getChart().getLegend().getTitle().getCaption().setValue(this.txtTitle.getText());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.btnVisible)) {
            this.getChart().getLegend().setVisible(this.btnVisible.getSelection());
            boolean enabled = this.btnVisible.getSelection();
            if (!enabled && this.isButtonSelected()) {
                this.detachPopup();
            }
            this.setState(enabled);
        } else if (e.widget.equals(this.btnTitleVisible)) {
            this.setToggleButtonEnabled(".Title", this.btnTitleVisible.getSelection());
            this.getChart().getLegend().getTitle().setVisible(((Button)e.widget).getSelection());
            this.txtTitle.setEnabled(this.getChart().getLegend().getTitle().isVisible());
            Button btnLegendTitle = this.getToggleButton(".Title");
            if (!this.btnTitleVisible.getSelection() && btnLegendTitle.getSelection()) {
                btnLegendTitle.setSelection(false);
                this.detachPopup();
            } else {
                this.refreshPopupSheet();
            }
        } else if (e.widget.equals(this.cmbLegendBehavior)) {
            this.getChart().getInteractivity().setLegendBehavior(LegendBehaviorType.getByName((String)LiteralHelper.legendBehaviorTypeSet.getNameByDisplayName(this.cmbLegendBehavior.getText())));
        } else if (e.widget.equals(this.btnShowValue)) {
            this.getChart().getLegend().setShowValue(((Button)e.widget).getSelection());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

