/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.series;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.datafeed.IDataPointDefinition;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierDialog;
import org.eclipse.birt.chart.ui.swt.composites.InsetsComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;

public class SeriesLabelSheet
extends AbstractPopupSheet
implements SelectionListener,
Listener {
    private Composite cmpContent = null;
    private Group grpDataPoint = null;
    private List lstComponents = null;
    private Combo cmbComponentTypes = null;
    private Button btnAddComponent = null;
    private Button btnRemoveComponent = null;
    private Button btnFormatSpecifier = null;
    private TextEditorComposite txtPrefix = null;
    private TextEditorComposite txtSuffix = null;
    private TextEditorComposite txtSeparator = null;
    private LineAttributesComposite liacOutline = null;
    private InsetsComposite icInsets = null;
    private SeriesDefinition seriesDefn = null;
    private Label lblPosition;
    private Combo cmbPosition;
    private Label lblFont;
    private FontDefinitionComposite fdcFont;
    private Label lblFill;
    private FillChooserComposite fccBackground;
    private Label lblShadow;
    private FillChooserComposite fccShadow;
    private Group grpAttributes;
    private Label lblPrefix;
    private Label lblSuffix;
    private Label lblSeparator;
    private Group grpOutline;
    private ChartWizardContext context;
    private Map<String, String> mapDataPointNames;
    private ArrayList<Integer> dataPointIndex;
    private IDataPointDefinition foDataPointDefinition;

    public SeriesLabelSheet(String title, ChartWizardContext context, SeriesDefinition seriesDefn) {
        super(title, context, true);
        this.seriesDefn = seriesDefn;
        this.context = context;
        this.mapDataPointNames = new HashMap<String, String>();
        this.dataPointIndex = new ArrayList();
    }

    public Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.DataPointLabels_ID");
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        this.cmpContent.setLayout((Layout)glContent);
        Composite cmpTop = new Composite(this.cmpContent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        cmpTop.setLayout((Layout)layout);
        cmpTop.setLayoutData((Object)new GridData(1808));
        Composite cmpLeft = new Composite(cmpTop, 0);
        cmpLeft.setLayout((Layout)new GridLayout());
        cmpLeft.setLayoutData((Object)new GridData(1808));
        Composite cmpRight = new Composite(cmpTop, 0);
        cmpRight.setLayout((Layout)new GridLayout());
        cmpRight.setLayoutData((Object)new GridData(1808));
        this.createAttributeArea(cmpLeft);
        this.grpOutline = new Group(cmpLeft, 0);
        GridData gdGOutline = new GridData(768);
        gdGOutline.heightHint = 110;
        this.grpOutline.setLayoutData((Object)gdGOutline);
        this.grpOutline.setText(Messages.getString("LabelAttributesComposite.Lbl.Outline"));
        this.grpOutline.setLayout((Layout)new FillLayout());
        this.liacOutline = new LineAttributesComposite((Composite)this.grpOutline, 0, this.getContext(), this.getSeriesForProcessing().getLabel().getOutline(), true, true, true);
        this.liacOutline.addListener(this);
        this.createDataPointArea(cmpRight);
        this.icInsets = new InsetsComposite(cmpRight, 0, this.getSeriesForProcessing().getLabel().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider());
        GridData gdICInsets = new GridData(768);
        gdICInsets.heightHint = this.icInsets.getPreferredSize().y;
        gdICInsets.grabExcessVerticalSpace = false;
        this.icInsets.setLayoutData(gdICInsets);
        this.icInsets.addListener(this);
        this.populateLists(this.getSeriesForProcessing());
        this.setEnabled(this.getSeriesForProcessing().getLabel().isVisible());
        this.refreshDataPointButtons();
        return this.cmpContent;
    }

    private void populateLists(Series series) {
        String[] componentsDisplayName = LiteralHelper.dataPointComponentTypeSet.getDisplayNames();
        boolean bException = false;
        try {
            this.mapDataPointNames.clear();
            this.foDataPointDefinition = PluginSettings.instance().getDataPointDefinition(this.getSeriesForProcessing().getClass());
            if (this.foDataPointDefinition != null) {
                String[] dpType = this.foDataPointDefinition.getDataPointTypes();
                String[] dpTypeDisplay = new String[dpType.length];
                int i = 0;
                while (i < dpType.length) {
                    dpTypeDisplay[i] = this.foDataPointDefinition.getDisplayText(dpType[i]);
                    this.mapDataPointNames.put(dpType[i], dpTypeDisplay[i]);
                    this.mapDataPointNames.put(dpTypeDisplay[i], dpType[i]);
                    ++i;
                }
                componentsDisplayName = this.concatenateArrays(dpTypeDisplay, componentsDisplayName);
            }
        }
        catch (ChartException e) {
            bException = true;
            WizardBase.showException((String)e.getLocalizedMessage());
        }
        if (!bException) {
            WizardBase.removeException();
        }
        this.cmbComponentTypes.setItems(componentsDisplayName);
        this.cmbComponentTypes.select(0);
        this.lstComponents.setItems(this.getDataPointComponents(series.getDataPoint()));
        String str = series.getDataPoint().getPrefix();
        this.txtPrefix.setText(str == null ? "" : str);
        str = series.getDataPoint().getSuffix();
        this.txtSuffix.setText(str == null ? "" : str);
        str = series.getDataPoint().getSeparator();
        this.txtSeparator.setText(str == null ? "" : str);
        int positionScope = ChartUIUtil.getPositionScopeOfSeriesLabel((Series)this.getSeriesForProcessing(), (ChartDimension)this.getContext().getModel().getDimension());
        this.cmbPosition.setItems(ChartUIUtil.getPositionDisplayNames((int)positionScope, (boolean)this.isFlippedAxes()));
        Position lpCurrent = this.getSeriesForProcessing().getLabelPosition();
        if (lpCurrent != null) {
            String positionName = ChartUIUtil.getFlippedPosition((Position)lpCurrent, (boolean)this.isFlippedAxes()).getName();
            int i = 0;
            while (i < this.cmbPosition.getItemCount()) {
                if (positionName.equals(LiteralHelper.fullPositionSet.getNameByDisplayName(this.cmbPosition.getItem(i)))) {
                    this.cmbPosition.select(i);
                }
                ++i;
            }
        }
        if (this.cmbPosition.getSelectionIndex() < 0) {
            this.cmbPosition.select(0);
            this.cmbPosition.notifyListeners(13, new Event());
        }
    }

    private String[] getDataPointComponents(DataPoint datapoint) {
        EList oArr = datapoint.getComponents();
        ArrayList<String> sArr = new ArrayList<String>(oArr.size());
        int i = 0;
        while (i < oArr.size()) {
            DataPointComponent dpc = (DataPointComponent)oArr.get(i);
            if (dpc.getOrthogonalType().length() == 0) {
                sArr.add(LiteralHelper.dataPointComponentTypeSet.getDisplayNameByName(dpc.getType().getName()));
                this.dataPointIndex.add(new Integer(i));
            } else if (this.mapDataPointNames.containsKey(dpc.getOrthogonalType())) {
                sArr.add(this.mapDataPointNames.get(dpc.getOrthogonalType()));
                this.dataPointIndex.add(new Integer(i));
            }
            ++i;
        }
        return sArr.toArray(new String[0]);
    }

    private void createAttributeArea(Composite parent) {
        this.grpAttributes = new Group(parent, 0);
        this.grpAttributes.setLayoutData((Object)new GridData(1808));
        this.grpAttributes.setLayout((Layout)new GridLayout(2, false));
        this.grpAttributes.setText(Messages.getString("SeriesLabelSheet.Label.Format"));
        this.lblPosition = new Label((Composite)this.grpAttributes, 0);
        GridData gdLBLPosition = new GridData();
        this.lblPosition.setLayoutData((Object)gdLBLPosition);
        this.lblPosition.setText(Messages.getString("LabelAttributesComposite.Lbl.Position"));
        this.cmbPosition = new Combo((Composite)this.grpAttributes, 12);
        GridData gdCMBPosition = new GridData(1808);
        this.cmbPosition.setLayoutData((Object)gdCMBPosition);
        this.cmbPosition.addSelectionListener((SelectionListener)this);
        this.lblFont = new Label((Composite)this.grpAttributes, 0);
        GridData gdLFont = new GridData();
        this.lblFont.setLayoutData((Object)gdLFont);
        this.lblFont.setText(Messages.getString("LabelAttributesComposite.Lbl.Font"));
        this.fdcFont = new FontDefinitionComposite((Composite)this.grpAttributes, 0, this.getContext(), this.getSeriesForProcessing().getLabel().getCaption().getFont(), this.getSeriesForProcessing().getLabel().getCaption().getColor(), false);
        GridData gdFDCFont = new GridData(1808);
        gdFDCFont.heightHint = this.fdcFont.getPreferredSize().y;
        gdFDCFont.widthHint = 96;
        gdFDCFont.grabExcessVerticalSpace = false;
        this.fdcFont.setLayoutData(gdFDCFont);
        this.fdcFont.addListener(this);
        this.lblFill = new Label((Composite)this.grpAttributes, 0);
        GridData gdLFill = new GridData();
        this.lblFill.setLayoutData((Object)gdLFill);
        this.lblFill.setText(Messages.getString("LabelAttributesComposite.Lbl.Background"));
        this.fccBackground = new FillChooserComposite((Composite)this.grpAttributes, 0, this.getContext(), this.getSeriesForProcessing().getLabel().getBackground(), false, false);
        GridData gdFCCBackground = new GridData(1808);
        gdFCCBackground.heightHint = this.fccBackground.getPreferredSize().y;
        this.fccBackground.setLayoutData(gdFCCBackground);
        this.fccBackground.addListener(this);
        this.lblShadow = new Label((Composite)this.grpAttributes, 0);
        GridData gdLBLShadow = new GridData();
        this.lblShadow.setLayoutData((Object)gdLBLShadow);
        this.lblShadow.setText(Messages.getString("LabelAttributesComposite.Lbl.Shadow"));
        this.fccShadow = new FillChooserComposite((Composite)this.grpAttributes, 0, this.getContext(), (Fill)this.getSeriesForProcessing().getLabel().getShadowColor(), false, false);
        GridData gdFCCShadow = new GridData(1808);
        this.fccShadow.setLayoutData(gdFCCShadow);
        this.fccShadow.addListener(this);
    }

    private void setEnabled(boolean bEnableUI) {
        this.grpOutline.setEnabled(bEnableUI);
        this.liacOutline.setAttributesEnabled(bEnableUI);
        this.icInsets.setEnabled(bEnableUI);
        this.grpAttributes.setEnabled(bEnableUI);
        this.lblPosition.setEnabled(bEnableUI);
        this.cmbPosition.setEnabled(bEnableUI);
        this.lblFont.setEnabled(bEnableUI);
        this.fdcFont.setEnabled(bEnableUI);
        this.lblFill.setEnabled(bEnableUI);
        this.fccBackground.setEnabled(bEnableUI);
        this.lblShadow.setEnabled(bEnableUI);
        this.fccShadow.setEnabled(bEnableUI);
    }

    private void createDataPointArea(Composite parent) {
        this.grpDataPoint = new Group(parent, 0);
        GridData gdCMPDataPoint = new GridData(1808);
        gdCMPDataPoint.heightHint = 160;
        this.grpDataPoint.setLayoutData((Object)gdCMPDataPoint);
        GridLayout glCMPDataPoint = new GridLayout();
        glCMPDataPoint.numColumns = 4;
        glCMPDataPoint.horizontalSpacing = 4;
        glCMPDataPoint.marginHeight = 2;
        glCMPDataPoint.marginWidth = 2;
        this.grpDataPoint.setLayout((Layout)glCMPDataPoint);
        this.grpDataPoint.setText(Messages.getString("SeriesLabelSheet.Label.Values"));
        this.lstComponents = new List((Composite)this.grpDataPoint, 2564);
        GridData gdLSTComponents = new GridData(1808);
        gdLSTComponents.horizontalSpan = 4;
        this.lstComponents.setLayoutData((Object)gdLSTComponents);
        this.lstComponents.addSelectionListener((SelectionListener)this);
        this.btnFormatSpecifier = new Button((Composite)this.grpDataPoint, 8);
        GridData gdBTNFormatSpecifier = new GridData();
        ChartUIUtil.setChartImageButtonSizeByPlatform((GridData)gdBTNFormatSpecifier);
        this.btnFormatSpecifier.setLayoutData((Object)gdBTNFormatSpecifier);
        this.btnFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
        this.btnFormatSpecifier.setImage(UIHelper.getImage((String)"icons/obj16/formatbuilder.gif"));
        this.btnFormatSpecifier.getImage().setBackground(this.btnFormatSpecifier.getBackground());
        this.btnFormatSpecifier.addSelectionListener((SelectionListener)this);
        this.btnRemoveComponent = new Button((Composite)this.grpDataPoint, 8);
        GridData gdBTNRemoveComponent = new GridData();
        this.btnRemoveComponent.setLayoutData((Object)gdBTNRemoveComponent);
        this.btnRemoveComponent.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Remove"));
        this.btnRemoveComponent.addSelectionListener((SelectionListener)this);
        this.btnAddComponent = new Button((Composite)this.grpDataPoint, 8);
        GridData gdBTNAddComponent = new GridData();
        this.btnAddComponent.setLayoutData((Object)gdBTNAddComponent);
        this.btnAddComponent.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Add"));
        this.btnAddComponent.addSelectionListener((SelectionListener)this);
        this.cmbComponentTypes = new Combo((Composite)this.grpDataPoint, 12);
        GridData gdCMBComponentTypes = new GridData(768);
        gdCMBComponentTypes.grabExcessHorizontalSpace = true;
        this.cmbComponentTypes.setLayoutData((Object)gdCMBComponentTypes);
        this.lblPrefix = new Label((Composite)this.grpDataPoint, 0);
        GridData gdLBLPrefix = new GridData();
        this.lblPrefix.setLayoutData((Object)gdLBLPrefix);
        this.lblPrefix.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Prefix"));
        this.txtPrefix = new TextEditorComposite((Composite)this.grpDataPoint, 2052);
        GridData gdTXTPrefix = new GridData(768);
        gdTXTPrefix.horizontalSpan = 3;
        this.txtPrefix.setLayoutData(gdTXTPrefix);
        this.txtPrefix.addListener(this);
        this.lblSuffix = new Label((Composite)this.grpDataPoint, 0);
        GridData gdLBLSuffix = new GridData();
        this.lblSuffix.setLayoutData((Object)gdLBLSuffix);
        this.lblSuffix.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Suffix"));
        this.txtSuffix = new TextEditorComposite((Composite)this.grpDataPoint, 2052);
        GridData gdTXTSuffix = new GridData(768);
        gdTXTSuffix.horizontalSpan = 3;
        this.txtSuffix.setLayoutData(gdTXTSuffix);
        this.txtSuffix.addListener(this);
        this.lblSeparator = new Label((Composite)this.grpDataPoint, 0);
        GridData gdLBLSeparator = new GridData();
        this.lblSeparator.setLayoutData((Object)gdLBLSeparator);
        this.lblSeparator.setText(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.Separator"));
        this.txtSeparator = new TextEditorComposite((Composite)this.grpDataPoint, 2052);
        GridData gdTXTSeparator = new GridData(768);
        gdTXTSeparator.horizontalSpan = 3;
        this.txtSeparator.setLayoutData(gdTXTSeparator);
        this.txtSeparator.addListener(this);
    }

    private Series getSeriesForProcessing() {
        return this.seriesDefn.getDesignTimeSeries();
    }

    private AxisType getAxisType(DataPointComponentType dpct) {
        if (dpct == DataPointComponentType.BASE_VALUE_LITERAL) {
            ChartWithAxes chart;
            if (this.context.getModel() instanceof ChartWithAxes && (chart = (ChartWithAxes)this.context.getModel()).getPrimaryBaseAxes().length > 0) {
                return chart.getPrimaryBaseAxes()[0].getType();
            }
        } else if (dpct == DataPointComponentType.ORTHOGONAL_VALUE_LITERAL) {
            Axis ax;
            ChartWithAxes chart;
            if (this.context.getModel() instanceof ChartWithAxes && (chart = (ChartWithAxes)this.context.getModel()).getPrimaryBaseAxes().length > 0 && (ax = chart.getPrimaryOrthogonalAxis(chart.getPrimaryBaseAxes()[0])) != null) {
                return ax.getType();
            }
        } else if (dpct == DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL) {
            return AxisType.LOGARITHMIC_LITERAL;
        }
        return null;
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fdcFont)) {
            this.getSeriesForProcessing().getLabel().getCaption().setFont((FontDefinition)((Object[])event.data)[0]);
            this.getSeriesForProcessing().getLabel().getCaption().setColor((ColorDefinition)((Object[])event.data)[1]);
        } else if (event.widget.equals((Object)this.liacOutline)) {
            switch (event.type) {
                case 1: {
                    this.getSeriesForProcessing().getLabel().getOutline().setStyle((LineStyle)event.data);
                    break;
                }
                case 2: {
                    this.getSeriesForProcessing().getLabel().getOutline().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 3: {
                    this.getSeriesForProcessing().getLabel().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    this.getSeriesForProcessing().getLabel().getOutline().setVisible(((Boolean)event.data).booleanValue());
                }
            }
        } else if (event.widget.equals((Object)this.fccBackground)) {
            this.getSeriesForProcessing().getLabel().setBackground((Fill)event.data);
        } else if (event.widget.equals((Object)this.fccShadow)) {
            this.getSeriesForProcessing().getLabel().setShadowColor((ColorDefinition)event.data);
        } else if (event.widget.equals((Object)this.icInsets)) {
            this.getSeriesForProcessing().getLabel().setInsets((Insets)event.data);
        } else if (event.widget.equals((Object)this.txtPrefix)) {
            this.getSeriesForProcessing().getDataPoint().setPrefix(this.txtPrefix.getText());
        } else if (event.widget.equals((Object)this.txtSuffix)) {
            this.getSeriesForProcessing().getDataPoint().setSuffix(this.txtSuffix.getText());
        } else if (event.widget.equals((Object)this.txtSeparator)) {
            this.getSeriesForProcessing().getDataPoint().setSeparator(this.txtSeparator.getText());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbPosition)) {
            if (this.context.getModel() instanceof ChartWithAxes) {
                this.getSeriesForProcessing().setLabelPosition(ChartUIUtil.getFlippedPosition((Position)Position.getByName((String)LiteralHelper.fullPositionSet.getNameByDisplayName(this.cmbPosition.getText())), (boolean)this.isFlippedAxes()));
            } else {
                this.getSeriesForProcessing().setLabelPosition(Position.getByName((String)LiteralHelper.fullPositionSet.getNameByDisplayName(this.cmbPosition.getText())));
            }
        } else if (e.getSource().equals(this.btnAddComponent)) {
            this.lstComponents.add(this.cmbComponentTypes.getText());
            this.addDataPointComponent(this.lstComponents.getItemCount() - 1);
            this.refreshDataPointButtons();
        } else if (e.getSource().equals(this.btnRemoveComponent)) {
            if (this.lstComponents.getSelectionCount() == 0) {
                return;
            }
            int iSelected = this.lstComponents.getSelectionIndices()[0];
            if (iSelected != -1) {
                this.removeDataPointComponent(iSelected);
                this.lstComponents.remove(iSelected);
            }
            this.refreshDataPointButtons();
        } else if (e.getSource().equals(this.btnFormatSpecifier)) {
            if (this.lstComponents.getSelectionCount() == 0) {
                return;
            }
            int iSelected = this.lstComponents.getSelectionIndices()[0];
            if (iSelected != -1) {
                this.setDataPointComponentFormatSpecifier(iSelected);
            }
        } else if (e.getSource().equals(this.lstComponents)) {
            this.refreshDataPointButtons();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void refreshDataPointButtons() {
        boolean formatEnable;
        this.btnRemoveComponent.setEnabled(this.lstComponents.getSelectionIndex() != -1);
        boolean bl = formatEnable = this.lstComponents.getSelectionIndex() != -1;
        if (formatEnable) {
            String sName = this.lstComponents.getItem(this.lstComponents.getSelectionIndex());
            String aa = LiteralHelper.dataPointComponentTypeSet.getNameByDisplayName(sName);
            DataPointComponentType dpct = DataPointComponentType.getByName((String)aa);
            if (dpct == DataPointComponentType.ORTHOGONAL_VALUE_LITERAL && this.mapDataPointNames != null && this.mapDataPointNames.size() > 0) {
                formatEnable = false;
            }
            if (dpct == DataPointComponentType.SERIES_VALUE_LITERAL) {
                formatEnable = false;
            } else if (this.getAxisType(dpct) == AxisType.TEXT_LITERAL) {
                formatEnable = false;
            } else if (dpct == null) {
                String sTypeName = this.mapDataPointNames.get(this.lstComponents.getItem(this.lstComponents.getSelectionIndex()));
                int iType = this.foDataPointDefinition.getCompatibleDataType(sTypeName);
                formatEnable = (iType & 9) != 0;
            }
        }
        this.btnFormatSpecifier.setEnabled(formatEnable);
    }

    private void addDataPointComponent(int iComponentIndex) {
        DataPoint dp = this.getSeriesForProcessing().getDataPoint();
        DataPointComponent dpc = null;
        String dpDisplayName = this.lstComponents.getItem(iComponentIndex);
        if (this.mapDataPointNames.containsKey(dpDisplayName)) {
            dpc = DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.ORTHOGONAL_VALUE_LITERAL, null);
            dpc.setOrthogonalType(this.mapDataPointNames.get(dpDisplayName));
        } else {
            DataPointComponentType dpct = DataPointComponentType.getByName((String)LiteralHelper.dataPointComponentTypeSet.getNameByDisplayName(this.lstComponents.getItem(iComponentIndex)));
            dpc = DataPointComponentImpl.create((DataPointComponentType)dpct, null);
            if (dpct == DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL) {
                JavaNumberFormatSpecifier fs = JavaNumberFormatSpecifierImpl.create((String)"##.##%");
                dpc.setFormatSpecifier((FormatSpecifier)fs);
            }
        }
        dpc.eAdapters().addAll((Collection)dp.eAdapters());
        dp.getComponents().add((Object)dpc);
        this.dataPointIndex.add(iComponentIndex, new Integer(dp.getComponents().size() - 1));
    }

    private void setDataPointComponentFormatSpecifier(int iComponentIndex) {
        DataPointComponent dpc = (DataPointComponent)this.getSeriesForProcessing().getDataPoint().getComponents().get(this.getIndexOfListItem(iComponentIndex));
        FormatSpecifier formatspecifier = dpc.getFormatSpecifier();
        String sContext = new MessageFormat(Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.SeriesDataPointComponent")).format(new Object[]{dpc.getType().getName()});
        if (sContext == null) {
            sContext = Messages.getString("OrthogonalSeriesAttributeSheetImpl.Lbl.SeriesDataPoint");
        }
        FormatSpecifierDialog editor = null;
        AxisType axisType = this.getAxisType(dpc.getType());
        boolean isAnyType = false;
        if (this.mapDataPointNames != null && this.mapDataPointNames.size() > 0) {
            int iType = this.foDataPointDefinition.getCompatibleDataType(this.mapDataPointNames.get(this.lstComponents.getItem(iComponentIndex)));
            isAnyType = (iType & 8) * (iType & 1) != 0;
        }
        if ((editor = axisType != null && !isAnyType ? new FormatSpecifierDialog(this.cmpContent.getShell(), formatspecifier, axisType, sContext) : new FormatSpecifierDialog(this.cmpContent.getShell(), formatspecifier, sContext)).open() == 0) {
            if (editor.getFormatSpecifier() == null) {
                dpc.eUnset((EStructuralFeature)AttributePackage.eINSTANCE.getDataPointComponent_FormatSpecifier());
                return;
            }
            dpc.setFormatSpecifier(editor.getFormatSpecifier());
        }
    }

    private int getIndexOfListItem(int indexOfListItem) {
        return this.dataPointIndex.get(indexOfListItem);
    }

    private void removeDataPointComponent(int iComponentIndex) {
        this.getSeriesForProcessing().getDataPoint().getComponents().remove(this.getIndexOfListItem(iComponentIndex));
        this.dataPointIndex.remove(iComponentIndex);
        if (this.dataPointIndex.size() != 0) {
            int i = iComponentIndex;
            while (i < this.dataPointIndex.size()) {
                this.dataPointIndex.set(i, new Integer(this.dataPointIndex.get(i) - 1));
                ++i;
            }
        }
    }

    private boolean isFlippedAxes() {
        return this.context.getModel() instanceof ChartWithAxes && ((ChartWithAxes)this.context.getModel()).getOrientation().equals(Orientation.HORIZONTAL_LITERAL);
    }

    private String[] concatenateArrays(String[] array1, String[] array2) {
        if (array1 == null || array2 == null) {
            return null;
        }
        String[] array = new String[array1.length + array2.length];
        int i = 0;
        while (i < array.length) {
            array[i] = i < array1.length ? array1[i] : array2[i - array1.length];
            ++i;
        }
        return array;
    }
}

