/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import com.ibm.icu.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.EllipsisHelper;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.LegendLayoutHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.SeriesNameFormat;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Direction;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;

public final class LegendBuilder
implements IConstants {
    private Size sz;

    private void initAvailableSize(LegendData legendData, IDisplayServer xs, Chart cm) throws ChartException {
        Legend lg = cm.getLegend();
        Block bl = cm.getBlock();
        Position lgPosition = lg.getPosition();
        Bounds boFull = bl.getBounds().scaledInstance(legendData.dScale);
        Insets ins = bl.getInsets().scaledInstance(legendData.dScale);
        Insets lgIns = lg.getInsets().scaledInstance(legendData.dScale);
        boolean titleWPos = false;
        boolean titleHPos = false;
        TitleBlock titleBlock = cm.getTitle();
        Bounds titleBounds = titleBlock.getBounds().scaledInstance(legendData.dScale);
        if (titleBlock.isVisible()) {
            switch (titleBlock.getAnchor().getValue()) {
                case 2: 
                case 6: {
                    titleWPos = true;
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    titleHPos = true;
                }
            }
        }
        legendData.dAvailableWidth = boFull.getWidth() - ins.getLeft() - ins.getRight() - lgIns.getLeft() - lgIns.getRight() - titleBounds.getWidth() * (double)titleWPos;
        legendData.dAvailableHeight = boFull.getHeight() - ins.getTop() - ins.getBottom() - lgIns.getTop() - lgIns.getBottom() - titleBounds.getHeight() * (double)titleHPos;
        double dMaxPercent = lg.getMaxPercent();
        if (dMaxPercent < 0.0 || dMaxPercent > 1.0) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, Messages.getString("exception.legend.orientation.InvalidMaxPercent"), Messages.getResourceBundle(xs.getULocale()));
        }
        double dMaxLegendWidth = boFull.getWidth() * dMaxPercent;
        double dMaxLegendHeight = boFull.getHeight() * dMaxPercent;
        switch (lgPosition.getValue()) {
            case 2: 
            case 3: 
            case 5: {
                if (!(legendData.dAvailableWidth > dMaxLegendWidth)) break;
                legendData.dAvailableWidth = dMaxLegendWidth;
                break;
            }
            case 0: 
            case 1: {
                if (!(legendData.dAvailableHeight > dMaxLegendHeight)) break;
                legendData.dAvailableHeight = dMaxLegendHeight;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Size compute(IDisplayServer xs, Chart cm, SeriesDefinition[] seda, RunTimeContext rtc) throws ChartException {
        ITextMetrics itm = null;
        try {
            Legend lg = cm.getLegend();
            LegendData legendData = new LegendData();
            if (!lg.isSetOrientation()) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.legend.orientation.horzvert", Messages.getResourceBundle(xs.getULocale()));
            }
            if (!lg.isSetDirection()) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.legend.direction.tblr", Messages.getResourceBundle(xs.getULocale()));
            }
            Orientation orientation = lg.getOrientation();
            Direction direction = lg.getDirection();
            boolean bPaletteByCategory = lg.getItemType().getValue() == 1;
            Label la = LabelImpl.create();
            la.setEllipsis(1);
            la.setCaption(TextImpl.copyInstance(lg.getText()));
            ClientArea ca = lg.getClientArea();
            LineAttributes lia = ca.getOutline();
            legendData.dSeparatorThickness = lia.getThickness();
            la.getCaption().setValue("X");
            itm = xs.getTextMetrics(la);
            legendData.dItemHeight = itm.getFullHeight();
            legendData.dScale = (double)xs.getDpiResolution() / 72.0;
            legendData.insCa = ca.getInsets().scaledInstance(legendData.dScale);
            legendData.maxWrappingSize = lg.getWrappingSize() * legendData.dScale;
            legendData.dHorizontalSpacing = 3.0 * legendData.dScale;
            legendData.dVerticalSpacing = 3.0 * legendData.dScale;
            legendData.dSafeSpacing = 3.0 * legendData.dScale;
            legendData.dHorizonalReservedSpace = legendData.insCa.getLeft() + legendData.insCa.getRight() + 3.0 * legendData.dItemHeight / 2.0 + legendData.dHorizontalSpacing;
            this.initAvailableSize(legendData, xs, cm);
            boolean bMinSliceDefined = false;
            if (cm instanceof ChartWithoutAxes) {
                bMinSliceDefined = ((ChartWithoutAxes)cm).isSetMinSlice();
                legendData.sMinSliceLabel = ((ChartWithoutAxes)cm).getMinSliceLabel();
                if (legendData.sMinSliceLabel == null || legendData.sMinSliceLabel.length() == 0) {
                    legendData.sMinSliceLabel = "";
                } else {
                    legendData.sMinSliceLabel = rtc.externalizedMessage(legendData.sMinSliceLabel);
                }
            }
            if (bMinSliceDefined && bPaletteByCategory && cm instanceof ChartWithoutAxes) {
                this.calculateExtraLegend(cm, rtc, legendData);
            }
            Label lgTitle = lg.getTitle();
            Size titleSize = null;
            BoundingBox titleBounding = null;
            int iTitlePos = -1;
            if (lgTitle != null && lgTitle.isSetVisible() && lgTitle.isVisible()) {
                lgTitle = LabelImpl.copyInstance(lgTitle);
                String sPreviousValue = lgTitle.getCaption().getValue();
                lgTitle.getCaption().setValue(rtc.externalizedMessage(sPreviousValue));
                try {
                    titleBounding = Methods.computeBox(xs, 4, lgTitle, 0.0, 0.0);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                }
                iTitlePos = lg.getTitlePosition().getValue();
                if (rtc.isRightToLeft()) {
                    if (iTitlePos == 2) {
                        iTitlePos = 3;
                    } else if (iTitlePos == 3) {
                        iTitlePos = 2;
                    }
                }
                double shadowness = 3.0 * legendData.dScale;
                switch (iTitlePos) {
                    case 0: 
                    case 1: {
                        LegendData legendData2 = legendData;
                        legendData2.dAvailableHeight = legendData2.dAvailableHeight - (titleBounding.getHeight() + 2.0 * shadowness);
                        break;
                    }
                    case 2: 
                    case 3: {
                        LegendData legendData3 = legendData;
                        legendData3.dAvailableWidth = legendData3.dAvailableWidth - (titleBounding.getWidth() + 2.0 * shadowness);
                    }
                }
                titleSize = SizeImpl.create(titleBounding.getWidth() + 2.0 * shadowness, titleBounding.getHeight() + 2.0 * shadowness);
            }
            double[] size = null;
            boolean bNeedInvert = this.needInvert(bPaletteByCategory, cm, seda);
            rtc.putState("[Legend]bNeedInvert", Boolean.toString(bNeedInvert));
            if (orientation.getValue() == 1) {
                if (bPaletteByCategory) {
                    size = this.computeVerticalByCategory(xs, cm, rtc, itm, la, legendData, bNeedInvert);
                } else if (direction.getValue() == 1) {
                    size = this.computeVerticalByValue(xs, cm, seda, rtc, itm, la, legendData, bNeedInvert, false);
                } else {
                    if (direction.getValue() != 0) throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.rendering.direction", new Object[]{direction.getName()}, Messages.getResourceBundle(xs.getULocale()));
                    size = this.computeVerticalByValue(xs, cm, seda, rtc, itm, la, legendData, bNeedInvert, true);
                }
            } else {
                if (orientation.getValue() != 0) throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.rendering.orientation", new Object[]{orientation}, Messages.getResourceBundle(xs.getULocale()));
                if (bPaletteByCategory) {
                    size = this.computeHorizalByCategory(xs, cm, rtc, itm, la, legendData, bNeedInvert);
                } else if (direction.getValue() == 1) {
                    size = this.computeHorizalByValue(xs, cm, seda, rtc, itm, la, legendData, bNeedInvert, false);
                } else {
                    if (direction.getValue() != 0) throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.rendering.direction", new Object[]{direction}, Messages.getResourceBundle(xs.getULocale()));
                    size = this.computeHorizalByValue(xs, cm, seda, rtc, itm, la, legendData, bNeedInvert, true);
                }
            }
            if (size == null) {
                Size size2 = SizeImpl.create(0.0, 0.0);
                return size2;
            }
            double dWidth = size[0];
            double dHeight = size[1];
            if (iTitlePos != -1) {
                double shadowness = 3.0 * legendData.dScale;
                switch (iTitlePos) {
                    case 0: 
                    case 1: {
                        dHeight += titleBounding.getHeight() + 2.0 * shadowness;
                        dWidth = Math.max(dWidth, titleBounding.getWidth() + 2.0 * shadowness);
                        break;
                    }
                    case 2: 
                    case 3: {
                        dWidth += titleBounding.getWidth() + 2.0 * shadowness;
                        dHeight = Math.max(dHeight, titleBounding.getHeight() + 2.0 * shadowness);
                    }
                }
            }
            if (rtc != null) {
                List legendItems = legendData.legendItems;
                LegendItemHints[] liha = legendItems.toArray(new LegendItemHints[legendItems.size()]);
                LegendLayoutHints lilh = new LegendLayoutHints(SizeImpl.create(dWidth, dHeight), titleSize, legendData.bMinSliceApplied, legendData.sMinSliceLabel, liha);
                rtc.setLegendLayoutHints(lilh);
            }
            this.sz = SizeImpl.create(dWidth, dHeight);
            return this.sz;
        }
        finally {
            itm.dispose();
        }
    }

    private void calculateExtraLegend(Chart cm, RunTimeContext rtc, LegendData legendData) throws ChartException {
        Map renders = rtc.getSeriesRenderers();
        if (renders != null && !((ChartWithoutAxes)cm).getSeriesDefinitions().isEmpty()) {
            SeriesDefinition sdBase = (SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0);
            EList sdA = sdBase.getSeriesDefinitions();
            SeriesDefinition[] sdOrtho = (SeriesDefinition[])sdA.toArray((Object[])new SeriesDefinition[sdA.size()]);
            DataSetIterator dsiOrtho = null;
            boolean started = false;
            int i = 0;
            block2: while (i < sdOrtho.length) {
                List sdRuntimeSA = sdOrtho[i].getRunTimeSeries();
                Series[] alRuntimeSeries = sdRuntimeSA.toArray(new Series[sdRuntimeSA.size()]);
                int j = 0;
                while (j < alRuntimeSeries.length) {
                    try {
                        dsiOrtho = new DataSetIterator(alRuntimeSeries[j].getDataSet());
                        LegendItemRenderingHints lirh = (LegendItemRenderingHints)renders.get(alRuntimeSeries[j]);
                        if (lirh == null) {
                            legendData.filteredMinSliceEntry = null;
                            break block2;
                        }
                        BaseRenderer br = lirh.getRenderer();
                        int[] fsa = br.getFilteredMinSliceEntry(dsiOrtho);
                        if (fsa != null && fsa.length > 0) {
                            legendData.bMinSliceApplied = true;
                        }
                        if (!started) {
                            started = true;
                            legendData.filteredMinSliceEntry = fsa;
                        } else {
                            legendData.filteredMinSliceEntry = LegendBuilder.getDuplicateIndices(fsa, legendData.filteredMinSliceEntry);
                            if (legendData.filteredMinSliceEntry == null || legendData.filteredMinSliceEntry.length == 0) {
                                legendData.filteredMinSliceEntry = null;
                                break block2;
                            }
                        }
                    }
                    catch (Exception ex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, ex);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (legendData.filteredMinSliceEntry == null) {
            legendData.filteredMinSliceEntry = new int[0];
        }
    }

    private double[] computeVerticalByCategory(IDisplayServer xs, Chart cm, RunTimeContext rtc, ITextMetrics itm, Label la, LegendData legendData, boolean bNeedInvert) throws ChartException {
        double dX = 0.0;
        double dY = 0.0;
        double dW = 0.0;
        double dH = 0.0;
        double dMaxW = 0.0;
        double dMaxH = 0.0;
        ArrayList<LegendItemHints> columnList = new ArrayList<LegendItemHints>();
        LabelItem laiLegend = new LabelItem(xs, rtc, itm, la, legendData.maxWrappingSize);
        SeriesDefinition sdBase = null;
        if (cm instanceof ChartWithAxes) {
            Axis axPrimaryBase = ((ChartWithAxes)cm).getBaseAxes()[0];
            if (axPrimaryBase.getSeriesDefinitions().isEmpty()) {
                return null;
            }
            sdBase = (SeriesDefinition)axPrimaryBase.getSeriesDefinitions().get(0);
        } else if (cm instanceof ChartWithoutAxes) {
            if (((ChartWithoutAxes)cm).getSeriesDefinitions().isEmpty()) {
                return null;
            }
            sdBase = (SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0);
        }
        if (sdBase.getRunTimeSeries().size() == 0) {
            return new double[]{0.0, 0.0};
        }
        Series seBase = (Series)sdBase.getRunTimeSeries().get(0);
        DataSetIterator dsiBase = this.createDataSetIterator(seBase, cm);
        FormatSpecifier fs = null;
        if (sdBase != null) {
            fs = sdBase.getFormatSpecifier();
        }
        int pos = -1;
        boolean bDataReverse = bNeedInvert;
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)cm;
            bDataReverse = ChartUtil.XOR(bNeedInvert, cwa.isReverseCategory());
        }
        dsiBase.reverse(bDataReverse);
        boolean bHasMoreData = true;
        block0: while (bHasMoreData) {
            int categoryIndex;
            if (dsiBase.hasNext()) {
                Object obj = dsiBase.next();
                obj = this.getNonEmptyValue(obj, " ");
                while (!this.isValidValue(obj) && dsiBase.hasNext()) {
                    obj = dsiBase.next();
                }
                if (legendData.bMinSliceApplied && Arrays.binarySearch(legendData.filteredMinSliceEntry, ++pos) >= 0) continue;
                laiLegend.setText(obj, fs);
                categoryIndex = 1;
            } else {
                if (!legendData.bMinSliceApplied) break;
                laiLegend.setText(legendData.sMinSliceLabel, null);
                categoryIndex = 5;
                bHasMoreData = false;
                ++pos;
            }
            boolean bRedo = true;
            int iLoopLimit = 2;
            while (bRedo && iLoopLimit > 0) {
                double[] dsize = this.getItemSizeCata(laiLegend, legendData, dX);
                dW = dsize[0];
                if (!LegendBuilder.hasPlaceForOneItem(dW, dH = dsize[1], legendData)) break block0;
                if (dX + dW > legendData.dAvailableWidth + legendData.dSafeSpacing) {
                    columnList.clear();
                    break block0;
                }
                if (dY + dH > legendData.dAvailableHeight + legendData.dSafeSpacing) {
                    legendData.legendItems.addAll(columnList);
                    columnList.clear();
                    dX += dMaxW;
                    dMaxH = Math.max(dMaxH, dY);
                    dY = 0.0;
                    dMaxW = 0.0;
                    bRedo = true;
                } else {
                    dMaxW = Math.max(dW, dMaxW);
                    dY += dH;
                    bRedo = false;
                }
                --iLoopLimit;
            }
            columnList.add(new LegendItemHints(categoryIndex, new Point(dX, dY - dH), dW - legendData.dHorizonalReservedSpace, laiLegend.getHeight(), laiLegend.getCaption(), bNeedInvert ? dsiBase.size() - 1 - pos : pos, sdBase, seBase));
        }
        legendData.legendItems.addAll(columnList);
        columnList.clear();
        double dWidth = dX + dMaxW;
        double dHeight = Math.max(dMaxH, dY);
        return new double[]{dWidth, dHeight};
    }

    private Object getNonEmptyValue(Object value, Object defaultValue) {
        if (value == null || value.toString().length() == 0) {
            return defaultValue;
        }
        return value;
    }

    private double[] computeVerticalByValue(IDisplayServer xs, Chart cm, SeriesDefinition[] seda, RunTimeContext rtc, ITextMetrics itm, Label la, LegendData legendData, boolean bNeedInvert, boolean bIsLeftRight) throws ChartException {
        double dX = 0.0;
        double dY = 0.0;
        double dMaxW = 0.0;
        double dMaxH = 0.0;
        ArrayList<LegendItemHints> columnList = new ArrayList<LegendItemHints>();
        LabelItem laiLegend = new LabelItem(xs, rtc, itm, la, legendData.maxWrappingSize);
        LabelItem laiValue = new LabelItem(laiLegend);
        ITextMetrics itm_v = xs.getTextMetrics(la);
        double dSeparatorThickness = legendData.dSeparatorThickness + (bIsLeftRight ? legendData.dHorizontalSpacing : legendData.dVerticalSpacing);
        int j = 0;
        block0: while (j < seda.length) {
            boolean bNotLastSeda;
            Object oGN;
            int iSedaId = bNeedInvert ? seda.length - 1 - j : j;
            SeriesNameFormat snFormat = SeriesNameFormat.getSeriesNameFormat(seda[iSedaId], rtc.getULocale());
            List al = seda[iSedaId].getRunTimeSeries();
            FormatSpecifier fs = seda[iSedaId].getFormatSpecifier();
            boolean oneVisibleSerie = false;
            LegendGroupNameProvider gnProvider = new LegendGroupNameProvider(seda, seda[iSedaId]);
            InvertibleIterator it = new InvertibleIterator(al, bNeedInvert);
            while ((oGN = gnProvider.getGroupName()) != null || it.hasNext()) {
                Object obj;
                Series se;
                boolean isGroupName = oGN != null;
                boolean bIsShowValue = cm.getLegend().isShowValue() && !isGroupName;
                Series series = se = isGroupName ? null : (Series)it.next();
                if (!isGroupName && !se.isVisible()) continue;
                oneVisibleSerie = true;
                String lgtext = null;
                String strExtText = null;
                if (isGroupName) {
                    obj = oGN;
                    lgtext = rtc.externalizedMessage(snFormat.format(obj));
                } else {
                    obj = se.getSeriesIdentifier();
                    lgtext = rtc.externalizedMessage(snFormat.format(obj));
                    strExtText = this.getValueText(cm, se);
                }
                double dW = 0.0;
                double dH = 0.0;
                laiLegend.setText(lgtext, fs);
                double dExtHeight = 0.0;
                if (bIsShowValue) {
                    Label seLabel = LabelImpl.copyInstance(se.getLabel());
                    laiValue.setLabel(seLabel, strExtText, fs, itm_v);
                }
                boolean bRedo = true;
                int iLoopLimit = 2;
                while (bRedo && iLoopLimit > 0) {
                    double[] dsize = isGroupName ? this.getItemSizeGN(laiLegend, legendData, dX) : this.getItemSize(laiLegend, laiValue, bIsShowValue, legendData, dX);
                    dW = dsize[0];
                    if (!LegendBuilder.hasPlaceForOneItem(dW, dH = dsize[1], legendData)) break block0;
                    if (dX + dW > legendData.dAvailableWidth + legendData.dSafeSpacing) {
                        columnList.clear();
                        break block0;
                    }
                    if (dY + dH > legendData.dAvailableHeight + legendData.dSafeSpacing) {
                        legendData.legendItems.addAll(columnList);
                        columnList.clear();
                        dX += dMaxW;
                        dMaxH = Math.max(dMaxH, dY);
                        dY = 0.0;
                        dMaxW = 0.0;
                        bRedo = true;
                    } else {
                        dMaxW = Math.max(dW, dMaxW);
                        dY += dH;
                        bRedo = false;
                    }
                    --iLoopLimit;
                }
                if (bIsShowValue) {
                    dExtHeight = laiValue.getHeight();
                    strExtText = laiValue.getCaption();
                }
                if (isGroupName) {
                    columnList.add(new LegendItemHints(4, new Point(dX, dY - dH + legendData.insCa.getTop()), dW, laiLegend.getHeight(), laiLegend.getCaption()));
                    continue;
                }
                columnList.add(new LegendItemHints(1, new Point(dX, dY - dH), dW - legendData.dHorizonalReservedSpace, laiLegend.getHeight(), laiLegend.getCaption(), dExtHeight, strExtText, it.getIndex(), seda[iSedaId], se));
            }
            legendData.legendItems.addAll(columnList);
            columnList.clear();
            boolean bl = bNotLastSeda = j < seda.length - 1;
            if (bIsLeftRight) {
                if (oneVisibleSerie) {
                    dX += dMaxW;
                    dMaxW = 0.0;
                    dMaxH = Math.max(dMaxH, dY);
                    if (bNotLastSeda && LegendBuilder.needSeparator(cm)) {
                        legendData.legendItems.add(new LegendItemHints(2, new Point((dX += dSeparatorThickness) - dSeparatorThickness / 2.0, 0.0), 0.0, dMaxH, null, 0.0, null));
                    }
                }
                dY = 0.0;
            } else if (oneVisibleSerie && bNotLastSeda && LegendBuilder.needSeparator(cm)) {
                legendData.legendItems.add(new LegendItemHints(2, new Point(dX, (dY += dSeparatorThickness) - dSeparatorThickness / 2.0), dMaxW - legendData.dHorizontalSpacing, 0.0, null, 0.0, null));
            }
            ++j;
        }
        columnList.clear();
        double dWidth = bIsLeftRight ? dX : dX + dMaxW;
        double dHeight = Math.max(dMaxH, dY);
        return new double[]{dWidth, dHeight};
    }

    private double[] computeHorizalByCategory(IDisplayServer xs, Chart cm, RunTimeContext rtc, ITextMetrics itm, Label la, LegendData legendData, boolean bNeedInvert) throws ChartException {
        double dX = 0.0;
        double dY = 0.0;
        double dW = 0.0;
        double dH = 0.0;
        double dMaxW = 0.0;
        double dMaxH = 0.0;
        ArrayList<LegendItemHints> columnList = new ArrayList<LegendItemHints>();
        LabelItem laiLegend = new LabelItem(xs, rtc, itm, la, legendData.maxWrappingSize);
        SeriesDefinition sdBase = null;
        if (cm instanceof ChartWithAxes) {
            Axis axPrimaryBase = ((ChartWithAxes)cm).getBaseAxes()[0];
            if (axPrimaryBase.getSeriesDefinitions().isEmpty()) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.base.axis.no.series.definitions", Messages.getResourceBundle(xs.getULocale()));
            }
            sdBase = (SeriesDefinition)axPrimaryBase.getSeriesDefinitions().get(0);
        } else if (cm instanceof ChartWithoutAxes) {
            if (((ChartWithoutAxes)cm).getSeriesDefinitions().isEmpty()) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.base.axis.no.series.definitions", Messages.getResourceBundle(xs.getULocale()));
            }
            sdBase = (SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0);
        }
        Series seBase = (Series)sdBase.getRunTimeSeries().get(0);
        DataSetIterator dsiBase = this.createDataSetIterator(seBase, cm);
        FormatSpecifier fs = null;
        if (sdBase != null) {
            fs = sdBase.getFormatSpecifier();
        }
        int pos = -1;
        boolean bDataReverse = bNeedInvert;
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)cm;
            bDataReverse = ChartUtil.XOR(bNeedInvert, cwa.isReverseCategory());
        }
        dsiBase.reverse(bDataReverse);
        boolean bHasMoreData = true;
        block0: while (bHasMoreData) {
            int categoryIndex;
            if (dsiBase.hasNext()) {
                Object obj = dsiBase.next();
                obj = this.getNonEmptyValue(obj, " ");
                while (!this.isValidValue(obj) && dsiBase.hasNext()) {
                    obj = dsiBase.next();
                }
                if (legendData.bMinSliceApplied && Arrays.binarySearch(legendData.filteredMinSliceEntry, ++pos) >= 0) continue;
                laiLegend.setText(obj, fs);
                categoryIndex = 1;
            } else {
                if (!legendData.bMinSliceApplied) break;
                laiLegend.setText(legendData.sMinSliceLabel, null);
                categoryIndex = 5;
                bHasMoreData = false;
                ++pos;
            }
            boolean bRedo = true;
            int iLoopLimit = 2;
            while (bRedo && iLoopLimit > 0) {
                double[] dsize = this.getItemSizeCata(laiLegend, legendData, dX);
                dW = dsize[0];
                if (!LegendBuilder.hasPlaceForOneItem(dW, dH = dsize[1], legendData)) break block0;
                if (dY + dH > legendData.dAvailableHeight + legendData.dSafeSpacing) {
                    columnList.clear();
                    break block0;
                }
                if (dX + dW > legendData.dAvailableWidth + legendData.dSafeSpacing) {
                    legendData.legendItems.addAll(columnList);
                    columnList.clear();
                    dY += dMaxH;
                    dMaxH = 0.0;
                    dMaxW = Math.max(dMaxW, dX);
                    dX = 0.0;
                    laiLegend.restoreOriginalText(fs);
                    bRedo = true;
                } else {
                    dMaxH = Math.max(dH, dMaxH);
                    dX += dW;
                    bRedo = false;
                }
                --iLoopLimit;
            }
            columnList.add(new LegendItemHints(categoryIndex, new Point(dX - dW, dY), dW - legendData.dHorizonalReservedSpace, laiLegend.getHeight(), laiLegend.getCaption(), bNeedInvert ? dsiBase.size() - 1 - pos : pos, sdBase, seBase));
        }
        legendData.legendItems.addAll(columnList);
        columnList.clear();
        double dHeight = dMaxH + dY;
        double dWidth = Math.max(dMaxW, dX);
        return new double[]{dWidth, dHeight};
    }

    private double[] computeHorizalByValue(IDisplayServer xs, Chart cm, SeriesDefinition[] seda, RunTimeContext rtc, ITextMetrics itm, Label la, LegendData legendData, boolean bNeedInvert, boolean bIsLeftRight) throws ChartException {
        double dX = 0.0;
        double dY = 0.0;
        double dMaxH = 0.0;
        double dMaxW = 0.0;
        ArrayList<LegendItemHints> columnList = new ArrayList<LegendItemHints>();
        LabelItem laiLegend = new LabelItem(xs, rtc, itm, la, legendData.maxWrappingSize);
        LabelItem laiValue = new LabelItem(laiLegend);
        ITextMetrics itm_v = xs.getTextMetrics(la);
        double dSeparatorThickness = legendData.dSeparatorThickness + (bIsLeftRight ? legendData.dHorizontalSpacing : legendData.dVerticalSpacing);
        LegendItemHints lihLastGN = null;
        int j = 0;
        block0: while (j < seda.length) {
            Object oGN;
            int iSedaId = bNeedInvert ? seda.length - 1 - j : j;
            SeriesNameFormat snFormat = SeriesNameFormat.getSeriesNameFormat(seda[iSedaId], rtc.getULocale());
            List al = seda[iSedaId].getRunTimeSeries();
            FormatSpecifier fs = seda[iSedaId].getFormatSpecifier();
            boolean oneVisibleSerie = false;
            LegendGroupNameProvider gnProvider = new LegendGroupNameProvider(seda, seda[iSedaId]);
            InvertibleIterator it = new InvertibleIterator(al, bNeedInvert);
            while ((oGN = gnProvider.getGroupName()) != null || it.hasNext()) {
                Object obj;
                Series se;
                boolean isGroupName = oGN != null;
                boolean bIsShowValue = cm.getLegend().isShowValue() && !isGroupName;
                Series series = se = isGroupName ? null : (Series)it.next();
                if (!isGroupName && !se.isVisible()) continue;
                oneVisibleSerie = true;
                String lgtext = null;
                String strExtText = null;
                if (isGroupName) {
                    obj = oGN;
                    lgtext = rtc.externalizedMessage(snFormat.format(obj));
                } else {
                    obj = se.getSeriesIdentifier();
                    lgtext = rtc.externalizedMessage(snFormat.format(obj));
                    strExtText = this.getValueText(cm, se);
                }
                double dW = 0.0;
                double dH = 0.0;
                laiLegend.setText(lgtext, fs);
                double dExtHeight = 0.0;
                if (bIsShowValue) {
                    Label seLabel = LabelImpl.copyInstance(se.getLabel());
                    laiValue.setLabel(seLabel, strExtText, fs, itm_v);
                }
                boolean bRedo = true;
                int iLoopLimit = 2;
                while (bRedo && iLoopLimit > 0) {
                    double[] dsize = isGroupName ? this.getItemSizeGN(laiLegend, legendData, dX) : this.getItemSize(laiLegend, laiValue, bIsShowValue, legendData, dX);
                    dW = dsize[0];
                    if (!LegendBuilder.hasPlaceForOneItem(dW, dH = dsize[1], legendData)) break block0;
                    if (dY + dH > legendData.dAvailableHeight + legendData.dSafeSpacing) {
                        columnList.clear();
                        break block0;
                    }
                    if (dX + dW > legendData.dAvailableWidth + legendData.dSafeSpacing) {
                        if (lihLastGN != null) {
                            lihLastGN.setHeight(dMaxH);
                            lihLastGN = null;
                        }
                        legendData.legendItems.addAll(columnList);
                        columnList.clear();
                        dY += dMaxH;
                        dMaxH = 0.0;
                        dMaxW = Math.max(dMaxW, dX);
                        dX = 0.0;
                        laiLegend.restoreOriginalText(fs);
                        if (bIsShowValue) {
                            laiValue.restoreOriginalText(fs);
                        }
                        bRedo = true;
                    } else {
                        dMaxH = Math.max(dH, dMaxH);
                        dX += dW;
                        bRedo = false;
                    }
                    --iLoopLimit;
                }
                if (bIsShowValue) {
                    dExtHeight = laiValue.getHeight();
                    strExtText = laiValue.getCaption();
                }
                if (isGroupName) {
                    lihLastGN = new LegendItemHints(4, new Point(dX - dW, dY), dW, dH - legendData.dVerticalSpacing, laiLegend.getCaption());
                    columnList.add(lihLastGN);
                    continue;
                }
                columnList.add(new LegendItemHints(1, new Point(dX - dW, dY), dW - legendData.dHorizonalReservedSpace, laiLegend.getHeight(), laiLegend.getCaption(), dExtHeight, strExtText, it.getIndex(), seda[iSedaId], se));
            }
            if (lihLastGN != null) {
                lihLastGN.setHeight(dMaxH);
                lihLastGN = null;
            }
            legendData.legendItems.addAll(columnList);
            columnList.clear();
            if (bIsLeftRight) {
                if (oneVisibleSerie && j < seda.length - 1 && LegendBuilder.needSeparator(cm)) {
                    legendData.legendItems.add(new LegendItemHints(2, new Point((dX += dSeparatorThickness) - dSeparatorThickness / 2.0, dY), 0.0, dMaxH - legendData.dVerticalSpacing, null, 0.0, null));
                }
            } else {
                dMaxW = Math.max(dMaxW, dX);
                if (oneVisibleSerie) {
                    dY += dMaxH;
                    if (j < seda.length - 1 && LegendBuilder.needSeparator(cm)) {
                        legendData.legendItems.add(new LegendItemHints(2, new Point(0.0, (dY += legendData.dSeparatorThickness) - legendData.dSeparatorThickness / 2.0), dMaxW, 0.0, null, 0.0, null));
                    }
                    dX = 0.0;
                }
            }
            ++j;
        }
        columnList.clear();
        double dHeight = bIsLeftRight ? dMaxH + dY : dY;
        double dWidth = Math.max(dMaxW, dX);
        return new double[]{dWidth, dHeight};
    }

    private static int[] getDuplicateIndices(int[] a1, int[] a2) {
        if (a1 == null || a2 == null || a1.length == 0 || a2.length == 0) {
            return null;
        }
        Arrays.sort(a1);
        Arrays.sort(a2);
        if (a1[a1.length - 1] < a2[0] || a1[0] > a2[a2.length - 1]) {
            return null;
        }
        if (a1.length > a2.length) {
            int[] tmp = a1;
            a1 = a2;
            a2 = tmp;
        }
        ArrayList<Integer> dup = new ArrayList<Integer>();
        int i = 0;
        while (i < a1.length) {
            if (Arrays.binarySearch(a2, a1[i]) >= 0) {
                dup.add(new Integer(a1[i]));
            }
            ++i;
        }
        if (dup.size() == 0) {
            return null;
        }
        int[] pia = new int[dup.size()];
        int i2 = 0;
        while (i2 < pia.length) {
            pia[i2] = (Integer)dup.get(i2);
            ++i2;
        }
        return pia;
    }

    public final Size getSize() {
        return this.sz;
    }

    private static boolean hasPlaceForOneItem(double dItemWidth, double dItemHeight, LegendData legendData) {
        return dItemWidth <= legendData.dAvailableWidth && dItemHeight <= legendData.dAvailableHeight;
    }

    private String getValueText(Chart cm, Series se) throws ChartException {
        DataSetIterator dsiBase;
        String strValueText = null;
        if (cm.getLegend().isShowValue() && (dsiBase = this.createDataSetIterator(se, cm)).hasNext()) {
            Object obj = dsiBase.next();
            while (!this.isValidValue(obj) && dsiBase.hasNext()) {
                obj = dsiBase.next();
            }
            strValueText = String.valueOf(obj);
        }
        return strValueText;
    }

    private double[] getItemSize(LabelItem laiLegend, LabelItem laiValue, boolean bIsShowValue, LegendData legendData, double dX) throws ChartException {
        double dWidth = 0.0;
        double dHeight = 0.0;
        laiLegend.checkEllipsis(LegendBuilder.getWidthLimit(dX, legendData));
        dWidth = laiLegend.getWidth() + legendData.dHorizonalReservedSpace;
        dHeight = legendData.insCa.getTop() + laiLegend.getHeight() + legendData.insCa.getBottom();
        if (bIsShowValue) {
            laiValue.checkEllipsis(legendData.dAvailableWidth - dX);
            dWidth = Math.max(dWidth, laiValue.getWidth());
            dHeight += laiValue.getHeight() + 2.0 * legendData.dScale;
        }
        return new double[]{dWidth, dHeight};
    }

    private double[] getItemSizeGN(LabelItem laiLegend, LegendData legendData, double dX) throws ChartException {
        double dWidth = 0.0;
        double dHeight = 0.0;
        laiLegend.checkEllipsis(legendData.dAvailableWidth - dX);
        dWidth = laiLegend.getWidth();
        dHeight = laiLegend.getHeight();
        return new double[]{dWidth, dHeight};
    }

    private double[] getItemSizeCata(LabelItem laiLegend, LegendData legendData, double dX) throws ChartException {
        double dWidth = 0.0;
        double dHeight = 0.0;
        laiLegend.checkEllipsis(LegendBuilder.getWidthLimit(dX, legendData));
        dWidth = laiLegend.getWidth();
        dHeight = legendData.insCa.getTop() + laiLegend.getHeight() + legendData.insCa.getBottom();
        return new double[]{dWidth += legendData.dHorizonalReservedSpace, dHeight};
    }

    private static double getWidthLimit(double dX, LegendData legendData) {
        return legendData.dAvailableWidth - legendData.dHorizonalReservedSpace - dX;
    }

    private boolean isValidValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Double) {
            return !((Double)obj).isNaN() && !((Double)obj).isInfinite();
        }
        if (obj instanceof String) {
            return ((String)obj).length() != 0;
        }
        return true;
    }

    private boolean isStacked(SeriesDefinition[] seda) {
        boolean bIsStack = true;
        int i = 0;
        while (i < seda.length) {
            if (bIsStack) {
                for (Series series : seda[i].getSeries()) {
                    if (series.isStacked()) continue;
                    bIsStack = false;
                    break;
                }
            }
            ++i;
        }
        return bIsStack;
    }

    private boolean needInvert(boolean bPaletteByCategory, Chart cm, SeriesDefinition[] seda) {
        boolean bNeedInvert = false;
        if (!(cm instanceof ChartWithAxes)) {
            return false;
        }
        boolean bIsStacked = this.isStacked(seda);
        boolean bIsFliped = ((ChartWithAxes)cm).isTransposed();
        bNeedInvert = bPaletteByCategory ? bIsFliped : bIsStacked && !bIsFliped || !bIsStacked && bIsFliped;
        return bNeedInvert;
    }

    private static boolean needSeparator(Chart cm) {
        return cm.getLegend().getSeparator() == null || cm.getLegend().getSeparator().isVisible();
    }

    private DataSetIterator createDataSetIterator(Series se, Chart cm) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(se.getDataSet());
            if (cm instanceof ChartWithAxes) {
                dsi.reverse(((ChartWithAxes)cm).isReverseCategory());
            }
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
        }
        return dsi;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvertibleIterator
    implements Iterator<Object> {
        private boolean isInverse_ = false;
        private ListIterator<?> lit_ = null;
        private int index_ = -1;

        public InvertibleIterator(List<?> tList, boolean isInverse, int index) {
            this.lit_ = tList.listIterator(index);
            this.isInverse_ = isInverse;
            this.index_ = isInverse ? this.lit_.previousIndex() : this.lit_.nextIndex();
        }

        public InvertibleIterator(List<?> tList, boolean isInverse) {
            this(tList, isInverse, isInverse ? tList.size() : 0);
        }

        @Override
        public boolean hasNext() {
            return this.isInverse_ ? this.lit_.hasPrevious() : this.lit_.hasNext();
        }

        @Override
        public final Object next() throws NoSuchElementException {
            if (this.isInverse_) {
                this.index_ = this.lit_.previousIndex();
                return this.lit_.previous();
            }
            this.index_ = this.lit_.nextIndex();
            return this.lit_.next();
        }

        @Override
        public void remove() {
        }

        public int getIndex() {
            return this.index_;
        }

        public boolean getInverse() {
            return this.isInverse_;
        }

        public void setInverse(boolean isInverse) {
            this.isInverse_ = isInverse;
        }
    }

    private class LabelItem
    implements EllipsisHelper.ILabelVisibilityTester {
        public static final String ELLIPSIS_STRING = "...";
        private IDisplayServer xs;
        private RunTimeContext rtc;
        private ITextMetrics itm;
        private Label la;
        private String text;
        private double maxWrappingSize = 0.0;
        private double dEllipsisWidth;
        BoundingBox bb = null;
        EllipsisHelper eHelper;

        public LabelItem(IDisplayServer xs_, RunTimeContext rtc_, ITextMetrics itm_, Label la_, double maxWrappingSize_) {
            this.xs = xs_;
            this.rtc = rtc_;
            this.itm = itm_;
            this.la = la_;
            this.maxWrappingSize = maxWrappingSize_;
            this.updateEllipsisWidth();
            this.eHelper = new EllipsisHelper(this, la_.getEllipsis());
        }

        public LabelItem(IDisplayServer xs_, RunTimeContext rtc_, ITextMetrics itm_, Label la_) {
            this(xs_, rtc_, itm_, la_, 0.0);
        }

        public LabelItem(LabelItem original) {
            this.xs = original.xs;
            this.rtc = original.rtc;
            this.itm = original.itm;
            this.la = original.la;
            this.text = original.text;
            this.maxWrappingSize = original.maxWrappingSize;
            this.dEllipsisWidth = original.dEllipsisWidth;
            this.bb = original.bb;
            this.eHelper = new EllipsisHelper(this, this.la.getEllipsis());
        }

        public void setText(Object oText, FormatSpecifier fs) throws ChartException {
            DecimalFormat df = null;
            if (fs == null && oText instanceof Number) {
                df = new DecimalFormat(ValueFormatter.getNumericPattern(((Number)oText).doubleValue()));
            }
            try {
                this.text = ValueFormatter.format(oText, fs, this.rtc.getULocale(), df);
            }
            catch (ChartException chartException) {
                this.text = oText.toString();
            }
            this.updateLabel(this.text);
        }

        public void restoreOriginalText(FormatSpecifier fs) throws ChartException {
            this.setText(this.text, fs);
        }

        public void setLabel(Label la_, String text_, FormatSpecifier fs) throws ChartException {
            this.la = la_;
            this.updateEllipsisWidth();
            this.setText(text_, fs);
        }

        public void setLabel(Label la_, String text_, FormatSpecifier fs, ITextMetrics itm_) throws ChartException {
            this.itm = itm_;
            this.setLabel(la_, text_, fs);
        }

        public boolean testLabelVisible(String strNew, Object oPara) throws ChartException {
            double dWidthLimit = (Double)oPara;
            this.updateLabel(strNew);
            return this.getWidth() <= dWidthLimit;
        }

        public boolean checkEllipsis(double dWidthLimit) throws ChartException {
            if (dWidthLimit < this.dEllipsisWidth) {
                return false;
            }
            double dWidth = this.getWidth();
            if (dWidth <= dWidthLimit) {
                return true;
            }
            return this.eHelper.checkLabelEllipsis(this.text, new Double(dWidthLimit));
        }

        public double getWidth() {
            return this.bb.getWidth();
        }

        public double getHeight() {
            return this.bb.getHeight();
        }

        public String getCaption() {
            return this.la.getCaption().getValue();
        }

        private void updateLabel(String strText) throws ChartException {
            this.la.getCaption().setValue(strText);
            this.itm.reuse(this.la, this.maxWrappingSize);
            this.updateSize();
        }

        private void updateSize() throws ChartException {
            try {
                this.bb = Methods.computeBox(this.xs, 4, this.la, 0.0, 0.0);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
            }
        }

        private void updateEllipsisWidth() {
            this.la.getCaption().setValue(ELLIPSIS_STRING);
            this.itm.reuse(this.la);
            this.dEllipsisWidth = this.itm.getFullWidth();
        }
    }

    private class LegendData {
        private boolean bMinSliceApplied;
        private int[] filteredMinSliceEntry;
        private double maxWrappingSize;
        private double dHorizonalReservedSpace;
        private double dAvailableWidth;
        private double dAvailableHeight;
        private double dItemHeight;
        private double dVerticalSpacing;
        private double dHorizontalSpacing;
        private double dScale;
        private double dSeparatorThickness;
        private double dSafeSpacing;
        private List<LegendItemHints> legendItems = new ArrayList<LegendItemHints>();
        private Insets insCa;
        private String sMinSliceLabel;

        private LegendData() {
        }
    }

    private static class LegendGroupNameProvider {
        private boolean bProvided = false;
        private Object oGroupName = null;

        public LegendGroupNameProvider(SeriesDefinition[] seda, SeriesDefinition sed) {
            if (LegendGroupNameProvider.needToShowGroupName(seda, sed)) {
                this.oGroupName = LegendGroupNameProvider.getGroupName(sed);
            }
        }

        private static boolean needToShowGroupName(SeriesDefinition[] seda, SeriesDefinition sed) {
            if (seda == null || seda.length <= 1 || sed.getQuery() == null || sed.getQuery().getDefinition() == null || sed.getQuery().getDefinition().trim() == "") {
                return false;
            }
            List alRun = sed.getRunTimeSeries();
            if (alRun.size() < 1) {
                return false;
            }
            Series seDesign = sed.getDesignTimeSeries();
            Series seRun = (Series)alRun.get(0);
            if (seDesign == null || alRun.size() > 1) {
                return true;
            }
            return !seDesign.getSeriesIdentifier().equals(seRun.getSeriesIdentifier());
        }

        private static Object getGroupName(SeriesDefinition sed) {
            Object sGN = "";
            if (sed.getDesignTimeSeries() != null) {
                sGN = sed.getDesignTimeSeries().getSeriesIdentifier();
            }
            return sGN;
        }

        public Object getGroupName() {
            if (!this.bProvided) {
                this.bProvided = true;
                return this.oGroupName;
            }
            return null;
        }
    }
}

