/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.EllipsisHelper;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.component.Label;

class SimpleTester
implements EllipsisHelper.ILabelVisibilityTester {
    private final IDisplayServer xs;
    private final Label la;
    private final double maxWidth;
    private final double maxHeight;
    private final ITextMetrics itm;
    private final double maxWrappingSize;

    public SimpleTester(IDisplayServer xs, Label la, double maxWidth, double maxHeight, double maxWrappingSize) {
        this.xs = xs;
        this.la = la;
        this.itm = xs.getTextMetrics(la);
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.maxWrappingSize = maxWrappingSize;
    }

    public boolean testLabelVisible(String strNew, Object para) throws ChartException {
        this.la.getCaption().setValue(strNew);
        this.itm.reuse(this.la, this.maxWrappingSize);
        try {
            BoundingBox bb = Methods.computeBox(this.xs, 4, this.la, 0.0, 0.0);
            return bb.getWidth() <= this.maxWidth && bb.getHeight() <= this.maxHeight;
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
        }
    }
}

