/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.chart.aggregate;

import java.util.HashSet;
import java.util.Set;

/**
 * 
 */

public class DistinctCount extends AggregateFunctionAdapter
{
	private Set uniqueValues;

	public void accumulate( Object oValue ) throws IllegalArgumentException
	{
		uniqueValues.add( oValue );
	}

	public Object getAggregatedValue( )
	{
		return new Integer( uniqueValues.size( ) );
	}

	public void initialize( )
	{
		uniqueValues = new HashSet( );
	}

}
