/*******************************************************************************
 * Copyright (c) 2007 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.chart.ui.swt.interfaces;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/**
 * Data sheet integration interface for chart builder. Implement this UI
 * interface to integrate chart builder with various data bindings.
 */

public interface IChartDataSheet
{

	/**
	 * Event type indicates refreshing preview.
	 */
	int EVENT_PREVIEW = 1;

	/**
	 * Event type indicates updating predefined queries.
	 */
	int EVENT_QUERY = 2;

	/**
	 * Sets chart model.
	 * 
	 * @param cm
	 *            chart model
	 */
	void setChartModel( Chart cm );

	/**
	 * Sets chart context.
	 * 
	 * @param context
	 *            chart context
	 */
	void setContext( IWizardContext context );

	/**
	 * Creates data selector to select data set and etc.
	 * 
	 * @param parent
	 *            parent composite
	 * @return new composite
	 */
	Composite createDataSelector( Composite parent );

	/**
	 * Creates the UI which could be used as drag-and-drop source during data
	 * binding.
	 * 
	 * @param parent
	 *            parent composite
	 * @return new composite
	 */
	Composite createDataDragSource( Composite parent );

	/**
	 * Creates the UI which includes buttons to trigger some actions.
	 * 
	 * @param parent
	 *            parent composite
	 * @return new composite
	 */
	Composite createActionButtons( Composite parent );

	/**
	 * Adds the listener to the collection of listeners who will be notified
	 * when an event of the given type occurs. When the event does occur in the
	 * widget, the listener is notified by sending it the
	 * <code>handleEvent()</code> message. The event type is one of the event
	 * constants defined in class <code>SWT</code>.
	 * 
	 * @param listener
	 *            the listener which should be notified when the event occurs
	 * 
	 * 
	 * @see Listener
	 * @see #removeListener( Listener)
	 * @see #notifyListeners( Event)
	 */
	void addListener( Listener listener );

	/**
	 * Removes the listener from the collection of listeners who will be
	 * notified when an event of the given type occurs. The event type is one of
	 * the event constants defined in class <code>SWT</code>.
	 * 
	 * @param listener
	 *            the listener which should no longer be notified when the event
	 *            occurs
	 * 
	 * 
	 * @see Listener
	 * @see #addListener( Listener)
	 * @see #notifyListeners( Event)
	 */
	void removeListener( Listener listener );

	/**
	 * Notifies all of the receiver's listeners for events of the given type
	 * that one such event has occurred by invoking their
	 * <code>handleEvent()</code> method. The event type is one of the event
	 * constants defined in class <code>SWT</code>.
	 * 
	 * @param event
	 *            the event data
	 * 
	 * 
	 * @see #addListener( Listener)
	 * @see #removeListener( Listener)
	 */
	void notifyListeners( Event event );

	/**
	 * Disposes the resources if needed.
	 */
	void dispose( );
}
