/***********************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Actuate Corporation - initial API and implementation
 ***********************************************************************/

package org.eclipse.birt.chart.model.layout.util;

import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.LayoutPackage;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory </b> for the model. It provides an adapter <code>createXXX</code>
 * method for each class of the model. <!-- end-user-doc -->
 * @see org.eclipse.birt.chart.model.layout.LayoutPackage
 * @generated
 */
public class LayoutAdapterFactory extends AdapterFactoryImpl
{

	/**
	 * The cached model package.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static LayoutPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public LayoutAdapterFactory( )
	{
		if ( modelPackage == null )
		{
			modelPackage = LayoutPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This
	 * implementation returns <code>true</code> if the object is either the model's package or is an instance object
	 * of the model. <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	public boolean isFactoryForType( Object object )
	{
		if ( object == modelPackage )
		{
			return true;
		}
		if ( object instanceof EObject )
		{
			return ( (EObject) object ).eClass( ).getEPackage( ) == modelPackage;
		}
		return false;
	}

	/**
	 * The switch the delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected LayoutSwitch modelSwitch = new LayoutSwitch( ) {

		public Object caseBlock( Block object )
		{
			return createBlockAdapter( );
		}

		public Object caseClientArea( ClientArea object )
		{
			return createClientAreaAdapter( );
		}

		public Object caseLabelBlock( LabelBlock object )
		{
			return createLabelBlockAdapter( );
		}

		public Object caseLegend( Legend object )
		{
			return createLegendAdapter( );
		}

		public Object casePlot( Plot object )
		{
			return createPlotAdapter( );
		}

		public Object caseTitleBlock( TitleBlock object )
		{
			return createTitleBlockAdapter( );
		}

		public Object defaultCase( EObject object )
		{
			return createEObjectAdapter( );
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	public Adapter createAdapter( Notifier target )
	{
		return (Adapter) modelSwitch.doSwitch( (EObject) target );
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.layout.Block <em>Block</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that we can easily ignore cases; it's useful
	 * to ignore a case when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.layout.Block
	 * @generated
	 */
	public Adapter createBlockAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.layout.ClientArea <em>Client Area</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases; it's useful to ignore a case when
	 * inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.layout.ClientArea
	 * @generated
	 */
	public Adapter createClientAreaAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.layout.LabelBlock <em>Label Block</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases; it's useful to ignore a case when
	 * inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.layout.LabelBlock
	 * @generated
	 */
	public Adapter createLabelBlockAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.layout.Legend <em>Legend</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that we can easily ignore cases; it's useful
	 * to ignore a case when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.layout.Legend
	 * @generated
	 */
	public Adapter createLegendAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.layout.Plot <em>Plot</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that we can easily ignore cases; it's useful
	 * to ignore a case when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.layout.Plot
	 * @generated
	 */
	public Adapter createPlotAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.layout.TitleBlock <em>Title Block</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases; it's useful to ignore a case when
	 * inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.layout.TitleBlock
	 * @generated
	 */
	public Adapter createTitleBlockAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc --> This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter( )
	{
		return null;
	}

} //LayoutAdapterFactory
