/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.impl.DataSetCacheUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class DiskDataSetCacheObject
implements IDataSetCacheObject {
    private String cacheDir;
    private int cacheCapability;

    public DiskDataSetCacheObject(String cacheDir, int cacheCapability) {
        assert (cacheCapability > 0);
        this.cacheDir = String.valueOf(cacheDir) + File.separator + "DataSetCacheObject_" + this.hashCode();
        new File(this.cacheDir).mkdirs();
        this.cacheCapability = cacheCapability;
    }

    public File getDataFile() {
        return new File(String.valueOf(this.cacheDir) + File.separator + "data.data");
    }

    public File getMetaFile() {
        return new File(String.valueOf(this.cacheDir) + File.separator + "meta.data");
    }

    public boolean isCachedDataReusable(int requiredCapability) {
        assert (requiredCapability > 0);
        return this.getDataFile().exists() && this.getMetaFile().exists() && this.cacheCapability >= requiredCapability;
    }

    public boolean needUpdateCache(int requiredCapability) {
        return !this.isCachedDataReusable(requiredCapability);
    }

    public void release() {
        DataSetCacheUtil.deleteFile(this.cacheDir);
    }

    public IResultClass getResultClass() throws DataException {
        FileInputStream fis1 = null;
        BufferedInputStream bis1 = null;
        try {
            fis1 = new FileInputStream(this.getMetaFile());
            bis1 = new BufferedInputStream(fis1);
            IOUtil.readInt((InputStream)bis1);
            ResultClass rsClass = new ResultClass(bis1);
            bis1.close();
            fis1.close();
            return rsClass;
        }
        catch (FileNotFoundException e) {
            throw new DataException("data.engine.datasetcache.load.error", e);
        }
        catch (IOException e) {
            throw new DataException("data.engine.datasetcache.load.error", e);
        }
    }

    public String getCacheDir() {
        return this.cacheDir;
    }
}

