/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.executor.aggregation.AggrDefnManager;
import org.eclipse.birt.data.engine.odi.IAggrDefnManager;
import org.eclipse.birt.data.engine.odi.IAggrInfo;

public class AggrDefnRoundManager {
    private IAggrInfo[] aggrDefns;
    private int[][] roundStartingEndingIndex;

    public AggrDefnRoundManager(List aggrDefns) {
        this.aggrDefns = new IAggrInfo[aggrDefns.size()];
        int i = 0;
        while (i < aggrDefns.size()) {
            this.aggrDefns[i] = (IAggrInfo)aggrDefns.get(i);
            ++i;
        }
        this.populateRoundStartingEndingIndex();
    }

    public int getRound() {
        return this.roundStartingEndingIndex.length;
    }

    private void populateRoundStartingEndingIndex() {
        ArrayList<Integer> breakIndex = new ArrayList<Integer>();
        breakIndex.add(new Integer(0));
        int i = 1;
        while (i < this.aggrDefns.length) {
            if (this.aggrDefns[i].getRound() != this.aggrDefns[i - 1].getRound()) {
                breakIndex.add(new Integer(i));
            }
            ++i;
        }
        this.roundStartingEndingIndex = new int[breakIndex.size()][2];
        i = 0;
        while (i < breakIndex.size()) {
            this.roundStartingEndingIndex[i][0] = (Integer)breakIndex.get(i);
            this.roundStartingEndingIndex[i][1] = i == breakIndex.size() - 1 ? this.aggrDefns.length : (Integer)breakIndex.get(i + 1);
            ++i;
        }
    }

    public IAggrDefnManager getAggrDefnManager(int round) {
        ArrayList<IAggrInfo> aggrDefn = new ArrayList<IAggrInfo>();
        int i = this.roundStartingEndingIndex[round][0];
        while (i < this.roundStartingEndingIndex[round][1]) {
            aggrDefn.add(this.aggrDefns[i]);
            ++i;
        }
        return new AggrDefnManager(aggrDefn);
    }
}

