/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeSortInfo;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odi.IResultObject;

class MergeSortUtil {
    private Comparator comparator;

    MergeSortUtil() {
    }

    static MergeSortUtil getUtil(Comparator comparator) {
        assert (comparator != null);
        MergeSortUtil instance = new MergeSortUtil();
        instance.comparator = comparator;
        return instance;
    }

    void sortSelf(IResultObject[] self) {
        Comparator comparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                IResultObject data1 = (IResultObject)obj1;
                IResultObject data2 = (IResultObject)obj2;
                return MergeSortUtil.this.compareResultObject(data1, data2);
            }
        };
        Arrays.sort(self, comparator);
    }

    public int getMinResultObject(IResultObject[] objects, int length) {
        IResultObject minObject = null;
        int minObjectPos = -1;
        int i = 0;
        while (i < length) {
            if (objects[i] != null && (minObject == null || this.compareResultObject(minObject, objects[i]) > 0)) {
                minObject = objects[i];
                minObjectPos = i;
            }
            ++i;
        }
        return minObjectPos;
    }

    MergeSortInfo mergeSort(IResultObject[][] resultObjects, IResultObject[] sortedResultObjects, StopSign stopSign) {
        int mergeCount = resultObjects.length;
        int[] indexOfAllUnits = new int[mergeCount];
        boolean[] validUnit = new boolean[mergeCount];
        int realMergeCount = 0;
        IResultObject[][] toBeSortData = new IResultObject[mergeCount][];
        int i = 0;
        while (i < mergeCount) {
            if (resultObjects[i].length > 0) {
                toBeSortData[realMergeCount++] = resultObjects[i];
                validUnit[i] = true;
            }
            ++i;
        }
        int totalCount = 0;
        int[] indexOfUnit = new int[realMergeCount];
        boolean isDone = false;
        while (!isDone) {
            int indexUnitOfMinValue = 0;
            IResultObject minSortData = toBeSortData[indexUnitOfMinValue][indexOfUnit[indexUnitOfMinValue]];
            int i2 = 1;
            while (i2 < realMergeCount) {
                if (this.compareResultObject(minSortData, toBeSortData[i2][indexOfUnit[i2]]) > 0) {
                    indexUnitOfMinValue = i2;
                    minSortData = toBeSortData[indexUnitOfMinValue][indexOfUnit[indexUnitOfMinValue]];
                }
                ++i2;
            }
            sortedResultObjects[totalCount++] = minSortData;
            int n = indexUnitOfMinValue;
            indexOfUnit[n] = indexOfUnit[n] + 1;
            if (toBeSortData[indexUnitOfMinValue].length == indexOfUnit[indexUnitOfMinValue]) {
                isDone = true;
            }
            if (stopSign.isStopped()) break;
        }
        int i3 = 0;
        int j = 0;
        while (i3 < mergeCount) {
            indexOfAllUnits[i3] = validUnit[i3] ? indexOfUnit[j++] : 0;
            ++i3;
        }
        return new MergeSortInfo(totalCount, indexOfAllUnits);
    }

    private int compareResultObject(IResultObject resultObject1, IResultObject resultObject2) {
        return this.comparator.compare(resultObject1, resultObject2);
    }
}

