/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IGroupInstanceInfo;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.expression.NamedExpression;
import org.eclipse.birt.data.engine.impl.CachedQueryResults;
import org.eclipse.birt.data.engine.impl.ConfigFileParser;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;
import org.eclipse.birt.data.engine.impl.IncreCacheDataSetAdapter;
import org.eclipse.birt.data.engine.impl.JointDataSetAdapter;
import org.eclipse.birt.data.engine.impl.OdaDataSetAdapter;
import org.eclipse.birt.data.engine.impl.PLSUtil;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedDummyQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVDataExtractionQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVQuery;
import org.eclipse.birt.data.engine.impl.PreparedIncreCacheDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedJointDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedScriptDSQuery;
import org.eclipse.birt.data.engine.impl.ScriptDataSetAdapter;
import org.eclipse.birt.data.engine.impl.document.FilterDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryCompUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.QueryResults;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.mozilla.javascript.Scriptable;

class PreparedQueryUtil {
    private static final int BASED_ON_RESULTSET = 1;
    private static final int BASED_ON_DATASET = 2;
    private static final int BASED_ON_PRESENTATION = 3;

    PreparedQueryUtil() {
    }

    static IPreparedQuery newInstance(DataEngineImpl dataEngine, IQueryDefinition queryDefn, Map appContext) throws DataException {
        PreparedDataSourceQuery preparedQuery;
        assert (dataEngine != null);
        assert (queryDefn != null);
        PreparedQueryUtil.validateQuery(dataEngine, queryDefn);
        if (queryDefn.getSourceQuery() != null) {
            return new PreparedIVDataExtractionQuery(dataEngine, queryDefn, appContext);
        }
        if (queryDefn.getQueryResultsID() != null) {
            if (dataEngine.getContext().getMode() == 1 || dataEngine.getContext().getMode() == 3) {
                return new DummyPreparedQuery(queryDefn, dataEngine.getSession());
            }
            if (dataEngine.getContext().getMode() == 2) {
                return new DummyPreparedQuery(queryDefn, dataEngine.getSession(), dataEngine.getContext(), queryDefn.getQueryExecutionHints() != null ? queryDefn.getQueryExecutionHints().getTargetGroupInstances() : null);
            }
            return PreparedQueryUtil.newIVInstance(dataEngine, queryDefn);
        }
        IBaseDataSetDesign dset = PreparedQueryUtil.cloneDataSetDesign(dataEngine.getDataSetDesign(queryDefn.getDataSetName()), appContext);
        if (dset == null && queryDefn.getQueryResultsID() == null) {
            return new PreparedDummyQuery(queryDefn, dataEngine.getSession());
        }
        if (dset instanceof IScriptDataSetDesign) {
            preparedQuery = new PreparedScriptDSQuery(dataEngine, queryDefn, dset, appContext);
        } else if (dset instanceof IOdaDataSetDesign) {
            preparedQuery = dset instanceof IIncreCacheDataSetDesign ? new PreparedIncreCacheDSQuery(dataEngine, queryDefn, dset, appContext) : new PreparedOdaDSQuery(dataEngine, queryDefn, dset, appContext);
        } else if (dset instanceof IJointDataSetDesign) {
            preparedQuery = new PreparedJointDataSourceQuery(dataEngine, queryDefn, dset, appContext);
        } else {
            throw new DataException("data.engine.UnsupportedDataSetType", dset.getName());
        }
        return preparedQuery;
    }

    private static void validateQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        String dataSetName = queryDefn.getDataSetName();
        IBaseDataSetDesign dataSet = dataEngine.getDataSetDesign(dataSetName);
        if (dataSet != null) {
            PreparedQueryUtil.validateComputedColumns(dataSet);
        }
    }

    private static void validateComputedColumns(IBaseDataSetDesign bdsd) throws DataException {
        List ccs = bdsd.getComputedColumns();
        if (ccs != null) {
            HashSet<NamedExpression> namedExpressions = new HashSet<NamedExpression>();
            for (IComputedColumn cc : ccs) {
                String name = cc.getName();
                if (name == null || name.equals("")) {
                    throw new DataException("data.engine.EmptyCustomFieldName");
                }
                IBaseExpression expr = cc.getExpression();
                namedExpressions.add(new NamedExpression(name, expr));
            }
            String nameInvolvedInCycle = ExpressionCompilerUtil.getFirstFoundNameInCycle(namedExpressions, "row");
            if (nameInvolvedInCycle != null) {
                throw new DataException("data.engine.ComputedColumnCycle", nameInvolvedInCycle);
            }
        }
    }

    private static IBaseDataSetDesign cloneDataSetDesign(IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        if (dataSetDesign instanceof IScriptDataSetDesign) {
            return new ScriptDataSetAdapter(dataSetDesign);
        }
        if (dataSetDesign instanceof IOdaDataSetDesign) {
            return PreparedQueryUtil.adaptOdaDataSetDesign(dataSetDesign, appContext);
        }
        if (dataSetDesign instanceof IJointDataSetDesign) {
            return new JointDataSetAdapter(dataSetDesign);
        }
        if (dataSetDesign == null) {
            return null;
        }
        throw new DataException("data.engine.UnsupportedDataSetType", dataSetDesign.getName());
    }

    private static IBaseDataSetDesign adaptOdaDataSetDesign(IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        OdaDataSetAdapter adaptedDesign = null;
        URL configFileUrl = IncreCacheDataSetAdapter.getConfigFileURL(appContext);
        if (configFileUrl != null) {
            try {
                InputStream is = configFileUrl.openStream();
                ConfigFileParser parser = new ConfigFileParser(is);
                String id = dataSetDesign.getName();
                if (parser.containDataSet(id)) {
                    String mode = parser.getModeByID(id);
                    if ("incremental".equalsIgnoreCase(mode)) {
                        String queryTemplate = parser.getQueryTextByID(id);
                        String timestampColumn = parser.getTimeStampColumnByID(id);
                        String formatPattern = parser.getTSFormatByID(id);
                        IncreCacheDataSetAdapter pscDataSet = new IncreCacheDataSetAdapter(dataSetDesign);
                        pscDataSet.setCacheMode(1);
                        pscDataSet.setConfigFileUrl(configFileUrl);
                        pscDataSet.setQueryTemplate(queryTemplate);
                        pscDataSet.setTimestampColumn(timestampColumn);
                        pscDataSet.setFormatPattern(formatPattern);
                        adaptedDesign = pscDataSet;
                    } else {
                        String message = MessageFormat.format("data.cache.UnsupportedIncrementalCacheMode", mode);
                        throw new UnsupportedOperationException(message);
                    }
                }
                is.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (adaptedDesign == null) {
            adaptedDesign = new OdaDataSetAdapter(dataSetDesign);
        }
        return adaptedDesign;
    }

    private static IPreparedQuery newIVInstance(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        switch (PreparedQueryUtil.runQueryOnRS(dataEngine, queryDefn)) {
            case 1: {
                return new PreparedIVQuery(dataEngine, queryDefn);
            }
            case 2: {
                return new PreparedIVDataSourceQuery(dataEngine, queryDefn);
            }
        }
        return new DummyPreparedQuery(queryDefn, dataEngine.getSession(), dataEngine.getContext(), PLSUtil.isPLSEnabled(queryDefn) ? queryDefn.getQueryExecutionHints().getTargetGroupInstances() : null);
    }

    private static int runQueryOnRS(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        String queryResultID = queryDefn.getQueryResultsID();
        String rootQueryResultID = QueryResultIDUtil.get1PartID(queryResultID);
        String parentQueryResultID = null;
        if (rootQueryResultID != null) {
            parentQueryResultID = QueryResultIDUtil.get2PartID(queryResultID);
        } else {
            rootQueryResultID = queryResultID;
        }
        QueryResultInfo queryResultInfo = new QueryResultInfo(rootQueryResultID, parentQueryResultID, null, null, -1);
        RDLoad rdLoad = RDUtil.newLoad(dataEngine.getSession().getTempDir(), dataEngine.getContext(), queryResultInfo);
        IBaseQueryDefinition previousQueryDefn = rdLoad.loadQueryDefn(0, 1);
        if (QueryCompUtil.isIVQueryDefnEqual(dataEngine.getContext().getMode(), previousQueryDefn, queryDefn)) {
            return 3;
        }
        return 2;
    }

    private static boolean isBindingReferenceSort(List sorts) {
        if (sorts == null || sorts.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < sorts.size()) {
            ISortDefinition sort = (ISortDefinition)sorts.get(i);
            if (sort.getExpression() != null) {
                try {
                    if (ExpressionUtil.getColumnBindingName((String)sort.getExpression().getText()) == null) {
                        return false;
                    }
                }
                catch (BirtException birtException) {}
            }
            ++i;
        }
        return true;
    }

    private static boolean hasSubQueryInDetail(Collection col) {
        if (col == null || col.size() == 0) {
            return false;
        }
        for (ISubqueryDefinition sub : col) {
            if (!sub.applyOnGroup()) {
                return true;
            }
            if (!PreparedQueryUtil.hasSubQueryInDetail(sub.getSubqueries())) continue;
            return true;
        }
        return false;
    }

    private static boolean isFiltersEquals(List oldFilter, List newFilter) {
        if (oldFilter.size() != newFilter.size()) {
            return false;
        }
        int i = 0;
        while (i < oldFilter.size()) {
            if (!FilterDefnUtil.isEqualFilter((IFilterDefinition)oldFilter.get(i), (IFilterDefinition)newFilter.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean hasAggregationInFilter(List filters) {
        if (filters == null || filters.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < filters.size()) {
            IBaseExpression o = ((IFilterDefinition)filters.get(i)).getExpression();
            if (o instanceof IConditionalExpression) {
                int type = ((IConditionalExpression)o).getOperator();
                if (type == 14 || type == 15 || type == 16 || type == 17) {
                    return true;
                }
                if (ExpressionCompilerUtil.hasAggregationInExpr(o)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean isCompatibleRSMap(Map oldMap, Map newMap) throws DataException {
        if (oldMap == null) {
            return newMap.size() == 0;
        }
        if (newMap == null) {
            return oldMap.size() == 0;
        }
        if (newMap.size() > oldMap.size()) {
            return false;
        }
        for (Object key : newMap.keySet()) {
            Object oldObj = oldMap.get(key);
            Object newObj = newMap.get(key);
            if (oldObj != null) {
                if (QueryCompUtil.isTwoBindingEqual((IBinding)newObj, (IBinding)oldObj)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean isCompatibleSubQuery(IBaseQueryDefinition oldDefn, IBaseQueryDefinition newDefn) {
        boolean isComp = QueryCompUtil.isCompatibleSQs(oldDefn.getSubqueries(), newDefn.getSubqueries());
        if (!isComp) {
            return false;
        }
        Iterator oldIt = oldDefn.getGroups().iterator();
        Iterator newIt = newDefn.getGroups().iterator();
        while (newIt.hasNext()) {
            IGroupDefinition oldGroupDefn = (IGroupDefinition)oldIt.next();
            IGroupDefinition newGroupDefn = (IGroupDefinition)newIt.next();
            isComp = QueryCompUtil.isCompatibleSQs(oldGroupDefn.getSubqueries(), newGroupDefn.getSubqueries());
            if (isComp) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAggregationOnRowObjects(Iterator it) throws DataException {
        while (it.hasNext()) {
            IBinding binding = (IBinding)it.next();
            if (ExpressionCompilerUtil.hasAggregationInExpr(binding.getExpression())) {
                return true;
            }
            if (binding.getAggrFunction() == null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSubquery(IQueryDefinition qd) {
        assert (qd != null);
        if (qd.getSubqueries() != null && qd.getSubqueries().size() > 0) {
            return true;
        }
        if (qd.getGroups() != null) {
            int i = 0;
            while (i < qd.getGroups().size()) {
                IGroupDefinition gd = (IGroupDefinition)qd.getGroups().get(i);
                if (gd.getSubqueries() != null && gd.getSubqueries().size() > 0) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyPreparedQuery
    implements IPreparedQuery {
        private IQueryDefinition queryDefn;
        private String tempDir;
        private DataEngineContext context;
        private List<IGroupInstanceInfo> targetGroups;
        private DataEngineSession session;

        public DummyPreparedQuery(IQueryDefinition queryDefn, DataEngineSession session) {
            this.queryDefn = queryDefn;
            this.session = session;
            this.tempDir = session.getTempDir();
        }

        public DummyPreparedQuery(IQueryDefinition queryDefn, DataEngineSession session, DataEngineContext context, List<IGroupInstanceInfo> targetGroups) {
            this(queryDefn, session);
            this.context = context;
            this.targetGroups = targetGroups;
        }

        @Override
        public IQueryResults execute(Scriptable queryScope) throws BirtException {
            return this.execute(null, queryScope);
        }

        @Override
        public IQueryResults execute(IQueryResults outerResults, Scriptable queryScope) throws BirtException {
            try {
                return this.execute((IBaseQueryResults)outerResults, queryScope);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }

        @Override
        public Collection getParameterMetaData() throws BirtException {
            return null;
        }

        @Override
        public IQueryDefinition getReportQueryDefn() {
            return this.queryDefn;
        }

        @Override
        public IQueryResults execute(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
            try {
                if (this.context == null) {
                    return new CachedQueryResults(this.session, this.queryDefn.getQueryResultsID(), this);
                }
                return new QueryResults(this.tempDir, this.context, this.queryDefn.getQueryResultsID(), outerResults, this.targetGroups);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }
}

