/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseTransform;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ExpressionCollection;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;

public class TransformUtil {
    private static TransformUtil instance = new TransformUtil();

    public static void saveBaseQuery(IBaseQueryDefinition queryDefn, OutputStream outputStream) throws DataException {
        DataOutputStream dos = new DataOutputStream(outputStream);
        try {
            instance.saveTransform(dos, queryDefn);
            instance.saveGroupInfo(dos, queryDefn.getGroups());
            dos.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    private void saveTransform(DataOutputStream dos, IBaseTransform transform) throws DataException, IOException {
        List filterList = transform.getFilters();
        if (filterList == null || filterList.size() == 0) {
            IOUtil.writeInt((OutputStream)dos, (int)0);
        } else {
            int size = filterList.size();
            IOUtil.writeInt((OutputStream)dos, (int)size);
            int i = 0;
            while (i < size) {
                this.saveExpression(dos, ((IFilterDefinition)filterList.get(i)).getExpression());
                ++i;
            }
        }
        List sortList = transform.getSorts();
        if (sortList == null || sortList.size() == 0) {
            IOUtil.writeInt((OutputStream)dos, (int)0);
        } else {
            int size = sortList.size();
            IOUtil.writeInt((OutputStream)dos, (int)size);
            int i = 0;
            while (i < size) {
                ISortDefinition sd = (ISortDefinition)sortList.get(i);
                IOUtil.writeString((DataOutputStream)dos, (String)sd.getColumn());
                this.saveExpression(dos, sd.getExpression());
                IOUtil.writeInt((OutputStream)dos, (int)sd.getSortDirection());
                ++i;
            }
        }
    }

    private void saveGroupInfo(DataOutputStream dos, List groupList) throws DataException, IOException {
        if (groupList == null || groupList.size() == 0) {
            IOUtil.writeInt((OutputStream)dos, (int)0);
        } else {
            int size = groupList.size();
            IOUtil.writeInt((OutputStream)dos, (int)size);
            int i = 0;
            while (i < size) {
                IGroupDefinition groupDefn = (IGroupDefinition)groupList.get(i);
                IOUtil.writeInt((OutputStream)dos, (int)groupDefn.getInterval());
                IOUtil.writeInt((OutputStream)dos, (int)groupDefn.getSortDirection());
                IOUtil.writeDouble((DataOutputStream)dos, (double)groupDefn.getIntervalRange());
                IOUtil.writeObject((DataOutputStream)dos, (Object)groupDefn.getIntervalStart());
                IOUtil.writeString((DataOutputStream)dos, (String)groupDefn.getKeyColumn());
                IOUtil.writeString((DataOutputStream)dos, (String)groupDefn.getKeyExpression());
                this.saveTransform(dos, groupDefn);
                ++i;
            }
        }
    }

    private void saveExpression(DataOutputStream dos, IBaseExpression expr) throws IOException {
        if (expr == null) {
            IOUtil.writeBool((OutputStream)dos, (boolean)false);
            return;
        }
        IOUtil.writeBool((OutputStream)dos, (boolean)true);
        if (expr instanceof IScriptExpression) {
            IOUtil.writeInt((OutputStream)dos, (int)0);
            IScriptExpression se = (IScriptExpression)expr;
            IOUtil.writeInt((OutputStream)dos, (int)se.getDataType());
            IOUtil.writeString((DataOutputStream)dos, (String)se.getText());
        } else if (expr instanceof IConditionalExpression) {
            IOUtil.writeInt((OutputStream)dos, (int)1);
            IConditionalExpression ce = (IConditionalExpression)expr;
            IOUtil.writeInt((OutputStream)dos, (int)ce.getDataType());
            this.saveExpression(dos, ce.getExpression());
            IOUtil.writeInt((OutputStream)dos, (int)ce.getOperator());
            this.saveExpression(dos, ce.getOperand1());
            this.saveExpression(dos, ce.getOperand2());
        } else if (expr instanceof IExpressionCollection) {
            IOUtil.writeInt((OutputStream)dos, (int)2);
            IExpressionCollection ce = (IExpressionCollection)expr;
            IOUtil.writeInt((OutputStream)dos, (int)ce.getDataType());
            Object[] exprs = ce.getExpressions().toArray();
            IOUtil.writeInt((OutputStream)dos, (int)exprs.length);
            int i = 0;
            while (i < exprs.length) {
                this.saveExpression(dos, (IBaseExpression)exprs[i]);
                ++i;
            }
        } else assert (false);
    }

    public static IBaseQueryDefinition loadBaseQuery(InputStream inputStream) throws DataException {
        QueryDefinition queryDefn = new QueryDefinition();
        DataInputStream dis = new DataInputStream(inputStream);
        try {
            instance.loadTransform(dis, queryDefn);
            instance.loadGroupInfo(dis, queryDefn, DataEngineSession.getCurrentClassLoader());
            dis.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", e);
        }
        return queryDefn;
    }

    private void loadTransform(DataInputStream dis, IBaseTransform transform) throws IOException {
        int i;
        int size = IOUtil.readInt((InputStream)dis);
        if (size > 0) {
            i = 0;
            while (i < size) {
                transform.getFilters().add(new FilterDefinition(this.loadExpression(dis)));
                ++i;
            }
        }
        if ((size = IOUtil.readInt((InputStream)dis)) > 0) {
            i = 0;
            while (i < size) {
                SortDefinition sd = new SortDefinition();
                sd.setColumn(IOUtil.readString((DataInputStream)dis));
                sd.setExpression(((IScriptExpression)this.loadExpression(dis)).getText());
                sd.setSortDirection(IOUtil.readInt((InputStream)dis));
                transform.getSorts().add(sd);
                ++i;
            }
        }
    }

    private void loadGroupInfo(DataInputStream dis, IBaseQueryDefinition queryDefn, ClassLoader classLoader) throws IOException {
        int size = IOUtil.readInt((InputStream)dis);
        if (size > 0) {
            int i = 0;
            while (i < size) {
                GroupDefinition gd = new GroupDefinition();
                gd.setInterval(IOUtil.readInt((InputStream)dis));
                gd.setSortDirection(IOUtil.readInt((InputStream)dis));
                gd.setIntervalRange(IOUtil.readDouble((DataInputStream)dis));
                gd.setIntervalStart(IOUtil.readObject((DataInputStream)dis, (ClassLoader)classLoader));
                gd.setKeyColumn(IOUtil.readString((DataInputStream)dis));
                gd.setKeyExpression(IOUtil.readString((DataInputStream)dis));
                this.loadTransform(dis, gd);
                queryDefn.getGroups().add(queryDefn);
                ++i;
            }
        }
    }

    private IBaseExpression loadExpression(DataInputStream dis) throws IOException {
        if (!IOUtil.readBool((InputStream)dis)) {
            return null;
        }
        BaseExpression expr = null;
        int type = IOUtil.readInt((InputStream)dis);
        if (type == 0) {
            int dataType = IOUtil.readInt((InputStream)dis);
            String text = IOUtil.readString((DataInputStream)dis);
            ScriptExpression se = new ScriptExpression(text);
            se.setDataType(dataType);
            expr = se;
        } else if (type == 1) {
            int dataType = IOUtil.readInt((InputStream)dis);
            IScriptExpression be = (IScriptExpression)this.loadExpression(dis);
            int oper = IOUtil.readInt((InputStream)dis);
            IScriptExpression operand1Expr = (IScriptExpression)this.loadExpression(dis);
            IScriptExpression operand2Expr = (IScriptExpression)this.loadExpression(dis);
            ConditionalExpression ce = new ConditionalExpression(be, oper, operand1Expr, operand2Expr);
            ce.setDataType(dataType);
            expr = ce;
        } else if (type == 2) {
            IOUtil.readInt((InputStream)dis);
            int size = IOUtil.readInt((InputStream)dis);
            IBaseExpression[] expression = new IBaseExpression[size];
            int i = 0;
            while (i < size) {
                expression[i] = this.loadExpression(dis);
                ++i;
            }
            expr = new ExpressionCollection(expression);
        } else assert (false);
        return expr;
    }
}

