/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.olap.OLAPException;
import javax.olap.cursor.Blob;
import javax.olap.cursor.Clob;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.Date;
import javax.olap.cursor.RowDataMetaData;
import javax.olap.cursor.Time;
import javax.olap.cursor.Timestamp;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.script.JSCubeBindingObject;
import org.eclipse.birt.data.engine.olap.script.OLAPExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public class CubeCursorImpl
implements ICubeCursor {
    private CubeCursor cursor;
    private Scriptable scope;
    private ICubeQueryDefinition queryDefn;
    private HashMap bindingMap;
    private HashMap dataTypeMap;
    private Set validBindingSet;
    private Scriptable outerResults;
    private BirtCubeView cubeView;
    private ScriptContext cx;

    public CubeCursorImpl(IBaseQueryResults outerResults, CubeCursor cursor, Scriptable scope, ScriptContext cx, ICubeQueryDefinition queryDefn, BirtCubeView view) throws DataException {
        this.cursor = cursor;
        this.scope = scope;
        this.queryDefn = queryDefn;
        this.cubeView = view;
        this.cx = cx;
        this.outerResults = OlapExpressionUtil.createQueryResultsScriptable(outerResults);
        this.bindingMap = new HashMap();
        this.validBindingSet = new HashSet();
        this.dataTypeMap = new HashMap();
        List<IBinding> allBindings = CubeQueryDefinitionUtil.getAllBindings(queryDefn);
        int i = 0;
        while (i < allBindings.size()) {
            IBinding binding = allBindings.get(i);
            String bindingName = binding.getBindingName();
            this.validBindingSet.add(bindingName);
            IBaseExpression expr = binding.getExpression();
            if (binding.getAggrFunction() == null) {
                this.bindingMap.put(bindingName, expr);
                OLAPExpressionCompiler.compile(cx.getContext(), expr);
            }
            this.dataTypeMap.put(bindingName, new Integer(binding.getDataType()));
            ++i;
        }
        this.scope.put("data", this.scope, (Object)new JSCubeBindingObject(this));
    }

    public List getOrdinateEdge() throws OLAPException {
        return this.cursor.getOrdinateEdge();
    }

    public Collection getPageEdge() throws OLAPException {
        return this.cursor.getPageEdge();
    }

    public void synchronizePages() throws OLAPException {
        this.cursor.synchronizePages();
    }

    public void close() throws OLAPException {
        this.cursor.close();
    }

    public InputStream getAsciiStream(int arg0) throws OLAPException {
        return null;
    }

    public InputStream getAsciiStream(String arg0) throws OLAPException {
        return null;
    }

    public BigDecimal getBigDecimal(int arg0) throws OLAPException {
        return null;
    }

    public BigDecimal getBigDecimal(String arg0) throws OLAPException {
        return null;
    }

    public InputStream getBinaryStream(int arg0) throws OLAPException {
        return null;
    }

    public InputStream getBinaryStream(String arg0) throws OLAPException {
        return null;
    }

    public Blob getBlob(int arg0) throws OLAPException {
        return null;
    }

    public Blob getBlob(String arg0) throws OLAPException {
        return null;
    }

    public boolean getBoolean(int arg0) throws OLAPException {
        return false;
    }

    public boolean getBoolean(String arg0) throws OLAPException {
        return false;
    }

    public byte getByte(int arg0) throws OLAPException {
        return 0;
    }

    public byte getByte(String arg0) throws OLAPException {
        return 0;
    }

    public byte[] getBytes(int arg0) throws OLAPException {
        return null;
    }

    public byte[] getBytes(String arg0) throws OLAPException {
        return null;
    }

    public Reader getCharacterStream(int arg0) throws OLAPException {
        return null;
    }

    public Reader getCharacterStream(String arg0) throws OLAPException {
        return null;
    }

    public Clob getClob(int arg0) throws OLAPException {
        return null;
    }

    public Clob getClob(String arg0) throws OLAPException {
        return null;
    }

    public Date getDate(int arg0) throws OLAPException {
        return null;
    }

    public Date getDate(String arg0) throws OLAPException {
        return null;
    }

    public Date getDate(int arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    public Date getDate(String arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    public double getDouble(int arg0) throws OLAPException {
        return 0.0;
    }

    public double getDouble(String arg0) throws OLAPException {
        return 0.0;
    }

    public float getFloat(int arg0) throws OLAPException {
        return 0.0f;
    }

    public float getFloat(String arg0) throws OLAPException {
        return 0.0f;
    }

    public int getInt(int arg0) throws OLAPException {
        return 0;
    }

    public int getInt(String arg0) throws OLAPException {
        return 0;
    }

    public long getLong(int arg0) throws OLAPException {
        return 0L;
    }

    public long getLong(String arg0) throws OLAPException {
        return 0L;
    }

    public RowDataMetaData getMetaData() throws OLAPException {
        return this.cursor.getMetaData();
    }

    public Object getObject(int arg0) throws OLAPException {
        return null;
    }

    public Object getObject(String arg0) throws OLAPException {
        Object result = null;
        if (!this.validBindingSet.contains(arg0)) {
            if (arg0.equals("_outer") && this.outerResults != null) {
                return this.outerResults;
            }
            throw new OLAPException("data.engine.NoOuterResultsExist");
        }
        if (this.bindingMap.get(arg0) == null) {
            result = this.cursor.getObject(arg0);
        } else {
            try {
                IBaseExpression expr = (IBaseExpression)this.bindingMap.get(arg0);
                result = ScriptEvalUtil.evalExpr(expr, this.cx, this.scope, ScriptExpression.defaultID, 0);
            }
            catch (Exception e) {
                throw new OLAPException(e.getLocalizedMessage());
            }
        }
        if (result instanceof DataException) {
            throw new OLAPException(((DataException)((Object)result)).getLocalizedMessage());
        }
        if (this.dataTypeMap.containsKey(arg0)) {
            try {
                result = DataTypeUtil.convert((Object)JavascriptEvalUtil.convertJavascriptValue((Object)result), (int)((Integer)this.dataTypeMap.get(arg0)));
            }
            catch (BirtException e) {
                throw new OLAPException(e.getLocalizedMessage());
            }
        }
        return result;
    }

    public Object getObject(int arg0, Map arg1) throws OLAPException {
        return null;
    }

    public Object getObject(String arg0, Map arg1) throws OLAPException {
        return null;
    }

    public short getShort(int arg0) throws OLAPException {
        return 0;
    }

    public short getShort(String arg0) throws OLAPException {
        return 0;
    }

    public String getString(int arg0) throws OLAPException {
        return null;
    }

    public String getString(String arg0) throws OLAPException {
        return null;
    }

    public Time getTime(int arg0) throws OLAPException {
        return null;
    }

    public Time getTime(String arg0) throws OLAPException {
        return null;
    }

    public Time getTime(int arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    public Time getTime(String arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    public Timestamp getTimestamp(int arg0) throws OLAPException {
        return null;
    }

    public Timestamp getTimestamp(String arg0) throws OLAPException {
        return null;
    }

    public Timestamp getTimestamp(int arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    public Timestamp getTimestamp(String arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    public String getId() throws OLAPException {
        return null;
    }

    public String getName() throws OLAPException {
        return null;
    }

    public void setId(String value) throws OLAPException {
    }

    public void setName(String value) throws OLAPException {
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public Object clone() {
        return this.cursor;
    }

    public BirtCubeView getCubeView() {
        return this.cubeView;
    }
}

