/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ViewerFiltersObservableSet
extends ObservableSet
implements IViewerObservableSet {
    private StructuredViewer viewer;
    static /* synthetic */ Class class$0;

    public ViewerFiltersObservableSet(Realm realm, StructuredViewer viewer) {
        HashSet<ViewerFilter> hashSet = new HashSet<ViewerFilter>(Arrays.asList(viewer.getFilters()));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ViewerFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(realm, hashSet, (Object)clazz);
        this.viewer = viewer;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    private void replaceFilters() {
        this.viewer.getControl().setRedraw(false);
        try {
            this.viewer.setFilters(this.wrappedSet.toArray(new ViewerFilter[this.wrappedSet.size()]));
        }
        finally {
            this.viewer.getControl().setRedraw(true);
        }
    }

    private void addFilter(ViewerFilter filter) {
        this.viewer.getControl().setRedraw(false);
        try {
            this.viewer.addFilter(filter);
        }
        finally {
            this.viewer.getControl().setRedraw(true);
        }
    }

    private void removeFilter(ViewerFilter filter) {
        this.viewer.getControl().setRedraw(false);
        try {
            this.viewer.removeFilter(filter);
        }
        finally {
            this.viewer.getControl().setRedraw(true);
        }
    }

    public boolean add(Object element) {
        this.checkRealm();
        boolean added = this.wrappedSet.add(element);
        if (added) {
            this.addFilter((ViewerFilter)element);
            this.fireSetChange(Diffs.createSetDiff(Collections.singleton(element), (Set)Collections.EMPTY_SET));
        }
        return added;
    }

    public boolean addAll(Collection c) {
        this.getterCalled();
        HashSet additions = new HashSet();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.wrappedSet.add(element)) continue;
            additions.add(element);
        }
        if (additions.size() > 0) {
            this.replaceFilters();
            this.fireSetChange(Diffs.createSetDiff(additions, (Set)Collections.EMPTY_SET));
            return true;
        }
        return false;
    }

    public void clear() {
        this.getterCalled();
        HashSet removes = new HashSet(this.wrappedSet);
        this.wrappedSet.clear();
        this.replaceFilters();
        this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, removes));
    }

    public boolean remove(Object o) {
        this.getterCalled();
        boolean removed = this.wrappedSet.remove(o);
        if (removed) {
            this.removeFilter((ViewerFilter)o);
            this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, Collections.singleton(o)));
        }
        return removed;
    }

    public boolean removeAll(Collection c) {
        this.getterCalled();
        HashSet removes = new HashSet();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.wrappedSet.remove(element)) continue;
            removes.add(element);
        }
        if (removes.size() > 0) {
            this.replaceFilters();
            this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, removes));
            return true;
        }
        return false;
    }

    public boolean retainAll(Collection c) {
        this.getterCalled();
        HashSet removes = new HashSet();
        Iterator it = this.wrappedSet.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (c.contains(element)) continue;
            it.remove();
            removes.add(element);
        }
        if (removes.size() > 0) {
            this.replaceFilters();
            this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, removes));
            return true;
        }
        return false;
    }
}

