/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DataSetDataSourceSelectionPage
extends AbstractDescriptionPropertyPage {
    Combo combo;
    int lastSelectedDataSourceIndex = -1;

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString((String)"dataset.editor.label.selectDataSource"));
        this.combo = new Combo(composite, 2056);
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.setItems(this.getSimilarDataSources());
        this.selectCurrentDataSource();
        return composite;
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.dataSource"), 0);
        this.lastSelectedDataSourceIndex = this.combo.getSelectionIndex();
    }

    private void selectCurrentDataSource() {
        String current = this.getCurrentDataSource().getName();
        String[] items = this.combo.getItems();
        int n = 0;
        while (n < items.length) {
            if (items[n].equals(current)) {
                this.combo.select(n);
                break;
            }
            ++n;
        }
    }

    private DataSourceHandle getCurrentDataSource() {
        return ((DataSetHandle)this.getContainer().getModel()).getDataSource();
    }

    private String[] getSimilarDataSources() {
        DataSourceHandle currentDataSource = this.getCurrentDataSource();
        if (currentDataSource instanceof OdaDataSourceHandle) {
            return this.getSimilarOdaDataSources((OdaDataSourceHandle)currentDataSource);
        }
        if (currentDataSource instanceof ScriptDataSourceHandle) {
            return this.getSimilarScriptDataSources((ScriptDataSourceHandle)currentDataSource);
        }
        return new String[0];
    }

    private String[] getSimilarOdaDataSources(OdaDataSourceHandle currentDataSource) {
        Iterator iter;
        ArrayList<String> similarDataSources = new ArrayList<String>();
        List dataSources = Utility.getDataSources();
        if (dataSources != null && (iter = dataSources.iterator()) != null) {
            while (iter.hasNext()) {
                DataSourceHandle dataSource = (DataSourceHandle)iter.next();
                if (!(dataSource instanceof OdaDataSourceHandle) || !((OdaDataSourceHandle)dataSource).getExtensionID().equals(currentDataSource.getExtensionID())) continue;
                similarDataSources.add(dataSource.getName());
            }
        }
        return similarDataSources.toArray(new String[0]);
    }

    private String[] getSimilarScriptDataSources(ScriptDataSourceHandle currentDataSource) {
        Iterator iter;
        ArrayList<String> similarDataSources = new ArrayList<String>();
        List dataSources = Utility.getDataSources();
        if (dataSources != null && (iter = dataSources.iterator()) != null) {
            while (iter.hasNext()) {
                DataSourceHandle dataSource = (DataSourceHandle)iter.next();
                if (!(dataSource instanceof ScriptDataSourceHandle)) continue;
                similarDataSources.add(dataSource.getName());
            }
        }
        return similarDataSources.toArray(new String[0]);
    }

    public boolean canLeave() {
        try {
            if (this.combo != null && !this.combo.isDisposed() && this.lastSelectedDataSourceIndex != this.combo.getSelectionIndex()) {
                ((DataSetHandle)this.getContainer().getModel()).setDataSource(this.combo.getItem(this.combo.getSelectionIndex()));
                ((DataSetEditor)this.getContainer()).updateDataSetDesign(this);
                ((DataSetHandle)this.getContainer().getModel()).clearProperty("resultSet");
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        return super.canLeave();
    }

    public boolean performOk() {
        try {
            if (this.combo != null && !this.combo.isDisposed() && this.combo.getSelectionIndex() > -1 && this.lastSelectedDataSourceIndex != this.combo.getSelectionIndex()) {
                ((DataSetHandle)this.getContainer().getModel()).setDataSource(this.combo.getItem(this.combo.getSelectionIndex()));
                ((DataSetEditor)this.getContainer()).updateDataSetDesign(this);
                ((DataSetHandle)this.getContainer().getModel()).clearProperty("resultSet");
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        return super.performOk();
    }

    public String getToolTip() {
        return Messages.getString((String)"dataset.editor.dataSource.Tooltip");
    }
}

